#include "xinternl.h"
#include "xpoint.h"

/*
much of this code is horked from the w_modex.zip code, the author of
which I can not remember.

Modified 1995 by Victor B. Putz
*/

void x_circle (
	xScreenCoord_t Left,
	xScreenCoord_t Top,
	int Diameter,
  xColor_t Color,
	xPageHandle_t ScreenOffs
)
{
	int Radius = Diameter / 2;
	int x = Left + Radius + 1;
  int y = Top + Radius + 1;
  int ix, iy, d, deltaE, deltaSE;

  ix = 0;
  iy = Radius;
  d = 1 - Radius;
  deltaE = 3;
  deltaSE = (-2 * Radius) + 5;

  x_put_pix(x + ix, y + iy, ScreenOffs, Color);
  x_put_pix(x + ix, y - iy, ScreenOffs, Color);
  x_put_pix(x + iy, y + ix, ScreenOffs, Color);
  x_put_pix(x + iy, y - ix, ScreenOffs, Color);
  x_put_pix(x - ix, y + iy, ScreenOffs, Color);
  x_put_pix(x - ix, y - iy, ScreenOffs, Color);
  x_put_pix(x - iy, y + ix, ScreenOffs, Color);
  x_put_pix(x - iy, y - ix, ScreenOffs, Color);

  while (iy > ix++) {
    if (d < 0) {
      d += deltaE;
      deltaE += 2;
      deltaSE += 2;
    } else {
      d += deltaSE;
      deltaE += 2;
      deltaSE += 4;
      iy--;
    }

    x_put_pix(x + ix, y + iy, ScreenOffs, Color);
    x_put_pix(x + ix, y - iy, ScreenOffs, Color);
    x_put_pix(x + iy, y + ix, ScreenOffs, Color);
    x_put_pix(x + iy, y - ix, ScreenOffs, Color);
    x_put_pix(x - ix, y + iy, ScreenOffs, Color);
    x_put_pix(x - ix, y - iy, ScreenOffs, Color);
    x_put_pix(x - iy, y + ix, ScreenOffs, Color);
    x_put_pix(x - iy, y - ix, ScreenOffs, Color);
  }
}



extern void _HorizontalLine(
	xPageHandle_t wOffset,
	int iLeftX,
	int iY,
	int iLength,
	int iColor
);

void x_filled_circle (
	xScreenCoord_t Left,
	xScreenCoord_t Top,
	int Diameter,
  xColor_t Color,
	xPageHandle_t ScreenOffs
)
{
	int Radius = Diameter / 2;
  //round to the nearest even coordinate center (for some reason it
  //likes this-- don't have time to see why)
  int x = (Left + Radius);
  int y = (Top + Radius);
  int ix, iy, d, deltaE, deltaSE;

  ix = 0;
  iy = Radius;
  d = 1 - Radius;
  deltaE = 3;
  deltaSE = (-2 * Radius) + 5;

  _HorizontalLine( ScreenOffs, x - ix, y + iy, (ix << 1) + 1, Color);
  _HorizontalLine( ScreenOffs, x - ix, y - iy, (ix << 1) + 1, Color);
  _HorizontalLine( ScreenOffs, x - iy, y + ix, (iy << 1) + 1, Color);
  _HorizontalLine( ScreenOffs, x - iy, y - ix, (iy << 1) + 1, Color);

  while (iy > ix++) {
    if (d < 0) {
      d += deltaE;
      deltaE += 2;
      deltaSE += 2;
    } else {
      d += deltaSE;
      deltaE += 2;
      deltaSE += 4;
      iy--;
    }

    _HorizontalLine( ScreenOffs, x - ix, y + iy, (ix << 1) + 1, Color);
    _HorizontalLine( ScreenOffs, x - ix, y - iy, (ix << 1) + 1, Color);
    _HorizontalLine( ScreenOffs, x - iy, y + ix, (iy << 1) + 1, Color);
    _HorizontalLine( ScreenOffs, x - iy, y - ix, (iy << 1) + 1, Color);
  }
}

