
'--------------------------------------------------------------------
' Title       : XLAT copyright (c) Philippe Guiochon 1993, 1995
' Version     : 1.0
' Author      : Philippe Guiochon
' Description : ASCII filter and converter
' Note 1      : Q&D port from MS-PDS 7.1
' Note 2      : XLAT is freeware, of course. ;-)
' Note 3      : Modify original source code, if necessary, for your
'               own personal use, but please release only original
'               source code with credits. Fanx!
' Future      : no!
' EXE         : XLAT
' Usage       : glossary[.GLO] source target
'
' Who When     What
' --- -------- ------------------------------------------------------
' PhG 05-30-95 Q&D port from PDS7.0 to PB3.1
' PhG 02-01-93 created from an old AppleSoft hack (those were the days!)
'--------------------------------------------------------------------

$CPU 8086

$OPTIMIZE SIZE
$COMPILE EXE

$DEBUG MAP OFF
$DEBUG PBDEBUG OFF

$LIB COM        OFF
$LIB CGA        OFF
$LIB EGA        OFF
$LIB VGA        OFF
$LIB HERC       OFF
$LIB LPT        OFF
$LIB IPRINT     OFF
$LIB FULLFLOAT  OFF

$ERROR BOUNDS   OFF
$ERROR NUMERIC  OFF
$ERROR OVERFLOW OFF
$ERROR STACK    OFF

$FLOAT PROCEDURE

$COM    0
$STRING 16
$STACK  2048
$SOUND  1

$DIM ARRAY

$DYNAMIC
' $STATIC

$OPTION CNTLBREAK OFF

'--------------------------------------------------------------------

DEFINT A-Z
OPTION BINARY BASE 0

%False  = 0
%True   = NOT %False
%Ignore = %True         ' %False prevents target overwrite

%MinChar = 0
%MaxChar = 255

%OK                 = 100
%Help               = 101
%MissingGlossary    = 102
%CantFindGlossary   = 103
%MissingSource      = 104
%CantFindSource     = 105
%MissingTarget      = 106
%TargetAlreadyHere  = 107
%NoWildcard         = 108
%TooMany            = 109
%Interval           = 110
%SyntaxInterval     = 111
%IllogicalInterval  = 112
%MissingDefinition  = 113
%Redefinition       = 114
%BadString          = 115
%Same               = 116

SHARED Nil$,Idem$,Unlikely$,Halt$,Extension$
Nil$        = "NIL"
Idem$       = "IDEM"
Unlikely$   = "{KirthGersen}"
Halt$       = "Argh! "
Extension$  = ".GLO"
'
DIM Flag(%MinChar:%MaxChar) AS SHARED INTEGER
DIM Translation(%MinChar:%MaxChar) AS SHARED STRING
SHARED glossary$, source$, target$, badline$

'--------------------------------------------------------------------

ON ERROR GOTO Abort

CALL ParseCLI
CALL LoadGlossary
CALL Process
END %OK-%OK

'--------------------------------------------------------------------

Abort:
IF ERR = %Help THEN
  PRINT "Usage: XLAT glossary[.GLO] source target"
  PRINT
  PRINT "where glossary: translation glossary"
  PRINT "      source  : file to translate"
  PRINT "      target  : file translated"
  PRINT
  PRINT "Exemple:"
  PRINT "      XLAT LUPIN813 CUTHBERT.ASC CLAY.TXT"
  END %Help-%OK
END IF
BEEP
PRINT "XLAT: ";
SELECT CASE ERR
  CASE %MissingGlossary
    PRINT "No glossary file specified!"
  CASE %CantFindGlossary
    PRINT "Glossary file does not exist!"
  CASE %MissingSource
    PRINT "No source file specified!"
  CASE %CantFindSource
    PRINT "Source file does not exist!"
  CASE %MissingTarget
    PRINT "No target file specified!"
  CASE %TargetAlreadyHere
    PRINT "Target file already exists!"
  CASE %NoWildcard
    PRINT "Wildcards are not allowed!"
  CASE %TooMany
    PRINT "Too many parameters!"
  CASE %Interval
    PRINT "Value out of [0..255] interval!"
  CASE %SyntaxInterval
    PRINT "Syntax error in an interval specification!"
  CASE %IllogicalInterval
    PRINT "This interval is illogical, Cap'n!"
  CASE %MissingDefinition
    PRINT "Glossary not complete!"
  CASE %Redefinition
    PRINT "Entry already defined!"
  CASE %BadString
    PRINT "Syntax error in a string specification!"
  CASE %Same
    PRINT "Source and target cannot be the same!"
  CASE ELSE
    PRINT "Error #"; ERR;" at address";ERADR;" (decimal)!"
END SELECT
END ERR-%OK

'--------------------------------------------------------------------

'
SUB ParseCLI
cli$ = COMMAND$
Blank = ASC(" ")
a$ = GetToken$(cli$)
SELECT CASE UCASE$(a$)
  CASE "", "?", "-?", "/?", "-H", "/H"
    ERROR %Help
END SELECT
IF INSTR(a$, ".") = 0 THEN a$ = a$ + Extension$
IF INSTR(a$, "*") > 0 THEN ERROR %NoWildcard
IF INSTR(a$, "?") > 0 THEN ERROR %NoWildcard
IF DIR$(a$) = "" THEN ERROR %CantFindGlossary
glossary$ = a$
a$ = GetToken$(cli$)
IF a$ = "" THEN ERROR %MissingSource
IF INSTR(a$, "*") > 0 THEN ERROR %NoWildcard
IF INSTR(a$, "?") > 0 THEN ERROR %NoWildcard
IF DIR$(a$) = "" THEN ERROR %CantFindSource
source$ = a$
a$ = GetToken$(cli$)
IF a$ = "" THEN ERROR %MissingTarget
IF INSTR(a$, "*") > 0 THEN ERROR %NoWildcard
IF INSTR(a$, "?") > 0 THEN ERROR %NoWildcard
IF UCASE$(a$) = UCASE$(source$) THEN ERROR %Same
IF DIR$(a$) <> "" THEN
  IF %Ignore = %False THEN ERROR %TargetAlreadyHere
END IF
target$ = a$
a$ = GetToken$(cli$)
IF a$ <> "" THEN ERROR %TooMany
END SUB

'--------------------------------------------------------------------

SUB Process
hndSource = FREEFILE
OPEN "b", #hndSource, source$
hndTarget = FREEFILE
OPEN "b", #hndTarget, target$
c$ = "*"
DO
  GET #hndSource, , c$
  IF EOF(hndSource) = %True THEN EXIT DO
  v = ASC(c$)
  PUT #hndTarget, , Translation$(v)
LOOP
CLOSE #hndTarget
CLOSE #hndSource
END SUB

'--------------------------------------------------------------------

FUNCTION GetString$ (a$)
DoubleQuote$ = CHR$(34)
Blank = ASC(" ")
r$ = ""
DO
' strip header
  length = LEN(a$)
  offset = 1
  DO
    IF offset > length THEN
      a$ = ""
      EXIT DO
    END IF
    char$ = MID$(a$, offset, 1)
    char = ASC(char$)
    IF char > Blank THEN
      a$ = MID$(a$, offset)
      EXIT DO
    END IF
    offset = offset + 1
  LOOP
' go !
  IF a$ = "" THEN EXIT DO
  IF MID$(a$, 1, 1) = ";" THEN EXIT DO
  IF MID$(a$, 1, 1) = DoubleQuote$ THEN
    p = INSTR(2, a$, DoubleQuote$)
    IF p = 0 THEN
      PRINT Halt$; badline$
      ERROR %BadString
    END IF
    r$ = r$ + MID$(a$, 2, p - 1 - 1)
    a$ = MID$(a$, p + 1)
  ELSE
    v$ = GetToken$(a$)
    IF UCASE$(v$) = Nil$ THEN
      r$ = Nil$ + Unlikely$
      EXIT DO
    ELSEIF UCASE$(v$) = Idem$ THEN
      r$ = Idem$ + Unlikely$
      EXIT DO
    ELSE
      v = GetVal(v$)
      r$ = r$ + CHR$(v)
    END IF
  END IF
LOOP
GetString$ = r$
END FUNCTION

'--------------------------------------------------------------------

FUNCTION GetToken$ (chaine$)
Blank = ASC(" ")
length = LEN(chaine$)
offset = 1
token$ = ""
intoken = 0
DO UNTIL intoken = 2 OR offset > length
  char$ = MID$(chaine$, offset, 1)
  char = ASC(char$)
  IF char > Blank THEN intoken = 1: token$ = token$ + char$
  IF char <= Blank AND intoken = 1 THEN intoken = 2
  offset = offset + 1
LOOP
IF offset > length THEN
  chaine$ = ""
ELSE
  chaine$ = MID$(chaine$, offset)
END IF
GetToken$ = token$
END FUNCTION

'--------------------------------------------------------------------

FUNCTION GetVal (a$)
IF MID$(a$, 1, 1) = "$" THEN
  v& = VAL("&H" + MID$(a$, 2))
ELSE
  v& = VAL(a$)
END IF
IF v& < %MinChar OR v& > %MaxChar THEN
  PRINT Halt$; badline$
  ERROR %Interval
END IF
GetVal = v&
END FUNCTION

'--------------------------------------------------------------------

SUB LoadGlossary
FOR i = %MinChar TO %MaxChar
  Flag(i) = %False
NEXT
hndGlossaire = FREEFILE
OPEN "i", #hndGlossaire, glossary$
DO UNTIL EOF(hndGlossaire)
  LINE INPUT #hndGlossaire, cli$
  badline$ = cli$
  a$ = GetToken(cli$)
  SELECT CASE MID$(a$, 1, 1)
  CASE "0" TO "9", "$"
    v = GetVal(a$)
    z$ = GetString$(cli$)
    IF Flag(v) = %True THEN
      PRINT Halt$; badline$
      ERROR %Redefinition
    END IF
    SELECT CASE z$
    CASE Nil$ + Unlikely$
      Translation$(v) = ""
    CASE Idem$ + Unlikely$
      Translation$(v) = CHR$(v)
    CASE ELSE
      Translation$(v) = z$
    END SELECT
    Flag(v) = %True
  CASE "["
    p = INSTR(a$, "..")
    IF p = 0 OR (RIGHT$(a$, 1) <> "]") THEN
      PRINT Halt$; badline$
      ERROR %SyntaxInterval
    END IF
    a$ = MID$(a$, 2)
    debut = GetVal(a$)
    a$ = MID$(a$, p + 2 - 1)
    fin = GetVal(a$)
    IF fin <= debut THEN
      PRINT Halt$; badline$
      ERROR %IllogicalInterval
    END IF
    z$ = GetString$(cli$)
    FOR i = debut TO fin
      IF Flag(i) = %True THEN
        PRINT Halt$; badline$
        ERROR %Redefinition
      END IF
      SELECT CASE z$
      CASE Nil$ + Unlikely$
        Translation$(i) = ""
      CASE Idem$ + Unlikely$
        Translation$(i) = CHR$(i)
      CASE ELSE
        Translation$(i) = z$
      END SELECT
      Flag(i) = %True
    NEXT
  CASE ELSE
    ' erreurs ignores ! ;-)
  END SELECT
LOOP
CLOSE #hndGlossaire
FOR i = %MinChar TO %MaxChar
  IF Flag(i) = %False THEN ERROR %MissingDefinition
NEXT
END SUB

'--------------------------------------------------------------------
