{ XBCONST.PAS - Common constants for Xphiles

Xphiles(tm) source code
Copyright (c) 1995 - 1996 by Interface Technologies
All Rights Reserved Worldwide

}
unit XbConst;

interface

uses Classes, SysUtils;

const

	{ File I/O values }
   F_ERROR     	= -1;    { File error }

   { FSeek(), FileSeek() options }

   FS_SET      	= 0;     { Seek from beginning of file }
   FS_RELATIVE 	= 1;     { Seek from current file position }
   FS_END      	= 2;     { Seek from end of file }

   { FOPEN() access modes }

   FO_READ      	= 0;     { Open for reading (default) }
   FO_WRITE     	= 1;     { Open for writing }
   FO_READWRITE 	= 2;     { Open for reading or writing }

   { FOPEN() sharing modes (combine with open mode using +) }

   FO_COMPAT    	=  0;   	{ Compatibility mode (default) }
   FO_EXCLUSIVE 	= 16;   	{ Exclusive use (other processes have no access) }
   FO_DENYWRITE 	= 32;   	{ Prevent other processes from writing }
   FO_DENYREAD  	= 48;   	{ Prevent other processes from reading }
   FO_DENYNONE  	= 64;   	{ Allow other processes to read or write }
   FO_SHARED    	= 64;   	{ Same as FO_DENYNONE }

   { FCreate() file attribute modes }

   FC_NORMAL    	= 0;    	{ Create normal read/write file (default) }
   FC_READONLY  	= 1;    	{ Create read-only file }
   FC_HIDDEN    	= 2;    	{ Create hidden file }
   FC_SYSTEM    	= 4;    	{ Create system file }

   { FCopyBytes() values }
   FC_BUFSIZE     = 65528; { Maximum GetMem() in 16-bit }

   { FSetDevMode() device modes }

   FD_RAW       	= 1;
   FD_BINARY    	= 1;
   FD_COOKED    	= 2;
   FD_TEXT      	= 2;
   FD_ASCII     	= 2;

   VowelChars  : set of char = [ 'A', 'E', 'I', 'O', 'U' ];

	_SET_EXACT       =   1;
	_SET_FIXED       =   2;
	_SET_DECIMALS    =   3;
	_SET_DATEFORMAT  =   4;
	_SET_EPOCH       =   5;
	_SET_PATH        =   6;
	_SET_DEFAULT     =   7;

	_SET_EXCLUSIVE   =   8;
	_SET_SOFTSEEK    =   9;
	_SET_UNIQUE      =  10;
	_SET_DELETED     =  11;

	_SET_CANCEL      =  12;
	_SET_DEBUG       =  13;
	_SET_TYPEAHEAD   =  14;

	_SET_COLOR       =  15;
	_SET_CURSOR      =  16;
	_SET_CONSOLE     =  17;
	_SET_ALTERNATE   =  18;
	_SET_ALTFILE     =  19;
	_SET_DEVICE      =  20;
	_SET_EXTRA       =  21;
	_SET_EXTRAFILE   =  22;
	_SET_PRINTER     =  23;
	_SET_PRINTFILE   =  24;
	_SET_MARGIN      =  25;

	_SET_BELL        =  26;
	_SET_CONFIRM     =  27;
	_SET_ESCAPE      =  28;
	_SET_INSERT      =  29;
	_SET_EXIT        =  30;
	_SET_INTENSITY   =  31;
	_SET_SCOREBOARD  =  32;
	_SET_DELIMITERS  =  33;
	_SET_DELIMCHARS  =  34;

	_SET_WRAP        =  35;
	_SET_MESSAGE     =  36;
	_SET_MCENTER     =  37;
	_SET_SCROLLBREAK =  38;

	_SET_EVENTMASK   =  39;
	_SET_VIDEOMODE   =  40;

	_SET_MBLOCKSIZE  =  41;
	_SET_MFILEEXT    =  42;

	_SET_STRICTREAD  =  43;
	_SET_OPTIMIZE    =  44;
	_SET_AUTOPEN     =  45;
	_SET_AUTORDER    =  46;
	_SET_AUTOSHARE   =  47;
   _SET_CENTURY     =  48;

type

   EXpCompat  = class( Exception );

   xbBlockProc = procedure( xVars : array of const );
   xbBlockFunc = function( xVars : array of const ) : TVarRec;
   xbBlockBool = function( xVars : array of const ) : boolean;
   CharSet     = set of char;

var
   XbAlternate    	: boolean;  { SET ALTERNATE ... toggle }
	XbAltFile 			: string;	{ SET ALTERNATE TO ... value }
   XbAltHandle    	: Integer;  { SET ALTERNATE ... output handle }
   XbCentury      	: boolean;  { SET CENTURY ... toggle }
	XbColor 				: string;	{ SET COLOR TO ... toggle }
   XbConsole      	: boolean;  { SET CONSOLE ... value }
   XbDateFormat   	: string;   { SET DATE FORMAT ... value }
   XbDecimal      	: Integer;  { SET DECIMAL ... value }
	XbDefault 			: string;	{ SET DEFAULT TO ... value }
	XbDeleted 			: boolean;	{ SET DELETED ... toggle }
   XbExact        	: boolean;  { SET EXACT ... toggle }
	XbExclusive			: boolean;	{ SET EXCLUSIVE ... toggle }
	XbFixed 				: boolean;  { SET FIXED ... toggle }
	XbMargin 			: integer;	{ SET MARGIN TO ... value }
	XbPath 				: string;	{ SET PATH TO ... value }
   XbPrinter      	: boolean;  { SET PRINTER ... toggle }
	XbPrintFile			: string;	{ SET PRINTER TO ... value }
   XbPrinterHandle	: Integer;  { SET PRINTER ... handle }
	XbSoftSeek			: boolean;	{ SET SOFTSEEK ... toggle }
	XbUnique 			: boolean;  { SET UNIQUE ... toggle }
{$IFDEF XP_APOLLO}
   XbApolloEnv       : TApolloEnv;  { Apollo Environment settings }
{$ENDIF}

implementation

end.
 