#define USE_TIME_MACROS

#include <ctype.h>
#include "mailer.h"
#include "modem.h"
#include "timers.h"
#include "transfer.h"
#include "nodelist.h"
#include "yoohoo.h"
#include "keys.h"
#include "xmisc.h"
#include "window.h"
#include "xbbs.h"


    extern MDM          *modems[MAXINSTANCES];
    extern ADDR         *addresses;
    extern HWND         xdhwnd;
    extern USHORT       focusline;
    extern unsigned int prod_maj;
    extern unsigned int prod_min;
    extern unsigned int prod_code;



/* Yoohoo receive implemented per FTS-0006 */



int _fastcall recv_yoohoo (USHORT cp,ADDR *addr,ADDR **myaddr,char *name,
                           int *reqsok) {

    int tries = 0,retries = 0,temp,escs = 0,musthavetsync = 0;
    char *p;
    HELLO hishello,myhello;
    NODEINFO nif;
    clock_t t1,t2;


    p = name;
    *p = 0;

    DosSleep(1000L);    /* initial 5 second snooze */
    t2 = timerset(60000L);

Again:

    while(retries < 128 && !timeup(t2)) {
        temp = get_modem_byte(cp,5000L);
        if(temp == ESC) {
            if(escs)
              return ESC;   /* human aborting thru? */
            escs++;
        }
        else
          escs = 0;
        switch(temp) {
            case LOSTCARRIER:   return LOSTCARRIER;

            case YOOHOO:        if(!musthavetsync && !modems[cp]->fts0001)
                                  goto GotYooHoo;
                                else break;

            case TSYNCH:        return TSYNCH;   /* FTS-0001 mailer */

            case '\r':          if(!*name || !modems[cp]->humansok || diff_stime(&modems[cp]->beginZMH,&modems[cp]->endZMH) == 1) {
                                    com_write(cp,"\r\n",2);
                                    if(!modems[cp]->humansok || diff_stime(&modems[cp]->beginZMH,&modems[cp]->endZMH) == 1) {
                                      com_write(cp,modems[cp]->mailonly,
                                                strlen(modems[cp]->mailonly));
                                    }
                                    else {
                                        com_write(cp,modems[cp]->banner,
                                                 strlen(modems[cp]->banner));
                                    }
                                }
                                else {
                                    if(strlen(name) < 4) {
                                        com_write(cp,"\07\r\n",3);
                                        com_write(cp,modems[cp]->banner,
                                                  strlen(modems[cp]->banner));
                                    }
                                    else return ESC;
                                }
                                break;

            default:            if(modems[cp]->humansok && diff_stime(&modems[cp]->beginZMH,&modems[cp]->endZMH) != 1 &&
                                  ((temp == '\b' ||
                                  temp == CTRL_Y) || isprint(temp))) {
                                    if(temp == '\b' && p > name) {
                                        com_write(cp,"\b \b",3);
                                        p--;
                                        *p = 0;
                                        Say_General(name);
                                        if(retries)
                                          retries--;
                                    }
                                    else if(p > name && temp == CTRL_Y) {
                                        while(p > name) {
                                            com_write(cp,"\b \b",3);
                                            p--;
                                            *p = 0;
                                        }
                                        Say_General(name);
                                        if(retries) retries--;
                                    }
                                    else if(isprint(temp) && p < name + 35) {
                                        if(temp == ' ' && (p == name || *(p - 1) == ' ')) {
                                            com_putc(cp,'\07');
                                            break;
                                        }
                                        *p = (char)temp;
                                        if(p == name || *(p - 1) == ' ' ||
                                          *(p - 1) == '\'' || *(p - 1) == '.')
                                            *p = (char)toupper(*p);
                                        else
                                          *p = (char)tolower(*p);
                                        com_putc(cp,*p);
                                        p++;
                                        *p = 0;
                                        Say_General(name);
                                        if(retries)
                                          retries--;
                                    }
                                    else
                                      com_putc(cp,'\07');
                                }
                                break;
        }
        retries++;
    }

    return TIMEOUT;

GotYooHoo:

    temp = recv_hello(cp,&hishello,addr,myaddr);
    switch(temp) {
        case LOSTCARRIER:   return LOSTCARRIER;

        case TIMEOUT:       return TIMEOUT;

        case TSYNCH:        musthavetsync = 1;
                            logfunc(2,cp,"Asshole doesn't do dietIFNA");
                            goto Again;
    }
    Change_Status("Yoohoo");
    logfunc(1,cp,"***Yoohoo");

    if(*hishello.sysop || *hishello.my_name)
    logfunc(0,cp,"Remote: %s#%u:%u/%u.%u (%u %u.%u)",addr->domain,
            addr->zone,addr->net,addr->node,addr->point,hishello.product,
            hishello.product_maj,hishello.product_min);
    if(*hishello.sysop || *hishello.my_name) {
        logfunc(1,cp,"%-0.20s@%-0.60s",hishello.sysop,hishello.my_name);
        sprintf(modems[cp]->lastmailer,"%-0.20s@%-0.60s",hishello.sysop,
                hishello.my_name);
        WinPostMsg(xdhwnd,WM_LASTMAILER,MPFROM2SHORT(cp,0),
                   (MPARAM)modems[cp]->lastmailer);
    }
    else
      logfunc(0,cp,"Other end's hello packet has \"blanks\"");

    nif.net = addr->net;
    nif.node = addr->node;
    if(get_node_from_list(&nif,addr->zone,addr->point,addr->domain)) {
        if(*nif.password) {
            if(strnicmp(hishello.my_password,nif.password,8)) {
                logfunc(0,cp,"Password mismatch:  Us: \"%-0.8s\"  Them: \"%-0.8s\"",nif.password,hishello.my_password);
                dropDTR(cp);
                return LOSTCARRIER;
            }
            modems[cp]->whichin = 0;    /* password-protected node */
        }
        else modems[cp]->whichin = 1;   /* unpassworded node */
    }
    else modems[cp]->whichin = 2;       /* unlisted node */
    logfunc(0,cp,"Responding as %s#%u:%u/%u.%u",(*myaddr)->domain,
             (*myaddr)->zone,(*myaddr)->net,(*myaddr)->node,(*myaddr)->point);

    *reqsok = (hishello.capabilities & WZ_FREQ);
    if(diff_stime(&modems[cp]->beginZMH,&modems[cp]->endZMH) == 1) {
        *reqsok = 0;
    }

LookENQ:

    t1 = timerset(10000L);
    do {
        temp = get_modem_byte(cp,5000L);
        switch(temp) {
            case LOSTCARRIER:   return LOSTCARRIER;

            case ENQ:           goto GotENQ;
        }
    } while(!timeup(t1));

    if(retries > 9) return TIMEOUT;
    com_putc(cp,YOOHOO);
    retries++;
    goto LookENQ;

GotENQ:

    temp = send_hello(cp,&myhello,*myaddr,nif.password);
    switch(temp) {
        case 0:             Change_Status("Yoohoo/2U2");
                            return YOOHOO;

        case LOSTCARRIER:   return LOSTCARRIER;

    }
    goto Again;
}
