#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"
#include "nodelist.h"
#include "xmsg.h"
#include "msgid.h"

#pragma optimize("",off)

    extern MDM               *modems[MAXINSTANCES];
    extern USER              *user[MAXINSTANCES];
    extern ADDR              *addresses;
    extern BBS               *bbs;


int _fastcall write_msg (int mode,USHORT cp,MSGAREA *newarea,
                         MSGAREA *oldarea,XMSG *oldmsg,USHORT flags) {

    /* bitmapped flags values:
        1:  force to force-to name
        2:  force private
        4:  force public
        8:  use existing MSGTMP.### file
    */

    XMSG msg;
    char s[166],fname[13],*p;


    if(!newarea)
      return -1;
    memset(&msg,0,sizeof(XMSG));

    if(flags & 1) {
        if(newarea->forceto && *newarea->forceto)
            strcpy(msg.to,newarea->forceto);
        else
            strcpy(msg.to,"SYSOP");
    }
    else if(!*get_msg_to(mode,cp,&msg))
        return -1;

    if(!stricmp(msg.to,"SYSOP") && ((newarea->areaflags & M_ECHO) ||
      (newarea->areaflags & M_GROUP) || (newarea->areaflags & M_USENET) ||
      (newarea->areaflags & M_QWK))) {
        sayp(mode,cp,250,NULL,0);
        return -1;
    }

    if(!*get_msg_subj(mode,cp,&msg))
        return -1;

    if(strlen(msg.to) < 3 || strlen(msg.subj) < 2)
      return -1;

    if(newarea->areaflags & M_REAL)
      strcpy(msg.from,user[cp]->name);
    else
      strcpy(msg.from,user[cp]->handle);

    set_msg_attribs(mode,cp,&msg,newarea,flags);
    set_msg_date(mode,cp,&msg);

    if(newarea->areaflags & M_NET) {

        ADDR addr,*faddr;

        memset(&addr,0,sizeof(ADDR));
        if(get_msg_addr(mode,cp,&addr,&msg)) return -1;
        if(is_addr_valid(mode,cp,&addr)) return -1;
        sayp(mode,cp,251,NULL,0);
        dprintf(mode,cp,"%u",msg.cost);
        sayp(mode,cp,252,NULL,0);
        dprintf(mode,cp,"%ld\r\n",user[cp]->credit);
        DosSleep(500L);
        if((long)msg.cost > user[cp]->credit) {
            sayp(mode,cp,253,NULL,0);
            return -1;
        }
        msg.d_zone = addr.zone;
        msg.d_net = addr.net;
        msg.d_node = addr.node;
        msg.d_point = addr.point;

        faddr = best_guess(&addr,addresses);
        if(!faddr)
          faddr = addresses;
        msg.o_zone = faddr->zone;
        msg.o_net = faddr->net;
        msg.o_node = faddr->node;
        msg.o_point = faddr->point;

        sprintf(s,"MSGTMP%u ",cp);
        make_msgid(cp,&s[strlen(s)],faddr);
        make_msgto(cp,&s[strlen(s)],&addr);
    }
    else {

        ADDR *faddr;

        if((newarea->areaflags & M_ECHO) || newarea->areaflags & M_GROUP) {
          faddr = best_guess(newarea->addr,addresses);
          if(!faddr)
            faddr = addresses;
          msg.o_zone = faddr->zone;
          msg.o_net = faddr->net;
          msg.o_node = faddr->node;
          msg.o_point = faddr->point;
        }
        else
          faddr = addresses;
        sprintf(s,"MSGTMP%u ",cp);
        make_msgid(cp,&s[strlen(s)],faddr);
    }

    msg.upmsg = 0;
    msg.dnmsg = 0;
    msg.unused = 0;

    if(!(newarea->areaflags & M_NET) && !(newarea->areaflags & M_ECHO) &&
      (msg.fflags & MSGPRIVATE) && !(flags & 1)) {
        if(check_private_validity(mode,cp,msg.to,newarea)) return -1;
    }

    sprintf(fname,"MSGTMP%u",cp);
    if(!(flags & 8))
        if(line_editor(mode,cp,fname,E_NOFROM + (((flags & 1) != 0) * E_NOTO),&msg))
          return -1;

    set_msg_import_date(&msg);

    if((newarea->areaflags & M_ECHO) && !(newarea->areaflags & M_NOORIG)) {
        if(add_tear_and_origin(mode,cp,fname,newarea) == -1)
            return -1;
    }

    if(!(newarea->areaflags & M_NET) && !(newarea->areaflags & M_ECHO) &&
      (msg.fflags & MSGPRIVATE) && !(flags & 1) && !(flags & 8)) {
        if(check_private_validity(mode,cp,msg.to,newarea))
          return -1;
    }

    p = bbs_strdup(cp,s);
    if(post_message(cp,&msg,&p,
                     newarea->number,1) == MSG_NOERR) {
        if(newarea->areaflags & M_NET) user[cp]->credit -= (long)msg.cost;
        {
            char ss[256];

            sprintf(ss,sayp(mode,cp,254,s,165),msg.to,newarea->name);
            logfunc(0,cp,ss);
        }
        return 0;
    }
    return -1;
}




char * _fastcall get_msg_subj (int mode,USHORT cp,XMSG *msg) {

    pinput_string(mode,cp,msg->subj,59,2,255,
                 STRT_ALL,STRF_NEAT,
                 "Msg Subj",NULL);
    return msg->subj;
}




char * _fastcall get_msg_to (int mode,USHORT cp,XMSG *msg) {

    pinput_string(mode,cp,msg->to,35,3,256,
                 STRT_ALL,STRF_PRETTY,
                 "Msg To",NULL);
    if(!stricmp(msg->to,user[cp]->name) || !stricmp(msg->to,user[cp]->handle)) {
        *msg->to = 0;
    }
    return msg->to;
}




char * _fastcall get_msg_from (int mode,USHORT cp,XMSG *msg) {

    pinput_string(mode,cp,msg->from,35,3,257,
                 STRT_ALL,STRF_PRETTY,
                 "Msg From",NULL);
    return msg->from;
}



int _fastcall get_msg_addr (int mode,USHORT cp,ADDR *addr,XMSG *msg) {

    char s[66],num[66],hs[66],*p;
    int  temp;
    ADDR taddr;


    if(!addr->zone && !addr->net && !addr->node && !addr->point &&
       !*addr->domain) {
      if(*msg->to && find_in_fidouser(mode,cp,msg->to,&taddr)) {
        guess_rest(&taddr,addresses);
        *addr = taddr;
      }
    }

    strset(s,0);
    if(addr->zone) {
        strcat(s,ltoa((long)addr->zone,num,10));
        strcat(s,":");
    }
    if(addr->net) {
        strcat(s,ltoa((long)addr->net,num,10));
        strcat(s,"/");
    }
    if(addr->node) {
        strcat(s,ltoa((long)addr->node,num,10));
    }
    if(addr->point) {
        strcat(s,".");
        strcat(s,ltoa((long)addr->point,num,10));
    }
    else if(*s || *addr->domain) {
      strcat(s,".0");
    }
    if(*addr->domain) {
        strcat(s,"@");
        strcat(s,addr->domain);
    }

    pinput_string(mode,cp,s,65,3,258,
                 STRT_ALL,0,
                 "Msg Destaddr",NULL);
    rstrip(s);
    lstrip(s);
    if(!*s) {
      return -1;
    }

    strcpy(hs,s);

    p = s;
    temp = parse_addr(&p,&taddr,addresses);
    if(temp) {
        sayp(mode,cp,259,NULL,0);
        if(!find_in_fidouser(mode,cp,s,&taddr)) {
            sayp(mode,cp,260,NULL,0);
            return -1;
        }
        guess_rest(&taddr,addresses);
    }

    sprintf(num,"%s#%u:%u/%u.%u",
            taddr.domain,taddr.zone,taddr.net,taddr.node,taddr.point);
    if(stricmp(hs,num)) {
      sayp(mode,cp,261,NULL,0);
      dputs(mode,cp,num);
    }

    {
        NODEINFO nif;

        nif.net = taddr.net;
        nif.node = taddr.node;
        if(get_node_from_list(&nif,taddr.zone,taddr.point,taddr.domain)) {
            sayp(mode,cp,248,NULL,0);
            msg->cost = (word)nif.rate;
            dprintf(mode,cp,"%s -=> %s\r\n",nif.name,nif.city);
        }
        else {
            sayp(mode,cp,249,NULL,0);
        }
    }

    strset(s,0);
    pinput_string(mode,cp,s,1,1,262,STRT_YN,
                 STRF_HOT | STRF_UCASE,"Addr Correct",NULL);
    if(*s == modems[cp]->NO) return -1;

    return 0;
}




int _fastcall is_addr_valid (int mode,USHORT cp,ADDR *addr) {

    return guess_rest(addr,addresses);
}



int _fastcall make_reply_addresses (int mode,USHORT cp,XMSG *omsg,XMSG *nmsg,
                                    USER *user,MSGAREA *narea) {

    memset(nmsg,0,sizeof(XMSG));
    lstrip(omsg->subj);
    if(strnicmp(omsg->subj,"RE:",3))
      sprintf(nmsg->subj,"Re: %0.55s",omsg->subj);
    else
      strcpy(nmsg->subj,omsg->subj);
    if(narea->areaflags & M_REAL)
      strcpy(nmsg->from,user->name);
    else
      strcpy(nmsg->from,user->handle);
    nmsg->d_zone = omsg->o_zone;
    nmsg->d_net = omsg->o_net;
    nmsg->d_node = omsg->o_node;
    nmsg->d_zone = omsg->o_point;
    return 0;
}


void _pascal set_msg_attribs (int mode,USHORT cp,XMSG *msg,MSGAREA *marea,
                              unsigned int flags) {

    /* bit-mapped flags values:
       1:
       2: force private
       4: force public
    */

    char yorn[6];


    msg->xflags = 0;
    msg->fflags = MSGLOCAL;

    if((marea->areaflags & M_NET) || (marea->areaflags & M_GROUP)) {
        msg->xflags |= MSGNET;
    }
    else if(marea->areaflags & M_ECHO) {
        msg->xflags |= MSGECHO;
    }

    if(!(flags & 6) && (marea->areaflags & M_PRIVATE) && (marea->areaflags & M_PUBLIC)) {
        strset(yorn,0);
        if(*pinput_string(mode,cp,yorn,1,1,263,
                         STRT_YN,STRF_HOT,"Msg Private",NULL) == modems[cp]->YES) {
            msg->fflags |= MSGPRIVATE;
        }
        else {
            msg->fflags &= (~MSGPRIVATE);
        }
    }
    else if(marea->areaflags & M_PRIVATE || (flags & 2)) {
        msg->fflags |= MSGPRIVATE;
    }
    else {
        msg->fflags &= (~MSGPRIVATE);
    }

    if(marea->areaflags & M_ANON) {
        strset(yorn,0);
        if(*pinput_string(mode,cp,yorn,1,1,264,
                         STRT_YN,STRF_HOT,"Msg Anonymous",NULL) == modems[cp]->YES) {
            msg->xflags |= MSGANON;
        }
        else {
            msg->xflags &= (~MSGANON);
        }
    }
}



int _fastcall set_msg_cost (int mode,USHORT cp,XMSG *msg,ADDR *addr) {

    NODEINFO nif;


    nif.node = addr->node;
    nif.net = addr->net;
    if(get_node_from_list(&nif,addr->zone,addr->point,addr->domain)) {
        msg->cost = (word)nif.rate;
        dprintf(mode,cp,"\r\n %s#%u:%u/%u.%u -- %s\r\n %s\r\n",addr->domain,
                addr->zone,addr->net,addr->node,addr->point,
                nif.name,nif.city);
        return 0;
    }

    return -1;
}




int _fastcall edit_msg_attribs (int mode,USHORT cp,XMSG *msg,
                                MSGAREA *marea) {

    char yorn[6];


    if((marea->areaflags & M_PRIVATE) && (marea->areaflags & M_PUBLIC)) {
        strset(yorn,0);
        if(*pinput_string(mode,cp,yorn,1,1,263,
                         STRT_YN,STRF_HOT,"Msg Private",NULL) == modems[cp]->YES) {
            msg->fflags |= MSGPRIVATE;
        }
        else {
            msg->fflags &= (~MSGPRIVATE);
        }
    }

    if(marea->areaflags & M_ANON) {
        strset(yorn,0);
        if(*pinput_string(mode,cp,yorn,1,1,264,
                         STRT_YN,STRF_HOT,"Msg Anonymous",NULL) == modems[cp]->YES) {
            msg->xflags |= MSGANON;
        }
        else {
            msg->xflags &= (~MSGANON);
        }
    }

    if(msg_sysop_ok(user[cp],marea)) {

        /* Finish someday */

    }

    return 0;
}



int _fastcall edit_msg_hdr (int mode,USHORT cp,XMSG *msg,MSGAREA *marea) {


    return 0;
}



int _fastcall add_tear_and_origin (int mode,USHORT cp,char *fname,
                                   MSGAREA *marea) {

    int handle;
    char ad[64];
    char origin[81];


    handle = sopen(fname,O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYWR);
    if(handle == -1)
      return -1;
    lseek(handle,0L,SEEK_END);
    sprintf(ad," (%s%s%u:%u/%u",marea->addr->domain,(*marea->addr->domain) ?
            "#" : "",marea->addr->zone,marea->addr->net,marea->addr->node);
    if(marea->addr->point)
      sprintf(&ad[strlen(ad)],".%u",marea->addr->point);
    ffprintf(handle,"\r--- XBBS-OS/2 0.00\r * Origin: ");
    strcpy(origin,bbs->origin);
    origin[78 - (12 + strlen(ad))] = 0;
    strcat(origin,ad);
    ffprintf(handle,"%s)\r",origin);
    close(handle);
    return 0;
}



int _fastcall set_msg_date (int mode,USHORT cp,XMSG *msg) {

    char s[21];
    time_t t;

    t = time(NULL);
    strftime(s,20,"%a %d %b %y %H:%M",localtime(&t));
    if(s[4] == '0') s[4] = ' ';
    strncpy(msg->date,s,20);
    msg->date[19] = 0;
    return 0;
}



int _fastcall set_msg_import_date (XMSG *msg) {

    time_t dos_date;
    struct tm *tm_date;

    dos_date = time(NULL);
    tm_date = localtime(&dos_date);
    msg->indate[0] = (char)(tm_date->tm_year - 89);
    msg->indate[1] = (char)(tm_date->tm_mon + 1);
    msg->indate[2] = (char)tm_date->tm_mday;
    msg->indate[3] = 0;
    return 0;
}



int _fastcall make_reply (int mode,USHORT cp,XMSG *omsg,MSGAREA *oarea,
                          USER *user,MSGAREA *narea,char *oldmsgid,
                          word oldmsgnum,USHORT flags) {

    /* bitmapped flags values:
        1:  force to force-to name
        2:  force private
        4:  force public
    */

    XMSG msg;
    char s[256],fname[13],*p;


    memset(&msg,0,sizeof(XMSG));

    make_reply_addresses(mode,cp,omsg,&msg,user,narea);
    if(narea->areaflags & M_REAL)
      strcpy(msg.from,user->name);
    else
      strcpy(msg.from,user->handle);
    if(!(omsg->xflags & MSGANON))
      strcpy(msg.to,omsg->from);
    else {
      sayp(mode,cp,266,msg.to,35);
      if(!*msg.to) strcpy(msg.to,"%Anonymous%");
    }
    if(flags & 1) {
      if(narea->forceto && *narea->forceto)
          strcpy(msg.to,narea->forceto);
        else
          strcpy(msg.to,"SysOp");
    }
    else if(!stricmp(msg.to,user->name) || !stricmp(msg.to,user->handle)) {
        if(!*get_msg_to(mode,cp,&msg))
          return -1;
    }
    set_msg_attribs(mode,cp,&msg,narea,flags);
    set_msg_date(mode,cp,&msg);

    msg.upmsg = oldmsgnum;
    msg.dnmsg = 0;
    msg.unused = 0;

    if(narea->areaflags & M_NET) {

        ADDR addr,*faddr;

        memset(&addr,0,sizeof(ADDR));
        addr.zone = msg.d_zone;
        addr.net = msg.d_net;
        addr.node = msg.d_node;
        addr.point = msg.d_point;

        if(get_msg_addr(mode,cp,&addr,&msg))
          return -1;
        if(is_addr_valid(mode,cp,&addr))
          return -1;
        sayp(mode,cp,251,NULL,0);
        dprintf(mode,cp,"%u",msg.cost);
        sayp(mode,cp,252,NULL,0);
        dprintf(mode,cp,"%ld\r\n",user->credit);
        if((long)msg.cost > user->credit) {
            sayp(mode,cp,253,NULL,0);
            return -1;
        }
        msg.d_zone = addr.zone;
        msg.d_net = addr.net;
        msg.d_node = addr.node;
        msg.d_point = addr.point;

        faddr = best_guess(&addr,addresses);
        if(!faddr)
          faddr = addresses;
        msg.o_zone = faddr->zone;
        msg.o_net = faddr->net;
        msg.o_node = faddr->node;
        msg.o_point = faddr->point;
        sprintf(s,"MSGTMP%u ",cp);
        make_msgid(cp,&s[strlen(s)],faddr);
        if(oldmsgid && *oldmsgid)
          make_replyid(cp,&s[strlen(s)],oldmsgid);
        make_msgto(cp,&s[strlen(s)],&addr);
        DosSleep(1000L);
    }
    else {
        msg.o_zone = narea->addr->zone;
        msg.o_net = narea->addr->net;
        msg.o_node = narea->addr->node;
        msg.o_point = narea->addr->point;
        sprintf(s,"MSGTMP%u ",cp);
        make_msgid(cp,&s[strlen(s)],narea->addr);
        if(oldmsgid && *oldmsgid)
          make_replyid(cp,&s[strlen(s)],oldmsgid);
    }

    if(!(narea->areaflags & M_NET) && !(narea->areaflags & M_ECHO) &&
      (msg.fflags & MSGPRIVATE) && !(flags & 1)) {
        if(check_private_validity(mode,cp,msg.to,narea)) return -1;
    }

    sprintf(fname,"MSGTMP%u",cp);
    if(line_editor(mode,cp,fname,E_NOFROM + (((flags & 1) != 0) * E_NOTO),&msg)) return -1;
    set_msg_import_date(&msg);
    if((narea->areaflags & M_ECHO) && !(narea->areaflags & M_NOORIG)) {
        if(add_tear_and_origin(mode,cp,fname,narea) == -1)
            return -1;
    }

    if(!(narea->areaflags & M_NET) && !(narea->areaflags & M_ECHO) &&
      (msg.fflags & MSGPRIVATE) && !(flags & 1)) {
        if(check_private_validity(mode,cp,msg.to,narea)) return -1;
    }

    p = bbs_strdup(cp,s);
    if(post_message(cp,&msg,&p,
                    narea->number,1) == MSG_NOERR) {
        if(narea->areaflags & M_NET) user->credit -= (long)msg.cost;
        {
            char ss[256];

            sprintf(ss,sayp(mode,cp,254,s,165),msg.to,narea->name);
            logfunc(0,cp,ss);
        }
        return 0;
    }

    return -1;
}



char * _fastcall make_msgid (USHORT cp,char *s,ADDR *addr) {

    if(addr->point) {
      sprintf(s,"\01MSGID: %s#%u:%u/%u.%u %08lx\r",addr->domain,addr->zone,
              addr->net,addr->node,addr->point,NextMsgidSerial());
    }
    else
      sprintf(s,"\01MSGID: %s#%u:%u/%u %08lx\r",addr->domain,addr->zone,
              addr->net,addr->node,NextMsgidSerial());
    RefreshMsgidDLL();
    return s;
}




char * _fastcall make_msgto (USHORT cp,char *s,ADDR *addr) {

    if(addr->point) {
        sprintf(s,"\01MSGTO: %s#%u:%u/%u.%u\r",addr->domain,addr->zone,
                addr->net,addr->node,addr->point);
    }
    else {
        sprintf(s,"\01MSGTO: %s#%u:%u/%u\r",addr->domain,addr->zone,
                addr->net,addr->node);
    }
    return s;
}




char * _fastcall make_replyid (USHORT cp,char *s,char *replyid) {

    strcpy(s,"\01REPLY: ");
    strcat(s,replyid);
    strcat(s,"\r");
    return s;
}



int _fastcall check_private_validity (int mode,USHORT cp,char *name,
                                      MSGAREA *info) {

    unsigned int dummy,temp;
    USER         *dummy2;


    if(!stricmp(name,"SYSOP") && !stricmp(info->name,"Feedback")) return 0;
    dummy2 = bbs_malloc(cp,sizeof(USER));
    if(!dummy2) return -1;
    memset(dummy2,0,sizeof(USER));
    temp = find_user(mode,cp,dummy2,name,&dummy);
    bbs_free(cp,dummy2);
    if(!temp) {
        sayp(mode,cp,265,NULL,0);
        return 1;
    }
    else return 0;
}

#pragma optimize("",on)

