/*
 * I use this to upgrade users periodically in a semi-automatic way
 */

#pragma pack(1)

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"


void spin (void) {

  static int  x = 0;
  static char *spinner = "/-\\|";

  if(!spinner[x])
    x = 0;
  fputc(spinner[x++],stdout);
  fputc('\b',stdout);
}


int main (int argc,char *argv[]) {

    int    handle,key = 0;
    USHORT c = 0;
    long   pos;
    ULONG  issec = 5L,makesec = 6L;
    char   *filename = "./users.bb2";   /* default */
    USER   u;

    if(argc > 1)
      filename = argv[1];
    if(argc > 2)
      issec = atol(argv[2]);
    if(argc > 3)
      makesec = atol(argv[3]);

    handle = sopen(filename,O_RDWR | O_BINARY,SH_DENYRW);
    if(handle == -1) {
      printf("\nCouldn't open user file \"%s\"\n",filename);
      return 1;
    }

lseek(handle,0L,SEEK_SET);
printf("\x1b[s\x1b[1;1H\x1b[K\x1b[u");
    while(!eof(handle)) {
      spin();
      pos = tell(handle);
      /* read record */
      if(read(handle,&u,(size_t)(sizeof(USER) - USERSUB)) !=
         (size_t)(sizeof(USER) - USERSUB))
        break;
      c++;
printf("\x1b[s\x1b[1;1H%u\x1b[u",c);
      if(u.security1 <= issec && !(u.attribs & (U_DELETED | U_LOCKEDOUT))) {
        printf("\nUser #%u\n",c);
        printf("Name:     \"%s\"\nHandle:   \"%s\"\nAddress:  \"%s\"\n",
               u.name,u.handle,u.address);
        printf("Phone:    \"%s\"\nBirthday: %04u/%02u/%02u\nSecLvl:   %lu\n",
               u.phone_number,u.birthyear,u.birthmonth,u.birthday,u.security1);
        printf("  Upgrade to %lu? [Y/n/d/l/q] ",makesec);
        key = getch();
        if(key == '\r' || toupper(key) == 'Y' || toupper(key) == 'D' ||
           toupper(key) == 'L') {
          if(toupper(key) == 'L')
            u.attribs |= U_LOCKEDOUT;
          else if(toupper(key) == 'D')
            u.attribs |= U_DELETED;
          else
            u.security1 = makesec;
          /* seek back to start of record */
          if(lseek(handle,pos,SEEK_SET) == -1)
            break;
          /* rewrite modified record */
          if(write(handle,&u,(size_t)(sizeof(USER) - USERSUB)) !=
             (size_t)(sizeof(USER) - USERSUB))
            break;
        }
        else if(key == '\x1b' || toupper(key) == 'Q')
          break;
      }
    }

    close(handle);

    if(key != '\x1b' && toupper(key) != 'Q')
      printf("\n  **Complete.\n");
    else
      printf("\n  **Aborted.\n");

    return 0;
}
