#define INCL_DOS

#include <os2.h>      // for DosSleep
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdarg.h>
#include <ctype.h>
#include <io.h>       // for setmode
#include <fcntl.h>    // for O_BINARY
#include "type109.h"

/*
 * this is just a simple example of what a type 109 Door might look like.
 * XBBS handles all the modem stuff; you read and write stdin and stdout.
 * note that flushing the buffered i/o is required, so this code uses
 * "specialized" input and output functions that you can build on:
 * mygets, myprintf and myputs.
 */


int main (void) {

  /* just for testing; does nothing important... */

  char string[133];
  FILE *fp;
  int  lines = 0;

  myinit();
  fp = fopen("type109.c","rt");
  if(fp) {
    while(!feof(fp)) {
      if(!fgets(string,132,fp))
        break;
      myprintf("%s\r",string);
      if(++lines > 23 && !feof(fp)) {
        lines = 0;
        myputs("More? (Y/n) ");
        if(toupper(*mygets(string,1,1)) == 'N')
          break;
        myputs("\b\b\b\b\b\b\b\b\b\b\b\b            \b\b\b\b\b\b\b\b\b\b\b\b");
      }
    }
    fclose(fp);
  }
  myputs("\r\n\r\nAnything you wanna say?\r\n -> ");
  if(*mygets(string,74,0))
    myprintf("\r\nYou said:\r\n\r\n%s\r\n",string);
  myputs("[Any key to exit] ");
  mygets(string,1,1);
  return 0;
}

  
char * mygets (char *gather, int len, int hot) {

  /* 
   * gather is a buffer at least len + 1 bytes long in which the
   * string is placed and returned.  if hot is non-zero, the function
   * will automatically return when the buffer is full, otherwise it
   * requires a carriage return to complete.  primitive editting is
   * provided via the delete and ctrl-y keys.  UNTESTED.
   */

  register int x = 0,c;
  time_t       timer;

  *gather = 0;
  timer = time(NULL) + 240L;
  for(;;) {
    if((c = fgetc(stdin)) != EOF) {
      timer = time(NULL) + 240L;
      if(c == '\r' || c == '\n')
        break;
      if(c == '\b' && x) {
        myputs("\b \b");
        x--;
        continue;
      }
      if(c == 25 && x) {
        while(x--)
          myputs("\b \b");
        continue;
      }
      if(!isprint(c))
        continue;
      fputc(c,stdout);
      fflush(stdout);
      gather[x++] = (char)c;
      gather[x] = 0;
      if(x >= len) {
        if(hot)
          break;
        fputc('\07',stdout);
        fflush(stdout);
        continue;
      }
    }
    else {
      DosSleep(33L);
      if(timer < time(NULL))
        exit(1);
    }
  }
  return gather;
}

int myprintf (char *string,...) {

    /* called just like printf */

    int     x;
    char    buffer[2048];
    va_list pArguments;

    va_start(pArguments,string);
    x = vsprintf(buffer,string,pArguments);
    va_end(pArguments);
    fputs(buffer,stdout);
    fflush(stdout);
    return x;
}


int myputs (char *s) {

  int ret;

  ret = fputs(s,stdout);
  fflush(stdout);
  return ret;
}


void myinit (void) {

  setvbuf(stdin,NULL,_IONBF,1);
  setvbuf(stdout,NULL,_IONBF,1);
  setvbuf(stderr,NULL,_IONBF,1);
  setmode(fileno(stdin),O_BINARY);
  setmode(fileno(stdout),O_BINARY);
  setmode(fileno(stderr),O_BINARY);
}
