/***********************************/
/* This module sends outgoing mail */
/***********************************/

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include "mailer.h"
#include "bbs.h"
#include "transfer.h"
#include "nodelist.h"
#include "modem.h"
#include "timers.h"
#include "xmisc.h"
#include "window.h"

    extern MDM   *modems[MAXINSTANCES];
    extern BBS   *bbs;
    extern int   *_threadid;


int _fastcall send_mail (USHORT cp,ADDR *addr,ADDR *myaddr,char *password,
                         int didrecv,int polling,int DoingYooHoo) {

    int         temp,chktec = 0,retries,handle;
    HDIR        search_handle;
    USHORT      num_matches;
    char       *s,eligible[13] = "APTCDN",*p,*pp,dostrays = 0,did = 0,
                second = 0;
    clock_t     t1;
    PKTHDR      pkt;
    struct stat st;
    FILEFINDBUF *f;
      
    if(didrecv)
      strcat(eligible,"HM");
    else {
        modems[cp]->lastaddress.zone = addr->zone;   /* set last session addr */
        modems[cp]->lastaddress.net = addr->net;
        modems[cp]->lastaddress.node = addr->node;
        modems[cp]->lastaddress.point = addr->point;
        strcpy(modems[cp]->lastaddress.domain,addr->domain);
        modems[cp]->wasbbs = 0;
        Change_Last();
    }
    if(polling && !didrecv)
      strcat(eligible,"M"); /* more eligible decisions */

    s = (char *)malloc(1050);                       /* allocate some junk */
    f = (FILEFINDBUF *)malloc(sizeof(FILEFINDBUF));
    if(!s || !f) {
      if(s)
        free(s);
      if(f)
        free(f);
      logfunc(0,cp,"Out of memory");
      return 0;
    }

    if(didrecv && DoingYooHoo) {

      make_dirname("*",s,addr);   /* check for eligible mail */

      search_handle = HDIR_CREATE;
      num_matches = 1;

      if(!DosFindFirst(s,&search_handle,0,f,
         sizeof(FILEFINDBUF),&num_matches,0L)) {
          do {
            if(strchr(eligible,toupper(*f->achName)) || (toupper(*f->achName) == 'R' && modems[cp]->hefreqs && modems[cp]->sfreqsok)) {
              DosFindClose(search_handle);
              goto CheckIt;
            }
            num_matches = 1;
          } while(!DosFindNext(search_handle,f,sizeof(FILEFINDBUF),
                               &num_matches));
          DosFindClose(search_handle);
        }

        sprintf(s,"%s/%08x.REQ",bbs->inbound[modems[cp]->whichin],*_threadid); /* any wazoo reqs? */
        if(!modems[cp]->rfreqsok || stat(s,&st))
          goto TryReqs;                            /* no mail to send */
    }

CheckIt:  /* attempt to get XModem/Sealink started */

    if(didrecv) {

      t1 = timerset(30000L);  /* wait for line clear 1/2 second */
      while(!timeup(t1) && get_modem_byte(cp,500L) > -1);
      if(timeup(t1)) {    /* garbage */
        free(s);
        free(f);
        logfunc(0,cp,"Other end is gibbering");
        return 0;
      }
      if(checkcarrier(cp)) {
        free(s);
        free(f);
        return 0;  /* lost carrier */
      }

      t1 = timerset(30000L);      /* 30 seconds to get a poll request */
      retries = 0;
      Say_General("Attempting to start send");
      while(retries < 30 && !timeup(t1)) {
        com_putc(cp,TSYNCH);
        temp = peek_at_byte(cp,1500L);
        switch(temp) {
            case LOSTCARRIER:   free(s);
                                free(f);
                                logfunc(0,cp,"Lost carrier");
                                return 0;

            case SUB: /* ?? */
            case EOT:    if(temp == EOT || (temp == SUB && retries < 3)) {
                             com_putc(cp,ACK);
                             DosSleep(300L);
                             purge_in(cp);
                             Say_General("Got EOT/SUB; ACKing");
                         }
                         else {
                            get_modem_byte(cp,32L);
                            Say_General("Got EOT/SUB");
                         }
                         break;

            case NAK:
            case 'C':    Say_General("Got polling C/NAK, beginning send");
                         goto SendIt;

            case SOH:    get_modem_byte(cp,32L);
                         Say_General("Got SOH; cancelling");
                         send_cancel(cp,1);
                         break;

            case TIMEOUT: if(!((retries + 1) % 5))
                            com_putc(cp,ACK);
                          break;

            default:
#ifdef DEBUG
                          logfunc(2,cp,"Got ASCII %d; ignoring",temp);
#endif
                          get_modem_byte(cp,32L);
                          break;
            }
            retries++;
        }
    }

SendIt:     /* send mail packet */

    Say_General("");
    make_dirname("P",s,addr);

    if(!stat(s,&st)) { /* packet exists, send in any case */

        char pk[13];

        if(st.st_size == 0L) {
            unlink(s);
            goto NoPkt;
        }

        Change_Status("Sending packet");
        if(password && *password) {     /* assure up-to-date password */
            handle = sopen(s,O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYNO);
            if(handle != -1) {
                memset(&pkt,0,sizeof(PKTHDR));
                read(handle,&pkt,sizeof(PKTHDR));
                lseek(handle,0L,SEEK_SET);
                strncpy(pkt.password,password,8);
                write(handle,&pkt,sizeof(PKTHDR));
                close(handle);
            }
        }
        sprintf(pk,"%08lx.PKT",time(NULL));  /* filename to remote */
        if(!send_file(cp,s,0,1,(DoingYooHoo == 0),1,pk)) {
            logfunc(0,cp,"Packet send error");
            inc_calls(addr,1);
            free(s);
            free(f);
            return 0;
        }
        else {
            unlink(s);
            logfunc(0,cp,"Unlinked packet %s",s);
        }
    }
    else {                  /* send intro pkt only if FTS-0001 or broken... */

NoPkt:

/*        if(DoingYooHoo && modems[cp]->hisprodcode == XBBSPRODCODE)
            goto MailOK;
*/
        fill_in_pkt_hdr(&pkt,myaddr,addr,password);
        make_fts1plus_pkt_from_file (&pkt,addr,myaddr);
        sprintf(s,"%08x.PKT",*_threadid);
        sprintf(&s[15],"%08lx.PKT",time(NULL));
        if(!send_file(cp,s,0,1,(DoingYooHoo == 0),1,&s[15])) {
            logfunc(0,cp,"Packet send error");
            free(s);
            free(f);
            kill_pkt();
            inc_calls(addr,1);
            return 0;
        }
        kill_pkt();
        logfunc(1,cp,"Sent packet");
    }

    goto TryNet2;

StrayPKTs:  /* send packets created while we were sending other junk */

    make_dirname("P",s,addr);
    goto DoPkt2;

TryNet2:

    make_dirname("T",s,addr);

DoPkt2:

    if(!stat(s,&st)) {

        char pk[13];

        Change_Status("Sending \'Stray\' Packets");
        sprintf(pk,"%08x.PKT",clock());  /* filename to remote */
        temp = 0;
        if(!DoingYooHoo) {
            temp = modem7_send(cp,pk);
            if(temp != 'C' && temp != ACK) {
                if(temp == LOSTCARRIER) {
                    logfunc(0,cp,"Lost carrier during archive send");
                }
                else logfunc(0,cp,"Modem-7 send fail");
                free(s);
                free(f);
                return 0;
            }
        }
        if(!send_file(cp,s,(temp == ACK),1 + ((temp == 'C') * 2),0,1,pk)) {
            logfunc(0,cp,"Stray packet send error");
            free(s);
            free(f);
            inc_calls(addr,1);
            return 0;
        }
        else {
            unlink(s);
            logfunc(0,cp,"Unlinked packet %s",s);
        }
    }

    if(*s == 'P')
      goto TryNet2;

/* MailOK */     /* send all mail archives */

    make_dirname("A",s,addr);
    if(!stat(s,&st)) {

        char pk[13];

        Change_Status("Sending Archived Mail");
        sprintf(pk,"%04x%04x.MO0",myaddr->net - addr->net,myaddr->node - addr->node);  /* filename to remote */
        temp = 0;
        if(!DoingYooHoo) {
            temp = modem7_send(cp,pk);
            if(temp != 'C' && temp != ACK) {
                if(temp == LOSTCARRIER) {
                    logfunc(0,cp,"Lost carrier during archive send");
                }
                else logfunc(0,cp,"Modem-7 send fail");
                free(s);
                free(f);
                return 0;
            }
        }
        if(!send_file(cp,s,(temp == ACK),1 + ((temp == 'C') * 2),0,1,pk)) {
            logfunc(0,cp,"Archive send error");
            free(s);
            free(f);
            inc_calls(addr,1);
            return 0;
        }
        else {
            unlink(s);
            logfunc(0,cp,"Unlinked archive %s",s);
        }
    }

/* ArcOK */      /* send all attached files */

    dostrays = 0;
    make_dirname("*",s,addr);

    search_handle = -1;
    num_matches = 1;

    /* Remove archives and packets from eligible list */
    if(!did)
      memmove(eligible,&eligible[3],strlen(&eligible[3]) + 1);

    if(!DosFindFirst(s,&search_handle,0,f,
       sizeof(FILEFINDBUF),&num_matches,0L)) {

        char *was;

        was = (char *)malloc(257);
        if(!was) {
          logfunc(0,cp,"Out of memory");
          if(!didrecv) {
            goto EndOfBatch;
          }
          goto TryReqs;
        }

        do {
            long pos = 0L;

            if(!strchr(eligible,toupper(*f->achName))) {
                if(strchr("PAT",toupper(*f->achName))) dostrays = 1;
                goto KeepLooking;
            }

            sprintf(s,"%s/%s",d_outbound,f->achName);
            handle = sopen(s,O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
            if(handle == -1) {
                logfunc(0,cp,"Couldn't open %s",s);
                goto KeepLooking;
            }

            p = f->achName;   /* copy type field to was */
            pp = was;
            while(*p != '.') {
                *pp = *p;
                pp++;
                p++;
                *pp = 0;
            }

            while(!eof(handle)) {   /* send files in attach file */

                int trunc,kill;

                pos = tell(handle);
                if(!fgetsx(s,1024,handle))
                  break;
                Change_Status("Sending attached files");
                p = strchr(s,';'); /* get rid of comments, empty lines, junk */
                if(p)
                  *p = 0;
                stripcr(s);
                p = lstrip(s);
                p = rstrip(p);
                if(!*p)
                  continue;

                kill = 0;
                trunc = 0;
                if(*p == '^') {
                    kill = 1;
                    p++;
                }
                else if(*p == '~') {
                    trunc = 1;
                    p++;
                }

                pp = strchr(p,' ');   /* see if we should use psuedonym for filename */
                if(pp) {
                    *pp = 0;
                    pp++;
                    lstrip(pp);
                    if(!*pp) pp = NULL;
                }

                if(stat(p,&st)) {
                    logfunc(0,cp,"Can't find %s",p);
                    continue;
                }
                if(!st.st_size)
                  continue;    /* null-length file */

                temp = 0;
                if(!DoingYooHoo) {
                    if(pp && *pp) {
                        temp = modem7_send(cp,pp);
                    }
                    else {
                        temp = modem7_send(cp,p);
                    }
                    if(temp != 'C' && temp != ACK) {
                        if(temp == LOSTCARRIER) {
                            logfunc(0,cp,"Lost carrier during batch send");
                        }
                        else logfunc(0,cp,"Modem-7 send fail");
                        DosFindClose(search_handle);
                        free(s);
                        free(f);
                        rebuild_list(handle,pos,was,addr);
                        free(was);
                        return 0;
                    }
                }
                if(send_file(cp,p,(temp == ACK),1 + ((temp == 'C') * 2),
                   0,1,pp)) {
                    if(kill) {
                        unlink(p);
                        logfunc(0,cp,"Unlinked %s",p);
                    }
                    if(trunc) {

                        int han;

                        han = sopen(p,O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYWR);
                        if(han == -1)
                          logfunc(0,cp,"Can't truncate %s",p);
                        else {
                            DosNewSize(han,0L);
                            logfunc(0,cp,"Truncated %s",p);
                            close(han);
                        }
                    }
                }
                else {
                    DosFindClose(search_handle);
                    free(s);
                    free(f);
                    rebuild_list(handle,pos,was,addr);
          free(was);
          logfunc(0,cp,"Send error, terminating session");
          inc_calls(addr,1);
          return 0;
        }
        purge_in(cp);
      }

            close(handle);
            make_dirname(was,s,addr);   /* done with attach file */
            logfunc(0,cp,"Unlinked attach file %s",s);
            unlink(s);
//            free(was);
//            DosFindClose(search_handle);
//            goto ArcOK;

KeepLooking:    /* 'skip' point */

            num_matches = 1;
        } while(!DosFindNext(search_handle,f,sizeof(FILEFINDBUF),
                             &num_matches));
        DosFindClose(search_handle);
        free(was);
    }
    if(dostrays && did < 3) {
      did++;
      goto StrayPKTs;
    }

TryReqs:    /* handle wazoo file requests (*.REQ's received) */

    if(second)
      goto EndOfBatch;

    if(didrecv)
      wazoo_reqs(cp,addr,myaddr);

    make_dirname("R",s,addr);

    if(DoingYooHoo && !didrecv && modems[cp]->sfreqsok &&
       modems[cp]->hefreqs) {

        char wazooname[15];

        if(!stat(s,&st)) {
            Change_Status("Sending Wazoo Request");
            sprintf(wazooname,"%04x%04x.REQ",addr->net,addr->node);
            logfunc(0,cp,"Sending Wazoo REQuest %s",wazooname);
            if(send_file(cp,s,0,1,0,1,wazooname)) {
                unlink(s);
                logfunc(0,cp,"Unlinked request file %s",s);
            }
        }
    }

    if(!second) {
      second++;
      goto StrayPKTs;
    }

EndOfBatch:     /* everything to be sent 'normally' has been sent */
                /* try to tell other end to quit receiving */

    t1 = timerset(10000L);
    do {
        chktec = get_modem_byte(cp,1000L);
        switch(chktec) {
            case LOSTCARRIER:   free(s);
                                free(f);
                                if(didrecv)
                                  p = "--no sweat";
                                else
                                  p = "";
                                logfunc(0,cp,"Lost carrier @ EOB%s",p);
                                return 0;

            case TSYNCH:        Say_General("Got TSYNCH");
                                break;

            case 'C':
            case NAK:           com_putc(cp,EOT);
                                break;

            default:
#ifdef DEBUG
                                logfunc(2,cp,"EOB ignored %d",chktec);
#endif
                                break;
        }
    } while(!timeup(t1) && chktec != 'C' && chktec != NAK && chktec != TSYNCH);

    Say_General("");
    if(timeup(t1)) {
        com_putc(cp,EOT);
        logfunc(0,cp,"Sent end-of-batch @ timeout");
    }
    else
      logfunc(0,cp,"Sent end-of-batch");

    Change_Status("End-of-batch");

    if(!didrecv || DoingYooHoo)
      goto SayDone;   /* skip bark stuff */

    make_dirname("R",s,addr);

    if(!stat(s,&st)) {          /* send bark requests */
        Change_Status("Bark negotiation--send");
        logfunc(1,cp,"Bark negotiation--send");
        t1 = timerset(45000L);
        while(!timeup(t1)) {
            temp = get_modem_byte(cp,5000L);
            switch(temp) {
                case LOSTCARRIER:   free(s);
                                    free(f);
                                    logfunc(0,cp,"Lost carrier");
                                    return 0;

                case TIMEOUT:       Say_General("Timeout: resending SYN");
                                    com_putc(cp,SYN);
                                    break;

                case CAN:
                                    logfunc(0,cp,"CAN: Remote refused requests");
                                    goto TakeReqs;

                case ENQ:           Say_General("ENQ: Sending bark");
                                    send_bark(cp,addr);
                                    goto TakeReqs;

                case SUB:           Say_General("SUB: resending SYN");
                                    com_putc(cp,SYN);
                                    break;

                case 'C':
                case NAK:           Say_General("Polling C/NAK; cancelling");
                                    com_putc(cp,EOT);
                                    break;

                default:
#ifdef DEBUG
                                    logfunc(2,cp,"Got ASCII %d; ignoring",temp);
#endif
                                    break;

            }
        }
    }

TakeReqs:

    Say_General("");
    Change_Status("Bark negotiation--receive");
    logfunc(1,cp,"Bark negotiation--receive");
    recv_bark(cp,myaddr,addr,1); /* receive bark requests */

    /* you may now leave the bus */

SayDone:

    if(didrecv) {              /* say this if we called */
        Change_Status("End Session");
        logfunc(1,cp,"********End session");
    }
    free(s);    /* terminate with prejudice */
    free(f);
    return (1 + (DoingYooHoo != 0));
}
