#define  INCL_DOS
#define  INCL_RXSUBCOM
#define  INCL_RXSYSEXIT

#include <os2.h>
#include <rexxsaa.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"

  extern MDM  *modems[MAXINSTANCES];
  extern BBS  *bbs;
  extern USER *user[MAXINSTANCES];

  static BOOL    fRexxOK = FALSE;

  static HMODULE hmodREXX;
  static HMODULE hmodREXXAPI;

  static SHORT   (APIENTRY *pfnREXXSAA)(SHORT,PRXSTRING,
                                        PSZ,PRXSTRING,PSZ,SHORT,
                                        PRXSYSEXIT,PSHORT,PRXSTRING);
  static USHORT  (APIENTRY *pfnRxSubcomRegister)(PSCBLOCK);
  static USHORT  (APIENTRY *pfnRxSubcomDrop)(PSZ,PSZ);
  static USHORT  (APIENTRY *pfnRxExitRegister)(PSCBLOCK);
  static USHORT  (APIENTRY *pfnRxExitDrop)(PSZ,PSZ);

SHORT  EXPENTRY MYREXX  (PRXSTRING p, PUSHORT pusRet, PRXSTRING prxstrgret);
SHORT  EXPENTRY MYRXIO  (SHORT sCode, SHORT sSubcode, PVOID pvParm);
SHORT  EXPENTRY MYRXHLT (SHORT sCode, SHORT sSubcode, PVOID pvParm);
SHORT  EXPENTRY MYRXINI (SHORT sCode, SHORT sSubcode, PVOID pvParm);

USHORT          RexxExecCommand (int mode,USHORT cp,char *cmd,
                                 PRXSTRING prxstrgret);

// --------------------------------------------------------------------------

#define REXXSAA          (*pfnREXXSAA)
#define RxSubcomRegister (*pfnRxSubcomRegister)
#define RxSubcomDrop     (*pfnRxSubcomDrop)
#define RxExitRegister   (*pfnRxExitRegister)
#define RxExitDrop       (*pfnRxExitDrop)



USHORT LoadRexx (void) {

  HMODULE hmod;
  CHAR    achBuf[CCHMAXPATH];
  USHORT  usErr = 0;

  if(hmodREXX)
    return TRUE;
  fRexxOK = FALSE;
  if(DosLoadModule(achBuf, CCHMAXPATH, "REXX", &hmod))
    return FALSE;
  hmodREXX = hmod;

  if(DosLoadModule(achBuf, CCHMAXPATH, "REXXAPI", &hmod)) {
    DosFreeModule(hmodREXX);
    hmodREXX = 0;
    return FALSE;
  }
  hmodREXXAPI = hmod;

  usErr |= DosGetProcAddr(hmodREXX,    "REXXSAA",          (PPFN)&pfnREXXSAA);
  usErr |= DosGetProcAddr(hmodREXXAPI, "RXSUBCOMREGISTER", (PPFN)&pfnRxSubcomRegister);
  usErr |= DosGetProcAddr(hmodREXXAPI, "RXSUBCOMDROP",     (PPFN)&pfnRxSubcomDrop);
  usErr |= DosGetProcAddr(hmodREXXAPI, "RXEXITREGISTER",   (PPFN)&pfnRxExitRegister);
  usErr |= DosGetProcAddr(hmodREXXAPI, "RXEXITDROP",       (PPFN)&pfnRxExitDrop);

  if(usErr) {
    DosFreeModule(hmodREXX);
    DosFreeModule(hmodREXXAPI);
    hmodREXX = hmodREXXAPI = 0;
    return FALSE;
  }

  return (fRexxOK = TRUE);
}



SHORT EXPENTRY MYREXX (PRXSTRING p, PUSHORT pusRet, PRXSTRING prxstrgret) {

  CHAR    achBuf[1024],*pp;
  ULONG   i;
  int     mode;
  USHORT  cp;

  i = p->strlength;
  memcpy(achBuf, p->strptr, (SHORT)i);
  achBuf[i] = 0;
  cp = atoi(achBuf);
  if(cp > MAXINSTANCES || !modems[cp])
    return 1;
  mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
  pp = strchr(achBuf,',');
  if(pp)
    memmove(achBuf,pp + 1,strlen(pp));
  else
    *achBuf = 0;

  *pusRet = RexxExecCommand(mode,cp,achBuf,prxstrgret);
  if(prxstrgret->strptr)
    i = atol(prxstrgret->strptr);
  else
    i = 0;

  return (SHORT)i;
}


SHORT EXPENTRY MYRXIO (SHORT sCode, SHORT sSubcode, PVOID pvParm) {

  RXSIOSAY_PARM *pparm = (RXSIOSAY_PARM *)pvParm;
  PRXSTRING     p      = &(pparm->rxsio_string);
  CHAR          achBuf[1024],*pp;
  ULONG         i;
  int           mode;
  USHORT        cp;

  if(sCode == RXSIO) {
    i = p->strlength;
    memcpy(achBuf,p->strptr,(SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp > MAXINSTANCES || !modems[cp])
      return 1;
    mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
    pp = strchr(achBuf,',');
    if(pp)
      memmove(achBuf,pp + 1,strlen(pp));
    else
      *achBuf = 0;
    if(sSubcode == RXSIOSAY) {
      dputs(mode,cp,achBuf);
      dputs(mode,cp,"\r\n");
      return 0;
    }
    else if((sSubcode == RXSIOTRD) || (sSubcode == RXSIODTR)) {
      strcpy(p->strptr,achBuf);
      input_string(mode,cp,p->strptr,249,0,NULL,STRT_ALL,STRF_NOHELP,NULL,NULL);
      dputs(mode,cp,"\r\n");
      p->strlength = strlen(p->strptr);
      return 0;
    }
  }

  return 1;
}


  // These next two functions, MYRXHLT and MYRXINI don't seem to work!
  // MYRXHLT doesn't seem to get called.  MYRXINI gets called but
  // installing a new Ctrl-BREAK handler doesn't seem to have any effect...

SHORT EXPENTRY MYRXHLT (SHORT sCode, SHORT sSubcode, PVOID pvParm) {

  RXHLTTST_PARM *pparm = (RXHLTTST_PARM *)pvParm;

  if(sCode == RXHLT) {
    if(sSubcode == RXHLTCLR) {
      pparm->rxhlt_flags.rxfhhalt = 0;
      return 0;
    }
    else if(sSubcode == RXHLTTST) {
      pparm->rxhlt_flags.rxfhhalt = 0;
      return 0;
    }
  }

  return 1;
}


SHORT EXPENTRY MYRXINI (SHORT sCode, SHORT sSubcode, PVOID pvParm) {

  (void)pvParm;
  (void)sSubcode;
  (void)sCode;

  return 0;
}



USHORT RexxScriptFile (int mode,USHORT cp,char *fname) {

  SCBLOCK   sc_block = { NULL, "MYSUBCOM", NULL, NULL, 0., (PFN)MYREXX,  0, 0, 0, 0 };
  SCBLOCK   io_block = { NULL, "MYRXIO",   NULL, NULL, 0., (PFN)MYRXIO,  0, 0, 0, 0 };
#if 0
  // This is the setup for MYRXHLT which doesn't appear to be working
  // under versions of OS/2 and REXX which have been tested!
  RXSYSEXIT exit_list[] = { {"MYRXIO", RXSIO}, {NULL, RXENDLST} };
  SCBLOCK   ht_block    = { NULL, "MYRXHLT", NULL, NULL, 0., (PFN)MYRXHLT, 0, 0, 0, 0 };
  RXSYSEXIT exit_list[] = { {"MYRXIO", RXSIO}, {"MYRXHLT", RXHLT}, {NULL, RXENDLST} };
#endif
  SCBLOCK   in_block    = { NULL, "MYRXINI", NULL, NULL, 0., (PFN)MYRXINI, 0, 0, 0, 0 };
  RXSYSEXIT exit_list[] = { {"MYRXIO", RXSIO}, {"MYRXINI", RXINIEXT}, {NULL, RXENDLST} };

  RXSTRING  arg;                       /* argument string for REXX   */
  RXSTRING  rexxretval;                /* return value from REXX     */
  SHORT     rc = 0;                    /* return code from REXX      */
  SHORT     rexxrc = 0;                /* return code from function  */
  CHAR     *s;

  if(hmodREXX == 0)
    return 0xffff;                    /* If we aren't loaded, leave */

  rexxretval.strlength = 0L;          /* initialize return to empty */
  rexxretval.strptr    = NULL;        /* initialize return to empty */

  s = malloc(250);
  if(!s)
    return 0xffff;
  sprintf(s,"%u",cp);                 /* initialize argument */
  MAKERXSTRING(arg,s,strlen(s));

  RxExitRegister(&io_block);
  // RxExitRegister(&ht_block); // If MYRXHLT were working we'd do this....
  RxExitRegister(&in_block);
  RxSubcomRegister(&sc_block);
  logfunc(0,cp,"Executing REXX interpreter on \"%s\"",fname);
  rc = REXXSAA( (SHORT)      1,         /* call the REXX interpreter  */
                (PRXSTRING)  &arg,
                (PSZ)        fname,
                (PRXSTRING)  0,
                (PSZ)        "MYSUBCOM",
                (SHORT)      RXSUBROUTINE,
                (PRXSYSEXIT) exit_list,
                (PSHORT)     &rexxrc,
                (PRXSTRING)  &rexxretval );

  if(arg.strptr)
    free(arg.strptr);
  if(rexxretval.strptr)
    DosFreeSeg(SELECTOROF(rexxretval.strptr));
  RxSubcomDrop("MYSUBCOM", "");
  RxExitDrop("MYRXINI", "");
  // RxExitDrop("MYRXHLT", "");
  RxExitDrop("MYRXIO", "");
  logfunc(0,cp,"Completed REXX command file \"%s\": rc = %d rexxrc = %d",
          fname,rc,rexxrc);
  return rexxrc;
}


  // This is the actual subcom handler.
  //    cmd        is the actual command to execute
  //    prxstrgret is the result buffer to fill
  // The function should return RXSUBCOM_OK or RXSUBCOM_ERROR

USHORT RexxExecCommand (int mode,USHORT cp,char *cmd, PRXSTRING retval) {

  SHORT       len;
  CHAR        FailName[CCHMAXPATH],comspec[CCHMAXPATH],*p;
  PSZ         parm;
  RESULTCODES rescode;
  USHORT      retcode = RXSUBCOM_OK;

  if(!strnicmp(cmd,"XBBSCONVERT ",12)) {

    char *p,*retstring;

    p = cmd + 12;
    while(*p == ' ')
      p++;
    retstring = bbs_convert_string(cp,p);
    if(retstring && *retstring) {
      if(strlen(retstring) > 249) {

        USHORT selector;

        if(!DosAllocSeg(strlen(retstring + 1),&selector,2))
          retval->strptr = (char *)MAKEP(selector,0);
        else {
          bbs_free(cp,retstring);
          retval->strlength = 0L;
          return RXSUBCOM_ERROR;
        }
      }
      strcpy(retval->strptr,retstring);
      retval->strlength = (ULONG) strlen (retval->strptr);
      bbs_free(cp,retstring);
    }
    else
      retval->strlength = 0L;
    return RXSUBCOM_OK;
  }

  /*******************************************************************/
  /* All we are going to do here is pass on the command passed to us */
  /* to another copy of CMD.EXE and have it execute the command.     */
  /*******************************************************************/

  parm = malloc ((USHORT) strlen(cmd) + CCHMAXPATH);
  if (parm == NULL) {
    retval->strlength = 0L;
    return RXSUBCOM_ERROR;
  }
  p = getenv("COMSPEC");
  if(!p)
    p = "CMD.EXE";
  strcpy(comspec,p);
  strcpy(parm,p);
  len = strlen (parm) + 1;
  strcpy (parm + len," /C ");
  len += 4;
  memcpy (parm + len, cmd, (USHORT)strlen(cmd));
  len += (USHORT) strlen(cmd);
  *(parm + len) = '\0';                  // 2 nulls
  *(parm + len + 1) = '\0';              //   required

  DosExecPgm (FailName, sizeof (FailName), EXEC_SYNC, parm, NULL,
              &rescode, comspec);

  if(rescode.codeTerminate != TC_EXIT)
     retcode = RXSUBCOM_ERROR;
  free (parm);

  itoa (rescode.codeResult, retval -> strptr, 10);
  retval->strlength = (ULONG) strlen (retval->strptr);

  return retcode;
}
