#define USE_TIME_MACROS

#include <io.h>
#include <ctype.h>
#include <limits.h>
#include <fcntl.h>
#include <share.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <sys\utime.h>
#include "mailer.h"
#include "bbs.h"
#include "transfer.h"
#include "modem.h"
#include "timers.h"
#include "xmisc.h"
#include "window.h"
#include "xbbs.h"

  #define D_LOCAL           0x0002

  extern MDM  *modems[MAXINSTANCES];
  extern HWND  xdhwnd;
  extern BBS  *bbs;
  extern int  *_threadid;
  extern unsigned int crctab[];

/* Functions for implementing XModem & SEAlink receive per FTS-0007
 * This code should be completely reentrant and capable of running
 * under multiple threads simultaneously.  Thanks to Phil for
 * excellent specs to code from, and Tom who thunk it up and Thom
 * who improved it.  Someday I may implement ZedZap, but lemme tell
 * you, writing completely reentrant protocols isn't easy or pretty.
 */


char * _fastcall getblock (USHORT cp, char *pbuf, int blksize, int chktec) {

  /* read a block of data from commport.
   * chktec > 0 for CRC-16 or 0 for checksum
   * data goes into buf (pre-allocated)
   * reads blksize bytes into buf
   * SOH and blk/comp should have already been read
   */

  register int     c;
  register char    temp,*buf = pbuf;
  USHORT           ourcrc, hiscrc;

  c = get_modem_block(cp,buf,blksize,1000L + ((blksize > 128) ? 1000L : 0L));
  if(c == LOSTCARRIER)
    return "Carrier";
  if(c == TIMEOUT) {
    purge_in(cp);
    return "Short Blk";
  }

  c = blksize;
  if(chktec) {        /* calc CRC */
    ourcrc = 0;
    while(c--)        /* calc crc inline for speed */
      ourcrc = (ourcrc << 8) ^ crctab[(ourcrc >> 8) ^ *buf++];
    ourcrc = ((ourcrc & 255) << 8) | ((ourcrc >> 8) & 255);
    c = get_modem_block(cp,(char *)&hiscrc,2,500L);
    if(c == LOSTCARRIER)
      return "Carrier";
    if(c == TIMEOUT)
      return "CRC Short";
  }
  else {              /* calc checksum */
    temp = 0;
    while(c--) {
      temp += *buf++;
    }
    ourcrc = (USHORT)temp;

    c = get_modem_byte(cp,500L);
    if(c == LOSTCARRIER)
      return "Carrier";
    if(c == TIMEOUT)
      return "CSum Short";
  }

  if(ourcrc == hiscrc)
    return NULL;        /* good block */
  if(chktec != 0)
    return "CRC";       /* else error */
  return "Csum";
}


char * _fastcall recv_file (USHORT cp,char *filename,int altentry,
                            char *prepath) {

  /* receives a file via sealink or telink/xmodem as detailed in
   * FTS-0007.  IMPORTANT NOTE:  this function returns a filename
   * if successful, NULL otherwise.  If a filename is returned, it
   * is the >caller's< responsibility to free the filename pointer*.
   * Note also that in the case of a double-CAN when the start-of-
   * block is expected, or other bizaare error, the filename
   * ";Aborted..." is returned for esoteric reasons (and must be freed).
   */

  FILE *fp;
  int  sealink,slo,resync,retries,chktec,c,macflow,temp,gotone = 0,err,
       blksize = 128,lastsealink = -1,lastslo = -1,blkrecv = 0,
       onceinced = 0;
  unsigned int lastacked = 0,conditional = 0;
  char blocknum,*status,buf[133],*fname,oneEOT = 0,ackedonce = 0,*p,
       timeouts = 1,oldpri[2];
  long writeblk,toterr = -1L,lastblk = 0L,wuzblk = 0L,tester;
  clock_t t1,t2 = 0L;
  struct _p_telink_block {    /* standard block w/out lead/end bytes */
    long size;
    int  time;
    int  date;
    char filename[16];
    char hdr;
    char sender[16];
    char crcmode;
    char fill[86];
  } tlblk;
  struct zeros slblk;
  struct _thisfile {          /* We use this struct locally */
    char name[17];
    char sender[17];
    long size;
    int  time;
    int  date;
    long stamp;
  } tf;
  TRANSBUF tbuf,*dupebuf;

  memset(&tf,0,sizeof(struct _thisfile));
  memset(&tbuf,0,sizeof(TRANSBUF));
  modems[cp]->checkcd = 1;

  set_devctlblk(cp,0,1,1);
  DosGetPrty(2,(PUSHORT)oldpri,*_threadid);
  DosSetPrty(2,modems[cp]->transfer[0],modems[cp]->transfer[1],*_threadid);

  if(prepath) {
    do {
      status = strchr(prepath,'\\');
      if(status)
        *status = '/';
    } while(status);
  }

  memset(&tf,0,sizeof(struct _thisfile));
  memset(&slblk,0,sizeof(struct zeros));
  memset(&tlblk,0,sizeof(struct _p_telink_block));
  strcpy(tf.sender,"Anonymous XModem");  /* if we get straight XModem */

  fname = (char *)malloc(1027);
  if(!fname) {
    DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
    return NULL;
  }

  if(filename && *filename && prepath)
    sprintf(fname,"%s/%s",prepath,filename);
  else if((!filename || !*filename) && prepath)
    sprintf(fname,"%s/%04x%04x.UNK",prepath,(int)(time(NULL) & 0xffffL),
            *_threadid);
  else if((filename && *filename) && !prepath)
    strcpy(fname,filename);
  else
    sprintf(fname,"%04x%04x.UNK",(int)(time(NULL) & 0xffffL),*_threadid);

  if(!modems[cp]->curbaud)
    modems[cp]->curbaud = 2400;
  tester = (6L * (1L + (4L * (modems[cp]->curbaud > 4800))));

/* XR0 */

  sealink = 0;
  slo = 0;
  resync = 0;
  macflow = 0;
  chktec = 1;
  blocknum = 0;
  writeblk = 1L;
  retries = 0;
  if(!DosSemWait(&modems[cp]->bbsrunningSEM,0L)) {
    t1 = timerset(60000L);
    t2 = timerset(45000L);
  }
  else {
    t1 = timerset(160000L);
    t2 = timerset(100000L);
  }
  if(altentry == SOH) {
    logfunc(2,cp,"SOH already received; skipping initial C/NAK");
    goto SOHrecvd;        /* Modem-7 skip may set */
  }
  else if(altentry == SYN) {
    logfunc(2,cp,"SYN already received; skipping initial C/NAK");
    goto SYNrecvd;        /* altentry to SYN or SOH */
  }
  else if(altentry) {
    logfunc(2,cp,"Skipping initial C/NAK");
    goto XR3;
  }

XR1:

  sendnak(cp,&resync,&sealink,&chktec,&blocknum,NULL,slo,&writeblk);
  tbuf.err = "C/NAK";
  tbuf.errcount++;
  tbuf.type = TB_ERR;
  toterr++;
  dupebuf = memdupe(&tbuf,sizeof(tbuf));
  if(dupebuf)
    if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                   MPFROMP(dupebuf)))
      free(dupebuf);
  lastacked = 0;

XR3:

  if(gotone) {
    t1 = timerset(60000L);
    retries = 0;
  }

/* XR2 */

  else {
    altentry = 0;
    if(!t2)
      t2 = timerset(45000L);
  }

  while(retries < 45 && !timeup(t1)) {

    if(!gotone) {

      /* this stuff only executed while waiting on first block */

      if(timeup(t2) || retries > 8) {
        tbuf.misc = "Going checksum";
        tbuf.type = TB_MISC;
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                         MPFROMP(dupebuf)))
            free(dupebuf);
        lastsealink = -1;
        chktec = 0;
        slo = 0;
      }
    }
    else {

      /* this stuff only executed after first block received */

      if(toterr > 15L || retries > 10) {
        if(slo) {
          tbuf.misc = "Overdrive off";
          tbuf.type = TB_MISC;
          dupebuf = memdupe(&tbuf,sizeof(tbuf));
          if(dupebuf)
            if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                           MPFROMP(dupebuf)))
              free(dupebuf);
        }
        lastsealink = -1;
        slo = 0;
      }

      if(modems[cp]->maxtranserrs && toterr) {
        if(toterr > (long)modems[cp]->maxtranserrs) {
          strcpy(fname,";Aborted -- too many errors");
          tbuf.misc = "Too many errors";
          tbuf.type = TB_ABORT;
          dupebuf = memdupe(&tbuf,sizeof(tbuf));
          if(dupebuf)
            if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                           MPFROMP(dupebuf)))
              free(dupebuf);
          DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
          if(fp)
            fclose(fp);
          Clear_UD();
          purge_in(cp);
          return fname;
        }
      }
    }

    c = get_modem_byte(cp,3000L);    /* looking for mr. goodbar... */

ReSwitch:

    switch(c) {

      /* I decided to go ahead and implement two CANs in a row as
         an abort by remote.  So sue me. */

      case SOH:   /* sealink or data block if waiting for first, */
                  /* else better be a data block */
SOHrecvd:

        timeouts = 0;
        oneEOT = 0;
        c = get_modem_byte(cp,500L);      /* blocknum */
        if(c == LOSTCARRIER || c == TIMEOUT)
          goto ReSwitch;
        if(!gotone) {                     /* waiting for #0 */
          altentry = 0;
          temp = get_modem_byte(cp,500L); /* blk cmp */
          if(temp == LOSTCARRIER || c == TIMEOUT) {
            c = temp;
            goto ReSwitch;
          }
          if(temp == (c ^ 255)) {         /* if match, in business */
            if(c == 0) {                  /* sealink header block */
              status = getblock(cp,(char *)&slblk,blksize,chktec);
              if(!status) {
                if(modems[cp]->nosealink) {
                  logfunc(2,cp,"Intentionally rejecting Sealink hdr blk");
                  tbuf.err = "NoSEA";
                  tbuf.errcount++;
                  tbuf.type = TB_ERR;
                  dupebuf = memdupe(&tbuf,sizeof(tbuf));
                  if(dupebuf)
                    if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                   MPFROMP(dupebuf)))
                      free(dupebuf);
                  toterr++;
                  goto XR1;
                }
                tbuf.misc = "Sealink hdr";
                tbuf.type = TB_MISC;
                dupebuf = memdupe(&tbuf,sizeof(tbuf));
                if(dupebuf)
                  if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                 MPFROMP(dupebuf)))
                    free(dupebuf);
                lastsealink = -1;
                gotone++;
                if(*slblk.fnam && !strchr(tf.name,'/'))
                  strncpy(tf.name,slblk.fnam,17);
                tf.name[16] = 0;
                rstrip(tf.name);
                tf.size = slblk.flen;
                strncpy(tf.sender,slblk.prog,15);
                tf.sender[15] = 0;
                tf.stamp = slblk.fstamp;
                sealink = 1;
                macflow = (slblk.macflow != 0);
                resync = (slblk.resync != 0);
                if(*tf.name) {
                  /* get rid of any path crap in filename */
                  p = tf.name;
                  while(*p) {
                    if(*p == '/')
                      *p = '\\';
                    p++;
                  }
                  p = strrchr(tf.name,'\\');
                  if(p)
                    memmove(tf.name,p,strlen(p) + 1);
                  /* replace illegal characters w/ underline -- assume HPFS */
                  p = tf.name;
                  while(*p) {
                    if(strchr("*?<>|:\"",*p) || *p < 0x1f)
                      *p = '_';
                    p++;
                  }
                  if(is_an_inbound(prepath)) {  /* check for req */
                    p = strrchr(tf.name,'.');
                    if(p) {
                      p++;
                      if(!stricmp(p,"REQ"))
                        sprintf(tf.name,"%08x.REQ",*_threadid);
                    }
                  }
                  if(prepath)
                    sprintf(fname,"%s/%s",prepath,tf.name);
                  else {
                    strcpy(fname,tf.name);
                  }
                }
                retries = 0;
                goto XR4;
              }
              tbuf.err = status;
              tbuf.errcount++;
              tbuf.type = TB_ERR;
              dupebuf = memdupe(&tbuf,sizeof(tbuf));
              if(dupebuf)
                if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                               MPFROMP(dupebuf)))
                  free(dupebuf);
              toterr++;
              goto XR1;
            }
            else {      /* first xmodem data block */
              status = getblock(cp,buf,blksize,chktec);
              if(!status) {
                gotone++;
                fp = _fsopen(fname,"r+b",SH_DENYWR);
                if(!fp)
                  fp = _fsopen(fname,"w+b",SH_DENYWR);
                if(!fp) {
                  send_cancel(cp,2);
                  tbuf.misc = "File open error";
                  tbuf.type = TB_ABORT;
                  dupebuf = memdupe(&tbuf,sizeof(tbuf));
                  if(dupebuf)
                    if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                   MPFROMP(dupebuf)))
                      free(dupebuf);
                  strcpy(fname,";Aborted--open error");
                  DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
                  Clear_UD();
                  return NULL;
                }
                else
                 setvbuf(fp,NULL,_IOFBF,BUFSIZ * 12);
                if(wuzblk != writeblk - 1L)
                  fseek(fp,((writeblk - 1L) * blksize),SEEK_SET);
                err = fwrite(buf,1,blksize,fp);
                if(err < blksize) {
                  /* ??? */
                }
                writeblk++;
                wuzblk = writeblk;
                logfunc(2,cp,"ACKing initial XModem datablock");
                sendack(cp,&slo,&sealink,&blocknum,writeblk);
                lastacked = 1;
                conditional = 0;
                goto SayIt;
              }
              else {
                tbuf.err = status;
                tbuf.errcount++;
                tbuf.type = TB_ERR;
                dupebuf = memdupe(&tbuf,sizeof(tbuf));
                if(dupebuf)
                  if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                 MPFROMP(dupebuf)))
                    free(dupebuf);
                toterr++;
              }
              goto XR1;
            }
          }
          else {
            tbuf.err = "Blk/cmp mismatch";
            tbuf.errcount++;
            tbuf.type = TB_ERR;
            dupebuf = memdupe(&tbuf,sizeof(tbuf));
            if(dupebuf)
              if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                             MPFROMP(dupebuf)))
                free(dupebuf);
            c = temp;
            retries++;
            goto ReSwitch;
          }
        }

        /* otherwise, we're already receiving file */

        temp = get_modem_byte(cp,500L); /* blk cmp */
        if(temp == LOSTCARRIER || temp == TIMEOUT) {
          c = temp;
          goto ReSwitch;
        }
        if(temp == (c ^ 255)) { /* if match, get blk */
          status = getblock(cp,buf,blksize,chktec);
          if(!status) {   /* good block */
            if(c == (int)(writeblk & 255L)) {
              ackedonce = 0;
              if(wuzblk != writeblk - 1L)
                fseek(fp,((writeblk - 1L) * 128L),SEEK_SET);
              err = fwrite(buf,1,blksize,fp);
              if(err < blksize) {
                /* ??? */
              }
              if(sealink != lastsealink || slo != lastslo) {
                if(sealink && !slo)
                  tbuf.misc = "SEAlink";
                else if(sealink && slo)
                  tbuf.misc = "SEAlink/Overdrive";
                else
                  tbuf.misc = "XModem";
                tbuf.type = TB_MISC;
                dupebuf = memdupe(&tbuf,sizeof(tbuf));
                if(dupebuf)
                  if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                 MPFROMP(dupebuf)))
                    free(dupebuf);
                lastsealink = sealink;
                lastslo = slo;
              }
              if(!(blkrecv % tester)) {
                tbuf.type = TB_TICK;
                tbuf.bytessent = writeblk * 128L;
                dupebuf = memdupe(&tbuf,sizeof(tbuf));
                if(dupebuf)
                  if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                 MPFROMP(dupebuf)))
                    free(dupebuf);
              }
              blkrecv++;
              wuzblk = writeblk;
              writeblk++;
              sendack(cp,&slo,&sealink,&blocknum,writeblk);
              retries = 0;
              lastacked = 1;
              conditional = 0;
              goto XR3;
            }
            else if(c == (int)((writeblk & 255L) - 1L)) {   /* last block again? */
              ackedonce = 0;
              blocknum--;
              sendack(cp,&slo,&sealink,&blocknum,writeblk);
              lastacked = 1;
              conditional = 0;
              goto XR3;
            }
            else {  /* not expected block */
              if(!sealink) {  /* xmodem can't recover */
                tbuf.type = TB_ABORT;
                tbuf.misc = "Blocks unsynched";
                dupebuf = memdupe(&tbuf,sizeof(tbuf));
                if(dupebuf)
                  if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                                 MPFROMP(dupebuf)))
                    free(dupebuf);
                logfunc(0,cp,"Transfer hopelessly botched--received %hu expected %ld",
                        (char)c,writeblk);
                fclose(fp);
                free(fname);
                DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
                Clear_UD();
                return NULL;
              }
              else {  /* sealink might... */

                char hiblk,loblk;

                hiblk = ((char)(writeblk & 255L)) + (char)127;
                loblk = ((char)(writeblk & 255L)) + (char)1;

                if((char)((c & 255) + 1) >= loblk &&
                   (char)((c & 255) + 127) <= hiblk) {
                  ackedonce = 0;
                  if(lastacked) {
                    sendnak(cp,&resync,
                            &sealink,&chktec,
                            &blocknum,NULL,
                            0,&writeblk);
                    conditional = 0;
                    lastacked = 0;
                    ++toterr;
                  }
                  else {
                    if(!((conditional + 1) % 32)) {
                      sendnak(cp,&resync,
                              &sealink,&chktec,
                              &blocknum,NULL,
                              0,&writeblk);
                      conditional++;
                      lastacked = 0;
                      ++toterr;
                    }
                  }
                }
              }
            }
          }
          else {  /* bad block */
            retries++;
            sendnak(cp,&resync,&sealink,
                    &chktec,&blocknum,NULL,slo,&writeblk);
            lastacked = 0;
            tbuf.err = status;
            tbuf.errcount++;
            tbuf.type = TB_ERR;
            dupebuf = memdupe(&tbuf,sizeof(tbuf));
            if(dupebuf)
              if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                             MPFROMP(dupebuf)))
                free(dupebuf);
            toterr++;
          }
          break;
        }
        else if(!sealink) { /* mismatched blk/cmp */
          sendnak(cp,&resync,&sealink,
                  &chktec,&blocknum,NULL,slo,&writeblk);
          tbuf.err = "Blk/cmp mismatch";
          tbuf.errcount++;
          tbuf.type = TB_ERR;
          dupebuf = memdupe(&tbuf,sizeof(tbuf));
          if(dupebuf)
            if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                           MPFROMP(dupebuf)))
              free(dupebuf);
          toterr++;
          lastacked = 0;
          break;
        }
        else {
          c = temp;
          goto ReSwitch;
        }
        break;

      case SYN:   /* telink header block */
SYNrecvd:
        timeouts = 0;
        oneEOT = 0;
        if(gotone) {
          tbuf.misc = "Ignoring SYN";
          tbuf.type = TB_MISC;
          dupebuf = memdupe(&tbuf,sizeof(tbuf));
          if(dupebuf)
            if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                           MPFROMP(dupebuf)))
              free(dupebuf);
          lastsealink = -1;
          break;
        }
        altentry = 0;
        c = get_modem_byte(cp,500L);
        if(c == LOSTCARRIER || c == TIMEOUT)
          goto ReSwitch;
        temp = get_modem_byte(cp,500L);
        if(temp == (int)(c ^ 255)) {
          if(!c) {
            status = getblock(cp,(char *)&tlblk,blksize,0);
            if(!status) {
              tbuf.misc = "Telink hdr";
              tbuf.type = TB_MISC;
              dupebuf = memdupe(&tbuf,sizeof(tbuf));
              if(dupebuf)
                if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                               MPFROMP(dupebuf)))
                  free(dupebuf);
              lastsealink = -1;
              gotone++;
              if(*tlblk.filename && !strchr(tf.name,'/'))
                strncpy(tf.name,tlblk.filename,16);
              tf.name[15] = 0;
              strncpy(tf.sender,tlblk.sender,16);
              tf.sender[15] = 0;
              rstrip(tf.sender);
              chktec = (tlblk.crcmode != 0);
              tf.time = tlblk.time;
              tf.date = tlblk.date;
              tf.size = tlblk.size;
              if(*tf.name) {
                if(is_an_inbound(prepath)) {  /* check for req */
                  p = strrchr(tf.name,'.');
                  if(p) {
                    p++;
                    if(!stricmp(p,"REQ"))
                      sprintf(tf.name,"%08x.REQ",*_threadid);
                  }
                }
                if(prepath)
                  sprintf(fname,"%s/%s",prepath,tf.name);
                else
                  strcpy(fname,tf.name);
              }
              retries = 0;
              sealink = 0;
              goto XR4;
            }
            else {
              tbuf.err = status;
              tbuf.errcount++;
              tbuf.type = TB_ERR;
              dupebuf = memdupe(&tbuf,sizeof(tbuf));
              if(dupebuf)
                if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                               MPFROMP(dupebuf)))
                  free(dupebuf);
              toterr++;
            }
            goto XR1;
          }
        }
        else {
          tbuf.err = "Blk/cmp mismatch";
          tbuf.errcount++;
          tbuf.type = TB_ERR;
          dupebuf = memdupe(&tbuf,sizeof(tbuf));
          if(dupebuf)
            if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                           MPFROMP(dupebuf)))
              free(dupebuf);
          c = temp;
          retries++;
        }
        break;

      case EOT:
        timeouts = 0;
        tbuf.type = TB_TICK;
        tbuf.bytessent = writeblk * 128L;
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                         MPFROMP(dupebuf)))
            free(dupebuf);
        tbuf.err = "EOT";
        tbuf.errcount++;
        tbuf.type = TB_ERR;
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                         MPFROMP(dupebuf)))
            free(dupebuf);
        if(!gotone) {
          logfunc(0,cp,"EOT on empty file");
          slo = 0;
          sendack(cp,&slo,&sealink,&blocknum,writeblk);
          free(fname);
          DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
          Clear_UD();
          return NULL;
        }
        if((int)oneEOT < 1 + (2 * (sealink != 0)) &&
           (!tf.size || (writeblk < lastblk))) {
          oneEOT++;
          sendnak(cp,&resync,&sealink,&chktec,&blocknum,
                  NULL,0,&writeblk);
          tbuf.misc = "EOT?  Checking...";
          tbuf.type = TB_MISC;
          dupebuf = memdupe(&tbuf,sizeof(tbuf));
          if(dupebuf)
            if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                           MPFROMP(dupebuf)))
              free(dupebuf);
          c = peek_at_byte(cp,2500L);
          if(c != EOT) {
            tbuf.misc = "Wasn't EOT";
            tbuf.type = TB_MISC;
            dupebuf = memdupe(&tbuf,sizeof(tbuf));
            if(dupebuf)
              if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                             MPFROMP(dupebuf)))
                free(dupebuf);
            lastsealink = -1;
            break;
          }
        }

        logfunc(0,cp,"ACKed EOT");

DoEOT:

        slo = 0;
        sendack(cp,&slo,&sealink,&blocknum,writeblk);
        fflush(fp);
        DosBufReset(fileno(fp));
        if(tf.date || tf.time) {

          struct _ub {
            int cdate;
            int ctime;
            int adate;
            int atime;
            int wdate;
            int wtime;
          } ub;

          ub.cdate = tf.date;
          ub.adate = tf.date;
          ub.wdate = tf.date;
          ub.ctime = tf.time;
          ub.atime = tf.time;
          ub.wtime = tf.time;
          if(DosSetFileInfo((HFILE)fileno(fp),(USHORT)1,
                            (PBYTE)&ub,
                            (USHORT)sizeof(struct _ub)))
            logfunc(0,cp,"DosSetFileInfo() unable to set filedate");
          else {
            tbuf.misc = "Adj. time/date";
            tbuf.type = TB_MISC;
            dupebuf = memdupe(&tbuf,sizeof(tbuf));
            if(dupebuf)
              if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                             MPFROMP(dupebuf)))
                free(dupebuf);
          }
        }

        if(tf.size) {
          if(tf.size < filelength(fileno(fp)) &&
             tf.size + 128L >= filelength(fileno(fp))) {
          if(DosNewSize(fileno(fp),tf.size))
              logfunc(0,cp,"DosNewSize() unable to set filesize");
            else {
              tbuf.misc = "Adj. filesize";
              tbuf.type = TB_MISC;
              dupebuf = memdupe(&tbuf,sizeof(tbuf));
              if(dupebuf)
                if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                               MPFROMP(dupebuf)))
                  free(dupebuf);
            }
          }
          else if(tf.size != filelength(fileno(fp)))
            logfunc(2,cp,"Didn't adjust filesize: %ld %ld",
                    tf.size,filelength(fileno(fp)));
        }
        else
          tf.size = filelength(fileno(fp));
        if(tf.stamp) {

          int temp;

          temp = unixsetftime(fileno(fp),tf.stamp);
          if(temp)
            logfunc(0,cp,"unixsetftime() unable to set filedate: error #%d, stamp: %lu",temp,tf.stamp);
          else {
            tbuf.misc = "Adj. filedate";
            tbuf.type = TB_MISC;
            dupebuf = memdupe(&tbuf,sizeof(tbuf));
            if(dupebuf)
              if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                             MPFROMP(dupebuf)))
                free(dupebuf);
          }
        }
        fclose(fp);
        tbuf.type = TB_FIN;
        tbuf.misc = NULL;
        tbuf.bytessent =  tf.size;
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                         MPFROMP(dupebuf)))
            free(dupebuf);
        DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
        DosSleep(200L);
        purge_in(cp);
        return fname;

      case CAN:
        timeouts = 0;
        oneEOT = 0;
        tbuf.err = "CAN";
        tbuf.errcount++;
        tbuf.type = TB_ERR;
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                         MPFROMP(dupebuf)))
            free(dupebuf);
        toterr++;
        c = peek_at_byte(cp,1250L);
        if(c != CAN)
          break;
        if(tf.size && (writeblk * 128L) >= tf.size) {
          logfunc(0,cp,"CAN; assuming EOT; seem to have all of file");
          goto DoEOT; /* should have it all */
        }
        tbuf.misc = "Aborted by remote (2 CANs)";
        tbuf.type = TB_ABORT;
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                         MPFROMP(dupebuf)))
            free(dupebuf);
        strcpy(fname,";Aborted by remote");
        DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
        if(fp)
          fclose(fp);
        Clear_UD();
        purge_in(cp);
        return fname;

      case LOSTCARRIER:
        if(!checkcarrier(cp))
          break;
        tbuf.type = TB_ABORT;
        tbuf.misc = "Lost carrier";
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                         MPFROMP(dupebuf)))
            free(dupebuf);
        logfunc(0,cp,"Lost carrier during receive");
        free(fname);
        DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
        if(fp)
          fclose(fp);
        Clear_UD();
        return NULL;

      case TIMEOUT:
        tbuf.type = TB_TICK;
        tbuf.bytessent = writeblk * 128L;
        if(timeouts)
          slo = 0;
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                     MPFROMP(dupebuf)))
            free(dupebuf);
        toterr++;
        if(!gotone) {
          retries++;
          goto XR1;
        }
        fflush(fp);
        DosBufReset(fileno(fp));
        if(tf.size && (writeblk * 128L) >= tf.size && timeouts > 2) {
          logfunc(0,cp,"Timeout; assuming EOT; seem to have all of file");
          goto DoEOT; /* should have it all */
        }
        timeouts++;
        sendnak(cp,&resync,&sealink,
                &chktec,&blocknum,NULL,slo,&writeblk);
        lastacked = 0;
        tbuf.err = "-Timeout";
        tbuf.errcount++;
        tbuf.type = TB_ERR;
        dupebuf = memdupe(&tbuf,sizeof(tbuf));
        if(dupebuf)
          if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                         MPFROMP(dupebuf)))
            free(dupebuf);
        break;

      default:
#ifdef DEBUG
        logfunc(2,cp,"Ignoring %d",c);
#endif
        break;
    }
  }

  tbuf.type = TB_ABORT;
  tbuf.misc = "Fatal timeout";
  dupebuf = memdupe(&tbuf,sizeof(tbuf));
  if(dupebuf)
    if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                   MPFROMP(dupebuf)))
      free(dupebuf);
  logfunc(0,cp,"Fatal receive timeout");
  free(fname);
  if(fp)
    fclose(fp);
  DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
  Clear_UD();
  return NULL;

XR4:

  {
    char        resync_pkt[81];
    struct stat f;

    if(!stat(fname,&f)) {   /* exists */
      if(tf.stamp) {
        fp = _fsopen(fname,"r+b",SH_DENYNO);
        if(fp) {
          f.st_mtime = unixgetftime(fileno(fp));
          fclose(fp);
        }
        if(f.st_mtime == tf.stamp && tf.size == f.st_size) {
          logfunc(0,cp,"Skipping %s--dupe",fname);
          if(resync) {
            writeblk = (f.st_size / 128L) + 1L;
            blocknum = (char)(writeblk & 255L);
            sprintf(resync_pkt,"%c%ld%c",(char)SYN,writeblk,(char)ETX);
            if(sendnak(cp,&resync,&sealink,&chktec,&blocknum,
                       resync_pkt,slo,&writeblk) == -1) {
                logfunc(0,cp,"Attempt to resync to file end failed");
                send_cancel(cp,2);
                logfunc(0,cp,"Sent two CANs");
            }
            DosSleep(1000L);
            slo = 0;
            sendack(cp,&slo,&sealink,&blocknum,writeblk);
            DosSleep(225L);
            sendack(cp,&slo,&sealink,&blocknum,writeblk);
          }
          else {
            send_cancel(cp,2);
            logfunc(0,cp,"Sent two CANs");
          }
          tbuf.misc = "Duplicate file";
          tbuf.type = TB_ABORT;
          dupebuf = memdupe(&tbuf,sizeof(tbuf));
          if(dupebuf)
            if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                           MPFROMP(dupebuf)))
              free(dupebuf);
          strcpy(fname,";Aborted--dupe");
          DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
          Clear_UD();
          DosSleep(128L);
          purge_in(cp);
          return fname;
        }
        else if(resync) {

          char time1[48],time2[48];

          strcpy(time1,asctime(localtime(&f.st_mtime)));
          strcpy(time2,asctime(localtime((time_t *)&tf.stamp)));
          if(stricmp(time1,time2)) {
            logfunc(0,cp,"Not resynching: %0.24s (%ld) vs. %0.24s (%ld), %ld vs. %ld",
                    time1,f.st_mtime,time2,tf.stamp,
                    tf.size,f.st_size);
            goto NoResync;
          }
          writeblk = ((f.st_size / 128L) - 1L);
          if(writeblk > 1L) {
            logfunc(0,cp,"Attempting resynch to block %ld",writeblk);
            blocknum = (char)(writeblk & 255L);
            sprintf(resync_pkt,"%c%ld%c",(char)SYN,writeblk,(char)ETX);
            if(sendnak(cp,&resync,&sealink,&chktec,&blocknum,
                       resync_pkt,slo,&writeblk) == -1) {
              writeblk = 1L;
              blocknum = 1;
              logfunc(0,cp,"Initial resync attempt failed");
            }
            else {
              tbuf.bytessent = tbuf.resyncedto = (128L * writeblk);
              logfunc(0,cp,"Initial resync to offset %ld succeeded.",
                       writeblk);
            }
          }
          else {
            writeblk = 1L;
            blocknum = 1;
            logfunc(0,cp,"No resync required");
          }
        }
      }
        else {
NoResync:
        if(!onceinced) {
          fname[strlen(fname) - 1] = '0';
          onceinced = 1;
        }
        else {
          if(fname[strlen(fname) - 1] == ':')
            fname[strlen(fname) - 1] = '@';
          fname[strlen(fname) - 1]++;
          if(fname[strlen(fname) - 1] > 'Z') {
            logfunc(0,cp,"File exists and can't resync or rename");
            send_cancel(cp,2);
            free(fname);
            DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
            Clear_UD();
            return NULL;
          }
        }
        goto XR4;
      }
    }
  }

  tbuf.misc = "Acking hdr";
  tbuf.type = TB_MISC;
  dupebuf = memdupe(&tbuf,sizeof(tbuf));
  if(dupebuf)
    if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                   MPFROMP(dupebuf)))
      free(dupebuf);
  lastslo = slo;
  slo = 0;
  sendack(cp,&slo,&sealink,&blocknum,writeblk);
  slo = lastslo;
  lastslo = -1;
  lastacked = 1;
  conditional = 0;
  lastsealink = -1;

  fp = _fsopen(fname,"r+b",SH_DENYWR);
  if(!fp)
    fp = _fsopen(fname,"w+b",SH_DENYWR);
  if(!fp) {
    logfunc(0,cp,"Can't open \"%s\"",fname);
    send_cancel(cp,2);
    tbuf.misc = "File open error";
    tbuf.type = TB_ABORT;
    dupebuf = memdupe(&tbuf,sizeof(tbuf));
    if(dupebuf)
      if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                     MPFROMP(dupebuf)))
        free(dupebuf);
    strcpy(fname,";Aborted--open error");
    DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);
    Clear_UD();
    return fname;
  }
  else
    setvbuf(fp,NULL,_IOFBF,BUFSIZ * 12);

SayIt:

  DosSetFHandState(fileno(fp),OPEN_ACCESS_WRITEONLY | OPEN_SHARE_DENYWRITE |
                   OPEN_FLAGS_NOINHERIT | OPEN_FLAGS_SEQUENTIAL |
                   OPEN_FLAGS_FAIL_ON_ERROR);

  retries = 0;
  lastblk = (tf.size + 127L) / 128L;
  tbuf.err = NULL;
  tbuf.filename = tf.name;
  tbuf.errcount = 0L;
  tbuf.filesize = tf.size;
  tbuf.bytessent = 0L;
  tbuf.misc = NULL;
  tbuf.type = TB_NAME;
  tbuf.started = time(NULL);
  dupebuf = memdupe(&tbuf,sizeof(tbuf));
  if(dupebuf)
    if(!WinPostMsg(xdhwnd,WM_TRANSFER,MPFROM2SHORT(cp,0),
                   MPFROMP(dupebuf)))
      free(dupebuf);

/* XR5 */

  slo = (modems[cp]->noslo) ? 0 : (slblk.slo != 0);
  if(modems[cp]->brokenover)
    slo = 0; /* bink 2.3 is broken */
  logfunc(0,cp,"%s%s-receiving \"%s\" from \"%s\"",
          (sealink) ? "SEAlink" : "XModem",
          (slo) ? "/Overdrive" : "",
          fname,tf.sender);

  if(tf.stamp) {   /* set appropriate date for file */

    int temp;

    temp = unixsetftime(fileno(fp),tf.stamp);
    if(temp)
      logfunc(0,cp,"unixsetftime() unable to set filedate: error #%d, stamp: %lu",temp,tf.stamp);
  }

  goto XR3;
}


int _fastcall sendnak (USHORT cp,int *resync,int *sealink,
                       int *chktec,char *blocknum,char *resync_pkt,
                       int slo,long *writeblk) {

  clock_t t1;
  char    send[3];
  int     temp;


/* SN0 */

  if(*resync && *sealink && (resync_pkt || (slo && *blocknum != 1))) {
    if(resync_pkt)
      send_resync(cp,resync_pkt);
    goto SN3;
  }

  if(!*sealink) {
/*
    t1 = timerset(30000L);
    while(!timeup(t1)) {
      temp = get_modem_byte(cp,128L);
      switch(temp) {
        case LOSTCARRIER:
          return -1;

        case TIMEOUT:
          goto SN1;

        default:
          logfunc(2,cp,"Jabbering at me XModem NAK");
          break;
      }
    }
    return -1;
*/
  }

/* SN1 */

  if(*chktec && (*writeblk <= 1L || *sealink))
    *send = 'C';
  else
    *send = NAK;

/* SN2 */

  if(*sealink) {
    send[1] = *blocknum;
    send[2] = (char)(255 - *blocknum);
    com_write(cp,send,3);
  }
  else
    com_putc(cp,*send);

  return 0;

SN3:

  {
    char r_pkt[81];

    if(!resync_pkt) {
      resync_pkt = r_pkt;
      sprintf(resync_pkt,"%c%ld%c",(char)SYN,*writeblk,(char)ETX);
      send_resync(cp,resync_pkt);
    }

    t1 = timerset(30000L);
    while(!timeup(t1)) {
      temp = get_modem_byte(cp,5000L);
      switch(temp) {
        case ACK:
          return 0;

        case NAK:
          send_resync(cp,resync_pkt);
          break;

        case TIMEOUT:
          send_resync(cp,resync_pkt);
          break;

        case LOSTCARRIER:
          return -1;

        default:
          break;
      }
    }
  }

  return -1;
}


int _fastcall sendack (USHORT cp,int *slo,int *sealink,
                       char *blocknum,long writeblk) {

  char  send[3];

  if(!*slo || !writeblk) {
    if(!*sealink) {
/*
      t1 = timerset(30000L);
      while(!timeup(t1)) {
        temp = get_modem_byte(cp,128L);
        switch(temp) {
          case LOSTCARRIER:
            return -1;

          case TIMEOUT:
            goto SA1;

          default:
            logfunc(2,cp,"Jabbering at me XModem ACK");
            break;
        }
      }
      return -1;
*/
    }
/* SA1 */

    *send = ACK;

/* SA2 */

    if(*sealink) {
      send[1] = *blocknum;
      send[2] = (char)(255 - (*blocknum));
      com_write(cp,send,3);
    }
    else
      com_putc(cp,*send);
  }

/* SA3 */

  (*blocknum)++;
  return 0;
}



int _fastcall send_resync (USHORT cp,char *resync_pkt) {

  int crc;

  crc = figurecrc(&resync_pkt[1],strlen(resync_pkt) - 2,0);
  com_write(cp,resync_pkt,strlen(resync_pkt));
  com_write(cp,(char *)&crc,2);
  DosSleep(32L);
  purge_in(cp);
  return 0;
}



int _fastcall is_an_inbound (char *s) {

  if(s) {
    if(s == bbs->inbound[0] || s == bbs->inbound[1] ||
       s == bbs->inbound[2]) {
      return 1;
    }
  }
  return 0;
}
