#define USE_TIME_MACROS

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <stdio.h>
#include <process.h>
#include "mailer.h"
#include "transfer.h"
#include "timers.h"
#include "modem.h"
#include "keys.h"
#include "xmisc.h"

    extern MDM  *modems[MAXINSTANCES];
    extern char *MBuff[MAXINSTANCES];
    extern char *MBstart[MAXINSTANCES],*MBend[MAXINSTANCES];

    DCBINFO *F53Info[MAXINSTANCES];


int _fastcall set_devctlblk (USHORT cp,int XONXOFF,int CTS,int RTS) {

  MODEMSTATUS ms;
  USHORT      error;

  /* set the modem device control block
   * XONXOFF = 1 means auto transmit mode
   *         = other non-zero means auto transmit & receive
   * CTS = 1 means use CTS handshaking
   * RTS = 1 means use RTS handshaking
   */

  DosDevIOCtl(F53Info[cp],0L,0x73,1,modems[cp]->mh);
  F53Info[cp]->fbCtlHndShake = (char) (MODE_CTS_HANDSHAKE * (CTS != 0));
  F53Info[cp]->fbFlowReplace = (char)(MODE_RTS_HANDSHAKE * (RTS != 0));
  F53Info[cp]->fbFlowReplace &= ~(MODE_DTR_HANDSHAKE);
  F53Info[cp]->fbFlowReplace |= MODE_DTR_CONTROL;
  if(XONXOFF == 1)
    F53Info[cp]->fbFlowReplace |= MODE_AUTO_TRANSMIT;
  else if(XONXOFF)
    F53Info[cp]->fbFlowReplace |= (MODE_AUTO_TRANSMIT | MODE_AUTO_RECEIVE);
  else
    F53Info[cp]->fbFlowReplace &= ~(MODE_AUTO_TRANSMIT | MODE_AUTO_RECEIVE);
  F53Info[cp]->usWriteTimeout = 1000;
  F53Info[cp]->usReadTimeout = 100;
  F53Info[cp]->fbTimeout &= ~(MODE_READ_TIMEOUT | MODE_NOWAIT_READ_TIMEOUT);
  F53Info[cp]->fbTimeout |= MODE_WAIT_READ_TIMEOUT;
  F53Info[cp]->fbTimeout &= ~(MODE_NO_WRITE_TIMEOUT);
  F53Info[cp]->fbTimeout |= 16 | 64 | 128;  /* FIFOs on? */
  DosDevIOCtl(0L,F53Info[cp],0x53,1,modems[cp]->mh);

  ms.fbModemOn = RTS_ON | DTR_ON;
  ms.fbModemOff = 0xff;
  DosDevIOCtl(&error,&ms,0x46,1,modems[cp]->mh);    /* set modem control */
  return 0;
}

/* temporary, does nothing */

void _fastcall hold_comthread (USHORT cp) {

  MBstart[cp] = MBend[cp] = MBuff[cp];
}

/* temporary, does nothing */

void _fastcall restart_comthread (USHORT cp) {

  MBstart[cp] = MBend[cp] = MBuff[cp];
}

int _fastcall open_modem (USHORT cp) {

  /*
   * initially open a commport, set stuff up, and so on
   * returns -1 on failure, 0 on success
   */

  MODEMSTATUS ms;
  CHAR        szBuffer[7];
  USHORT      action;
  USHORT      error;

  for(error = 0;error < MAXINSTANCES;error++) /* no peeking :-) */
    MBstart[error] = MBend[error] = MBuff[error];

  if(cp) {
    if (modems[cp]->mh == (HFILE)-1) {
      modems[cp]->lastt2 = 0L;
      F53Info[cp] = malloc(sizeof(DCBINFO));
      MBuff[cp] = malloc(MBUFFSIZE);
      if(!F53Info[cp] || !MBuff[cp]) {
        if(F53Info[cp]) {
          free(F53Info[cp]);
          F53Info[cp] = NULL;
        }
        if(MBuff[cp]) {
          free(MBuff[cp]);
          MBuff[cp] = NULL;
        }
        return -1;
      }
      MBstart[cp] = MBend[cp] = MBuff[cp];

      sprintf(szBuffer,"COM%u",cp);
      error = DosOpen(szBuffer,&modems[cp]->mh,&action,0L,FILE_NORMAL,FILE_OPEN,
                      OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE,0L);
      if(error) {
        modems[cp]->mh = (HFILE)-1;
        if(!F53Info[cp] || !MBuff[cp]) {
          if(F53Info[cp]) {
            free(F53Info[cp]);
            F53Info[cp] = NULL;
          }
          if(MBuff[cp]) {
            free(MBuff[cp]);
            MBuff[cp] = NULL;
          }
        }
        return -1;       /* failed port open */
      }

      DosDevIOCtl(&modems[cp]->save_di,0L,0x73,1,modems[cp]->mh);
      memcpy(F53Info[cp],&modems[cp]->save_di,sizeof(DCBINFO));
      F53Info[cp]->fbFlowReplace = MODE_RTS_CONTROL;
      F53Info[cp]->fbCtlHndShake = MODE_CTS_HANDSHAKE;
      F53Info[cp]->fbFlowReplace &= ~(MODE_DTR_HANDSHAKE);
      F53Info[cp]->fbFlowReplace &= ~(MODE_AUTO_TRANSMIT | MODE_AUTO_RECEIVE); /* xon/xoff bye-bye */
      F53Info[cp]->usWriteTimeout = 1000;
      F53Info[cp]->usReadTimeout = 100;
      F53Info[cp]->fbTimeout = MODE_WAIT_READ_TIMEOUT;
      F53Info[cp]->fbTimeout &= ~(MODE_NO_WRITE_TIMEOUT);
      F53Info[cp]->fbTimeout |= 16 | 64 | 128;  /* FIFOs on? */
      F53Info[cp]->fbCtlHndShake |= MODE_DTR_CONTROL;
      DosDevIOCtl(0L,F53Info[cp],0x53,1,modems[cp]->mh);

      ms.fbModemOn = RTS_ON | DTR_ON;
      ms.fbModemOff = 0xff;
      DosDevIOCtl(&error,&ms,0x46,1,modems[cp]->mh);    /* set modem control */

      return 0;
    }
  }
  return -1;
}

int _fastcall close_modem (USHORT cp) {

  /* close & restore port */

  MODEMSTATUS ms;
  USHORT      error;

  if(cp) {
    if (modems[cp]->mh != (HFILE)-1) {
      DosDevIOCtl(0L,&modems[cp]->save_di,0x53,1,modems[cp]->mh);
      raiseDTR(cp);
      ms.fbModemOn = RTS_ON | DTR_ON;
      ms.fbModemOff = 0xff;
      DosDevIOCtl(&error,&ms,0x46,1,modems[cp]->mh); /* set modem control */
      DosClose(modems[cp]->mh);
      modems[cp]->mh = (HFILE)-1;
      free(F53Info[cp]);
      F53Info[cp] = NULL;
      free(MBuff[cp]);
      MBuff[cp] = NULL;
      return 1;
    }
  }
  return 0;
}

int _fastcall set_baud (USHORT cp,unsigned int baud,char parity,
                        int databits,int stopbits) {

  /*
   * set baud rate, parity, stop bits, etc.
   */

  LINECONTROL lc;
  int         rtn = 1;

  if (DosDevIOCtl(0L,&baud,0x41,1,modems[cp]->mh))
    rtn = 0;
  else {
    lc.bDataBits = (BYTE)databits;
    switch (stopbits) {
      case 1:
        lc.bStopBits = 0;
        break;
      case 2:
        lc.bStopBits = 2;
        break;
      default:
        if (databits == 5)
          lc.bStopBits = 1;
        else
          lc.bStopBits = 0;
    }
    lc.fTransBreak = 0;
    switch (parity) {
      case 'O':
      case 'o':
        lc.bParity = 1;
        break;
      case 'E':
      case 'e':
        lc.bParity = 2;
        break;
      case 'M':
      case 'm':
        lc.bParity = 3;
        break;
      case 'S':
      case 's':
        lc.bParity = 4;
        break;
      default:      /* default to N parity */
        lc.bParity = 0;
        break;
    }
    if (DosDevIOCtl(0L,&lc,0x42,1,modems[cp]->mh))
      rtn = 0;
  }
  return rtn;
}

void _fastcall com_XON_disable (USHORT cp) {

  DCBINFO di;

  DosDevIOCtl(&di,0L,0x73,1,modems[cp]->mh);
  di.fbFlowReplace &= ~(MODE_AUTO_TRANSMIT | MODE_AUTO_RECEIVE); /* Turn off XON/XOFF automatic input and output flow control */
  DosDevIOCtl(0L,&di,0x53,1,modems[cp]->mh);
}

void _fastcall com_XON_enable (USHORT cp) {

  DCBINFO di;

  DosDevIOCtl(&di,0L,0x73,1,modems[cp]->mh);
  di.fbFlowReplace |= (MODE_AUTO_TRANSMIT | MODE_AUTO_RECEIVE); /* Turn on XON/XOFF automatic input and output flow control */
/*
  di.bXOFFChar = (char)0x13;
  di.bXONChar = (char)0x11;
*/
  DosDevIOCtl(0L,&di,0x53,1,modems[cp]->mh);
}

void _fastcall com_break (USHORT cp,int cmd) {

  /* com_break() : start break if on==TRUE, stop break if on==FALSE */

  USHORT err;

  if (cmd == 1)
    DosDevIOCtl(&err,0L,0x4b,1,modems[cp]->mh); /* setbreakon */
  else
    DosDevIOCtl(&err,0L,0x45,1,modems[cp]->mh); /* setbreakoff */
}
