#define MBUFFSIZE 8192

#ifdef BUFFERED
#define RING_STACKSIZE      4096
#define RECV_RINGBUF_SIZE   8192
#define TRANS_RINGBUF_SIZE  2048
#define RECV_READ_AHEAD     1024
#define TRANS_READ_AHEAD    512

#define get_modem_byte(cp,msecs) read_iringbuf((cp),(msecs))
#define get_modem_block(cp,buf,len,msecs) mult_read_iringbuf((cp),(buf),(len),(msecs),NULL)
#define receive(cp,buf,len) mult_read_iringbuf((cp),(buf),*((len)),0L,(len))
#define peek_at_byte(cp,msecs) peek_iringbuf((cp),(msecs))
#define com_write(cp,buf,len) mult_write_oringbuf((cp),(buf),(len))
#define com_putc(cp,character) write_oringbuf((cp),(character))

void  _fastcall purge_oringbuf (USHORT cp);
int   _fastcall write_oringbuf (USHORT cp,char character);
int   _fastcall mult_write_oringbuf (USHORT cp,char *str,int towrite);
void  oring_handler (void far *dummy);
void  _fastcall purge_iringbuf (USHORT cp);
int   _fastcall peek_iringbuf (USHORT cp,clock_t msecs);
int   _fastcall read_iringbuf (USHORT cp,clock_t msecs);
int   _fastcall mult_read_iringbuf (USHORT cp,char *buf,int len,clock_t msecs,
                                  int *readlen);
void  iring_handler (void far *dummy);
int   _fastcall start_comthread (USHORT cp);
#else
int _fastcall get_modem_byte(USHORT cp,long msecs);
int _fastcall get_modem_block(USHORT cp,char *buf,int len,long msecs);
 #define receive(cp,buffer,len) get_modem_block((cp),(buffer),(len),0L)
int _fastcall peek_at_byte(USHORT cp,long msecs);
int _fastcall com_write(USHORT cp,char *buf,int len);
int _fastcall com_putc(USHORT cp,char character);
#endif

#define dropDTR(cp) doDTR(cp,0)
#define raiseDTR(cp) doDTR(cp,1)

void  _fastcall doDTR (USHORT cp,int which);
int   _fastcall checkcarrier (USHORT cp);
int   _fastcall get_modem_str (USHORT cp,char *s,int slen,char term,int ignore,
                long msecs);
int   _fastcall get_modem_int (USHORT cp,long msecs);
void  _fastcall purge_in (USHORT cp);
void  _fastcall purge_out (USHORT cp);
int   _fastcall set_devctlblk (USHORT cp,int xonxoff,int CTS,int RTS);
unsigned int _fastcall detect_baud (USHORT cp,long msecs,char *s);
void  _fastcall dial_phone (USHORT cp,char *prefix,char *number,char *suffix);
void  _fastcall dial_trans (USHORT cp,char *s);
void  _fastcall flushout (USHORT cp);
int   _fastcall open_modem (USHORT cp);
int   _fastcall close_modem (USHORT cp);
int   _fastcall set_baud (USHORT cp,unsigned int baud,char parity,
                          int databits,int stopbits);
void  _fastcall com_XON_disable (USHORT cp);
void  _fastcall com_XON_enable (USHORT cp);
void  _fastcall com_break (USHORT cp,int cmd);
int   _fastcall com_online (USHORT cp);
int   _fastcall com_putc_now (USHORT cp,char c);
int   _fastcall com_out_empty (USHORT cp);
int   _fastcall com_in_empty (USHORT cp);

void  _fastcall hold_comthread (USHORT cp);
void  _fastcall restart_comthread (USHORT cp);
