#define USE_TIME_MACROS
#define INCL_DOSERRORS

#include <process.h>
#include "mailer.h"
#include "xmisc.h"
#include "transfer.h"
#include "modem.h"
#include "timers.h"

  extern MDM     *modems[MAXINSTANCES];
  extern DCBINFO *F53Info[MAXINSTANCES];

  /* buffers for incoming modem crap */

  char *MBuff[MAXINSTANCES];
  char *MBstart[MAXINSTANCES],*MBend[MAXINSTANCES];


int _fastcall com_putc (USHORT cp,char c) {

  /* write a byte thru the com driver */

  USHORT temp;

  if(modems[cp]->checkcd && !com_online(cp) && checkcarrier(cp))
    return LOSTCARRIER;
  return(!DosWrite(modems[cp]->mh,&c,1,&temp));
}


int _fastcall com_write (USHORT cp,register char *buf,int len) {

  /* write a block thru the com driver */

  DosWrite(modems[cp]->mh,buf,len,(USHORT *)&len);
  if(modems[cp]->checkcd && !com_online(cp) && checkcarrier(cp))
    return LOSTCARRIER;
  return len;
}


int _fastcall peek_at_byte (USHORT cp,long milli) {

  clock_t t1 = 0L,t2;
  USHORT  len;
  int     error;

  do {
    if(MBend[cp] != MBstart[cp])
      return (int)*(MBstart[cp]);
    if(modems[cp]->checkcd && !com_online(cp) && checkcarrier(cp))
      return LOSTCARRIER;
    if(!milli) {  /* special case request with no waiting */
      if(com_in_empty(cp))
        return TIMEOUT;
    }
    MBstart[cp] = MBend[cp] = MBuff[cp];
    if(!t1)
      t1 = timerset(milli);
    t2 = (modems[cp]->checkcd) ? min(timeleft(t1),1000L) : timeleft(t1);
    if(t2 != modems[cp]->lastt2) {
      F53Info[cp]->usReadTimeout = (USHORT)(t2 / 10L);
      DosDevIOCtl(0L,F53Info[cp],0x53,1,modems[cp]->mh);
      modems[cp]->lastt2 = t2;
    }
    error = DosRead(modems[cp]->mh,MBuff[cp],MBUFFSIZE,&len);
    if((!error || error == ERROR_MORE_DATA) && len)
      MBend[cp] += len;
  } while(!timeup(t1) || MBend[cp] != MBstart[cp]);
  return TIMEOUT;
}


int _fastcall get_modem_byte (USHORT cp,long milli) {

  clock_t t1 = 0L,t2;
  USHORT  len;
  int     error;

  do {
    if(MBend[cp] != MBstart[cp])
      return (int)*(MBstart[cp]++);
    if(modems[cp]->checkcd && !com_online(cp) && checkcarrier(cp))
      return LOSTCARRIER;
    if(!milli) {  /* special case request with no waiting */
      if(com_in_empty(cp))
        break;
    }
    MBstart[cp] = MBend[cp] = MBuff[cp];
    if(!t1)
      t1 = timerset(milli);
    t2 = min(((modems[cp]->checkcd) ?
               min(timeleft(t1),1000L) : timeleft(t1)),
             1L);
    if(modems[cp]->lastt2 != t2) {
      F53Info[cp]->usReadTimeout = (USHORT)(t2 / 10L);
      DosDevIOCtl(0L,F53Info[cp],0x53,1,modems[cp]->mh);
      modems[cp]->lastt2 = t2;
    }
    error = DosRead(modems[cp]->mh,MBuff[cp],MBUFFSIZE,&len);
    if((!error || error == ERROR_MORE_DATA) && len)
      MBend[cp] += len;
    else if(error)
      /* what to do? */
      logfunc(1,cp,"Error #%d reading from com driver",error);
  } while(!timeup(t1) || MBend[cp] != MBstart[cp]);
  return TIMEOUT;
}


int _fastcall get_modem_block (USHORT cp,register char *buffer,int blen,
                               long milli) {

  register char *mbs = MBstart[cp];
  register char *mbe = MBend[cp];
  int            error;
  USHORT         len;
  clock_t        t1 = 0L,t2;
  
  do {
    while(mbe != mbs && blen) {
      len = mbe - mbs;
      len = min(len,blen);
      memcpy(buffer,mbs,len);
      blen -= len;
      buffer += len;
      mbs += len;
    }
    if(blen) {
      if(modems[cp]->checkcd && !com_online(cp) && checkcarrier(cp))
        return LOSTCARRIER;
      if(!milli) {  /* special case request with no waiting */
        if(com_in_empty(cp)) {
          MBend[cp] = mbe;
          MBstart[cp] = mbs;
          break;
        }
      }
      mbs = mbe = MBuff[cp];
      if(!t1)
        t1 = timerset(milli);
      t2 = min(((modems[cp]->checkcd) ?
                min(timeleft(t1),1000L) : timeleft(t1)),
               1L);
      if(t2 != modems[cp]->lastt2) {
        F53Info[cp]->usReadTimeout = (USHORT)(t2 / 10L);
        DosDevIOCtl(0L,F53Info[cp],0x53,1,modems[cp]->mh);
        modems[cp]->lastt2 = t2;
      }
      error = DosRead(modems[cp]->mh,MBuff[cp],MBUFFSIZE,&len);
      if((!error || error == ERROR_MORE_DATA) && len)
        mbe += len;
      else if(error)
        /* what to do? */
        logfunc(1,cp,"Error #%d reading from com driver",error);
    }
  } while((!timeup(t1) || mbs != mbe) && blen);
  MBend[cp] = mbe;
  MBstart[cp] = mbs;
  return (blen) ? TIMEOUT : 0;
}

void _fastcall doDTR (USHORT cp,int which) {

  /* which == 0 == lower DTR
   * which != 0 == raise DTR
   */

  struct _MODEMSTATUS ms;
  USHORT error;

  ms.fbModemOn = (char)(which != 0);
  ms.fbModemOff = (char)(255 - (which == 0));
  DosDevIOCtl(&error,&ms,0x46,1,modems[cp]->mh);
}

int _fastcall com_online (USHORT cp) {

  /* return non-0 value if carrier detected */

  char flags;

  DosDevIOCtl(&flags,0L,0x67,1,modems[cp]->mh);   /* get modem input */
  return(flags & DCD_ON);   /* DCD not on? */
}

void _fastcall purge_in (USHORT cp) {

  /* purge the input buffer */

  DosDevIOCtl(0L,0L,0x1,0xb,modems[cp]->mh);    /* dev flush input */
  MBstart[cp] = MBend[cp] = MBuff[cp];
}

void _fastcall purge_out (USHORT cp) {

  /* purge the output buffer */

  DosDevIOCtl(0L,0L,0x2,0xb,modems[cp]->mh);    /* dev flush output */
}

int _fastcall com_putc_now (USHORT cp,char c) {

  /* com_putc_now() : disregard any buffering and send a byte NOW!
   * this function should be called only during emergencies...like when
   * trying to cancel a file transfer
   */

  return(!DosDevIOCtl(0L,&c,0x44,0x1,modems[cp]->mh));  /* dev transmit immediately */
}

void _fastcall flushout (USHORT cp) {

  /* wait for output buffer to empty */

  clock_t t1;

  t1 = timerset(5000L);
  while (com_online(cp) && !com_out_empty(cp) && !timeup(t1))
    DosSleep (128L);
}

int _fastcall checkcarrier (USHORT cp) {

  /* check for carrier; be forgiving */

  if(modems[cp]->mh != -1 && modems[cp]->curbaud) {
    if(!com_online(cp)) {
      DosSleep(50L);
      if(!com_online(cp)) {
        DosSleep(100L);
        if(!com_online(cp)) {
          MBstart[cp] = MBend[cp] = MBuff[cp];
          return LOSTCARRIER;
        }
      }
    }
  }
  return 0;
}

int _fastcall get_modem_int (USHORT cp,long msecs) {

  /* get an integer from the com driver w/ timeout */

  int     ret,get;
  clock_t istime;

  istime = clock();
  ret = get_modem_byte(cp,msecs) << 8;
  if(ret != TIMEOUT && ret != LOSTCARRIER) {
    msecs = min(msecs - (clock() - istime),0L);
    get = get_modem_byte(cp,msecs);
    if(get != TIMEOUT && get != LOSTCARRIER)
      ret = ((ret << 8) | get);
    else
      ret = get;
  }
  return ret;
}

int _fastcall get_modem_str (USHORT cp,char *s,int slen,char term,int ignore,
                             long msecs) {

  /* Gets a string from the modem with timeout & carrier check (if ignore != 0)
   * cp = commhandle index, s is buffer for string, slen is length of
   * buffer, msecs is 1000ths of a second to wait.  If term != 0
   * it is a character that terminates input early. Mainly for
   * checking modem response strings.
   */

  clock_t      tmr;
  char         *p;
  int          by;

  p = s;
  *s = 0;
  tmr = timerset(msecs);

  for(;;) {
    if(!ignore && checkcarrier(cp))
      return LOSTCARRIER;
    by = get_modem_byte(cp,64L);
    if(by != TIMEOUT) {
      *p = (char)by;
      p++;
      *p = 0;
      if(!--slen || (term && (char)by == term))
        return 0;
    }
    else {
      if(timeup(tmr))
        break;
      if(msecs > 999L)
        DosSleep(128L);
      else
        DosSleep(32L);
    }
  }
  return TIMEOUT;
}

unsigned int _fastcall detect_baud (USHORT cp,long msecs,char *s) {

  /* detect the baud rate from modem strings.  char *s should be at
   * least 81 bytes long.  it will contain the last modem string on
   * return.
   */

  clock_t      t1;
  int          temp;
  char         *p;
  unsigned int baud = 0;

  t1 = timerset(msecs);
  for(;;) {
    temp = get_modem_str(cp,s,79,(char)'\r',1,5000L);
    if(*s) {
      stripcr(s);
      p = s;
      while(*p == '\r' || *p == '\n')
        p++;
      if(p != s)
        memmove(s,p,strlen(p) + 1);
      p = s;
      if(*p) {
        if(!stricmp(p,"BUSY") || !stricmp(p,"NO CARRIER") || \
           !stricmp(p,"NO DIALTONE") || !stricmp(p,"VOICE"))
          break;
        if(!strnicmp(p,"CONNECT",7)) {    /* deduce baud rate */
          p += 7;
          while(*p == ' ')
            p++;
          if(*p)
            baud = atoi(p);
          if(!baud)
            baud = 300;
          break;
        }
      }
    }
    if(timeup(t1))
      break;
  }

  if(!baud || checkcarrier(cp))
    return 0;
  return baud;
}

void _fastcall dial_phone (USHORT cp,char *prefix,char *number,char *suffix) {

  /* Dial a number on the modem */

  if(prefix && *prefix)
    dial_trans(cp,prefix);
  if(number && *number)
    com_write(cp,number,strlen(number));
  if(suffix && *suffix)
    dial_trans(cp,suffix);
}

void _fastcall dial_trans (USHORT cp,char *s) {

  /* send chars to the modem with translation for ^v~`|, allow \ escaping */

  char *p = s;

  while(p && *p) {
    switch(*p) {
      case '~':   DosSleep(1000L);    /* 1 sec delay */
                  break;
      case '`':   DosSleep(100L);     /* .1 sec delay */
                  break;
      case '^':   raiseDTR(cp);       /* DTR on */
                  break;
      case 'v':   dropDTR(cp);        /* DTR off */
                  break;
      case '|':   com_putc(cp,'\r');  /* cr */
                  break;
      case '\\':  p++;                /* escape char */
        /* intentional fallthru */
      default:    com_putc(cp,*p);
                  break;
    }
    p++;
  }
}

int _fastcall com_in_empty (USHORT cp) {

  /* return TRUE if input buffer is empty */

  struct _RXQUEUE rq;

  if(MBstart[cp] != MBend[cp])
    return FALSE;
  DosDevIOCtl(&rq,0L,0x68,1,modems[cp]->mh);
  if (!rq.cch)
    return TRUE;
  return FALSE;
}

int _fastcall com_out_empty (USHORT cp) {

  /* com_out_empty() : return TRUE if output buffer is empty */

  struct _RXQUEUE rq;

  DosDevIOCtl(&rq,0L,0x69,1,modems[cp]->mh);
  if (!rq.cch)
    return TRUE;
  return FALSE;
}


#ifdef NEVER

  minimum description of modems[] structure:

  typedef struct {
    HFILE           mh;         /* handle for commport */
    USHORT          cp;         /* commport # (1 for COM1) also used to index structures */
    USHORT          curbaud;    /* current baud rate */
    USHORT          initbaud;   /* init baud rate (& lock rate) */
    DCBINFO         save_di;    /* used to restore initial config at close */
    int             checkcd;    /* check carrier if non-zero */
  }         MDM;

#endif
