#define INCL_WIN

#include <process.h>
#include <stddef.h>
#include <conio.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include "mailer.h"
#include "bbs.h"
#include "timers.h"
#include "window.h"
#include "keys.h"
#include "modem.h"
#include "xmisc.h"
#include "xbbs.h"

    #define KEYBUFSIZE   10

    extern MDM           *modems[MAXINSTANCES];
    extern USER          *user[MAXINSTANCES];
    extern int           helpkey;
    extern HWND          hwndBBS[MAXINSTANCES];
    int                  fakekey[MAXINSTANCES][KEYBUFSIZE];
    int                  fakekeyfirst[MAXINSTANCES],fakekeylast[MAXINSTANCES],
                         fakekeyfull[MAXINSTANCES];
    long                 fakekeySEM[MAXINSTANCES];
    long                 userread[MAXINSTANCES];

    #define TIMEOUT      -1
    #define LOSTCARRIER  -2


int _fastcall get_key (USHORT cp) {

  int temp;

  DosSemRequest(&fakekeySEM[cp],1250L);
  if(fakekeyfull[cp] || fakekeyfirst[cp] != fakekeylast[cp]) {
    temp = fakekey[cp][fakekeyfirst[cp]++];
    fakekeyfull[cp] = 0;
    if(fakekeyfirst[cp] > KEYBUFSIZE)
      fakekeyfirst[cp] = 0;
    DosSemClear(&fakekeySEM[cp]);
    return temp;
  }
  DosSemClear(&fakekeySEM[cp]);
  return 0;
}


int _fastcall put_key (USHORT cp,int key) {

  DosSemRequest(&fakekeySEM[cp],1250L);
  if(!fakekeyfull[cp]) {
    fakekey[cp][fakekeylast[cp]++] = key;
    if(fakekeylast[cp] > KEYBUFSIZE)
      fakekeylast[cp] = 0;
    if(fakekeyfirst[cp] == fakekeylast[cp])
      fakekeyfull[cp] = 1;
    DosSemClear(&fakekeySEM[cp]);
    return key;
  }
  DosSemClear(&fakekeySEM[cp]);
  return 0;
}


void _fastcall zero_keys (USHORT cp) {

  DosSemRequest(&fakekeySEM[cp],250L);
  fakekeyfull[cp] = fakekeyfirst[cp] = fakekeylast[cp] = 0;
  DosSemClear(&fakekeySEM[cp]);
}


int _fastcall if_key (USHORT cp) {

    int temp;

Again:

  temp = get_key(cp);

  if((temp & 1024) && !modems[cp]->inchat) {
    switch(temp) {
        case ALT_C:   /* invoke chat */
            if(user[cp])
              chat(cp);
            temp = -1;
            break;

        case ALT_PLUS:    /* more time */
            if(user[cp]) {
                user[cp]->offline += 60L;
                dprintf(D_LOCAL,cp,"\r\n\04 %ld mins\r\n",(user[cp]->offline - time(NULL)) / 60L);
            }
            goto Again;

        case ALT_MINUS:   /* less time */
            if(user[cp]) {
                user[cp]->offline -= 60L;
                dprintf(D_LOCAL,cp,"\r\n\04 %ld mins\r\n",(user[cp]->offline - time(NULL)) / 60L);
            }
            goto Again;

        case ALT_L:      /* lockout */
            if(user[cp]) {
                user[cp]->attribs |= U_LOCKEDOUT;
                readansi(((modems[cp]->curbaud != 0) * D_REMOTE) + D_LOCAL,cp,"LOCKOUT.ASC",NULL,3);
                sayp(((modems[cp]->curbaud != 0) * D_REMOTE) + D_LOCAL,cp,191,NULL,0);
                flushout(cp);
                DosSleep(2000L);
                if(modems[cp]->curbaud) dropDTR(cp);
                DosSemClear(&modems[cp]->bbsrunningSEM);
                _endthread();
            }
            temp = 0;
            break;

        case ALT_I:     /* id */
            if(user[cp]) {
                dputs(D_LOCAL,cp,"\r\n\04 Local only:\r\n");
                DosSleep(100L);
                give_status1(D_LOCAL,cp,user[cp]);
                DosSleep(500L);
            }
            temp = 0;
            break;

        case ALT_H:     /* hangup */
            if(user[cp])
                if(modems[cp]->curbaud) dropDTR(cp);
            if(DosSemWait(&modems[cp]->bbsrunningSEM,0L)) {
                DosSemClear(&modems[cp]->bbsrunningSEM);
                _endthread();
            }
            temp = 0;
            break;

        case ALT_M:     /* moron key */
            if(user[cp]) {
                readansi(((modems[cp]->curbaud != 0) * D_REMOTE) + D_LOCAL,cp,"YOUMORON.ASC",NULL,3);
                sayp(((modems[cp]->curbaud != 0) * D_REMOTE) + D_LOCAL,cp,190,NULL,0);
                flushout(cp);
                DosSleep(2000L);
                if(modems[cp]->curbaud) dropDTR(cp);
                DosSemClear(&modems[cp]->bbsrunningSEM);
                _endthread();
            }
            temp = 0;
            break;

        case ALT_G:     /* ring remote's bell */
            if(user[cp])
              quiet_bell(((modems[cp]->curbaud != 0) * D_REMOTE),cp,1);
            temp = 0;
            break;

        default:
            break;
    }
  }
  return temp;
}



/* Get keypress from local or remote if anything available, no waiting */

int _fastcall inkey (int mode,USHORT cp) {

    int temp = 0;

    if(mode & D_LOCAL)
      temp = if_key(cp);
    if(!temp && modems[cp]->curbaud && (mode & D_REMOTE)) {
        temp = get_modem_byte(cp,0L);
        switch(temp) {
            case LOSTCARRIER:    if(!com_online(cp)) {
                                   DosSemClear(&modems[cp]->bbsrunningSEM);
                                   _endthread();
                                 }
                                 return 0;

            default:    if(user[cp]->attribs & U_EBCDIC)
                          temp = (int)EBCDIC2ASCII((unsigned char)temp);
                        if(temp == 0) {
                            temp = get_modem_byte(cp,500L);
                            switch(temp) {
                                case LOSTCARRIER:   DosSemClear(&modems[cp]->bbsrunningSEM);
                                                    _endthread();

                                case TIMEOUT:       return 0;

                                default:           if(user[cp]->attribs & U_EBCDIC) temp = (int)EBCDIC2ASCII((unsigned char)temp);
                                                   temp += 1024;
                                                   break;
                            }
                        }
                        else if(temp == ESC && (user[cp]->attribs & U_ANSI)) {
                            temp = interp_ansiin(cp);
                        }
                        break;
        }
    }
    return temp;
}




/* Get keypress from local or remote if anything available, w/waiting */

int _fastcall wait_inkey (int mode,USHORT cp) {

    int     temp = 0,once = 0;
    clock_t t1;

    t1 = timerset(120000L);

Again:

    while(!timeup(t1)) {
        if(DosSemWait(&modems[cp]->amdonexportingSEM,0L)) {

            char s[60];

            DosSemClear(&modems[cp]->amdonexportingSEM);
            sprintf(s,"./XPORT/%08lx.MO0",user[cp]->userid);
            {
                struct stat   st;
                unsigned long dummy;

                if(stat(s,&st)) {
                    sprintf(s,"./XPORT/%08lx.ZIP",user[cp]->userid);
                    if(stat(s,&st) || !st.st_size) {
                        unlink(s);
                        sayp(mode,cp,114,NULL,0);
                        return -1;
                    }
                }
                else if(!st.st_size) {
                    unlink(s);
                    sayp(mode,cp,114,NULL,0);
                    return -1;
                }
                sayp(mode,cp,112,NULL,0);
                hitreturn(mode,cp);
                if(!cp || download_files(mode,cp,s,NULL,&dummy,0) != -1)
                  unlink(s);
                return -1;
            }
        }
        else if(userread[cp]) {

          int  whichbit;
          char s[31];

          for(whichbit = 0;whichbit < 32;whichbit++) {
            if(userread[cp] & (1 << whichbit)) {
              userread[cp] = 0;
              sprintf(s,"FUNKEY%02d.ASC",whichbit + 1);
              if(readansi(mode,cp,s,NULL,2) != -1) {
                WinPostMsg(hwndBBS[cp],WM_COMMAND,
                           MPFROM2SHORT(BBM_F1 + whichbit,0),
                           MPFROMLONG(0L));
                return -1;
              }
              else {
                WinPostMsg(hwndBBS[cp],WM_COMMAND,
                           MPFROM2SHORT(BBM_F1 + whichbit,0),
                           MPFROMLONG(0L));
                break;
              }
            }
          }
        }
        if(mode & D_LOCAL)
          temp = if_key(cp);
        if(temp) {
            if(temp == -1) {
                t1 = timerset(120000L);
                continue;
            }
            return temp;
        }
        if(modems[cp]->curbaud && (mode & D_REMOTE)) {
            temp = get_modem_byte(cp,96L);
            switch(temp) {
                case TIMEOUT:       temp = 0;
                                    break;
                case LOSTCARRIER:   DosSemClear(&modems[cp]->bbsrunningSEM);
                                    _endthread();
                default:            if(temp == 0) {
                                      temp = get_modem_byte(cp,500L);
                                      switch(temp) {
                                        case TIMEOUT:       return 0;
                                        case LOSTCARRIER:   DosSemClear(&modems[cp]->bbsrunningSEM);
                                                            _endthread();
                                        default:            temp += 1024;
                                      }
                                    }
                                    else if(temp == ESC && (user[cp]->attribs & U_ANSI)) {
                                      temp = interp_ansiin(cp);
                                    }
                                    return temp;
            }
        }
        DosSleep(100L);
    }

    if(!once) {
        once++;
        sayp(mode,cp,13,NULL,0);
        t1 = timerset(60000L);
        goto Again;
    }
    DosSemClear(&modems[cp]->bbsrunningSEM);
    _endthread();
  return 0; /* keep compiler gods happy */
}


int _fastcall interp_ansiin (USHORT cp) {

    int temp;


    temp = peek_at_byte(cp,500L);
    if(temp == TIMEOUT) temp = peek_at_byte(cp,1L);
    switch(temp) {
        case LOSTCARRIER:   DosSemClear(&modems[cp]->bbsrunningSEM);
                            _endthread();
        case '[':           get_modem_byte(cp,1L);
                            break;
        default:            return ESC;
    }

    DosSleep(1L);
    temp = peek_at_byte(cp,500L);
    if(temp == TIMEOUT)
      temp = peek_at_byte(cp,1L);
    switch(temp) {
        case LOSTCARRIER:   DosSemClear(&modems[cp]->bbsrunningSEM);
                            _endthread();
        case '1':           get_modem_byte(cp,1L);
                            break;
        case 'A':           get_modem_byte(cp,1L);
                            return UP;
        case 'B':           get_modem_byte(cp,1L);
                            return DN;
        case 'C':           get_modem_byte(cp,1L);
                            return RIGHT;
        case 'D':           get_modem_byte(cp,1L);
                            return LEFT;
        case 'K':           get_modem_byte(cp,1L);
                            return DEL;
        default:            return ESC;
    }

    DosSleep(1L);
    temp = peek_at_byte(cp,500L);
    if(temp == TIMEOUT)
      temp = peek_at_byte(cp,1L);
    switch(temp) {
        case LOSTCARRIER:   DosSemClear(&modems[cp]->bbsrunningSEM);
                            _endthread();
        case 'A':           get_modem_byte(cp,1L);
                            return UP;
        case 'B':           get_modem_byte(cp,1L);
                            return DN;
        case 'C':           get_modem_byte(cp,1L);
                            return RIGHT;
        case 'D':           get_modem_byte(cp,1L);
                            return LEFT;
        case 'K':           get_modem_byte(cp,1L);
                            return DEL;
        default:            return '[';
    }
}
