#include "doorskel.h"
#include "keys.h"
#include "hydra.h"


static char *chatstart = "\007\007 * Chat mode start\r\n";
static char *chatend   = "\007\007\r\n * Chat mode end\r\n";
static char *chattime  = "\007\007\r\n * Chat mode end - timeout\r\n";


int Hydrakeyabort (void)
{
#define CHATLEN 256
  static char     chatbuf1[CHATLEN + 5],
                  chatbuf2[CHATLEN + 5],
                 *curbuf = chatbuf1;
  static boolean  warned = false;
  boolean         esc = false;
  char           *p;
  word            c;

  if (Hydrachattimer > 0L) {
     if (time(NULL) > Hydrachattimer) {
        Hydrachattimer = Hydralasttimer = 0L;
        Hydra_devsend("CON",(char *) chattime,strlen(chattime));
        DoorANSIPuts(&chattime[2]);
     }
     else if ((time(NULL) + 10L) > Hydrachattimer && !warned) {
        DoorANSIPuts("\007\r\n * Warning: chat mode timeout in 10 seconds\r\n");
        warned = true;
     }
  }
  else if (Hydrachattimer != Hydralasttimer) {
     if (Hydrachattimer ==  0L) {
        if (Hydranobell) p = " * Remote has chat facility with bell disabled\r\n";
        else        p = " * Remote has chat facility with bell enabled\r\n";
        Hydra_devsend("CON",(char *) p,(int) strlen(p));
        DoorANSIPuts(" * Hydra session in progress, chat facility now available\r\n");
     }
     else if (Hydrachattimer == -1L)
        DoorANSIPuts(" * Hydra session in init state, can't chat yet\r\n");
     else if (Hydrachattimer == -2L)
        DoorANSIPuts(" * Remote has no chat facility available\r\n");
     else if (Hydrachattimer == -3L) {
        if (Hydralasttimer > 0L) DoorANSIPuts("\r\n");
        DoorANSIPuts(" * Hydra session in exit state, can't chat anymore\r\n");
     }
     Hydralasttimer = Hydrachattimer;
  }
  while (kbhit()) {
        switch (c = Hydraget_key()) {
               case ESC:
                    esc = true;
                    break;

               case ALT_C:
                    if (Hydrachattimer == 0L) {
                       Hydra_devsend("CON",(char *) chatstart,strlen(chatstart));
                       DoorANSIPuts(&chatstart[2]);
                       Hydrachattimer = Hydralasttimer = time(NULL) + HYDRACHAT_TIMEOUT;
                    }
                    else if (Hydrachattimer > 0L) {
                       Hydrachattimer = Hydralasttimer = 0L;
                       Hydra_devsend("CON",(char *) chatend,strlen(chatend));
                       DoorANSIPuts(&chatend[2]);
                    }
                    else
                       DoorANSIPuts("\007");
                    break;

               default:
                    if (c < ' ' || c > 126)
                       break;

               case '\r':
               case '\a':
               case '\b':
                    if (Hydrachattimer <= 0L)
                       break;

                    Hydrachattimer = time(NULL) + HYDRACHAT_TIMEOUT;
                    warned = false;

                    if (Hydrachatfill >= CHATLEN)
                       DoorANSIPuts("\007");
                    else {
                       switch (c) {
                              case '\r':
                                   curbuf[Hydrachatfill++] = '\n';
                                   DoorANSIPuts("\r\n");
                                   break;

                              case '\b':
                                   if (Hydrachatfill > 0 && curbuf[Hydrachatfill - 1] != '\n')
                                      Hydrachatfill--;
                                   else {
                                      curbuf[Hydrachatfill++] = '\b';
                                      curbuf[Hydrachatfill++] = ' ';
                                      curbuf[Hydrachatfill++] = '\b';
                                   }
                                   DoorANSIPuts("\b \b");
                                   break;

                              default:
                                   curbuf[Hydrachatfill++] = (char) c;
                                   if (c != 7)
                                      DoorANSIPutc(c);
                                   {
                                     int x,y;

                                     DoorCurrCursor(&x,&y);
                                     if(y > 24) {
                                       DoorScrollUp(0,18,79,23,7);
                                       DoorCursor(x,24);
                                     }
                                   }
                                   break;
                       }
                    }
                    break;
        }
  }

  if (Hydrachatfill > 0 && Hydra_devsend("CON",curbuf,Hydrachatfill)) {
     curbuf = (curbuf == chatbuf1) ? chatbuf2 : chatbuf2;
     Hydrachatfill = 0;
  }

  return (esc);
}/*Hydrakeyabort()*/


void Hydrarem_chat (char *data, word len)
{
  int x,y;

        len = len;

        DoorCurrCursor(&Hydralocal_x,&Hydralocal_y);
        DoorCursor(Hydraremote_x,Hydraremote_y);

        while (*data) {
              switch (*data) {
                     case '\a':
                          if (!Hydranobell) {
                             DoorANSIPutc(7);
                          }
                          break;

                     case '\n':
                          DoorANSIPutc('\r');
                          /* fallthrough to default */

                     default:
                          DoorANSIPutc(*data);
                          DoorCurrCursor(&x,&y);
                          if(y > 17) {

                            DoorScrollUp(0,10,79,16,7);
                            DoorCursor(x,17);
                          }
                          break;
              }
              data++;
        }

        DoorCurrCursor(&Hydraremote_x,&Hydraremote_y);
        DoorCursor(Hydralocal_x,Hydralocal_y);
}/*Hydrarem_chat()*/


void Hydrasplitpath(char *filepath,char *path,char *file)
{
  char *p,*q;

  for (p=filepath;*p;p++) ;
  while (p!=filepath && *p!=':' && *p!='\\' && *p!='/') --p;
  if (*p==':' || *p=='\\' || *p=='/') ++p;        /* begin     */
  q=filepath;
  while (q!=p) *path++=*q++;                      /* copy path */
  *path='\0';
  strcpy(file,p);
}/*Hydrasplitpath()*/


void Hydramergepath(char *filepath,char *path,char *file)
{
  strcpy(filepath,path);
  strcat(filepath,file);
}/*Hydramergepath()*/


int Hydrafexist (char *filename)
{
  struct stat f;

  return ((stat(filename,&f) != -1) ? 1 : 0);
}/*Hydrafexist()*/


int Hydraget_key (void)
{
   register int c = getch();

   return ((c && c != 0xe0) ? c : getch() | 0x100);
}/*Hydraget_key()*/


void Hydraresultlog (boolean xmit, char *fname, long bytes, long xfertime)
{          /* Omen's DSZ compatible logfile - for RBBS-PC XFER-?.DEF reports */
  FILE *fp;

  if (Hydraopuslog) {
     if ((fp = DoorFsopen(Hydraopuslog,"at",SH_DENYWR)) != NULL) {
        if (fname) {
           fprintf(fp, "%s %s%s %ld", xmit ? "Sent" : "Got",
                       xmit ? "" : Hydradownload, fname, bytes);
           fprintf(fp,"\n");
        }
        fclose(fp);
     }
     else
        Hydramessage(3,"-Couldn't append opus log-file %s",Hydraopuslog);
  }

  if (Hydraresult) {
     if ((fp = DoorFsopen(Hydraresult,"at",SH_DENYWR)) != NULL) {
        if (fname) {
           fprintf(fp, "%c %6ld %5u bps %4ld cps 0 errors     0 1024 %s -1\n",
                       xmit ? 'H' : 'R',
                       bytes, DoorGetBaudVar(),
                       xfertime ? (bytes / xfertime) : 9999L,
                       fname);
        }
        fclose(fp);
     }
     else
        Hydramessage(3,"-Couldn't append result-file %s",Hydraresult);
  }
}/*Hydraresultlog()*/


static char *mon[12] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                         "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

char *Hydrah_revdate (long revstamp)
{
  static char  buf[12];
  struct tm   *t;

  t = localtime(&revstamp);
  sprintf(buf, "%02d %s %d",
          t->tm_mday, mon[t->tm_mon], t->tm_year + 1900);

  return (buf);
}/*Hydrah_revdate()*/


void Hydramessage (int level, char *fmt,...)
{
  char       buf[255];
  long       tim;
  struct tm *t;
  va_list    arg_ptr;

  tim = time(NULL);
  t = localtime(&tim);

  va_start(arg_ptr,fmt);
  sprintf(buf, "%c %02d %03s %02d:%02d:%02d ",
               *fmt, t->tm_mday, mon[t->tm_mon],
               t->tm_hour, t->tm_min, t->tm_sec);
  vsprintf(&buf[23], &fmt[1], arg_ptr);
  va_end(arg_ptr);

  if (level >= Hydraloglevel && Hydralogfp)
     fprintf(Hydralogfp, "%s\n", buf);

  if (!Hydrafile_x)
     DoorANSIPrintf("\r%s\r\n",buf);
  else {
     DoorCurrCursor(&Hydralocal_x,&Hydralocal_y);
     if (Hydralog_y) {
        DoorCursor(1,Hydralog_y);
        DoorANSIPuts("\r\n");
     }
     {
       int x,y;

       DoorCurrCursor(&x,&y);
       if(y > 6) {
         DoorScrollUp(0,1,79,5,7);
         DoorCursor(x,6);
       }
     }
     DoorANSIPuts(buf);
     {
       int x,y;

       DoorCurrCursor(&x,&y);
       if(y > 6) {
         DoorScrollUp(0,1,79,5,7);
         DoorCursor(x,5);
       }
     }
     Hydralog_y = DoorWhereY();
     DoorCursor(Hydralocal_x,Hydralocal_y);
  }
}/*Hydramessage()*/


void Hydra_gotoxy (int x, int y)
{
  Hydrafile_x = x;
  Hydrafile_y = y;
}/*Hydra_gotoxy()*/


void Hydra_printf (char *fmt, ...)
{
  char    buf[255];
  va_list arg_ptr;

  va_start(arg_ptr,fmt);
  vsprintf(buf, fmt, arg_ptr);
  va_end(arg_ptr);

  DoorCurrCursor(&Hydralocal_x,&Hydralocal_y);
  DoorCursor(Hydrafile_x,Hydrafile_y);
  DoorANSIPuts(buf);
  DoorCurrCursor(&Hydrafile_x,&Hydrafile_y);
  DoorCursor(Hydralocal_x,Hydralocal_y);
}/*Hydra_printf()*/


void Hydra_clreol (void)
{
  Hydra_printf("\x1b[K");
}/*Hydra_clreol()*/

/* end of misc.c */
