#include <ctype.h>
#include <process.h>
#include "mailer.h"
#include "modem.h"
#include "bbs.h"
#include "xmisc.h"

#pragma optimize("",off)


    extern struct _msgarea   *msgareas;
    extern struct _filearea  *fileareas;
    extern MDM               *modems[MAXINSTANCES];
    extern USER              *user[MAXINSTANCES];
    extern BBS               *bbs;
    extern COMPTYPES         *computer;

#define getrandom( min, max ) ((rand() % (int)(((max) + 1) - (min))) + (min))



int _pascal edit_yourself (int mode,USHORT cp) {

    #define NUM_SELECTS 20

    int  changed = 0,selection;


  for(;;) {

    if(user[cp]->offline < time(NULL)) return changed;

    if(!clear_toplines(mode,cp,2)) dputs(mode,cp,"\r\n");
    if(user[cp]->attribs & U_COLOR) {
        dputs(mode,cp,"\x1b[s\x1b[2;1H");
    }
    sayp(mode,cp,270,NULL,0);
    if(user[cp]->attribs & U_COLOR) {
        dputs(mode,cp,"\x1b[u");
    }
    else dputs(mode,cp,"\r\n");

    selection = pselect_one(mode,cp,47,NUM_SELECTS,48,NULL,"Edit You",set_iflg(cp));
    selection++;

    switch (selection) {
        case 1:         chg_address(mode,cp);
                        break;

        case 2:         chg_color(mode,cp);
                        break;

        case 3:         chg_high(mode,cp);
                        break;

        case 4:         chg_cold(mode,cp);
                        break;

        case 5:         chg_length(mode,cp);
                        break;

        case 6:         chg_pause(mode,cp);
                        break;

        case 7:         chg_handle(mode,cp);
                        break;

        case 8:         chg_password(mode,cp);
                        break;

        case 9:         chg_width(mode,cp);
                        break;

        case 10:        chg_phone(mode,cp);
                        break;

        case 11:        chg_interests(mode,cp);
                        break;

        case 12:        chg_show(mode,cp);
                        break;

        case 13:        chg_expert(mode,cp);
                        break;

        case 14:        chg_roll(mode,cp);
                        break;

        case 15:        adjust_msgareas(mode,cp);
                        break;

        case 16:        adjust_fileareas(mode,cp);
                        break;

        case 17:        chg_ANSI(mode,cp);
                        break;

        case 18:        chg_misc(mode,cp);
                        break;

        case 19:        chg_clear(mode,cp);
                        break;

        case 0:
        case NUM_SELECTS:  return changed;
        default:        sayp(mode,cp,94,NULL,0);
                        changed--;
                        break;
    }

    changed++;
  }
}





void _pascal chg_interests (int mode,USHORT cp) {

    char interests[80];


    strset(interests,0);
    strcpy(interests,user[cp]->interests);
    interests[79] = 0;
    do {
        while(!*pinput_string(mode,cp,interests,78,6,49,
                              STRT_ALL,STRF_REQUIRED | STRF_NEAT,
                              "User Interests",NULL));
    } while(any_lower(mode,cp,interests));
    strcpy(user[cp]->interests,interests);
}




void _pascal chg_address (int mode,USHORT cp) {

    char address[80];


    strset(address,0);
    strcpy(address,user[cp]->address);
    address[79] = 0;
    do {
        while(!*pinput_string(mode,cp,address,78,6,50,
                             STRT_ALL,STRF_REQUIRED | STRF_NEAT,
                             "User Address",NULL));
    } while(any_lower(mode,cp,address));
    strcpy(user[cp]->address,address);
}




void _pascal chg_phone (int mode,USHORT cp) {

    char phone[21];
    int  temp;


    strset(phone,0);
    strcpy(phone,user[cp]->phone_number);
    phone[20] = 0;
    while(!*pinput_string(mode,cp,phone,20,10,51,
                         STRT_ALPHANUMERIC,STRF_REQUIRED,
                         "User Phone",NULL));

    sayp(mode,cp,52,NULL,0);
    temp = phonecan(mode,cp,phone);
    if(temp == -1) {
        DosSemClear(&modems[cp]->bbsrunningSEM);
        _endthread();
    }
    else if(temp == -2) {
        if(bbs->attribs & B_NODUPENUMS) {
            readansi(mode,cp,"DUPEPHON.ASC",NULL,3);
            sayp(mode,cp,201,NULL,0);
            flushout(cp);
            DosSemClear(&modems[cp]->bbsrunningSEM);
            _endthread();
        }
        sayp(mode,cp,53,NULL,0);
        logfunc(0,cp,"Dupe phone #: \"%s\"",phone);
    }

    strcpy(user[cp]->phone_number,phone);
}




void _fastcall chg_password (int mode,USHORT cp) {

    char pword[13];
    char chkstr[13];


Again:

    strset(pword,0);
    if(!(bbs->attribs & B_AUTOPASSWORDS)) {
        pinput_string(mode,cp,pword,12,0,54,
                     STRT_ALL,STRF_REQUIRED | STRF_ENCRYPT,
                     "User Password",NULL);
    }
    if(strlen(pword) < 3 || (bbs->attribs & B_AUTOPASSWORDS)) {
        auto_password(mode,cp,pword);
        sayp(mode,cp,55,NULL,0);
        dprintf(mode,cp,"\"%s\"\r\n",pword);
        sayp(mode,cp,56,NULL,0);
    }
    strset(chkstr,0);
    while(!*pinput_string(mode,cp,chkstr,12,3,57,
                         STRT_ALL,STRF_ENCRYPT,
                         "Check Password",NULL));
    if(strcmp(pword,chkstr)) {
        sayp(mode,cp,58,NULL,0);
        goto Again;
    }
    strcpy(user[cp]->password,pword);
}




void _fastcall chg_handle (int mode,USHORT cp) {

    char hnd[36];
    int  temp;


ReTry:

    strset(hnd,0);
    strcpy(hnd,user[cp]->handle);
    hnd[35] = 0;
    pinput_string(mode,cp,hnd,35,2,59,
                 STRT_ALL,STRF_REQUIRED | STRF_PRETTY,
                 "User Handle",NULL);

    if(stricmp(user[cp]->name,hnd)) {
        sayp(mode,cp,52,NULL,0);
        temp = trashcan(mode,cp,hnd);
        if(temp == -1) {
            DosSemClear(&modems[cp]->bbsrunningSEM);
            _endthread();
        }

        {
            USER         *dummy1;
            unsigned int c,dummy2;

            dummy1 = bbs_malloc(cp,sizeof(USER));
            if(dummy1) {
                c = find_user(mode,cp,dummy1,hnd,&dummy2);
                if(c && c != user[cp]->number) {
                    bbs_free(cp,dummy1);
                    dprintf(mode,cp,"\r\n\"%s\"",hnd);
                    sayp(mode,cp,61,NULL,0);
                    goto ReTry;
                }
                bbs_free(cp,dummy1);
            }
        }
    }

    strcpy(user[cp]->handle,hnd);
}




void _fastcall chg_show (int mode,USHORT cp) {

    char yorn[6];


  strset(yorn,0);
  if(*pinput_string(mode,cp,yorn,1,1,61,
                     STRT_YN,STRF_HOT,"User Showaddress",NULL) == modems[cp]->YES) {
        user[cp]->attribs |= U_NOSHOWADDRESS;
    }
    else {
        user[cp]->attribs &= (~U_NOSHOWADDRESS);
    }

  strset(yorn,0);
  if(*pinput_string(mode,cp,yorn,1,1,62,
                     STRT_YN,STRF_HOT,"User Showphone",NULL) == modems[cp]->YES) {
        user[cp]->attribs |= U_NOSHOWPHONE;
    }
    else {
        user[cp]->attribs &= (~U_NOSHOWPHONE);
    }

    strset(yorn,0);
  if(*pinput_string(mode,cp,yorn,1,1,63,
                     STRT_YN,STRF_HOT,"User Showreal",NULL) == modems[cp]->YES) {
        user[cp]->attribs |= U_NOSHOWREAL;
    }
    else {
        user[cp]->attribs &= (~U_NOSHOWREAL);
    }
}





void _fastcall chg_ANSI (int mode,USHORT cp) {

    char yorn[6];


    strset(yorn,0);
    if(*pinput_string(mode,cp,yorn,1,1,64,
                     STRT_YN,STRF_HOT,"User ANSI",NULL) == modems[cp]->YES) {
        user[cp]->attribs |= U_ANSI;
    }
    else {
        user[cp]->attribs &= (~U_ANSI);
        user[cp]->attribs &= (~U_COLOR);
    }
}



void _fastcall chg_color (int mode,USHORT cp) {

    char yorn[6];


    if(!(user[cp]->attribs & U_ANSI)) {
        sayp(mode,cp,105,NULL,0);
        return;
    }
    strset(yorn,0);
    if(*pinput_string(mode,cp,yorn,1,1,104,
                     STRT_YN,STRF_HOT,"User Color",NULL) == modems[cp]->YES) {
        user[cp]->attribs |= U_COLOR;
    }
    else {
        if(user[cp]->attribs & U_COLOR) dputs(mode,cp,"\x1b[0m");
        user[cp]->attribs &= (~U_COLOR);
    }
}




void _fastcall chg_high (int mode,USHORT cp) {

    char yorn[6];


    strset(yorn,0);
    user[cp]->attribs |= U_HIGHASCII;
    if(*pinput_string(mode,cp,yorn,1,1,106,
                     STRT_YN,STRF_HOT,
                     "User HighASCII",NULL) == modems[cp]->YES) {
                     user[cp]->attribs |= U_HIGHASCII;
    }
    else {
        user[cp]->attribs &= (~U_HIGHASCII);
    }
}




void _fastcall chg_expert (int mode,USHORT cp) {

    char yorn[6];


    strset(yorn,0);
    if(*pinput_string(mode,cp,yorn,1,1,107,
                     STRT_YN,STRF_HOT,"User Novice",NULL) == modems[cp]->NO) {
        user[cp]->attribs &= (~U_NOVICE);
    }
    else {
        user[cp]->attribs |= U_NOVICE;
    }

    strset(yorn,0);
    if(*pinput_string(mode,cp,yorn,1,1,108,
                     STRT_YN,STRF_HOT,"User Expert",NULL) == modems[cp]->YES) {
        user[cp]->attribs |= U_EXPERT;
    }
    else {
        user[cp]->attribs &= (~U_EXPERT);
    }

    sayp(mode,cp,109,NULL,0);
    DosSleep(1000L);
}

#pragma optimize("",on)

