#include "mailer.h"
#include "bbs.h"
#include "window.h"
#include "xmisc.h"
#include "modem.h"
#include "comm/serial.h"
#include "comm/protocol.h"

extern MDM *modems[MAXINSTANCES];


VOID CALLBACK tstatus (USHORT msg,PVOID tdata,PVOID mdm) {

    MDM *m = (MDM *)mdm;
    char s[81],*p;
    USHORT cp;

    cp = m->cp;

    switch(msg) {
        case XMODEM_CHKSUM:
            Say_Transmisc("XModem Csum");
            break;

        case XMODEM_CRC:
            sprintf(s,"XModem CRC");
            if(*(int *)tdata) strcat(s," 1K");
            Say_Transmisc(s);
            break;

        case YMODEM_CRC:
            Say_Transmisc("YModem");
            break;

        case ZMODEM_CRC:
            Say_Transmisc("ZModem");
            break;

        case XMIT_BLOCK:
            sprintf(s,"SBlk %d",*(int *)tdata);
            Say_UD(s);
            break;

        case XMIT_PACKET:
            sprintf(s,"%ld Sbytes",*(long *)tdata);
            Say_UD(s);
            break;

        case RETRY_BLOCK:
            sprintf(s,"Retry blk %d",*(int *)tdata);
            Say_UDErr(s);
            break;

        case RETRY_PACKET:
            Say_UDErr("Retrying packet");
            break;

        case RCV_BLOCK:
            sprintf(s,"RBlk %d",*(int *)tdata);
            Say_UD(s);
            break;

        case RCV_PACKET:
            sprintf(s,"%ld Rbytes",*(long *)tdata);
            Say_UD(s);
            break;

        case XMIT_FILE:
            sprintf(s,"SFile: \"%s\"",(char *)tdata);
            Say_Transmisc(s);
            break;

        case RCV_FILE:
            sprintf(s,"RFile: \"%s\"",(char *)tdata);
            Say_Transmisc(s);
            break;

        case XMIT_FILE_YZ:
            sprintf(s,"SFile: \"%s\"",(char *)tdata);
            p = (char *)tdata;
            while(*p) p++;
            if(!*(p + 1)) {
                Say_Transmisc(s);
                break;
            }
            p++;
            strcat(s,p);
            Say_UD(s);
            break;

        case RCV_FILE_YZ:
            sprintf(s,"RFile: \"%s\"",(char *)tdata);
            p = (char *)tdata;
            while(*p) p++;
            if(!*(p + 1)) {
                Say_Transmisc(s);
                break;
            }
            p++;
            strcat(s,p);
            Say_Transmisc(s);
            break;

        case NO_RESPONSE:
            Say_UDErr("No response");
            break;

        case INVAL_SOH:
            Say_UDErr("Invalid SOH");
            break;

        case INVAL_BLKNUM:
            Say_UDErr("Invalid Block #");
            break;

        case INVAL_CHKSUM:
            Say_UDErr("Invalid Checksum");
            break;

        case XFER_TIMEOUT:
            Say_UDErr("Timeout");
            break;

        case INVAL_ESCAPE:
            Say_UDErr("Invalid Escape");
            break;

        case USER_ABORT:
            Say_UDErr("User abort");
            break;

        case REMOTE_ABORT:
            Say_UDErr("Remote abort");
            break;

        case GIVEUP_ABORT:
            Say_UDErr("Giveup abort");
            break;

        case NO_FILES:
            Say_UDErr("No files");
            break;

        case NO_MEMORY:
            Say_UDErr("Out of memory");
            break;

        case ACCESS_FILE:
            Say_UDErr("Invalid filename");
            break;

        case READ_FILE:
            Say_UDErr("Read error");
            break;

        case PORT_ERROR:
            sprintf(s,"Port error #%d",*(int *)tdata);
            break;

        case BAD_WORDLEN:
            Say_UDErr("Bad word length");
            break;

        case CHG_FSIZE:
            Say_UDErr("Error changing file size");
            break;

        case CHG_FDATE:
            Say_UDErr("Error changing file date");
            break;

        case WRITE_FILE:
            Say_UDErr("Write error");
            break;

        case TERM_SUCCESS:
            Say_UDErr("Success");
            break;

        case TERM_FAILURE:
            Say_UDErr("Failure");
            break;

        default:
            sprintf(s,"Message #%u",msg);
            Say_Transmisc(s);
            break;
    }
}


USHORT CALLBACK tdupe (PSZ fname,PVOID mdm) {

    MDM *m = (MDM *)mdm;

    return 0;
}



USHORT _pascal ZMUpload (USHORT cp,char *path) {

  XFERIOINFO2 ioInfo;
  SZINFO      szInfo;
  USHORT      rVal;
  PCOMM       comm;

  hold_comthread(cp);

  comm = CommReOpen(modems[cp]->mh,cp);
  if(!comm) {
    restart_comthread(cp);
    return 1;
  }

  ioInfo.msgIn         = NULL;
  ioInfo.msgOut        = tstatus;
  ioInfo.salvage       = tdupe;
  ioInfo.prtyClass     = PRTYC_REGULAR;
  ioInfo.prtyDelta     = 31;
  ioInfo.awareLevel    = 0x0060;
  ioInfo.pInitData     = NULL;
  ioInfo.xtraInfo      = &szInfo;
  ioInfo.xtraInfo2     = modems[cp];

  ioInfo.xmitThreshold = 0;
  ioInfo.xmitPacing    = 0;
  ioInfo.xmitTOFactor  = 1;

  szInfo.blkopt        = 0;
  szInfo.Tframlen      = 0;
  szInfo.Txwindow      = 0;
  szInfo.Rxwindow      = 0;
  szInfo.Rxtimeout     = 0;

logfunc(0,cp,"Engaging Zmodem receive");
  rVal = XferReceiveZModem(comm,XMIT_NOPATH | CPK2_99_AWARE,
                           path,(PXFERIOINFO)&ioInfo);

  free(comm);
  restart_comthread(cp);

  return rVal;
}



USHORT _pascal ZMDownload (USHORT cp,char *files) {

  XFERIOINFO2 ioInfo;
  SZINFO      szInfo;
  USHORT      rVal;
  PCOMM       comm;


  hold_comthread(cp);

  comm = CommReOpen(modems[cp]->mh,cp);
  if(!comm) {
    restart_comthread(cp);
    return 1;
  }

  ioInfo.msgIn         = NULL;
  ioInfo.msgOut        = tstatus;
  ioInfo.salvage       = tdupe;
  ioInfo.prtyClass     = PRTYC_REGULAR;
  ioInfo.prtyDelta     = 31;
  ioInfo.awareLevel    = 0x0060;
  ioInfo.pInitData     = NULL;
  ioInfo.xtraInfo      = &szInfo;
  ioInfo.xtraInfo2     = modems[cp];

  ioInfo.xmitThreshold = 0;
  ioInfo.xmitPacing    = 0;
  ioInfo.xmitTOFactor  = 1;

  szInfo.blkopt        = 0;
  szInfo.Tframlen      = 0;
  szInfo.Txwindow      = 0;
  szInfo.Rxwindow      = 0;
  szInfo.Rxtimeout     = 0;

logfunc(0,cp,"Engaging Zmodem Send");
  rVal = XferSendZModem(comm,files,XMIT_NOPATH | CPK2_99_AWARE,
                        (PXFERIOINFO)&ioInfo);

  free(comm);
  restart_comthread(cp);

  return rVal;
}



USHORT _pascal YMDownload (USHORT cp,char *files,int Gopt) {

  XFERIOINFO2 ioInfo;
  SZINFO      szInfo;
  USHORT      rVal;
  PCOMM       comm;


  hold_comthread(cp);

  comm = CommReOpen(modems[cp]->mh,cp);
  if(!comm) {
    restart_comthread(cp);
    return 1;
  }

  ioInfo.msgIn         = NULL;
  ioInfo.msgOut        = tstatus;
  ioInfo.salvage       = tdupe;
  ioInfo.prtyClass     = PRTYC_REGULAR;
  ioInfo.prtyDelta     = 31;
  ioInfo.awareLevel    = 0x0060;
  ioInfo.pInitData     = NULL;
  ioInfo.xtraInfo      = &szInfo;
  ioInfo.xtraInfo2     = modems[cp];

  ioInfo.xmitThreshold = 0;
  ioInfo.xmitPacing    = 0;
  ioInfo.xmitTOFactor  = 1;

  szInfo.blkopt        = 0;
  szInfo.Tframlen      = 0;
  szInfo.Txwindow      = 0;
  szInfo.Rxwindow      = 0;
  szInfo.Rxtimeout     = 0;

  rVal = XferSendYModem(comm,files,XMIT_NOPATH | CPK2_99_AWARE,
                        Gopt,(PXFERIOINFO)&ioInfo);

  free(comm);
  restart_comthread(cp);

  return rVal;
}



USHORT _pascal YMUpload (USHORT cp,char *path,int Gopt) {

  XFERIOINFO2 ioInfo;
  SZINFO      szInfo;
  USHORT      rVal;
  PCOMM       comm;


  hold_comthread(cp);

  comm = CommReOpen(modems[cp]->mh,cp);
  if(!comm) {
    restart_comthread(cp);
    return 1;
  }

  ioInfo.msgIn         = NULL;
  ioInfo.msgOut        = tstatus;
  ioInfo.salvage       = tdupe;
  ioInfo.prtyClass     = PRTYC_REGULAR;
  ioInfo.prtyDelta     = 31;
  ioInfo.awareLevel    = 0x0060;
  ioInfo.pInitData     = NULL;
  ioInfo.xtraInfo      = &szInfo;
  ioInfo.xtraInfo2     = modems[cp];

  ioInfo.xmitThreshold = 0;
  ioInfo.xmitPacing    = 0;
  ioInfo.xmitTOFactor  = 1;

  szInfo.blkopt        = 0;
  szInfo.Tframlen      = 0;
  szInfo.Txwindow      = 0;
  szInfo.Rxwindow      = 0;
  szInfo.Rxtimeout     = 0;

  rVal = XferReceiveYModem(comm,XMIT_NOPATH | CPK2_99_AWARE,
                           Gopt,path,(PXFERIOINFO)&ioInfo);

  free(comm);
  restart_comthread(cp);

  return rVal;
}
