#define INCL_DOS

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>


#define isleap(year) ((((year%4)==0) && ((year%100)!=0)) || \
        ((year%400)==0))

int monthdays[12] = {31,28,31,30,31,30,31,31,30,31,30,31};

    union _fd {
      FDATE fd;
      unsigned int x;
    };

    union _ft {
      FTIME ft;
      unsigned int x;
    };

    struct _file_buffer {   /* For DosFindFirst/DosFindNext */
      union _fd     cd;
      union _ft     ct;
      union _fd     ld;
      union _ft     lt;
      union _fd     wd;
      union _ft     wt;
      long          size;
      long          falloc;
      unsigned int  attr;
      unsigned char namelen;
      char          filename[257];
    };




int _fastcall filedatetime_from_timet (time_t t,FDATE *date,FTIME *time) {

  register int x;

  for(x = 1970;x < 1980;x++) {
    if(isleap(x)) {
      if(t < (366L * (24L * 60L * 60L)))
        break;
      else
        t -= (366L * (24L * 60L * 60L));
    }
    else {
      if(t < (365L * (24L * 60L * 60L)))
        break;
      else
        t -= (365L * (24L * 60L * 60L));
    }
  }
  for(date->year = 0;;) {
    if(isleap(date->year)) {
      if(t < (366L * (24L * 60L * 60L)))
        break;
      else
        t -= (366L * (24L * 60L * 60L));
    }
    else {
      if(t < (365L * (24L * 60L * 60L)))
        break;
      else
        t -= (365L * (24L * 60L * 60L));
    }
    date->year++;
  }
  for(date->month = 1;;) {
    if(date->month == 2 && isleap(date->year + 1980)) {
      if(t < (29L * (24L * 60L * 60L)))
        break;
      else
        t -= (29L * (24L * 60L * 60L));
    }
    else {
      if(t < ((long)monthdays[date->month - 1] * (24L * 60L * 60L)))
        break;
      else
        t -= ((long)monthdays[date->month - 1] * (24L * 60L * 60L));
    }
    date->month++;
  }
  date->day = 1 + (int)(t / (24L * 60L * 60L));
  t %= (24L * 60L * 60L);
  time->hours = (int)(t / (60L * 60L));
  t %= (60L * 60L);
  time->minutes = (int)(t / 60L);
  t %= 60L;
  time->twosecs = (int)(t / 2L);
  return 1;
}


time_t _fastcall secs_since_1970 (FDATE *date,FTIME *time) {

  time_t       total = 0L;
  register int x;

  for(x = 1970;x < date->year + 1980;x++) {
    if(isleap(x))
      total += (366L * (24L * 60L * 60L));
    else
      total += (365L * (24L * 60L * 60L));
  }
  for(x = 1;x < date->month;x++) {
    if(x == 2 && isleap(date->year + 1980))
      total += (29L * (24L * 60L * 60L));
    else
      total += ((long)monthdays[x - 1] * (24L * 60L * 60L));
  }
  total += (((long)date->day - 1L) * (24L * 60L * 60L));
  total += ((long)time->hours * (60L * 60L));
  total += ((long)time->minutes * 60L);
  total += ((long)time->twosecs * 2L);
  return total;
}


char * _fastcall say_date (char *buffer,time_t tt) {

    struct tm *t;

    t = localtime(&tt);
    sprintf(buffer,"%02u/%02u/%02u",t->tm_year % 100,t->tm_mon + 1,t->tm_mday);
    return buffer;
}


char * _fastcall say_filedate (char *buffer, FILEFINDBUF *f) {

    struct _file_buffer *fb = (struct _file_buffer *)f;

    sprintf(buffer,"%02u/%02u/%02u",(fb->wd.fd.year + 1980) % 100,
            fb->wd.fd.month,fb->wd.fd.day);
    return buffer;
}


char * _fastcall say_filedate2 (char *buffer, FILEFINDBUF *f) {

return say_filedate(buffer,f);
}



time_t _fastcall dosfile_2_unix (FTIME *ft,FDATE *fd) {

  return secs_since_1970(fd,ft);
}


/* note 1980 base */

time_t _fastcall unixgetftime (int handle) {

    FILESTATUS fdata;

    if(DosQFileInfo(handle,1,&fdata,sizeof(FILESTATUS)))
      return -1L;
    return secs_since_1970(&fdata.fdateLastWrite,&fdata.ftimeLastWrite);
}



int _fastcall unixsetftime (int handle,time_t t) {

  FILESTATUS fdata;

  if(handle == -1)
    return -1;
  if(DosQFileInfo(handle,FIL_STANDARD,&fdata,sizeof(FILESTATUS)))
    return -1;
  filedatetime_from_timet(t,&fdata.fdateLastWrite,&fdata.ftimeLastWrite);
  fdata.fdateCreation = fdata.fdateLastWrite;
  fdata.fdateLastAccess = fdata.fdateLastWrite;
  fdata.ftimeCreation = fdata.ftimeLastWrite;
  fdata.ftimeLastAccess = fdata.ftimeLastWrite;
  return DosSetFileInfo(handle,FIL_STANDARD,(PBYTE)&fdata,sizeof(FILESTATUS));
}

