#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <ctype.h>
#include "mailer.h"
#include "bbs.h"
#include "modem.h"
#include "xmisc.h"
#include "xmsg.h"



    extern USER *user[MAXINSTANCES];
    extern MDM  *modems[MAXINSTANCES];
    extern BBS  *bbs;

#define CTRL_K      11
#define CTRL_S      19



int _fastcall read_msg (int mode,USHORT cp,MSGAREA *info,word messno,
                        unsigned int flags) {

    /* flags bitmapped values:
        1:  ignore linecounter (no paging)
        2:  don't set user's lmrs
        4:  don't stop at EOM
        8:  work backwards

       returns:
        -1: Error occurred when attempting to read msg
        -2: No more messages or bad messno
         0: Last msg was unreadable (security or deleted)
         1: Next
         2: Prev
         3: Stop
         8: #msg
        10: Scan from here
        128 ORed in: nonstop request in this function by user
    */

    XMSG         msg;
    int          temp,lines,hdrlines,ret = 0;
    char         *hold = NULL,**lpos = NULL,line[133],lastmsgid[133],*p,
                 color[13],lastreplyid[133],threadby[133],input[81];
    word         page;
    static int   quotecolor = 10,tearcolor = 2,origincolor = 13,
                 textcolor = 12,hdrcolor = 15,kludgecolor = 3,
                 promptcolor = 4,cmdcolor = 12;
    unsigned int endthread = 0,tmessno,nummsgs;
    int          rulesavailable,descravailable,ctla = 0,x;


    if(!info || info->number > 512)
      return -1;

ReStart:

    nummsgs = how_many_msgs(info);
    page = 0;
    memset(&msg,0,sizeof(XMSG));
    temp = get_messu(cp,&msg,info->number,messno,user[cp]);
    if(temp != MSG_NOERR) {
        if(temp == MSG_ISPRIVATE) {
            dprintf(mode,cp,"\r\n%5u. Private\r\n",messno);
        }
        else if(temp == MSG_ISDELETED) {
            dprintf(mode,cp,"\r\n%5u. Deleted\r\n",messno);
        }
        else if(temp == MSG_BADNUM) {
            return -2;
        }
        else return -1;
        if(!(flags & 2)) {
            if(user[cp]->lastread[info->number - 1] < messno)
                if(messno) user[cp]->lastread[info->number - 1] = messno;
        }
        return 0;
    }

    {
      struct stat st;

      sprintf(line,"MSG/RULES.%03x",info->number);
      if(!stat(line,&st) && st.st_size != 0)
        rulesavailable = 1;
      sprintf(line,"MSG/DESCR.%03x",info->number);
      if(!stat(line,&st) && st.st_size != 0)
        descravailable = 1;
    }

    if(rulesavailable && user[cp]->lastread[info->number - 1] == 0) {
        sprintf(line,"MSG/RULES.%03x",info->number);
        if(bbs->attribs & B_ANSINEWS) {
            readansi(mode,cp,line,NULL,3);
            hitreturn(mode,cp);
        }
        else
          readtext(mode,cp,line);
    }

    if(!(flags & 2)) {
        if(user[cp]->lastread[info->number - 1] < messno) {
            if(messno)
              user[cp]->lastread[info->number - 1] = messno;
        }
    }

    hdrlines = lines = show_hdr(mode,cp,&msg,messno,info,
                                ((flags & 1) == 0) +
                                (((flags & 1) != 0) * 8),
                                nummsgs);
    dputs(mode,cp,"\r\n");
    lines++;
    hdrlines++;

    if(flags & 1) {
        lines = 0;
        hdrlines = 0;
    }

    temp = get_text(cp,&hold,&msg,info->number,messno);
    if(temp != MSG_NOERR && temp != MSG_REDUCED) {
        if(hold)
          bbs_free(cp,hold);
        return -1;
    }

    *lastmsgid = 0;
    *lastreplyid = 0;

    if((p = strnistr(hold,"\01MSGID: ",1024)) != NULL) {
        p += 8;
        p = skip_white(p);
        strncpy(lastmsgid,p,132);
        lastmsgid[132] = 0;
        p = to_delim(lastmsgid,"\r");
        if(p) *p = 0;
        rstrip(lastmsgid);
    }
    if((p = strnistr(hold,"\01REPLY: ",1024)) != NULL) {
        p += 8;
        p = skip_white(p);
        strncpy(lastreplyid,p,132);
        lastreplyid[132] = 0;
        p = to_delim(lastreplyid,"\r");
        if(p) *p = 0;
        rstrip(lastreplyid);
    }

    if(!lpos)
      lpos = (char **)bbs_malloc(cp,sizeof(char *) * 2048);
    if(!lpos) {
        if(hold)
          bbs_free(cp,hold);
        return -1;
    }

    if(!ctla)
      strip_seenbys(hold);

    lpos[0] = hold;
    p = hold;

    if(!(flags & 1) && (user[cp]->attribs & U_COLOR))
        dputs(mode,cp,make_ansi(textcolor & 255,(textcolor << 8) & 255,color));

    for(;;) {

        if(user[cp]->offline < time(NULL) || checkcarrier(cp)) {
            ret = 0;
            goto QuitNow;
        }

        if(!*write_line(line,&p,(unsigned int)(user[cp]->width - 1),ctla)) {
            if(flags & 4) {
                ret = 1 + 128;
                goto QuitNow;
            }
            goto CoitusInterruptus;
        }

        if(*line == '\01' && !ctla)
            continue;

        if(!(flags & 1) && (user[cp]->attribs & U_ANSI) &&
           !(user[cp]->attribs & U_NOCLEAR))
            dprintf(mode,cp,"\x1b[%d;1H\x1b[K%s",lines + 1,line);
        else
            dprintf(mode,cp,"%s\r\n",line);

        if(!(flags & 1))
          lines++;
        if(lines > (int)user[cp]->length - 2 &&
           !(user[cp]->attribs & U_NOMORE)) {

CoitusInterruptus:

            if((user[cp]->attribs & U_ANSI) &&
               !(user[cp]->attribs & U_NOCLEAR)) {
                dputs(mode,cp,"\r\n\x1b[s");
                for(temp = lines + 1;temp < (int)user[cp]->length;temp++)
                  dprintf(mode,cp,"\x1b[%d;1H\x1b[K",temp);
                dputs(mode,cp,"\x1b[u");
            }

            if(page == 2047)
              page = 0;
            page++;
            lpos[page] = p;

ReAsk:

            {
                char prompt[64];
                char tppt[30];

                if(user[cp]->offline < time(NULL) || checkcarrier(cp)) {
                  ret = 0;
                  break;
                }

                DosSleep(0L);
                *prompt = 0;
                if(user[cp]->attribs & U_COLOR)
                  strcpy(prompt,MAKE_ANSI(promptcolor,color));
                if(user[cp]->attribs & U_ANSI)
                  strcat(prompt,"\x1b[K");
                else
                  strcat(prompt,"\r\n");
                if(!*p)
                  strcat(prompt,sayp(mode,cp,167,tppt,6));
                strcat(prompt,sayp(mode,cp,168,tppt,28));
                if(user[cp]->attribs & U_COLOR)
                    strcat(prompt,MAKE_ANSI(cmdcolor,color));

                temp = select_one(mode,cp,modems[cp]->afmsg,23,prompt,NULL,
                                  "AfterPage",((user[cp]->attribs & U_EXPERT) == 0) * 2 |
                                  ((user[cp]->attribs & U_NOROLL) == 0) * 4);
                temp++;
                switch(temp) {
                    case 1:     if(!*p) {                           /* next page */
                                    ret = 1;
                                    goto QuitNow;
                                }
                                break;

                    case 2:     if(page) {                          /* prev page */
                                    page--;
                                    if(page) {
                                        page--;
                                        p = lpos[page];
                                        break;
                                    }
                                }
                                ret = 2;
                                goto QuitNow;

PageOver:

                    case 3:     if(page)                            /* over */
                                  page--;
                                p = lpos[page];
                                hdrlines = lines = show_hdr(mode,cp,&msg,
                                                            messno,info,
                                                            ((flags & 1) == 0) + (((flags & 1) != 0) * 8),
                                                            nummsgs);
                                dputs(mode,cp,"\r\n");
                                lines++;
                                hdrlines++;
                                if(flags & 1)
                                  lines = 0;
                                break;

                    case 4:     ret = 3;                            /* stop */
                                goto QuitCRNow;

                    case 5:     if(msg_write_ok(user[cp],info)) {   /* reply */
                                    if(page)
                                      page--;
                                    p = lpos[page];
                                    break;
                                }
                                if(make_reply(mode,cp,&msg,NULL,user[cp],info,lastmsgid,messno,0)) {
                                    dputs(mode,cp,"\r\n");
                                    goto ReAsk;
                                }
                                else
                                  user[cp]->numposts++;
                                page = 0;
                                p = lpos[page];
                                goto PageOver;

                    case 6:     {                                   /* forward */
                                 unsigned int temp;

                                 if(!endthread)
                                  strcpy(threadby,lastmsgid);
                                 temp = thread(mode,cp,'F',messno,threadby,&msg,info);
                                 if(temp) {
                                    if(!endthread)
                                      endthread = messno;
                                    messno = temp;
                                    goto ReStart;
                                 }
                                }
                                sayp(mode,cp,169,NULL,0);
                                goto ReAsk;

                    case 7:     {                       /* backward */
                                 unsigned int temp;

                                 if(!endthread)
                                  strcpy(threadby,lastreplyid);
                                 temp = thread(mode,cp,'B',messno,threadby,&msg,info);
                                 if(temp) {
                                   if(!endthread)
                                     endthread = messno;
                                   messno = temp;
                                   goto ReStart;
                                 }
                                }
                                sayp(mode,cp,169,NULL,0);
                                goto ReAsk;

                    case 23:    ctla = 1 - ctla;        /* toggle ^a */
                                goto ReStart;

                    case 11:                            /* locate */
                    case 21:                            /* locate next */
                    case 22:                            /* locate prev */
                              {
                                int found = 0,sdir = 1,ask = 0,prompt = 0;

                                if(temp == 22)
                                  sdir = -1;
                                if(temp != 11) {
                                  for(x = 0;x < 10;x++) {
                                    if((user[cp]->from[x] &&
                                       (!x || user[cp]->from[x - 1])) ||
                                       (user[cp]->to[x] &&
                                       (!x || user[cp]->to[x - 1])) ||
                                       (user[cp]->body[x] &&
                                       (!x || user[cp]->body[x - 1])) ||
                                       (user[cp]->subj[x] &&
                                       (!x || user[cp]->subj[x - 1])))
                                      found = 1;
                                      break;
                                  }
                                }
                                if(!found || temp == 11) {
                                  prompt = 1;
                                 sayp(mode,cp,293,NULL,0);
                                 for(x = 0;x < 10;x++) {
                                  *input = 0;
                                  if(user[cp]->from[x])
                                    strcpy(input,user[cp]->from[x]);
                                  dprintf(mode,cp,"\r\n[%d]",x + 1);
                                  pinput_string(mode,cp,input,35,3,289,
                                                STRT_ALL,STRF_PRETTY,
                                                "Msg Locate--from",NULL);
                                  if(*input && (!user[cp]->from[x] ||
                                     stricmp(input,user[cp]->from[x]))) {
                                    if(user[cp]->from[x])
                                      bbs_free(cp,user[cp]->from[x]);
                                    user[cp]->from[x] =
                                      bbs_strdup(cp,input);
                                  }
                                  else if(!*input && user[cp]->from[x]) {
                                    bbs_free(cp,user[cp]->from[x]);
                                    user[cp]->from[x] = NULL;
                                  }
                                  if(!*input)
                                    break;
                                 }

                                 for(x = 0;x < 10;x++) {
                                  strset(input,0);
                                  if(user[cp]->to[x])
                                    strcpy(input,user[cp]->to[x]);
                                  dprintf(mode,cp,"\r\n[%d]",x + 1);
                                  pinput_string(mode,cp,input,35,3,290,
                                                STRT_ALL,STRF_PRETTY,
                                                "Msg Locate--to",NULL);
                                  if(*input && (!user[cp]->to[x] ||
                                     stricmp(input,user[cp]->to[x]))) {
                                    if(user[cp]->to[x])
                                      bbs_free(cp,user[cp]->to[x]);
                                    user[cp]->to[x] = bbs_strdup(cp,input);
                                  }
                                  else if(!*input && user[cp]->to[x]) {
                                    bbs_free(cp,user[cp]->to[x]);
                                    user[cp]->to[x] = NULL;
                                  }
                                  if(!*input)
                                    break;
                                 }

                                 for(x = 0;x < 10;x++) {
                                  strset(input,0);
                                  if(user[cp]->subj[x])
                                    strcpy(input,user[cp]->subj[x]);
                                  dprintf(mode,cp,"\r\n[%d]",x + 1);
                                  pinput_string(mode,cp,input,59,3,291,
                                                STRT_ALL,STRF_NEAT,
                                                "Msg Locate--subj",NULL);
                                  if(*input && (!user[cp]->subj[x] ||
                                     stricmp(input,user[cp]->subj[x]))) {
                                    if(user[cp]->subj[x])
                                      bbs_free(cp,user[cp]->subj[x]);
                                    user[cp]->subj[x] = bbs_strdup(cp,input);
                                  }
                                  else if(!*input && user[cp]->subj[x]) {
                                    bbs_free(cp,user[cp]->subj[x]);
                                    user[cp]->subj[x] = NULL;
                                  }
                                  if(!*input)
                                    break;
                                 }

                                 for(x = 0;x < 10;x++) {
                                  strset(input,0);
                                  if(user[cp]->body[x])
                                    strcpy(input,user[cp]->body[x]);
                                  dprintf(mode,cp,"\r\n[%d]",x + 1);
                                  pinput_string(mode,cp,input,70,3,292,
                                                STRT_ALL,STRF_NEAT,
                                                "Msg Locate--body",NULL);
                                  if(*input && (!user[cp]->body[x] ||
                                     stricmp(input,user[cp]->body[x]))) {
                                    if(user[cp]->body[x])
                                      bbs_free(cp,user[cp]->body[x]);
                                    user[cp]->body[x] = bbs_strdup(cp,input);
                                  }
                                  else if(!*input && user[cp]->body[x]) {
                                    bbs_free(cp,user[cp]->body[x]);
                                    user[cp]->body[x] = NULL;
                                  }
                                  if(!*input)
                                    break;
                                 }
                               }
                                for(x = 0;x < 10;x++) {
                                  if(!found && (user[cp]->from[x] &&
                                     (!x || user[cp]->from[x - 1])) ||
                                     (user[cp]->to[x] &&
                                     (!x || user[cp]->to[x - 1])) ||
                                     (user[cp]->body[x] &&
                                     (!x || user[cp]->body[x - 1])) ||
                                     (user[cp]->subj[x] &&
                                     (!x || user[cp]->subj[x - 1]))) {
                                    found = 1;
                                    if(temp == 11)
                                      break;
                                  }
                                  ask = (user[cp]->from[x] &&
                                        (!x || user[cp]->from[x - 1]));
                                  ask += (user[cp]->to[x] &&
                                         (!x || user[cp]->to[x - 1]));
                                  ask += (user[cp]->body[x] &&
                                         (!x || user[cp]->body[x - 1]));
                                  ask += (user[cp]->subj[x] &&
                                         (!x || user[cp]->subj[x - 1]));
                                  if(ask > 1)
                                    break;
                                }
                                if(found) {
                                  *input = 0;
                                  if(ask > 1 && prompt) {
                                    pinput_string(mode,cp,input,1,1,294,
                                                  STRT_YN,STRF_HOT,
                                                  "Msg Locate--all",NULL);
                                    if(*input == modems[cp]->NO)
                                      user[cp]->matchhow = 1;
                                    else
                                      user[cp]->matchhow = 0;
                                  }
                                  else
                                    user[cp]->matchhow = 0;
                                  dputs(mode,cp,"\r\n");
                                  tmessno = superthread(mode,cp,user[cp]->from,
                                                        user[cp]->to,
                                                        user[cp]->subj,
                                                        user[cp]->body,
                                                        NULL,NULL,sdir,
                                                        (user[cp]->matchhow * 2),
                                                        user[cp]->currmsgarea,
                                                        messno + sdir);
                                  dputs(mode,cp,"\r\n");
                                  if(tmessno) {
                                    if(!endthread)
                                      endthread = messno;
                                    messno = tmessno;
                                    goto ReStart;
                                  }
                                  else
                                   sayp(mode,cp,295,NULL,0);
                                }
                               }
                                goto ReAsk;

                    case 12:    ret = 8;                /* #msg */
                                goto QuitCRNow;

                    case 13:    if(endthread) {
                                    messno = endthread;
                                    endthread = 0;
                                    goto ReStart;
                                }
                                dputs(mode,cp,"\r\nNot threading\r\n");
                                goto ReAsk;

                    case 8:     if(!msg_sysop_ok(user[cp],info) || !mymsg(user[cp],&msg)) {  /* Kill */
                                    if(user[cp]->attribs & U_ANSI)
                                        dputs(mode,cp,"\r\x1b[K");
                                    else
                                      dputs(mode,cp,"\r\n");
                                    if(kill_msg(cp,&msg,info,messno)) {
                                        dputs(mode,cp,"Deleted");
                                        if((info->areaflags & M_NET) &&
                                           !(msg.xflags & MSGSCANNED) &&
                                           mymsg(user[cp],&msg))
                                            user[cp]->credit += (long)msg.cost;
                                        if(mymsg(user[cp],&msg))
                                          user[cp]->numposts++;
                                    }
                                    else {
                                        dputs(mode,cp,"Undeleted");
                                        if((info->areaflags & M_NET) &&
                                           !(msg.xflags & MSGSCANNED) &&
                                           mymsg(user[cp],&msg))
                                            user[cp]->credit -= (long)msg.cost;
                                        if(mymsg(user[cp],&msg) &&
                                           user[cp]->numposts)
                                          user[cp]->numposts--;
                                    }
                                    if(user[cp]->attribs & U_ANSI)
                                      DosSleep(500L);
                                }
                                if(user[cp]->attribs & U_ANSI)
                                    dputs(mode,cp,"\r\x1b[K");
                                else
                                  dputs(mode,cp,"\r\n");
                                goto ReAsk;

                    case 9:                                                     /* move/copy */
                    case 10:    if(!msg_sysop_ok(user[cp],info)) {

                                    MSGAREA *temparea = user[cp]->currmsgarea;
                                    int     temp;

                                    if(select_msg_area(mode,cp) &&
                                       user[cp]->currmsgarea != info) {
                                        if(msg_sysop_ok(user[cp],user[cp]->currmsgarea))
                                            dputs(mode,cp,"\r\nYou don't have sysop access to that area.\r\n");
                                        else {
                                            temp = copy_msg(cp,&msg,info,user[cp]->currmsgarea,messno,(temp == 10));
                                            if(temp == 0)
                                                dputs(mode,cp,"\r\nCopy/move succeeded.\r\n");
                                            else if(temp == -1)
                                                dputs(mode,cp,"\r\nCopy/move failed.\r\n");
                                            else {
                                                if(temp == -2)
                                                    dputs(mode,cp,"\r\nCopy/move succeeded, but can't reread original...\r\n");
                                                else
                                                    dputs(mode,cp,"\r\nAll screwed up.\r\n");
                                                if(hold)
                                                  bbs_free(cp,hold);
                                                if(lpos)
                                                  bbs_free(cp,lpos);
                                                user[cp]->currmsgarea = temparea;
                                                return -1;
                                            }
                                        }
                                    }
                                    user[cp]->currmsgarea = temparea;
                                    if(temparea)
                                      user[cp]->lastmsgarea = temparea->number;
                                    DosSleep(1000L);
                                }
                                show_hdr(mode,cp,&msg,messno,info,1,nummsgs);
                                dputs(mode,cp,"\r\n");
                                if(page)
                                  page--;
                                p = lpos[page];
                                break;

                    case 14:    if(!descravailable) {   /* area description */
                                    dputs(mode,cp,"\rNo description available for this area.");
                                    DosSleep(1500L);
                                    goto ReAsk;
                                }
                                sprintf(line,"MSG/DESCR.%03x",info->number);
                                if(bbs->attribs & B_ANSINEWS) {
                                    readansi(mode,cp,line,NULL,7);
                                    hitreturn(mode,cp);
                                }
                                else
                                  readtext(mode,cp,line);
                                goto PageOver;

                    case 15:    if(!rulesavailable) {   /* area rules */
                                    dputs(mode,cp,"\rNo rules available for this area.");
                                    DosSleep(1500L);
                                    goto ReAsk;
                                }
                                sprintf(line,"MSG/RULES.%03x",info->number);
                                if(bbs->attribs & B_ANSINEWS)
                                  readansi(mode,cp,line,NULL,3);
                                else
                                  readtext(mode,cp,line);
                                goto PageOver;

                    case 16:    page = 0;               /* home */
                                p = lpos[page];
                                goto PageOver;

                    case 17:    if(!modems[cp]->curbaud || msg_write_ok(user[cp],info)) {   /* upload msg */
                                  goto PageOver;
                                }

                                dputs(mode,cp,"\r\nReady to receive message text.\r\nEngage Sealink/XModem SEND mode or send a few CTRL-Xs to abort.\r\n");
                                sprintf(line,"./MSGTMP.%03x",cp);
                                unlink(line);
                                {
                                    char *got = NULL;
                                    struct stat st;

                                    got = recv_file(cp,line,0,NULL);
                                    if(got && !strnicmp(got,";Aborted",9)) { /* Aborted transfer */
                                        logfunc(0,cp,"Upload of msg %s",&got[1]);
                                        free(got);
                                        got = NULL;
                                    }
                                    else if(got && !stat(got,&st)) {  /* got an upload? */
                                        rename(got,line);
                                        free(got);
                                        got = NULL;
                                        if(!write_msg(mode,cp,user[cp]->currmsgarea,NULL,NULL,0)) {
                                          user[cp]->numposts++;
                                        }
                                    }
                                    if(got)
                                      free(got);
                                }
                                page = 0;
                                p = lpos[page];
                                goto PageOver;


                    case 18:    ret = 10;               /* scan */
                                goto QuitNow;

                    case 19:    if(msg.fflags & MSGLOCAL && (!(msg.xflags & MSGANON) || msg_sysop_ok(user[cp],info))) {
                                    list_users(mode,cp,msg.from,0);
                                    dputs(mode,cp,"\r\n");
                                    hitreturn(mode,cp);
                                }
                                else {
                                    dputs(mode,cp,"\r\nCan't look up a remote or anonymous users.\r\n");
                                    DosSleep(2000L);
                                }
                                break;

                    case 20:    flags |= 5;             /* nonstop */
                                if(user[cp]->attribs & U_COLOR)
                                  dputs(mode,cp,"\x1b[0m");
                                dputs(mode,cp,"\r\n");
                                goto ReStart;

                    default:    if(user[cp]->attribs & U_ANSI) {
                                    dputs(mode,cp,"\r\x1b[K **Not yet implemented.");
                                    DosSleep(2000L);
                                    dputs(mode,cp,"\r\x1b[K");
                                }
                                else
                                    dputs(mode,cp,"\r\nNot implemented yet.\r\n");
                                goto ReAsk;
                }
            }

            if(!(flags & 1) && !(user[cp]->attribs & U_ANSI) &&
               !(user[cp]->attribs & U_NOCLEAR)) {
                dprintf(mode,cp,"\r\nArea #%u ** Msg# %u of %u ** Pg#%u\r\n",
                        info->number,messno,nummsgs,page + 1);
                lines = 2;
            }
            else if(!(flags & 1)) {
                lines = hdrlines;
                if(!(user[cp]->attribs & U_NOCLEAR)) {
                  if(user[cp]->attribs & U_COLOR) {
                      dputs(mode,cp,MAKE_ANSI(hdrcolor,color));
                  }
                  dprintf(mode,cp,"\r\x1b[K\x1b[s\x1b[1;73H#%u\x1b[u",page + 1);
                }
                if(user[cp]->attribs & U_COLOR) {
                    dputs(mode,cp,MAKE_ANSI(textcolor,color));
                }
            }
            if(user[cp]->attribs & U_NOCLEAR) {
              if(user[cp]->attribs & U_ANSI)
                dputs(mode,cp,"\r\x1b[K");
              else
                dputs(mode,cp,"\r\n");
            }
        }
        else {
            temp = inkey(mode,cp);
            if(temp) {
                temp = toupper(temp);
                switch(temp) {
                    case 'A':   ret = 3;
                                if((user[cp]->attribs & U_ANSI) &&
                                   !(user[cp]->attribs & U_NOCLEAR)) {
                                    dputs(mode,cp,"\r\n\x1b[s");
                                    for(temp = lines + 1;temp < (int)user[cp]->length;temp++) {
                                        dprintf(mode,cp,"\x1b[%d;1H\x1b[K",temp);
                                    }
                                    dputs(mode,cp,"\x1b[u");
                                }
                                goto QuitNow;

                    case 'N':   ret = 1;
                                if((user[cp]->attribs & U_ANSI) &&
                                   !(user[cp]->attribs & U_NOCLEAR)) {
                                    dputs(mode,cp,"\r\n\x1b[s");
                                    for(temp = lines + 1;temp < (int)user[cp]->length;temp++) {
                                        dprintf(mode,cp,"\x1b[%d;1H\x1b[K",temp);
                                    }
                                    dputs(mode,cp,"\x1b[u");
                                }
                                goto QuitNow;

                    case CTRL_S:
                    case 'P':   ret = 2;
                                if((user[cp]->attribs & U_ANSI) &&
                                   !(user[cp]->attribs & U_NOCLEAR)) {
                                    dputs(mode,cp,"\r\n\x1b[s");
                                    for(temp = lines + 1;temp < (int)user[cp]->length;temp++) {
                                        dprintf(mode,cp,"\x1b[%d;1H\x1b[K",temp);
                                    }
                                    dputs(mode,cp,"\x1b[u");
                                }
                                goto QuitNow;

                }
            }
        }
    }

QuitCRNow:

    dputs(mode,cp,"\r\n");

QuitNow:

    if(hold)
      bbs_free(cp,hold);
    if(lpos)
      bbs_free(cp,lpos);
    return ret;
}



int _fastcall show_hdr (int mode,USHORT cp,XMSG *msg,word messno,
                        MSGAREA *info,unsigned int flags,word nomess) {

    /* flag bitmapped values:
        1: clear screen
        2: qscan header
        4: scan header
        8: no color
    */

    int lines = 0,temp = 0;
    static int hdrcolor = 15,hdrback = 7;
    char color[13],*anon;

    if(info || messno) {
        if(!(user[cp]->attribs & U_NOCLEAR) && (flags & 1)) {
            if(!(user[cp]->attribs & U_ANSI)) {
                dputs(mode,cp,"\xc\b \r\n");
                lines++;
            }
            else {
                dputs(mode,cp,"\x1b[2J");
            }
        }
        else {
            dputs(mode,cp,"\r\n");
            lines++;
        }

        if(!(flags & 8) && (user[cp]->attribs & U_COLOR)) {
            dputs(mode,cp,MAKE_ANSI(hdrback,color));
        }

        if(!(flags & 2) && !(flags & 4)) {
            if(info)
              temp += dprintf(mode,cp,"Area #%u \"%0.66s\"",info->number,info->name);
            if(messno)
              temp += dprintf(mode,cp," Msg #%u of %u",messno,nomess);
            if(temp > (int)user[cp]->width)
              lines++;
            if(temp != (int)user[cp]->width)
              dputs(mode,cp,"\r\n");
            lines++;
        }
        else dprintf(mode,cp,"%5u. ",messno);
    }

    if(!(flags & 2)) {
        dputs(mode,cp,"Fm: ");
    }

    if((msg->xflags & MSGANON) && !msg_sysop_ok(user[cp],info)) {
        anon = "%Anonymous%";
    }
    else anon = msg->from;

    if(!(flags & 8) && (user[cp]->attribs & U_COLOR)) {
        dputs(mode,cp,MAKE_ANSI(hdrcolor,color));
    }

    if(!(flags & 2) && !(flags & 4)) {
        dputs(mode,cp,anon);
    }
    else if(flags & 2) {
        dprintf(mode,cp,"%-20.20s",anon);
    }
    else if(flags & 4) {
        dprintf(mode,cp,"%-35.35s",anon);
    }

    if(!(flags & 2)) {
        if(!(flags & 8) && (user[cp]->attribs & U_COLOR)) {
            dputs(mode,cp,MAKE_ANSI(hdrback,color));
        }
        dputs(mode,cp,"  To: ");
        if(!(flags & 8) && (user[cp]->attribs & U_COLOR)) {
            dputs(mode,cp,MAKE_ANSI(hdrcolor,color));
        }
    }

    if(!(flags & 2) && !(flags & 4)) {
        dputs(mode,cp,msg->to);
        if(!(flags & 8) && (user[cp]->attribs & U_COLOR)) {
            dputs(mode,cp,MAKE_ANSI(hdrback,color));
        }
    }
    else if(flags & 2) {
        dprintf(mode,cp,"  %-20.20s  %-0.28s",msg->to,msg->subj);;
        return lines;
    }
    else if(flags & 4) {
        dprintf(mode,cp,"%s",msg->to);
    }

    if(!(msg->xflags & MSGANON) || !msg_sysop_ok(user[cp],info)) {
        dprintf(mode,cp,"\r\n%-19.19s | ",msg->date);
    }
    else dprintf(mode,cp,"\r\n%-9.9s           | ",msg->date);

    if(msg->fflags & MSGPRIVATE) dputs(mode,cp,"P");
    if(msg->fflags & MSGREAD) dputs(mode,cp,"R");
    else if(mymsg(user[cp],msg)) dputs(mode,cp,"!");
    if(msg->xflags & MSGDELETED) dputs(mode,cp,"D");
    if(msg->xflags & MSGNET) dputs(mode,cp,"N");
    if(msg->xflags & MSGECHO) dputs(mode,cp,"E");
    if(msg->xflags & MSGKEEP) dputs(mode,cp,"+");
    if(info->areaflags & M_NET) {
        if(msg->fflags & MSGFILE) dputs(mode,cp,"A");
        if(msg->fflags & MSGRRQ) dputs(mode,cp,"Q");
        if(msg->fflags & MSGURQ) dputs(mode,cp,"U");
        if(msg->fflags & MSGKILL) dputs(mode,cp,"K");
        if(msg->fflags & MSGCRASH) dputs(mode,cp,"C");
        if(msg->fflags & MSGSENT) dputs(mode,cp,"S");
        if(msg->xflags & MSGHOST) dputs(mode,cp,"H");
        if(msg->xflags & MSGHOLD) dputs(mode,cp,"h");
        if(msg->xflags & MSGANON) dputs(mode,cp,"a");
        dprintf(mode,cp," | %u:%u/%u.%u->%u:%u/%u.%u",msg->o_zone,msg->o_net,
                msg->o_node,msg->o_point,msg->d_zone,msg->d_net,msg->d_node,
                msg->d_point);
        if((msg->fflags & MSGFILE) || (msg->fflags & MSGRRQ) || (msg->fflags & MSGURQ)) {
            dputs(mode,cp,"\r\nFile: ");
        }
        else dputs(mode,cp,"\r\nSubj: ");
    }
    else dputs(mode,cp,"\r\nSubj: ");
    if(!(flags & 8) && (user[cp]->attribs & U_COLOR)) {
        dputs(mode,cp,MAKE_ANSI(hdrcolor,color));
    }
    dputs(mode,cp,msg->subj);
    dputs(mode,cp,"\r\n");
    lines += 3;

    return lines;
}




word scan_msgs (int mode,USHORT cp,MSGAREA *info,word messno,
                       unsigned int flags) {

    /* flags bitmapped values:
        1:  ignore linecounter (no paging)
        2:  qscan
        4:  scan
        8:  give "#" prompt
        16: just show one

       returns:
         0:     Stop or error; stop either way...
         other: Read from this message #
    */

    XMSG       msg;
    int        lines = 0;
    word       temp = MSG_NOERR,ntemp,nummsgs;
    char       input[7],*prompt = "\r\n   More? (Y/n): ";


    if(!info || !info->number || info->number > 512)
      return 0;
    if(flags & 8) {
      prompt[3] = '#';
      prompt[4] = '/';
    }
    memset(&msg,0,sizeof(XMSG));
     nummsgs = how_many_msgs(info);

    if(flags & 2) {
        if(!(flags & 1) && (user[cp]->attribs & U_COLOR))
          dputs(mode,cp,"\x1b[0m");
        dputs(mode,cp,"\r\n#      From                  To                    Subj");
        dputs(mode,cp,"\r\n-----  --------------------  --------------------  ----------------------------");
    }

    for(;;) {
        if(user[cp]->offline < time(NULL) || checkcarrier(cp))
          break;
        if(temp == MSG_BADNUM)
          break;
        temp = get_messu(cp,&msg,info->number,messno,user[cp]);
        if(temp != MSG_NOERR) {
            if(temp == MSG_ISPRIVATE) {
              dprintf(mode,cp,"\r\n%5u. Private",messno++);
              lines++;
              continue;
            }
            else if(temp == MSG_ISDELETED) {
              dprintf(mode,cp,"\r\n%5u. Deleted",messno++);
              lines++;
              continue;
            }
            else if(temp == MSG_BADNUM) {
              if(lines != 0) goto Decide;
            }
            break;
        }

        lines += show_hdr(mode,cp,&msg,messno,info,
                          (flags & 6) + (((flags & 1) != 0) * 8),nummsgs);
        if(flags & 1)
          lines = 0;
        if(lines > (int)user[cp]->length - 4 && !(user[cp]->attribs & U_NOMORE)) {

Decide:

            if(!(flags & 1) && (user[cp]->attribs & U_COLOR)) dputs(mode,cp,"\x1b[0m");
            messno++;
            if(messno > how_many_msgs(info))
              prompt[2] = '*';
            else
              prompt[2] = ' ';
            strset(input,0);
            input_string(mode,cp,input,5,1,prompt,
                         STRT_ALPHANUMERIC,STRF_UCASE,"Scan Page",NULL);
            lstrip(input);
            ntemp = atoi(input);
            if(!ntemp || !(flags & 8)) {
                if(*input == 'N')
                  break;
                else {
                    if(messno > how_many_msgs(info))
                      break;
                    lines = 0;
                    if(flags & 2) {
                        if(!(flags & 1) && (user[cp]->attribs & U_COLOR)) dputs(mode,cp,"\x1b[0m");
                        dputs(mode,cp,"\r#      From                  To                    Subj");
                        dputs(mode,cp,"\r\n-----  --------------------  --------------------  ----------------------------");
                    }
                }
            }
            else {
                dputs(mode,cp,"\r\n");
                return ntemp;
            }
        }

        else
          messno++;
    }

    return 0;
}
