/* background msg-to-qwkfile export thread */

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"
#include "xmsg.h"

    extern MDM     *modems[MAXINSTANCES];
    extern USER    *user[MAXINSTANCES];
    extern BBS     *bbs;
    extern MSGAREA *msgareas;
    extern int     *_threadid;
    extern ADDR    *addresses;




void TXT_export (void *ccp) {

    /* exports msgs into QWK format in background */

    USHORT  cp = *((USHORT *)ccp),messno,c;
    USER    u;
    MSGAREA *info;
    XMSG    msg;
    char    *hold,*p,line[133];
    int     temp,handle,handle2,areanums = 0;
    int     mode = (((modems[cp]->curbaud != 0) * D_REMOTE) + D_LOCAL);
    struct stat st;
    long    wherenum;


    DosEnterCritSec();
      if(!user[cp]) {
        DosExitCritSec();
        _endthread();
      }
      if(DosSemRequest(&modems[cp]->amexportingSEM,0L)) {
          dputs(mode,cp,"\r\nAn export is already in progress; try again after it finishes.\r\n");
          DosExitCritSec();
          _endthread();
      }
      sprintf(line,"%s/%08lx.QWK",d_xport,user[cp]->userid);
      if(!stat(line,&st)) {
        if(st.st_size) {
            dputs(mode,cp,"\r\nYou already have a packet waiting; download it first\r\n");
            DosSemSet(&modems[cp]->amdonexportingSEM); /* let BBS thread know it's done */
            DosSemClear(&modems[cp]->amexportingSEM);
            DosExitCritSec();
            _endthread();
        }
        else unlink(line);
      }
      memcpy(&u,user[cp],sizeof(USER));
      u.lastread = (unsigned int *)malloc(LASTREADSIZE * sizeof(unsigned int));
      if(!u.lastread) {
        dputs(mode,cp,"\r\nExport aborted; I'm out of memory\r\n");
        DosSemClear(&modems[cp]->amexportingSEM);
        DosExitCritSec();
        _endthread();
      }
      memcpy(u.lastread,user[cp]->lastread,LASTREADSIZE * sizeof(unsigned int));
    DosExitCritSec();

    /* find first available area */

    info = next_xport_area(msgareas,&u,0);
    if(!info) {
        free(u.lastread);
        DosSemClear(&modems[cp]->amexportingSEM);
        _endthread();
    }

    /* open export file */

    sprintf(line,"%s/%08lx.MDT",d_xport,u.userid);
    unlink(line);
    handle = sopen(line,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT,SH_DENYWR,S_IWRITE);
    if(handle == -1) {
        free(u.lastread);
        DosSemClear(&modems[cp]->amexportingSEM);
        _endthread();
    }

    /* open BBS ID file */

    sprintf(line,"%s/%08lx.CDT",d_xport,u.userid);
    unlink(line);
    handle2 = sopen(line,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT,SH_DENYWR,S_IWRITE);
    if(handle2 == -1) {
        free(u.lastread);
        close(handle);
        sprintf(line,"%s/%08lx.MDT",d_xport,u.userid);
        unlink(line);
        DosSemClear(&modems[cp]->amexportingSEM);
        _endthread();
    }
    else {

        ADDR  *addr;
        time_t t;
        char   s[21];

        ffprintf(handle2,"%s\r\nSomewhere, ??\r\n",bbs->bbs_name);
        ffprintf(handle2,"123-456-7890\xe3%s\r\n",bbs->sysop);
        ffprintf(handle2,"00000,XBBS\r\n");
        t = time(NULL);
        strftime(s,18,"%m-%d-%y,%H:%M:%S",localtime(&t));
        ffprintf(handle2,"%s\r\n%s\r\n\r\n0\r\n0\r\n",s,u->name);
        wherenum = tell(handle2);
        ffprintf(handle2,"000\r\n");
    }

    /* set priority before beginning actual work */

    logfunc(0,cp,"QWK export thread working");
    DosSetPrty(2,modems[cp]->export[0],modems[cp]->export[1],*_threadid);

    /* do the export */

    while(info) {

        ffprintf(handle2,"#%u\r\n%-0.10s\r\n",info->number - 1,info->name);
        areanums++;

        messno = how_many_msgs(info);
        if(u.lastread[info->number - 1] > messno) {
           if(messno)
             u.lastread[info->number - 1] = messno;
        }

        for(c = u.lastread[info->number - 1] + 1;c < messno + 1;c++) {

            /* get header */

            memset(&msg,0,sizeof(XMSG));
            temp = get_mess((USHORT)-1,&msg,info->number,c);
            if(temp != MSG_NOERR) continue;
            if(msg.fflags & MSGPRIVATE) {
                if(mymsg(&u,&msg) && msg_sysop_ok(&u,info)) continue;
            }
            if(msg.xflags & MSGDELETED && msg_sysop_ok(&u,info)) continue;

            /* get text */

            temp = get_text((USHORT)-1,&hold,&msg,info->number,c);
            if(temp != MSG_NOERR && temp != MSG_REDUCED) {
                if(hold) free(hold);
                continue;
            }

            /* write header */

            ffprintf(handle,"Area \"%s\"\xe3",info->name);
            ffprintf(handle,"From: ");
            if((msg.xflags & MSGANON) && !msg_sysop_ok(&u,info)) {
                ffprintf(handle,"%%Anonymous%%\xe3");
            }
            else ffprintf(handle,"%s\xe3",msg.from);
            ffprintf(handle,"To:   %s\xe3",msg.to);
            if(!(msg.xflags & MSGANON) || !msg_sysop_ok(&u,info)) {
                ffprintf(handle,"Date: %-0.19s\xe3Attr: ",msg.date);
            }
            else ffprintf(handle,"Date: %-0.9s\xe3Attr: ",msg.date);
            temp = 0;
            if(msg.fflags & MSGPRIVATE) temp += write(handle,"P",1);
            if(msg.fflags & MSGREAD) temp += write(handle,"R",1);
            else if(mymsg(&u,&msg)) temp += write(handle,"!",1);
            if(msg.xflags & MSGDELETED) temp += write(handle,"D",1);
            if(msg.xflags & MSGNET) temp += write(handle,"N",1);
            if(msg.xflags & MSGECHO) temp += write(handle,"E",1);
            if(msg.xflags & MSGKEEP) temp += write(handle,"+",1);
            if(info->areaflags & M_NET) {
                if(msg.fflags & MSGFILE) temp += write(handle,"A",1);
                if(msg.fflags & MSGRRQ) temp += write(handle,"Q",1);
                if(msg.fflags & MSGURQ) temp += write(handle,"U",1);
                if(msg.fflags & MSGKILL) temp += write(handle,"K",1);
                if(msg.fflags & MSGCRASH) temp += write(handle,"C",1);
                if(msg.fflags & MSGSENT) temp += write(handle,"S",1);
                if(msg.xflags & MSGHOST) temp += write(handle,"H",1);
                if(msg.xflags & MSGHOLD) temp += write(handle,"h",1);
                if(msg.xflags & MSGANON) temp += write(handle,"a",1);
                if(!temp) write(handle,"<none>",6);
                ffprintf(handle,"\xe3Net:  %u:%u/%u.%u.%u -> %u/%u.%u.%u",msg.o_zone,
                         msg.o_net,msg.o_node,msg.o_point,msg.d_zone,msg.d_net,
                         msg.d_node,msg.d_point);
                if((msg.fflags & MSGFILE) || (msg.fflags & MSGRRQ) || (msg.fflags & MSGURQ)) {
                    ffprintf(handle,"\xe3File: %s\xe3",msg.subj);
                }
                else ffprintf(handle,"\xe3Subj: %s\xe3",msg.subj);
            }
            else {
                if(!temp) write(handle,"<none>",6);
                ffprintf(handle,"\xe3Subj: %s\xe3",msg.subj);
            }

            /* write kludge lines into header */

            p = hold;
            strip_seenbys(hold);

            for(;;) {
                if(!*write_line(line,&p,(unsigned int)(u.width - 1),1)) break;
                if(*line == '\01') {
                    if(line[1]) {
                        ffprintf(handle,"%s\xe3",&line[1]);
                    }
                }
                continue;
            }

            write(handle,"\xe3",1);   /* end-of-header marker */
            DosSleep(0L);   /* brief snooze */

            /* write text */

            p = hold;

            for(;;) {
                if(!*write_line(line,&p,(unsigned int)(u.width - 1),0)) break;
                if(*line == '\01') {
                    continue;
                }
                if(!*line) write(handle," \xe3",2);     /* "fold" */
                else ffprintf(handle,"%s\xe3",line);
            }
            write(handle,"\xe3",1); /* end-of-text marker */

            if(hold)
              free(hold);

            if(c == messno)
              messno = how_many_msgs(info);
            DosSleep(1L);
            if(bbs->maxuserpkt && tell(handle) > bbs->maxuserpkt)
              break;
        }
        if(messno)
          u.lastread[info->number - 1] = messno;
        DosSleep(1L);
        DosBufReset(handle);
        if(bbs->maxuserpkt && tell(handle) > bbs->maxuserpkt)
          break;
        info = next_xport_area(info,&u,1);
    }

    if(filelength(handle) == 0L) {
        close(handle);
        close(handle2);
        sprintf(line,"%s/%08lx.MDT",d_xport,u.userid);
        unlink(line);
        sprintf(line,"%s/%08lx.CDT",d_xport,u.userid);
        unlink(line);
        goto BailOut;
    }

    lseek(handle2,wherenum,SEEK_SET);
    ffprintf(handle2,"%-03u",areanums);

    close(handle);
    close(handle2);

    /* update lastread */

    DosEnterCritSec();
      if(user[cp] && user[cp]->number == u.number) {
        memcpy(user[cp]->lastread,u.lastread,LASTREADSIZE * sizeof(unsigned int));
      }
      save_lastread((USHORT)-1,u.lastread,u.number);
    DosExitCritSec();

    /* archive files */

    forkf(D_LOCAL,-1,0,"%s /C PKZIP.EXE -m %s/%08lx.QWK ./XPORT/MESSAGES.DAT ./XPORT/CONTROL.DAT ./XPORT/*.NDX 1>NUL 2>NUL",
            getenv("COMSPEC"),d_xport,u.userid);

BailOut:

    free(u.lastread);

    DosSemSet(&modems[cp]->amdonexportingSEM); /* let BBS thread know it's done */
    DosSemClear(&modems[cp]->amexportingSEM);
}



size_t qwkwritehdr (int fp,QWKHDR *hdr,int rep) {

    /* encode and write awful QWK message header
     * if rep != 0 then header is for reply packet
     */

    QWKHDRREADER h;


    h.status  = hdr->status;
    if(!rep) sprintf(h.msgnum,"%-7ld",hdr->msgnum);
    else sprintf(h.msgnum,"%-7d",hdr->confnum - 1); /* zero based again */
    strftime(h.date,13,"%m/%d/%y%H:%M",localtime(&hdr->date));
    sprintf(h.to,"%-25.25s",hdr->to);
    sprintf(h.from,"%-25.25s",hdr->from);
    sprintf(h.subj,"%-25.25s",hdr->subj);
    sprintf(h.pword,"%-12.12s",hdr->pword);
    sprintf(h.repnum,"%-8ld",hdr->repnum);
    sprintf(h.numchunks,"%-6ld",hdr->numchunks + 1); /* add one for header */
    if(hdr->live) h.live = 0xe1;
    else h.live = 0xe2;
    h.confnum = hdr->confnum - 1;   /* zero based again */
    if(write(fp,&h,QWKBLKSIZE) != QWKBLKSIZE) return 0;
    return 1;
}

