#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mailer.h"
#include "bbs.h"
#include "nodelist.h"
#include "xmisc.h"



/*  Implemented 5-D packet header per FSC-0045.  Hopefully Thom's voice
    is strong enough to get most everyone to implement this. */


    extern ADDR *addresses;
    extern MDM  *modems[MAXINSTANCES];
    extern BBS  *bbs;



int _fastcall who_is_it (USHORT cp,char **got,char *s,
                         ADDR *addr,int didsend) {

    int               handle,notlisted = 0;
    PKTHDR            pkt;
    OLDPKTHDR         *opkt;
    NODEINFO          nif;


    opkt = (OLDPKTHDR *)&pkt;
    modems[cp]->hisprodcode = 0;

    memset(&nif,0,sizeof(NODEINFO));
    if(!didsend) {
      memset(addr,0,sizeof(ADDR));
    }
    else unlock_out(addr);  /* in case address 'changes' */
    addr->next = NULL;

    handle = sopen(*got,O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(handle != -1) {
      read(handle,&pkt,sizeof(PKTHDR));

      if(pkt.subver != 2) {      /* not FSC-0045 packet */
                                 /* let's do some wild guesswork */
        addr->zone=opkt->qm_orig_zone;
        if(!addr->zone) addr->zone = opkt->orig_zone;
        addr->point=opkt->orig_point;
        strncpy(addr->domain,opkt->domain,8);
        addr->domain[8] = 0;
      }

      else {                      /* how nice, we can tell who it is */
        addr->zone = pkt.ozone;
        addr->point = pkt.opoint;
        strncpy(addr->domain,pkt.odomain,8);
        addr->domain[8] = 0;
      }

      addr->net = nif.net = pkt.onet;           /* these are always right */
      addr->node = nif.node = pkt.onode;

      if(!addr->zone || !*addr->domain) {
        guess_rest(addr,addresses);
      }

      if(!get_node_from_list(&nif,addr->zone,addr->point,addr->domain)) {
        *nif.name = 0;
        notlisted++;
        modems[cp]->whichin = 2;    /* unlisted node */
      }

      modems[cp]->hisprodcode = pkt.product;

      logfunc(0,cp,"Remote: %s#%u:%u/%u.%u (%s)",addr->domain,addr->zone,
              nif.net,nif.node,addr->point,nif.name);

      /* Kill short packets */
      if(filelength(handle) < 61L || (filelength(handle) == 128L && pkt.first == 0)) {
        close(handle);
      }
      else close(handle);

      if(!notlisted) {    /* check password */
        if(*nif.password) {
          if(strnicmp(pkt.password,nif.password,8)) {
            logfunc(0,cp,"Password mismatch:  Us: \"%-0.8s\"  Them: \"%-0.8s\"",nif.password,pkt.password);
            return 0;
          }
          modems[cp]->whichin = 0;    /* passworded connect */
        }
        else modems[cp]->whichin = 1;   /* unpassworded connect to listed node */
      }

      if(stricmp(bbs->inbound[0],bbs->inbound[modems[cp]->whichin])) {
      /* move file from outbound 0 to appropriate outbound */

        char *p;

        while((p = strchr(*got,'\\')) != NULL) *p = '/';
        p = strrchr(*got,'/');
        if(!p) p = strrchr(*got,':');
        if(!p) p = *got;
        else p++;
        s = malloc(strlen(p) + strlen(bbs->inbound[modems[cp]->whichin]) + 2);
        if(s) {
          sprintf(s,"%s/%s",bbs->inbound[modems[cp]->whichin],p);
          DosMove(*got,s,0L);
          free(*got);
          *got = s;
        }
      }
      return 1;
    }
    return -1;
}
