#include <limits.h>
#include <io.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <share.h>
#include <errno.h>
#include <ctype.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"
#include "xmsg.h"


    extern MDM  *modems[MAXINSTANCES];
    extern USER *user[MAXINSTANCES];



void _fastcall strip_seenbys (char *hold) {

    char  *path =   NULL;
    char  *seenby = NULL;
    char  *origin = NULL;
    char  *p;


    origin = strstr(hold,"\r * Origin:");

    if (origin) {
        while((p = (strstr(&origin[1],"\r * Origin:"))) != NULL) origin = p;
        path = strstr(origin,"\r\01PATH:");
        seenby = strstr(origin,"\rSEEN-BY:");
        if (!seenby) seenby = strstr(origin,"\r\01SEEN-BY:");
        if (!path) if (seenby) *seenby = 0;
        if (seenby && path) memmove(seenby,path,strlen(path)+1);
    }
}



int _fastcall isbrktquote (char *line) {

    register char *p;
    register int x = 0;


    p = line;
    while(*p && x < 7) {  /* Is there a > in the first 7 chars? */
        if(*p == '<') return 0;   /* Maybe <grin> */
        if(*p == '>') return 1;   /* Yep */
        p++;
        x++;
    }
    return 0;   /* Nope */
}



void _fastcall do_recpt (int mode, USHORT cp,unsigned int messno,
                         MSGAREA *info,XMSG *omsg) {

  /* Handle MSGRRQ (return recpt request) bit */

  time_t t;
  struct tm tt;


  if(omsg->fflags & MSGRRQ) {
    if (!(info->areaflags & M_ECHO)) {
        dprintf(mode,cp,"\r\nReturn Receipt Requested...shall I send one? (y/N) ");
        if(toupper(wait_inkey(mode,cp))=='Y') {

            XMSG msg;
            char msgtext[161];

            memcpy(&msg,omsg,sizeof(struct _xmsg));
            msg.fflags = MSGCPT | MSGLOCAL | MSGKILL | MSGPRIVATE;
            if(info->areaflags & M_NET) msg.xflags = MSGNET;
            else msg.xflags = 0L;
            strncpy(msg.to,msg.from,36);
            msg.to[35] = 0;
            strncpy(msg.from,user[cp]->name,36);
            msg.from[35] = 0;
            t = time(NULL);
            memcpy(&tt,localtime(&t),sizeof(struct tm));
            msg.indate[0] = (char)(tt.tm_year - 89);
            msg.indate[1] = (char)(tt.tm_mon + 1);
            msg.indate[2] = (char)tt.tm_mday;
            msg.indate[3] = 0;
            msg.d_zone = msg.o_zone;
            msg.d_node = msg.o_node;
            msg.d_point = msg.o_point;
            msg.d_net = msg.o_net;
            msg.o_zone = info->addr->zone;
            msg.o_node = info->addr->node;
            msg.o_net = info->addr->net;
            msg.o_point = info->addr->point;
            t = time(NULL);
            sprintf(msgtext,
                    "\rMsg \"%s\" was received %u/%02hu/%02hu and read %s.\r",
                    omsg->subj,(int)omsg->indate[0] + 1989,
                    omsg->indate[1],omsg->indate[2],ctime(&t));
            post_message(cp,&msg,(char **)&msgtext,info->number,0);
        }

        omsg->fflags &= (~MSGRRQ);
        put_mess(cp,omsg,info->number,messno);
    }
  }
}
