#include <io.h>
#include <process.h>
#include <share.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"


    extern MDM *modems[MAXINSTANCES];



unsigned int * _fastcall load_lastread (USHORT cp,unsigned int usernumber) {

    unsigned int *lmrs;
    int          handle;


    lmrs = (unsigned int *)bbs_malloc(cp,LASTREADSIZE * sizeof(unsigned int));
    if(!lmrs) {
        sayp(D_LOCAL,cp,247,NULL,0);
        DosSemClear(&modems[cp]->bbsrunningSEM);
        _endthread();
    }
    memset(lmrs,0,sizeof(unsigned int) * LASTREADSIZE);

    handle = bbs_sopen(cp,"MSG/LASTREAD.BB2",O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(handle == -1) {
        logfunc(0,cp,"Couldn't open lastread file: %d",errno);
        return lmrs;
    }

    if(filelength(handle) < (long)((LASTREADSIZE * sizeof(unsigned int)) * (usernumber - 1))) {
        logfunc(0,cp,"Lastreads not available for user #%u",usernumber);
        bbs_close(cp,handle);
        return lmrs;
    }

    if(lseek(handle,(long)(((long)LASTREADSIZE * (long)sizeof(unsigned int)) * ((long)usernumber - 1L)),SEEK_SET) != -1L) {
        if(read(handle,lmrs,LASTREADSIZE * sizeof(unsigned int)) == -1) {
            logfunc(0,cp,"Error reading lastread: %d",errno);
        }
    }

    bbs_close(cp,handle);

    return lmrs;
}




void _fastcall save_lastread (USHORT cp,unsigned int *lmrs,
                              unsigned int usernumber) {

    int          handle;


    if(lmrs) {
        handle = bbs_sopen(cp,"MSG/LASTREAD.BB2",O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT,SH_DENYNO,S_IWRITE | S_IREAD);
        if(handle == -1) return;

        if(lseek(handle,(long)(((long)LASTREADSIZE * (long)sizeof(unsigned int)) * ((long)usernumber - 1L)),SEEK_SET) != -1L) {
            write(handle,lmrs,LASTREADSIZE * sizeof(unsigned int));
        }
        bbs_close(cp,handle);
    }
}




unsigned int * _fastcall make_new_lastread (USHORT cp) {

    unsigned int *lmrs;


    lmrs = (unsigned int *)bbs_malloc(cp,LASTREADSIZE * sizeof(unsigned int));
    if(!lmrs) {
        sayp(D_LOCAL,cp,247,NULL,0);
        DosSemClear(&modems[cp]->bbsrunningSEM);
        _endthread();
    }
    memset(lmrs,0,sizeof(unsigned int) * LASTREADSIZE);
    return lmrs;
}
