/*
 *  bmg.h ->    Boyer-Moore-Gosper search definitions
 *
 *  see bmg.c for documentation
 */

#define bmgMAXPAT   133         /*  max pattern length  */

typedef struct {
    char    delta[256];         /*  ASCII only deltas   */
    char    pat[bmgMAXPAT + 1]; /*  the pattern     */
    char    ignore;             /*  ignore case flag    */
} bmgARG;


void _fastcall   bmgCompile(char *s, bmgARG *pattern, int ignore_case);
char * _fastcall bmgSearch(char *buffer, size_t buflen, bmgARG *pattern);
char * _fastcall bmgStrstr (char *find,char *in,int ignore);

/*
 *  END of bmg.h
 */
