@ECHO OFF
REM --------------------------------------------------------------------
REM This is an excerpt from my AUTOEXEC.BAT file. Use these sample
REM statements to configure your system to use XA.
REM 
REM Set your PATH to include the directory where XA is kept.
REM --------------------------------------------------------------------

PATH C:\X10;(...other directories placed here...)

REM --------------------------------------------------------------------
REM Setup the XA Environment variable to point to the directory where
REM XA's command and initialization files are kept.
REM --------------------------------------------------------------------

SET XA=C:\X10

REM --------------------------------------------------------------------
REM You could synchronize the clock in your CP-290 every time you boot
REM your PC.
REM --------------------------------------------------------------------

XA "SYNCHRONIZE X10"

REM --------------------------------------------------------------------
REM CHECK TO SEE IF IT'S TIME TO UPDATE THE CP-290...
REM ... Then perform BACKUP to tape:
REM ...    Week 1: Drive C - Full Backup, D-E Differential
REM ...    Week 2: Drive D - Full Backup, C-E Differential
REM ...    Week 3: Drive E - Full Backup, C-D Differential
REM ...    Week 4: All Drives - Differential Backup
REM ...    Week 5: All Drives - Differential Backup
REM ...
REM ... Then DEFRAG DRIVES C,D,E,F
REM --------------------------------------------------------------------
POWERUP D=SUNDAY s=2:55 e=3:05
IF NOT ERRORLEVEL 1 GOTO :FINISH
REM
REM   Always update the CP-290 on Sunday mornings...
XA f=xa.cmd +r1

REM
REM   If week 1, full backup drive c:, differential d: and e:
REM
POWERUP D=SUNDAY W=1 s=2:55 e=3:10
IF NOT ERRORLEVEL 1 GOTO :WEEK2
qbackup drive_c.set /a
qbackup drive_de.set /a
goto :defrag

REM
REM   If week 2, full backup drive d:, differential c: and e:
REM
:week2
POWERUP D=SUNDAY W=2 s=2:55 e=3:10
IF NOT ERRORLEVEL 1 GOTO :WEEK3
qbackup drive_d.set /a
qbackup drive_ce.set /a
goto :defrag

REM
REM   If week 3, full backup drive e:, differential c: and d:
REM
:week3
POWERUP D=SUNDAY W=3 s=2:55 e=3:10
IF NOT ERRORLEVEL 1 GOTO :WEEK45
qbackup drive_e.set /a
qbackup drive_cd.set /a
goto :defrag

REM
REM   All other weeks - do differential backup of ALL drives
REM
:week45
qbackup all_diff.set /a

:defrag
C:\DOS\DEFRAG C: /F
C:\DOS\DEFRAG D: /F
C:\DOS\DEFRAG E: /F
C:\DOS\DEFRAG F: /F
C:\DOS\smartdrv /c C- D- E- 1024 512

XA "C1 OFF"

:FINISH
