#if !defined(__mainapp_h)              // Sentry, use file only if it's not already included.
#define __mainapp_h

/*  Project main
    ITD
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    main.exe Application
    FILE:         mainapp.h
    AUTHOR:       TK


    OVERVIEW
    ========
    Class definition for mainApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\statusba.h>
#include <owl\controlb.h>
#include <owl\buttonga.h>
#include <owl\opensave.h>

#include "mainapp.rh"            // Definition of all resources.


//{{TApplication = mainApp}}
class mainApp : public TApplication {
private:
    TWindow *Client;                                 // Client window for the frame.
    TOpenSaveDialog::TData FileData;                    // Data to control open/saveas standard dialog.

private:
    void SetupSpeedBar (TDecoratedFrame *frame);
    BOOL CanClose();

public:
    mainApp ();
    virtual ~mainApp ();

    void OpenFile (const char *fileName = 0);
//{{mainAppVIRTUAL_BEGIN}}
public:
    virtual void InitMainWindow();
//{{mainAppVIRTUAL_END}}

//{{mainAppRSP_TBL_BEGIN}}
protected:
	 void CmExit ();
	 void CmHelpAbout ();
	 void CmViewTraders ();
	 void CmViewCustomers ();
	 void CmViewAffairs() ;

//{{mainAppRSP_TBL_END}}
  DECLARE_RESPONSE_TABLE(mainApp);
};    //{{mainApp}}


#endif                                      // __mainapp_h sentry.
