;
;Beginn
;
code            segment
                assume  cs:code, ds:code
                org     44h                ;environment pointer
umgebungsadr    dw      ?                  ;
                org     100h               ;(COM-program)

zuaddex:        jmp     installation
;
;Daten
;
programm_name   db      'AddEx 1.00 '
copyright       db      '(C) Kolja Waschk 1993',0
old_fossil_int  dw      ?,?
prg_laenge      equ     offset copyright - offset programm_name
fossil_int      equ     14h
;
; strings
;
realconmsg      db      '+FCON',0,'                                            '
simuconmsg      db      0Dh,0Ah,'CONNECT FAX/AddEx',0Dh,0Ah,0,'                            '
porttoserv      dw      1                       ;0=COM1, 1=COM2, ...
recmsgpntr      dw      0
simmsgpntr      dw      0
in_addex        db      0

;
; Fossil-add-on Routine (main program)
;
new_fossil_int  proc    far
                assume  ds:code

;               cmp     dx, CS:[porttoserv]
;               jne     alt_int_patch
                cmp     CS:[in_addex], 0        ; irq 14 called from within addex ?
                jne     alt_int_patch           ; yes - do not check
                cmp     ah, 02h                 ; rec char (wait) function ?
                je      function_hit
                cmp     ah, 0Ch                 ; rec char (no wait) function ?
                je      function_hit

alt_int_patch:  jmp     dword ptr cs:old_fossil_int ; normal fossil call
;
; noch Zeichen zu simulieren ?
;
function_hit:   push    ds
                push    bx

                push    cs
                pop     ds

                cmp     [simmsgpntr],0
                je      wait_for_rmsg           ; no chars left to simulate

                mov     bx, [simmsgpntr]
                mov     al, [simuconmsg-1+bx]   ; move char into output reg.

                cmp     ah, 0Ch
                je      peek_ahead_only         ; increase string pointer
                                                ; if the function call wasn't
                inc     bx                      ; "peek ahead input buffer"
                cmp     [simuconmsg-1+bx], 0
                jne     not_the_end
                mov     bx, 0

not_the_end:    mov     [simmsgpntr], bx

peek_ahead_only: mov     ah, 0

                pop     bx
                pop     ds
                iret

; external msg simulieren ?

wait_for_rmsg:
                mov     [in_addex], 1           ; execute fossil function
                int     fossil_int
                mov     [in_addex], 0

                cmp     ah, 0
                jne     quit_query

                mov     bx, [recmsgpntr]        ; check result for the
                cmp     [realconmsg+bx], al     ; original connect msg.
                                                ; (+FCON etc.)
                jne     reset_rmpntr

                inc     bx                      ; increase string pointer
                mov     [recmsgpntr], bx
                cmp     [realconmsg+bx], 0
                jne     quit_query

                mov     [simmsgpntr], 1
reset_rmpntr:   mov     [recmsgpntr], 0

quit_query:     pop     bx
                pop     ds

                iret

new_fossil_int  endp
;
; Installation         (set new irq vectors etc.)
;
installation:
                assume  ds:code
                push    cs                 ;setze die Segmente
                pop     ds                 ;DS=CS
;
; schon installiert ?
;
                mov     al,fossil_int      ;gewnschter neuer
                mov     ah,35h             ;Interrupt wird ber
                int     21h                ;INT 21h gesucht
;
; vergleiche Interrupt: ist er von AddEx benutzt ?
;
                lea     di,programm_name   ;ES:DI zeigt auf Prgname
                mov     si,di
                mov     cx,prg_laenge      ;Lnge des Namens
                repe    cmpsb              ;vergleiche
                jcxz    schon_installiert  ;ja, schon installiert
;
; installiere AddEx
;
                lea     dx,start_text      ;Installationsmeldung
                call    text_ausgeben      ;ausgeben
;
; sichere alte Interrupts
;
                mov     al,fossil_int      ;sichere orig.Fossil-Vektor
                mov     ah,35h             ;nach old_fossil_int
                int     21h
                mov     old_fossil_int,bx
                mov     old_fossil_int+2,es
;
; gebe Umgebungsstrings frei
;
                mov     ax,umgebungsadr    ;Adresse der Umgebung im PSP
                mov     es,ax              ;Gib Umgebung durch
                mov     ah,73              ;Funktion 73 von
                int     21h                ;INT 21h frei
;
; setze die neuen Interrupts
;
                lea     dx,new_fossil_int  ;Offset
                mov     al,fossil_int      ;Nummer
                mov     ah,25h             ;setze Vektor
                int     21h
;
; nun beenden, aber bis zum Label INSTALLATION resident bleiben
;
                lea     dx,installation    ;Adresse von INSTALL
                mov     cl,4               ;durch das 4-malige
                shr     dx,cl              ;Schieben durch 16 teilen
                inc     dx
                xor     al,al              ;kein Fehler
                mov     ah,49              ;beende resident
                int     21h
;
; AddEx ist schon installiert, de-installiere und gebe Meldung aus
;
schon_installiert:
                lea     dx,schon_text      ;Meldung ausgeben
                call    text_ausgeben
                mov     ah,35h             ;orig.Int.-Vektor lesen
                mov     al,fossil_int
                int     21h
                push    ds
                mov     dx,es:old_fossil_int+2
                mov     ds,dx
                mov     dx,es:old_fossil_int
                mov     ah,25h             ;reset orig. Int.-Vektor
                int     21h
                pop     ds                 ;Speicher wieder freigeben
                mov     ah,49h
                int     21h
                mov     ax,4c00h           ;beende das Programm 
                int     21h
;
; Unterroutine: gibt ASCII-Text aus
;
text_ausgeben   proc    near               ;ASCIIZ-String
                mov     ah,9               ;ueber Fkt. 9
                int     21h                ;vom INT 21h ausgeben
                ret                        ;und zurck
text_ausgeben   endp
;
;
start_text  db  10,13,10,13
            db  'AddEx 1.00  (c) 1993 Kolja Waschk',10,13
            db  'loaded',10,10,13
            db  '$'
schon_text  db  10,13
            db  'AddEx unloaded',10,10,13,'$'
code        ends
            end     zuaddex
