/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :   strskip
 *
 *  Description :   Skip 'n' words from a string.
 *
 *  Decisions   :
 *
 *  Parameters  :   in    char    *string     string to be matched
 *                  in    int     word_nb     number of words to skip
 *
 *  Return code :   pointer to word.
 *
 *  OS/Compiler :   All
 ***/

char *strskip( const char *string, int word_nb )

{ char *ptr;

  while ( *string == ' ' || *string == '\n' || *string == '\t' ) string++;

  for ( ; word_nb; word_nb-- )
      {
        ptr = strpbrk( string, " \n\t" );
        if ( ptr ) string = ptr + strspn( ptr, " \n\t" );
              else while ( *string ) string++;
      }

return string;
}
