PROGRAM wxterm;
{$S-,R-,D+,L+,V-,B+} {3.08}

{$M 10240,0,0} {3.09}

USES Dos,CRT; {3.05}
  {
  Scott Murphy
  77 So. Adams St. #301
  Denver, CO 80209
  Compuserve 70156,263

  Defaults, help screen and hot keys improved.  Ran thru Pascal
  Formatter, changed to a two file program.  Changed to Ver: 3.01
  12-05-87 L.B. Neal, Sunnyvale, CA.
  }
{**************************************************************}
{ Jun 1990. Upgraded to Turbo Pascal 5.0/5.5. Ver:3.04         }
{ Aug 1991. Corrected several items. New version is 3.05.      }
{ Dec 1991. New goodies and StonyBrook support!  3.07          }
{ Mar 1992. Fixes and new Goodies!!  New version 3.09          }
{ Apr 1992. Fixes and improvements. 3.10                       }
{ L.B. Neal, Sunnyvale,CA.                                     }
{**************************************************************}

TYPE
  bigstring = STRING[80];     {general purpose}
  Str90 = String[90];         {3.07}
  cset = SET OF 0..127;
  parity_set = (none, even);  {readability and expansion}

CONST
  Version = '3.10 ';          { 11-JUN-92 Another look}
  BELL_FREQ = 440;            {frequency for bell sound}
  BELL_DELAY = 100;           {duration of bell sound}
  DEFAULT_BAUD = 9600;        {Serial port speed at start-up}
  RECV_BUF_SIZE = 4097;       {this may be changed to whatever size you need}
  Buffer_End = RECV_BUF_SIZE-1; { safety margin }
  ComPort : Byte = 3;         { I use COM3: }
  WxExit : Boolean = False;  {3.05}
  Cdet: Boolean =  False;   {3.08}
  InitStr:  String[60] = 'AT&C1&D2X4S0=0M0V1Q0'; {3.09}

VAR
  AsyncVector: Pointer;
  xtnd: Boolean;
  a: Byte;
  c,i: Integer;
  ch: Char;
  regs: Registers;            { 3.04 }
  INVLIST: Integer;
  Buffer_Head,Buffer_Tail,Buffer_Count: Integer;
  recv_buffer: ARRAY[1..RECV_BUF_SIZE] OF Byte;

  speed: Integer;            {I don't know the top speed these

                              routines will handle}
  dbits : 7..8;               {only ones most people use}
  stop_bits : 1..2;           {does anyone use 2?}
  parity : parity_set;        {even and none are the common ones}
  Cport: String[4];           {3.04}
  Base: Word;                 {3.04}
  Async_Irq: Word;            {3.04}
  OutPort: Word;              {3.04}
  CdetPort: Word;             {3.07}
  junk: Char;                 {3.04}
  PassStrg: BigString;        {3.04}
  wcol,wrow: Byte;            {3.08}
  fcol,frow: Byte;            {3.09}

 {$F+} { MUST be a FAR Procedure 3.04 }
 PROCEDURE async_isr; Interrupt; {$F-} {3.09}
  BEGIN
   Inline($FB); {STI} {3.06}
   Recv_Buffer[Buffer_Head] := Port[Base];
   IF (Buffer_Head = Buffer_End) THEN
    Buffer_Head := 1
   ELSE
    INC(Buffer_Head);
   INC(Buffer_Count);
   Port[$20] := $20;
  END;

  PROCEDURE DoBorder(FstCol,FstRow,LstCol,LstRow : Integer; Save:Boolean);
  VAR i,thisrow,width,height,column: Integer; horiz: String[90];
  BEGIN
    IF save THEN wcol := WhereX; wrow := WhereY; {3.08}
    Window(FstCol,FstRow,LstCol,LstRow);
    ClrScr;
    thisrow := 2;
    width := (LstCol-FstCol)-2;
    height := (LstRow-FstRow)-1;
    column := Width+2;
   
    FOR i := 1 to width DO horiz[i] := #205;
    horiz[0] := Char(width);

    Gotoxy(1,1); Write(Chr(201));
    Write(horiz);
    Write(Chr(187));

    FOR i := 1 TO height DO
     BEGIN
      Gotoxy(1,thisrow);       Write(Chr(186));
      Gotoxy(column,thisrow);  Write(Chr(186));
      INC(thisrow);
     END;

    Gotoxy(1,thisrow); Write(CHR(200));
    Write(horiz);
    Write(#188);
  END;

  FUNCTION Carrier:Boolean;
  BEGIN
   Carrier := (port[CdetPort] AND 128) <> 0;
  END;

  FUNCTION CTS:Boolean; {3.07}
  BEGIN
   Cts := (Port[CdetPort] AND $10) <> 0;
  END;

  FUNCTION Wcgetc: Byte; { 3.04 }
  BEGIN
   INLINE($FA); {suspend interrupts}
   wcgetc := Recv_Buffer[buffer_Tail];
   IF Buffer_Tail < Buffer_End THEN { 3.04 safer this way }
    INC(Buffer_Tail)
   ELSE
    Buffer_Tail := 1;
   DEC(Buffer_Count); 
   INLINE($FB); {resume interrupts}
   Port[$20] := $20; {3.05}
  END;

  PROCEDURE send(c:Integer); {3.09}
  BEGIN
   (* WHILE NOT Cts DO {NOP}; *)
   WHILE (Port[CdetPort] AND $10) = 0 DO {NOP}; {3.09}
   WHILE (port[outport] AND 32) = 0 DO {NOP};
   port[base] := LO(c); {3.09}
  END;

  PROCEDURE sendstr(s:Str90); {3.09 Complete rewrite}
  VAR size,cnt: Byte; ochar: Char; {3.09}
  BEGIN
   size := ORD(s[0]);
   cnt := 1;
   REPEAT
    ochar := s[cnt]; {3.09}
    IF ochar = '~' THEN  {3.09}
     Delay(500)
    ELSE
     BEGIN
      WHILE NOT Cts DO {NOP};
      WHILE (port[outport] AND 32) = 0 DO {NOP};
      port[base] := ORD(ochar);
      Delay(5); {3.08}
     END;
    INC(cnt);
   UNTIL cnt > size;
   port[base] := 13; {3.09}
  END;

 PROCEDURE set_baud(r:integer);
 VAR a:byte; rw:word;
 BEGIN
  IF (r >= 300) AND (r <= 9600) THEN
   BEGIN
    CASE r OF {3.07}
     2400: rw := 48;
     1200: rw := 96;
     9600: rw := 12; { 3.07 really 9600 bps }
      300: rw := 384;
    END;
    a := port[base+3] OR 128;
    port[base+3] := a;
    port[base] := lo(rw);
    port[base+1] := hi(rw);
    port[base+3] := a AND 127;
    Delay(500); {3.07 handle slow modems}
   END
  ELSE
   BEGIN
    Writeln('Invalid Baud Rate = ', r); { 2.0i }
    Halt(1);
   END;
 END;

procedure dump;
begin
  Inline($FA); {CLI}
  buffer_head := 1;
  buffer_tail := 1;
  buffer_count := 0;
  Inline($FB); {STI}
  Port[$20] := $20; {3.05}
end;

 procedure remove_port;
 var i,m : Word;
 begin
  inline($FA); {CLI}
  i := port[$21];
  m := 1 SHL Async_Irq;
  port[$21] := i OR m;
  port[base+2] := 0;
  port[base+4] := port[base+4] AND 1;
  inline($FB); {STI}
  Port[$20] := $20; {3.05}
 end;

procedure term_ready(s:Boolean);
var x:byte;
begin
  x := port[base+4] and $FE;
  if s then x := x+1;
  port[base+4] := x;
  Delay(300); {for slow modem 3.07}
end;

 PROCEDURE iport1;
  BEGIN
   CASE comport OF
   1 : begin
        base := $3f8; Async_Irq  := 4; cport := 'COM1:';
       end;
   2 : begin
        base := $2f8; Async_Irq  := 3; cport := 'COM2:';
       end;
   3 : begin
        base := $3E8; Async_Irq  := 4; cport := 'COM3:';
       end;
   4 : begin
        base := $2E8; Async_Irq  := 3; cport := 'COM4:';
       end;
   ELSE
    WriteLn('Invalid Comport:',comport);
    Halt(1);
   END; {case}
   outport  := Base+5;
   cdetport := Base+6; {3.07}
  END;

  {3.08 NOTE: This needs to be fixed to adjust parity,bits and stopbits!}
  PROCEDURE iport;
  VAR i,m:Integer;
  BEGIN
    buffer_Head := 1;
    buffer_Tail := 1;
    buffer_Count := 0;
    port[base+3]:= $03;
    WITH regs DO
     BEGIN
      ah := $25; al := async_irq+8;
      ds := cseg;
      dx := ofs(async_isr);
      msdos(regs);
     END;
    inline($FA);
    i := port[base+5];
    i := port[base];
    i := port[$21];
    m := (1 shl Async_Irq) xor $00FF;
    port[$21] := i AND m;
    port[base+1] := $01;
    i := port[base+4];
    port[base+4] := i OR $0B;   { 3.07 enable RTS,CTS = $0B;}
    inline($FB);      {3.07}
    Port[$20] := $20; {3.05}
    term_ready(true);
  END;

  PROCEDURE break; {send a break}
  VAR a,b: Byte;
  BEGIN
    a := Port[base+3];
    b := (a AND $7F) OR $40;
    Port[base+3] := b;
    Delay(750);
    Port[base+3] := a;
  END;

  FUNCTION exists(fname:bigstring): Boolean;
  VAR f: FILE;
  BEGIN
   Assign(f, fname);
   {$I-} Reset(f); {$I+}
   IF IOResult = 0 THEN
    BEGIN
     exists := True;
     Close(f);
    END
   ELSE
    exists := False
  END;

  {This is really interesting and educational too!!!}
  {NOTE: This does deserve some study!!  3.09}

  PROCEDURE supcase(VAR s);
  VAR ss:bigstring ABSOLUTE s; i,size:Byte;
  BEGIN
   {size := length(ss);} {3.09}
   size := ORD(ss[0]); {3.09}
   {FOR i := 1 TO size DO ss[i] := UpCase(ss[i]);} {3.09}
   i := 1;
   REPEAT
    ss[i] := Upcase(ss[i]);
    INC(i);
   UNTIL i > size;
  END;

  PROCEDURE processcom;
  VAR c,cnt: Byte;
  BEGIN
   IF Buffer_Count > 0 THEN {Safety net 3.04 }
    BEGIN
     c := WcGetc;
     IF c < 13 THEN
      BEGIN
       CASE c OF
        10 : Write(#10); {3.08}
         8 : Write(#8+#32+#8); {3.07}
         7 : BEGIN {bell}
              Sound(BELL_FREQ);
              Delay(BELL_DELAY);
              NoSound
             END;
        12 : ClrScr;
       END;
      END
     ELSE
      Write(Chr(c));             { Full IBM char set now - 3.03}
    END;
  END;

 PROCEDURE StatusLine;
 VAR scol,srow: Byte; {3.09}
 BEGIN
  scol := WhereX; srow := WhereY; {3.09}
  Window(1,25,80,25);
  Gotoxy(1,1);
  Write('WXTerm:'+Version+'  Mode:');
  IF carrier THEN Write('On-Line ') ELSE Write('Off-Line');{3.08}
  Write('  Bps:',speed,'  <Home> for help'); {3.08}
  Window(1,1,80,24);
  GotoXY(scol,srow); {3.09}
 END;

{$I WXTMXFER.INC}

CONST MASTER_FILE_NAME = 'WXTERM.MST';

TYPE
  MasterRec = RECORD
                mdbits : 7..8;
                mparity :parity_set;
                mstop_bits : 1..2;
                mcom_port: Byte;
                mspeed : Integer;
                minit: String[60]; {3.09}
              END;
VAR
  msrecord : MasterRec;
  msfile: FILE OF MasterRec;

  PROCEDURE setup; {initialize most stuff - you may want to replace this}
  VAR err: Integer; {3.05}
  BEGIN
    WITH msrecord DO
      BEGIN
        Assign(msfile, MASTER_FILE_NAME);
        IF exists(MASTER_FILE_NAME) THEN
          BEGIN
           Reset(msfile);
           Read(msfile, msrecord)
          END
        ELSE
          BEGIN
            Rewrite(msfile);
            mdbits := 8;        {Chg 3.01}
            mparity := NONE;    {Chg 3.01}
            mstop_bits := 1;    {Chg 3.01}
            mcom_port := comport;
            mspeed := DEFAULT_BAUD;
            minit := InitStr; {3.09}
            Write(msfile, msrecord);
          END;
        {$I-} Close(msfile); {$I+} err := IoResult; {3.05}
        dbits := mdbits;
        parity := mparity;
        stop_bits := mstop_bits;
        speed := mspeed;
        ComPort := mcom_port;
        InitStr := minit;
      END;
  END;

  PROCEDURE GetParms;
  VAR p: string[4]; yn,cp,ans: Char; junk: integer; Tstr: String[60];
  BEGIN
   GotoXy(3,2); Write('Current Parameters:');
   Gotoxy(3,3); Write('Baud Rate:', speed:6);
   Gotoxy(3,4); Write('Data Bits:', dbits:6);
   Gotoxy(3,5); Write('Stop Bits:', stop_bits:6);
   CASE parity OF
    even : p := 'EVEN';
    none : p := 'NONE';
    ELSE
    p := '????'
   END;{case}
   Gotoxy(3,6); Write('Parity   : ', p:6); {3.05}
   Gotoxy(3,7); Write('Comm Port: ', Comport);
   GotoXy(3,8); Write('InitStr  : '+InitStr);
   Gotoxy(3,9); Write('Change(Y/N)?');
   REPEAT
    ans := Upcase(ReadKey);
   UNTIL (ans = 'Y') OR (ans = 'N');

   IF ans = 'Y' THEN   {3.05}
    BEGIN
     Gotoxy(3,10);
     Write('Bps 3)00 1)200 2)400 9)600 <CR>=keep.'); {Chd 3.08}
     REPEAT
      ans := ReadKey;
     UNTIL ans IN['1','2','3','9',#13]; {3.08}
     IF ans IN['1','2','3','9'] THEN {3.08}
      BEGIN
       CASE ans OF
        '1': speed := 1200;
        '2': speed := 2400;
        '3': speed := 300;
        '9': speed := 9600;
       END;
      END;

     Gotoxy(3,11); Write('New Data Bits[7/8] <cr> to keep.'); {Chd 3.05}
     REPEAT
      ans := ReadKey;
     UNTIL ans IN['7','8',#13];
     IF ans IN['7','8'] THEN val(ans,dbits,junk);

     Gotoxy(3,12); Write('New Stop Bits[1/2] <cr> to keep.'); {Chd 3.01}
     REPEAT          {3.05}
      ans := ReadKey;
     UNTIL ans IN['1','2',#13];
     IF ans IN['1','2'] THEN val(ans,stop_bits,junk);

     Gotoxy(3,13); Write('New Parity E or N <cr> to keep:'); {Chd 3.01}
     REPEAT
      ans := ReadKey;
     UNTIL ans IN['E','N',#13];
     IF (ans = 'E') THEN
      parity := even
     ELSE
      IF (ans = 'N') THEN parity := none;

     Gotoxy(3,14); Write('New com port 1..4 or <cr> to keep.'); {Chd 3.05}
     REPEAT
      cp := Upcase(Readkey);
     UNTIL cp IN['1'..'4',#13];
     IF cp IN['1'..'4'] THEN Comport := ORD(cp)-48;

     GotoXY(3,15); {3.09}
     WriteLn('InitStr or <cr> to keep'); {3.09}
     Write(':'); ReadLn(tstr); {3.09}

     GotoXY(3,16); {3.05}
     Write('Save changes[Y/N]?'); {Chd 3.01}
     REPEAT
      yn := Upcase(Readkey);
     UNTIL (yn = 'Y') OR (yn = 'N');
     IF yn = 'Y' THEN
      BEGIN
       WITH msrecord DO
        BEGIN
         mdbits := dbits;
         mparity := parity;
         mstop_bits := stop_bits;
         mspeed := speed;
         mcom_port := Comport;
         IF Length(tstr) > 0 THEN InitStr := Tstr; {3.09}
         minit := InitStr; {3.09}
         Reset(msfile);
         Write(msfile, msrecord);
         Close(msfile);
        END;
      END;
    END;
  END;

  PROCEDURE NewParms;
  BEGIN
   DoBorder(10,2,60,23,True); {3.09}
   GetParms;
   ClrScr;
   {Window(1,1,80,24);} {3.08}
   Set_Baud(speed);
   StatusLine; {3.08}
  END;

 BEGIN {WXTerm}
  {IF Mem[$0000:$0449] = 7 THEN TextMode(MONO) ELSE TextMode(CO80);} {3.10}
  MEMW[$0040:0004] := $03E8; {COM3: for DOS} {3.07}
  MEMW[$0040:0006] := $02E8; {COM4: for DOS} {3.07}
  DirectVideo := True;    {3.07}
  CheckBreak := False;     {3.04}
  CheckSnow := False;      {3.04}
  Delay(100); {3.08 kick the Delay function}
  ClrScr;
  setup;
  StatusLine; {3.08}
  iport1;
  GetIntVec(Async_Irq+8, AsyncVector);
  iport;
  Set_Baud(speed);
  {term_ready(True);} {3.08}

  SendStr(InitStr); {3.08}
  Delay(500); {3.08}

  WHILE NOT WxExit DO    { our main program loop }
   BEGIN
    IF (carrier AND NOT Cdet) THEN BEGIN Cdet := True; StatusLine; END; {3.08}
    IF (cdet AND NOT carrier) THEN BEGIN Cdet := False; StatusLine; END; {3.08}
    WHILE Buffer_Count > 0 DO Processcom;  {3.04}
    wcol := WhereX; wrow := WhereY; {3.05 moved here}
    DEC(wcol);                      {3.05 moved here}
    IF keypressed THEN
     BEGIN
      a := ORD(Readkey);
      IF a = 0 THEN
       BEGIN
        a := ORD(Readkey);
        CASE a OF
         81 : BEGIN {PgDn - now is more standard 3.08}
               fcol := WhereX; frow := WhereY; {3.09}
               recv_wcp;
               GotoXy(fcol,frow); {3.09}
              END;
         45 : BEGIN { alt-X}
               DoBorder(20,18,60,22,True); {3.09}
               Gotoxy(13,2); Write(' WXTERM ');
               Gotoxy(4,3); Write('Do you really want to exit(Y/N)?');
               REPEAT
                ch := Upcase(Readkey);
               UNTIL (ch = 'Y') OR (ch = 'N');
               IF ch = 'Y' THEN
                WxExit := True
               ELSE
                BEGIN
                 Clrscr; Window(1,1,80,24);
                 GotoXY(wcol,wrow);
                END;
              END;
         73 : BEGIN {PgUp - now is more to standard 3.08}
               fcol := WhereX; frow := WhereY; {3.09}
               send_wcp;
               GotoXY(fcol,frow); {3.09}
              END;
         35 : BEGIN    { alt-H }
               WriteLn(' WXTERM ');
               WriteLn('Disconnecting');
               term_ready(False);
               Delay(500);
               term_ready(True);
               IF Carrier THEN                   { 3.04 added }
                WriteLn('Oops! Hangup Failed!')
               ELSE
                StatusLine; {3.08}
              END;
         46 : ClrScr;         {alt-C}
         48 : Break;          {alt-B}
         25 : BEGIN NewParms; GotoXY(wcol,wrow); END; {3.05}  {alt-P}
         50 : BEGIN           {ALT-I 3.08}
               WriteLn('Initializing Modem..'); {3.08}
               SendStr(InitStr); Delay(500);
               WHILE Buffer_Count > 0 DO Processcom;
              END;
         71 : BEGIN           {Home}
               DoBorder(34,3,78,10,True);
               Gotoxy(3,2); Write('Rcv WXmodem <PGDN>   Send WXmodem <PGUP>');
               Gotoxy(3,3); Write('Exit ALT-X           Hangup ALT-H       ');
               Gotoxy(3,4); Write('Send Break ALT-B     ClrSrn ALT-C       ');            
               Gotoxy(3,5); Write('Comm Params. ALT-P   Modem Init ALT-M   ');
               Gotoxy(3,7); Write('    <Press any key to continue>         ');
               REPEAT UNTIL (KeyPressed);
               junk := ReadKey;
               BEGIN ClrScr; Window(1,1,80,24); Gotoxy(wcol,wrow); END;
              END;
        END; {case}
       END    {if extended key}
      ELSE    {not extended}
       Send(a);
    END;{if KeyPressed}
  END;{while not wxexit}

  remove_port;
  SetIntVec(Async_irq+8, AsyncVector);
  NormVideo;
  Window(1,1,80,25);           { Added 3.03 }
  ClrScr;                      { Added 3.01 }
END.
