#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>                
#include <string.h>             
#include "wizunzip.h"
#include "helpids.h"
#include <shellapi.h>


/* Windows Info-ZIP Unzip Window Procedure, wndproc.c.
 * Author: Robert A. Heath, 157 Chartwell Rd., Columbia, SC 29210
 * I, Robert Heath, place this source code module in the public domain.
 */

#define MAKE_TABSTOP_TABLE_ENTRY(WNDHANDLE, ID) \
    { \
        TabStopTable[ID - TABSTOP_ID_BASE].lpfnOldFunc = \
            (FARPROC)GetWindowLong(WNDHANDLE, GWL_WNDPROC); \
        SetWindowLong(WNDHANDLE, GWL_WNDPROC, (LONG)lpfnKbd); \
        TabStopTable[ID - TABSTOP_ID_BASE].hWnd = WNDHANDLE; \
    }


static char szFormatKeyword[2][6] = { "short", "long" };

/* Trailers are the lines just above the totals */
static char * __based(__segname("STRINGS_TEXT")) szTrailers[2] = {
" ------                    -------",
" ------          ------  ---                              -------"
} ;

/* size of char in SYSTEM font in pixels */
short dxChar, dyChar;

/* button control table -- one entry for 
 * each of 4 entries. Indexed by the window ID relative to
 * the first tabstop (TABSTOP_ID_BASE).         
 */
TabStopEntry TabStopTable[TABSTOP_TABLE_ENTRIES]; 


static LPSTR
lstrrchr(LPSTR lpszSrc, char chFind)
{
    LPSTR   lpszFound = (LPSTR)0;
    LPSTR   lpszT;
    
    if ( lpszSrc )
    {
        for (lpszT = lpszSrc; *lpszT; ++lpszT)
        {
            if ((*lpszT) == chFind)
                lpszFound = lpszT;
        }
    }
    
    return lpszFound;
}

/****************************************************************************

    FUNCTION: SetCaption(HWND hWnd,  PSTR szOemFileName)
                szFileName is OEM char set.

    PURPOSE: Set new caption for main window

****************************************************************************/
void 
SetCaption(HWND hWnd)
{
    WORD wMenuState;
    char szSimpleFileName[15];  /* just the 8.3 part in ANSI char set */
    LPSTR lpszFileNameT;        /* pointer to simple filename               */
    BOOL    fIconic = IsIconic(hWnd);   /* is window iconic ?   */

    /* point to simple filename in OEM char set                 */
    if ((lpszFileNameT = lstrrchr(lpumb->szFileName, '\\')) ||
        (lpszFileNameT = lstrrchr(lpumb->szFileName, ':')))
        lpszFileNameT++;
    else
        lpszFileNameT = lpumb->szFileName;

    OemToAnsi(lpszFileNameT, szSimpleFileName);
    (void)wsprintf(lpumb->szBuffer, "%s - %s %s %s", 
                    (LPSTR)szAppName, 
                    (LPSTR)(szSimpleFileName[0] ? 
                        szSimpleFileName : "(No .ZIP file)"),
                    (LPSTR)(!fIconic && lpumb->szOrigDirName[0] ? " - " : ""),
                    (LPSTR)(!fIconic ? lpumb->szOrigDirName : ""));
    SetWindowText(hWnd, lpumb->szBuffer);
    wMenuState = (WORD)(szSimpleFileName[0] ? MF_ENABLED : MF_GRAYED) ;
    EnableMenuItem(hMenu, IDM_SELECT_ALL, wMenuState|MF_BYCOMMAND); 
    EnableMenuItem(hMenu, IDM_DESELECT_ALL, wMenuState|MF_BYCOMMAND); 
}

/****************************************************************************

    FUNCTION: WizunzipWndProc(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages

    MESSAGES:

    WM_DESTROY      - destroy window
    WM_SIZE         - window size has changed
    WM_QUERYENDSESSION - willing to end session?
    WM_ENDSESSION   - end Windows session
    WM_CLOSE        - close the window
    WM_SIZE         - window resized
    WM_PAINT        - windows needs to be painted
    WM_DROPFILES    - open a dropped file
    COMMENTS:

    WM_COMMAND processing:

        IDM_OPEN -  open a new file.


        IDM_EXIT - query to save current file if there is one and it
               has been changed, then exit.

        IDM_ABOUT - display "About" box.

****************************************************************************/

long FAR PASCAL WizunzipWndProc(HWND hWnd, WORD wMessage, WORD wParam, LONG lParam)
{
    FARPROC lpfnAbout, lpfnSelectDir;

    HDC hDC;                /* device context       */
    TEXTMETRIC    tm;           /* text metric structure    */
    POINT point;
    FARPROC lpfnKbd;
    short   i;


    switch (wMessage)
    {
    case WM_CREATE: /* create  window       */
        hInst = ((LPCREATESTRUCT)lParam)->hInstance;
        lpfnKbd = MakeProcInstance((FARPROC)KbdProc, hInst);
        hAccTable = LoadAccelerators(hInst, "WizunzipAccels");
        hBrush = CreateSolidBrush(GetSysColor(BG_SYS_COLOR)); /* background */

        hMenu = GetMenu(hWnd);
        /* Check Menu items to reflect WIN.INI settings */
        CheckMenuItem(hMenu, IDM_RECR_DIR_STRUCT, MF_BYCOMMAND | 
                            (uf.fRecreateDirs ? MF_CHECKED : MF_UNCHECKED));
        CheckMenuItem(hMenu, (IDM_SHORT+uf.fFormatLong), MF_BYCOMMAND | MF_CHECKED);
        CheckMenuItem(hMenu, IDM_OVERWRITE, MF_BYCOMMAND |
                            (uf.fOverwrite ? MF_CHECKED : MF_UNCHECKED));
        CheckMenuItem(hMenu, IDM_TRANSLATE, MF_BYCOMMAND |
                            (uf.fTranslate ? MF_CHECKED : MF_UNCHECKED));
        CheckMenuItem(hMenu, wLBSelection, MF_BYCOMMAND | MF_CHECKED);
        CheckMenuItem(hMenu, IDM_UNZIP_TO_ZIP_DIR, MF_BYCOMMAND |
                            (uf.fUnzipToZipDir ? MF_CHECKED : MF_UNCHECKED));
        CheckMenuItem(hMenu, IDM_BEEP_ON_FINISH, MF_BYCOMMAND |
                            (uf.fBeepOnFinish ? MF_CHECKED: MF_UNCHECKED));
        EnableMenuItem(hMenu, IDM_CHDIR, MF_BYCOMMAND |
                            (uf.fUnzipToZipDir ? MF_GRAYED : MF_ENABLED));

        /* Get an hourglass cursor to use during file transfers */
        hHourGlass = LoadCursor(0, IDC_WAIT);

        hFixedFont = GetStockObject(SYSTEM_FIXED_FONT);
        hDC = GetDC(hWnd);  /* get device context */
        hOldFont = SelectObject(hDC, hFixedFont);
        GetTextMetrics(hDC, &tm);
        ReleaseDC(hWnd, hDC);
        dxChar = tm.tmAveCharWidth;
        dyChar = tm.tmHeight + tm.tmExternalLeading; 

        hWndList = CreateWindow("listbox", NULL,
                        WS_CHILD | WS_VISIBLE | LBS_NOTIFY | WS_VSCROLL | WS_BORDER| LBS_EXTENDEDSEL,
                        0, 0,
                        0, 0,
                        hWnd, IDM_LISTBOX,
                        GetWindowWord (hWnd, GWW_HINSTANCE), NULL);

        MAKE_TABSTOP_TABLE_ENTRY(hWndList, IDM_LISTBOX);
        SendMessage(hWndList, WM_SETFONT, hFixedFont, FALSE);
        ShowWindow(hWndList, SW_SHOW);
        UpdateWindow(hWndList);         /* show it now! */

        hWndStatus = CreateWindow(szStatusClass, "Status",
                            WS_CHILD|WS_SYSMENU|WS_VISIBLE|WS_BORDER|WS_HSCROLL|WS_VSCROLL|WS_MAXIMIZEBOX|WS_CAPTION,
                            0, 0,
                            0, 0,
                            hWnd, IDM_STATUS,
                            GetWindowWord (hWnd, GWW_HINSTANCE), NULL);
        SendMessage(hWndStatus, WM_SETFONT, hFixedFont, TRUE);
        MAKE_TABSTOP_TABLE_ENTRY(hWndStatus, IDM_STATUS);
        if (uf.fStatusHidden)
        {
            ShowWindow( hWndStatus, SW_HIDE );
            ModifyMenu(hMenu,IDM_SHOWHIDE_STATUS,
                        MF_BYCOMMAND|MF_STRING|MF_ENABLED,
                        IDM_SHOWHIDE_STATUS,
                        (uf.fStatusHidden) ? "S&how Status Window" : "&Hide Status Window");
        }

        hExtract = CreateWindow("button", "E&xtract",  
                            WS_CHILD | BS_PUSHBUTTON,
                            0, 0,
                            0, 0,
                            hWnd, IDM_EXTRACT,
                            hInst,
                            NULL);
        ShowWindow(hExtract, SW_SHOW);
        MAKE_TABSTOP_TABLE_ENTRY(hExtract, IDM_EXTRACT);


        hDisplay= CreateWindow("button", "&Display",                    
                            WS_CHILD | BS_PUSHBUTTON,
                            0, 0,
                            0, 0,
                            hWnd, IDM_DISPLAY,
                            hInst,
                            NULL);
        ShowWindow(hDisplay, SW_SHOW);
        MAKE_TABSTOP_TABLE_ENTRY(hDisplay, IDM_DISPLAY);

        hTest= CreateWindow("button", "&Test",          
                            WS_CHILD | BS_PUSHBUTTON,
                            0, 0,
                            0, 0,
                            hWnd, IDM_TEST,
                            hInst,
                            NULL);
        ShowWindow(hTest, SW_SHOW);
        MAKE_TABSTOP_TABLE_ENTRY(hTest, IDM_TEST);
    

        hShowComment= CreateWindow("button", "&Show Comment", 
                                    WS_CHILD | BS_PUSHBUTTON,
                                    0, 0,
                                    0, 0,
                                    hWnd, IDM_SHOW_COMMENT,
                                    hInst,
                                    NULL);

        ShowWindow(hShowComment, SW_SHOW);
        MAKE_TABSTOP_TABLE_ENTRY(hShowComment, IDM_SHOW_COMMENT);

        /* if file spec'd on entry */
        if (lpumb->szFileName[0])
        {
            LPSTR lpch;
            extern int ofretval; /* return value from initial open if filename given
                                during WinMain()                 */


            OemToAnsi(lpumb->szFileName, lpumb->szBuffer);
            /* If valid filename change dir to where it lives */
            if (ofretval >= 0)
            {
                /* take only path portion */
                if ((lpch = lstrrchr(lpumb->szBuffer, '\\')) ||
                     (lpch = lstrrchr(lpumb->szBuffer, ':')))
                    *lpch = '\0';

                lstrcpy(lpumb->szOrigDirName, lpumb->szBuffer);
                DlgDirList(hWnd, lpumb->szBuffer, 0, 0, 0);
            }
            else /* bad file name */
            {
                if ((lpch = lstrrchr(lpumb->szBuffer, '\\')) ||
                     (lpch = lstrrchr(lpumb->szBuffer, ':')))
                    lpch++; /* point to filename */
                else
                    lpch = lpumb->szBuffer;
    
                wsprintf (lpumb->szBuffer, "Cannot open %s", lpch);
                MessageBox (hWnd, lpumb->szBuffer, szAppName, MB_ICONINFORMATION | MB_OK);
                lpumb->szFileName[0] = '\0'; /* pretend filename doesn't exist  */
            }
        }

        SetCaption(hWnd);
        UpdateListBox(hWnd);
        SendMessage(hWndList, LB_SETSEL, 1, 0L);
        UpdateButtons(hWnd);
        SizeWindow(hWnd, TRUE);
        if ( uf.fCanDragDrop )
            DragAcceptFiles( hWnd, TRUE );
        break;
    
    case WM_SETFOCUS:
        SetFocus( (uf.fStatusMaximized) ? hWndStatus : hWndList);
        break;

    case WM_ACTIVATE:
        SetCaption(hWnd);
        return DefWindowProc(hWnd, wMessage, wParam, lParam);

    case WM_SIZE:
        SizeWindow(hWnd, FALSE);
        break;

    case WM_CTLCOLOR: /* color background of buttons and statics */
        if (HIWORD(lParam) == CTLCOLOR_STATIC)
        {
            SetBkMode(wParam, TRANSPARENT);
            SetBkColor(wParam, GetSysColor(BG_SYS_COLOR)); /* custom b.g. color */
            SetTextColor(wParam, GetSysColor(COLOR_WINDOWTEXT));
            UnrealizeObject(hBrush);
            point.x = point.y = 0;
            ClientToScreen(hWnd, &point);
            SetBrushOrg(wParam, point.x, point.y);
            return ((DWORD)hBrush);
        }
        /* fall thru to WM_SYSCOMMAND */
        
    case WM_SYSCOMMAND:
        return DefWindowProc( hWnd, wMessage, wParam, lParam );

    case WM_COMMAND:
        /* Was F1 just pressed in a menu, or are we in help mode */
        /* (Shift-F1)? */

        if (uf.fHelp)
        {
            DWORD dwHelpContextId =
                (wParam == IDM_OPEN)            ? (DWORD) HELPID_OPEN :
                (wParam == IDM_EXIT)            ? (DWORD) HELPID_EXIT_CMD :
                (wParam == IDM_CHDIR)           ? (DWORD) HELPID_CHDIR :
                (wParam == IDM_SHORT)           ? (DWORD) HELPID_SHORT :
                (wParam == IDM_LONG)            ? (DWORD) HELPID_LONG :
                (wParam == IDM_HELP)            ? (DWORD) HELPID_HELP :
                (wParam == IDM_HELP_HELP)       ? (DWORD) HELPID_HELP_HELP :
                (wParam == IDM_ABOUT)           ? (DWORD) HELPID_ABOUT :
                (wParam == IDM_RECR_DIR_STRUCT) ? (DWORD) HELPID_RECR_DIR_STRUCT :
                (wParam == IDM_OVERWRITE)       ? (DWORD) HELPID_OVERWRITE :
                (wParam == IDM_TRANSLATE)       ? (DWORD) HELPID_TRANSLATE :
                (wParam == IDM_UNZIP_TO_ZIP_DIR)? (DWORD) HELPID_UNZIP_TO_ZIP_DIR :
                (wParam == IDM_LISTBOX)         ? (DWORD) HELPID_LISTBOX :
                (wParam == IDM_EXTRACT)         ? (DWORD) HELPID_EXTRACT :
                (wParam == IDM_DISPLAY)         ? (DWORD) HELPID_DISPLAY :
                (wParam == IDM_TEST)            ? (DWORD) HELPID_TEST :
                (wParam == IDM_SHOW_COMMENT)    ? (DWORD) HELPID_SHOW_COMMENT :
                (wParam == IDM_LB_EXTRACT)      ? (DWORD) HELPID_LB_EXTRACT :
                (wParam == IDM_LB_DISPLAY)      ? (DWORD) HELPID_LB_DISPLAY :
                (wParam == IDM_LB_TEST)         ? (DWORD) HELPID_LB_TEST :
                (wParam == IDM_DESELECT_ALL)    ? (DWORD) HELPID_DESELECT_ALL :
                (wParam == IDM_SELECT_ALL)      ? (DWORD) HELPID_SELECT_ALL :
                (wParam == IDM_CLEAR_STATUS)    ? (DWORD) HELPID_CLEAR_STATUS :
                (wParam == IDM_BEEP_ON_FINISH)  ? (DWORD) HELPID_BEEP_ON_FINISH :
                (wParam == IDM_SHOWHIDE_STATUS) ? (DWORD) (uf.fStatusHidden ? HELPID_SHOW_STATUS : HELPID_HIDE_STATUS) :
                                                  (DWORD) 0L;

            if (!dwHelpContextId)
            {
                MessageBox( hWnd, "Help not available for Help Menu item",
                            "Help Example", MB_OK);
                return DefWindowProc(hWnd, wMessage, wParam, lParam);
            }

            uf.fHelp = FALSE;
            WinHelp(hWnd,szHelpFileName,HELP_CONTEXT,dwHelpContextId);
        }
        else /* not in help mode */
        {
            switch (wParam)
            {
            case IDM_OPEN:
                /* If unzipping separately and previous file exists,
                 * go to directory where archive lives.
                 */
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );
                lpumb->szBuffer[0] = '\0';
                for (i=0; i<sizeof(OPENFILENAME); ++i)
                {
                    ((char __far *)&lpumb->ofn)[i] = 0;
                }

                lpumb->ofn.lStructSize = sizeof(OPENFILENAME);
                lpumb->ofn.hwndOwner = hWnd;
                lpumb->ofn.lpstrFilter = "Zip Files (*.zip)\0*.zip\0\0";
                lpumb->ofn.nFilterIndex = 1;
                lpumb->ofn.lpstrFile = lpumb->szFileName;
                lpumb->ofn.nMaxFile = 128;
                lpumb->ofn.lpstrFileTitle = lpumb->szBuffer;
                lpumb->ofn.nMaxFileTitle = 256;
                lpumb->ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
                if (GetOpenFileName(&lpumb->ofn))   /* if successful file open  */
                {
                    RECT    rClient;

                    if (uf.fUnzipToZipDir)
                    {
                        LPSTR lpchLast;

                        /* strip off filename to make directory name    */
                        OemToAnsi(lpumb->szFileName, lpumb->szOrigDirName);
                        if ((lpchLast = lstrrchr(lpumb->szOrigDirName, '\\')) ||
                            (lpchLast = lstrrchr(lpumb->szOrigDirName, ':')))
                            *lpchLast = '\0';
                    }

                    UpdateListBox(hWnd); /* fill in list box */
                    SendMessage(hWndList, LB_SETSEL, 1, 0L);
                    UpdateButtons(hWnd); /* update state of buttons */

                    GetClientRect( hWndList, &rClient );
                    OffsetRect( &rClient, 0, dyChar );
                    rClient.top = rClient.bottom;
                    rClient.bottom = rClient.top + (2*dyChar);
                    InvalidateRect( hWnd, &rClient, TRUE);
                    UpdateWindow( hWnd );
                }

                if (lpumb->szOrigDirName[0]) /* if directory name exists, go there  */
                {
                    lstrcpy(lpumb->szBuffer, lpumb->szOrigDirName); /* get scratch copy */
                    DlgDirList (hWnd, lpumb->szBuffer, 0, 0, 0); /* change dir */
                }
                SetCaption(hWnd);
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, TRUE );
                break;
            case IDM_CHDIR:
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );
                lpumb->szBuffer[0] = '\0';
                for (i=0; i<sizeof(OPENFILENAME); ++i)
                {
                    ((char __far *)&lpumb->ofn)[i] = 0;
                }

                lpumb->ofn.lStructSize = sizeof(OPENFILENAME);
                lpumb->ofn.hwndOwner = hWnd;
                lpumb->ofn.lpstrFilter = "All Files (*.*)\0*.*\0\0";
                lpumb->ofn.nFilterIndex = 1;
                lpumb->ofn.lpstrFile = lpumb->szDirName;
                lpumb->ofn.nMaxFile = 128;
                lpumb->ofn.lpstrFileTitle = lpumb->szBuffer;
                lpumb->ofn.nMaxFileTitle = 256;
                lpumb->ofn.lpstrTitle = (LPSTR)"Unzip To";
                lpumb->ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_ENABLEHOOK | OFN_HIDEREADONLY;
                lpumb->ofn.lpfnHook = lpfnSelectDir = MakeProcInstance((FARPROC)SelectDirProc, hInst);
                if (GetSaveFileName(&lpumb->ofn))
                {
                    OemToAnsi(lpumb->szDirName, lpumb->szOrigDirName);
                    SetCaption(hWnd);
                }
                else
                {

                }
                FreeProcInstance(lpfnSelectDir);
                lpumb->szBuffer[0] = '\0';
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, TRUE );
                break;

            case IDM_EXIT:
                SendMessage(hWnd, WM_CLOSE, 0, 0L);
                break;

            case IDM_HELP:  /* Display Help */
                WinHelp(hWnd,szHelpFileName,HELP_INDEX,0L);
                break;

            case IDM_HELP_HELP:
                WinHelp(hWnd,"WINHELP.HLP",HELP_INDEX,0L);
                break;

            case IDM_ABOUT:
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );
                lpfnAbout = MakeProcInstance(AboutProc, hInst);
                DialogBox(hInst, "About", hWnd, lpfnAbout);
                FreeProcInstance(lpfnAbout);
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, TRUE );
                break;

            case IDM_LISTBOX:       /* command from listbox     */
                if (cZippedFiles)
                {
                    switch (HIWORD(lParam))
                    {
                    case LBN_SELCHANGE:
                        UpdateButtons(hWnd);
                        break;
                    case LBN_DBLCLK:
                        UpdateButtons(hWnd);
                        if ( uf.fCanDragDrop )
                            DragAcceptFiles( hWnd, FALSE );
                        Action(hWnd, wLBSelection - IDM_LB_EXTRACT);
                        if ( uf.fCanDragDrop )
                            DragAcceptFiles( hWnd, TRUE );
                        break;
                    }
                }
                break;
            case IDM_LONG:
            case IDM_SHORT:
                /* If format change, uncheck old, check new. */
                if ((wParam - IDM_SHORT) != uf.fFormatLong)
                {
                    WORD wFormatTmp = wParam - IDM_SHORT;
                    int __far *pnSelItems; /* pointer to list of selected items */
                    HANDLE  hnd = 0;
                    int cSelLBItems ; /* no. selected items in listbox */
                    RECT    rClient;

                    cSelLBItems = CLBItemsGet(hWndList, &pnSelItems, &hnd);
                    CheckMenuItem(hMenu, (IDM_SHORT+uf.fFormatLong), MF_BYCOMMAND|MF_UNCHECKED);
                    CheckMenuItem(hMenu, (IDM_SHORT+wFormatTmp), MF_BYCOMMAND|MF_CHECKED);
                    uf.fFormatLong = wFormatTmp;
                    UpdateListBox(hWnd);

                    SizeWindow(hWnd, TRUE);
                    WriteProfileString(szAppName, szFormatKey, 
                                        (LPSTR)(szFormatKeyword[uf.fFormatLong]));

                    /* anything previously selected ? */
                    if (cSelLBItems > 0)
                    {
                        ReselectLB(hWndList, cSelLBItems, pnSelItems);
                        GlobalUnlock(hnd);
                        GlobalFree(hnd);
                    }

                    /* enable or disable buttons */
                    UpdateButtons(hWnd);

                    /* make sure labels & Zip archive totals get updated */
                    GetClientRect( hWnd, &rClient );
                    rClient.top = 0;
                    rClient.bottom = rClient.top + dyChar;
                    InvalidateRect( hWnd, &rClient, TRUE);
                    GetClientRect( hWndList, &rClient );
                    OffsetRect( &rClient, 0, dyChar );
                    rClient.top = rClient.bottom;
                    rClient.bottom = rClient.top + (2*dyChar);
                    InvalidateRect( hWnd, &rClient, TRUE);
                    UpdateWindow( hWnd );
                }
                break;

            case IDM_OVERWRITE:
                /* Toggle value of overwrite flag. */
                uf.fOverwrite = !uf.fOverwrite;
                CheckMenuItem(hMenu,IDM_OVERWRITE,MF_BYCOMMAND|
                                (WORD)(uf.fOverwrite ? MF_CHECKED: MF_UNCHECKED));
                WriteProfileString(szAppName, szOverwriteKey, 
                        (LPSTR)(uf.fOverwrite ? szYes : szNo ));
                break;

            case IDM_TRANSLATE:
                /* Toggle value of translate flag. */
                uf.fTranslate = !uf.fTranslate;
                CheckMenuItem(hMenu,IDM_TRANSLATE,MF_BYCOMMAND|
                                (WORD)(uf.fTranslate ? MF_CHECKED: MF_UNCHECKED));
                WriteProfileString(szAppName, szTranslateKey, 
                        (LPSTR)(uf.fTranslate ? szYes : szNo ));
                break;
            
            case IDM_UNZIP_TO_ZIP_DIR:
                /* toggle value of Unzip to .ZIP  */
                uf.fUnzipToZipDir = !uf.fUnzipToZipDir;
                CheckMenuItem(hMenu,IDM_UNZIP_TO_ZIP_DIR,MF_BYCOMMAND|
                                    (WORD)(uf.fUnzipToZipDir ? MF_CHECKED:MF_UNCHECKED));
                EnableMenuItem(hMenu,IDM_CHDIR,MF_BYCOMMAND|
                                    (WORD)(uf.fUnzipToZipDir ? MF_GRAYED:MF_ENABLED));
                WriteProfileString(szAppName, szUnzipToZipDirKey, 
                            (LPSTR)(uf.fUnzipToZipDir ? szYes : szNo ));

                if (uf.fUnzipToZipDir && lpumb->szFileName[0])
                {
                    LPSTR lpchLast;

                    /* strip off filename to make directory name    */
                    OemToAnsi(lpumb->szFileName, lpumb->szOrigDirName);
                    if ((lpchLast = lstrrchr(lpumb->szOrigDirName, '\\')) ||
                        (lpchLast = lstrrchr(lpumb->szOrigDirName, ':')))
                        *lpchLast = '\0';

                    if (lpumb->szOrigDirName[0]) /* if directory name exists, go there  */
                    {
                        lstrcpy(lpumb->szBuffer, lpumb->szOrigDirName); /* get scratch copy */
                        DlgDirList (hWnd, lpumb->szBuffer, 0, 0, 0); /* change dir */
                    }
                    SetCaption(hWnd);
                }
                break;
            case IDM_BEEP_ON_FINISH:
                /* Toggle value of beep flag. */
                uf.fBeepOnFinish = !uf.fBeepOnFinish;
                CheckMenuItem(hMenu,IDM_BEEP_ON_FINISH,MF_BYCOMMAND|
                                (WORD)(uf.fBeepOnFinish ? MF_CHECKED: MF_UNCHECKED));
                WriteProfileString(szAppName, szBeepOnFinish, 
                        (LPSTR)(uf.fBeepOnFinish ? szYes : szNo ));
                break;

            case IDM_LB_EXTRACT:
            case IDM_LB_DISPLAY:
            case IDM_LB_TEST:
                /* If overwrite change, uncheck old, check new. */
                /* wParam is the new default action */
                if (wParam != wLBSelection)
                {
                    CheckMenuItem(hMenu,wLBSelection,MF_BYCOMMAND|MF_UNCHECKED);
                    CheckMenuItem(hMenu,wParam,MF_BYCOMMAND|MF_CHECKED);

                    wLBSelection = wParam;
                    WriteProfileString(szAppName, szLBSelectionKey, 
                        (LPSTR)(LBSelectionTable[wParam - IDM_LB_EXTRACT]));
                }
                break;

            case IDM_SHOW_COMMENT:
                /* display the archive comment in mesg window */
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );
                DisplayComment(hWnd);
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, TRUE );
                break;
            case IDM_RECR_DIR_STRUCT:
                /* re-create directories structure */
                uf.fRecreateDirs = !uf.fRecreateDirs;
                CheckMenuItem(hMenu, IDM_RECR_DIR_STRUCT, 
                 MF_BYCOMMAND | (uf.fRecreateDirs ? MF_CHECKED : MF_UNCHECKED));
                WriteProfileString(szAppName, szRecreateDirsKey,
                                    (LPSTR)(uf.fRecreateDirs ? szYes : szNo));
                break;

            case IDM_DISPLAY:
            case IDM_TEST:
            case IDM_EXTRACT:
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, FALSE );
                Action(hWnd, wParam - IDM_EXTRACT);
                if ( uf.fCanDragDrop )
                    DragAcceptFiles( hWnd, TRUE );
                break;

            case IDM_SELECT_ALL:
            case IDM_DESELECT_ALL:
                if (cZippedFiles)
                {
                    SendMessage(hWndList , LB_SELITEMRANGE, 
                            (WORD)(wParam == IDM_DESELECT_ALL ? FALSE : TRUE),
                                MAKELONG(0, (cZippedFiles-1)));
                    UpdateButtons(hWnd);
                }
                break;

            case IDM_CLEAR_STATUS:  /* forward to status window */
                PostMessage(hWndStatus, WM_COMMAND, IDM_CLEAR_STATUS, 0L);
                break;

            case IDM_SHOWHIDE_STATUS:   /* status window was shown/hidden */
                uf.fStatusHidden = !uf.fStatusHidden;
                ModifyMenu(hMenu,IDM_SHOWHIDE_STATUS,
                            MF_BYCOMMAND|MF_STRING|MF_ENABLED,
                            IDM_SHOWHIDE_STATUS,
                            (uf.fStatusHidden) ? "S&how Status Window" : "&Hide Status Window");
                WriteProfileString(szAppName, szHideStatus,
                                    (LPSTR)(uf.fStatusHidden ? szYes : szNo));
                EnableWindow( hWndStatus, !uf.fStatusHidden );
                if (uf.fStatusHidden)
                    ShowWindow(hWndStatus, SW_HIDE);
                else
                    ShowWindow(hWndStatus, SW_SHOWNORMAL);
                SizeWindow(hWnd, FALSE);
                break;
                
            case IDM_MAX_STATUS:    /* status window went to the max */
            case IDM_RESTORE_STATUS:    /* status window restored   */
                /* This logic is used for maximizing the message window.
                 * It will either hide all other windows allowing the
                 * message window to grow, or it will show them,
                 * allowing the message box to resume its normal size.
                 * These two messages come from the Message window proc.
                 */
                {
                    int nWndState;  /* ShowWindow state     */
                    BOOL fWndEnabled;   /* Enable Window state */

                    if (wParam == IDM_RESTORE_STATUS)
                    {
                        ShowWindow(hWndStatus, SW_RESTORE);
                        UpdateWindow(hWndStatus);
                        uf.fStatusMaximized = FALSE;
                        fWndEnabled = TRUE;
                        nWndState = SW_SHOWNORMAL;
                    }
                    else    /* Message window goes to maximum state     */
                    {
                        uf.fStatusMaximized = TRUE;
                        nWndState = SW_HIDE;    /* assume max state     */
                        fWndEnabled = FALSE;
                    }

                    EnableWindow( hWndList, fWndEnabled);
                    UpdateWindow( hWndList);
                    ShowWindow( hWndList, nWndState);

                    if (wParam == IDM_RESTORE_STATUS) /* uncover buttons    */
                    {
                        UpdateButtons(hWnd);    /* restore to proper state  */
                    }
                    else    /* else Message window occludes buttons         */
                    {
                        EnableWindow( hExtract, fWndEnabled);
                        EnableWindow( hTest, fWndEnabled);
                        EnableWindow( hDisplay, fWndEnabled);
                        EnableWindow( hShowComment, fWndEnabled);
                    }

                    UpdateWindow( hExtract);
                    ShowWindow( hExtract, nWndState);

                    ShowWindow( hTest, nWndState);
                    UpdateWindow( hTest);

                    ShowWindow( hDisplay, nWndState);
                    UpdateWindow( hDisplay);

                    ShowWindow( hShowComment, nWndState);
                    UpdateWindow( hShowComment);

                    if (wParam == IDM_MAX_STATUS)   /* message box max'd out */
                    {
                        ShowWindow(hWndStatus, SW_SHOWMAXIMIZED);
                    }
                    SetFocus(hWndStatus);
                    SizeWindow(hWnd, FALSE);
                }
                break;

            default:
                return DefWindowProc(hWnd, wMessage, wParam, lParam);
            }
        } /* bottom of not in help mode */
        break;
    case WM_SETCURSOR:
        /* In help mode it is necessary to reset the cursor in response */
        /* to every WM_SETCURSOR message.Otherwise, by default, Windows */
        /* will reset the cursor to that of the window class. */

        if (uf.fHelp)
        {
            SetCursor(hHelpCursor);
            break;
        }
        return DefWindowProc(hWnd, wMessage, wParam, lParam);


    case WM_INITMENU:
        if (uf.fHelp)
        {
            SetCursor(hHelpCursor);
        } 
        return TRUE;

    case WM_ENTERIDLE:
        if ((wParam == MSGF_MENU) && (GetKeyState(VK_F1) & 0x8000))
        {
            uf.fHelp = TRUE;
            PostMessage(hWnd, WM_KEYDOWN, VK_RETURN, 0L);
        }
        break;

    case WM_CLOSE:
        DestroyWindow(hWnd);
        break;

    case WM_DESTROY:
        if ( uf.fCanDragDrop )
            DragAcceptFiles( hWnd, FALSE );
        DeleteObject(hBrush);
        WinHelp(hWnd, szHelpFileName, HELP_QUIT, 0L);
        PostQuitMessage(0);
        break;

    case WM_DROPFILES:
        {
            WORD    cFiles;
            WORD    cch;
            
            /* Get the number of files that have been dropped */
            cFiles = DragQueryFile( (HDROP)wParam, (UINT)-1, lpumb->szBuffer, 256);

            /* Only handle one dropped file until MDI-ness happens */
            if (cFiles == 1)
            {
                RECT    rClient;

                cch = DragQueryFile( wParam, 0, lpumb->szFileName, 128);

                if (uf.fUnzipToZipDir)
                {
                    LPSTR lpchLast;

                    /* strip off filename to make directory name    */
                    OemToAnsi(lpumb->szFileName, lpumb->szOrigDirName);
                    if ((lpchLast = lstrrchr(lpumb->szOrigDirName, '\\')) ||
                        (lpchLast = lstrrchr(lpumb->szOrigDirName, ':')))
                        *lpchLast = '\0';
                }

                UpdateListBox(hWnd); /* fill in list box */
                SendMessage(hWndList, LB_SETSEL, 1, 0L);
                UpdateButtons(hWnd); /* update state of buttons */

                GetClientRect( hWndList, &rClient );
                OffsetRect( &rClient, 0, dyChar );
                rClient.top = rClient.bottom;
                rClient.bottom = rClient.top + (2*dyChar);
                InvalidateRect( hWnd, &rClient, TRUE);
                UpdateWindow( hWnd );
                SetCaption(hWnd);
            }
            DragFinish( (HDROP)wParam );
        }
        break;

    case WM_PAINT:
        if ( !uf.fStatusMaximized )
        {
            PAINTSTRUCT ps;
            RECT    rClient;
            DWORD   dwBackColor;
            
            hDC = BeginPaint( hWnd, &ps );
            if ( hDC )
            {
                GetClientRect( hWndList, &rClient );
                if (RectVisible( hDC, &rClient ))
                    UpdateWindow( hWndList );
                hOldFont = SelectObject ( hDC, hFixedFont);
                GetClientRect( hWnd, &rClient );
                dwBackColor = SetBkColor(hDC,GetSysColor(BG_SYS_COLOR));

                rClient.top = 0;
                rClient.left += dxChar/2;
                DrawText( hDC, (LPSTR)Headers[uf.fFormatLong][0], -1, &rClient, DT_NOPREFIX | DT_TOP);

                GetClientRect( hWndList, &rClient );
                OffsetRect( &rClient, 0, dyChar+2);
                rClient.left += dxChar/2;
                rClient.top = rClient.bottom;
                rClient.bottom = rClient.top + dyChar;
                DrawText( hDC, (LPSTR)szTrailers[uf.fFormatLong], -1, &rClient, DT_NOPREFIX | DT_TOP);

                rClient.top += dyChar;
                rClient.bottom += dyChar;
                DrawText( hDC, lpumb->szTotalsLine, -1, &rClient, DT_NOPREFIX | DT_TOP);

                SetBkColor(hDC, dwBackColor);
                (void)SelectObject ( hDC, hOldFont);
            }
            EndPaint(hWnd, &ps);
            break;
        }
        /* else fall thru */
    default:
        return DefWindowProc(hWnd, wMessage, wParam, lParam);
    }
    return 0;
}
