/****************************************************************************

    PROGRAM: WizUnzip.c

    PURPOSE:  Windows Info-ZIP Unzip, an Unzipper for Windows
    FUNCTIONS:

        WinMain() - calls initialization function, processes message loop
        WizUnzipInit() - initializes window data and registers window
        WizUnzipWndProc() - processes messages
        About() - processes messages for "About" dialog box

    AUTHOR: Robert A. Heath,  157 Chartwell Rd. Columbia, SC 29210
    I place this source module, WizUnzip.c, in the public domain.  Use it as you will.
****************************************************************************/

#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>                
#include <string.h>             
#include "wizunzip.h"


static char __based(__segname("STRINGS_TEXT")) szFirstUse[] = "FirstUse"; /* first use keyword in WIN.INI */
char __based(__segname("STRINGS_TEXT")) szBeepOnFinish[] = "Beep";
char __based(__segname("STRINGS_TEXT")) szFormatKey[] = "Format";       /* Format keyword in WIN.INI        */
char __based(__segname("STRINGS_TEXT")) szOverwriteKey[] = "Overwrite"; /* Overwrite keyword in WIN.INI     */
char __based(__segname("STRINGS_TEXT")) szTranslateKey[] = "Translate"; /* Translate keyword in WIN.INI     */
char __based(__segname("STRINGS_TEXT")) szLBSelectionKey[] = "LBSelection"; /* LBSelection keyword in WIN.INI */
char __based(__segname("STRINGS_TEXT")) szRecreateDirsKey[] = "Re-createDirs"; /* re-create directory structure WIN.INI keyword             */
char __based(__segname("STRINGS_TEXT")) szUnzipToZipDirKey[] = "UnzipToZipDir"; /* unzip to .ZIP dir WIN.INI keyword */
char __based(__segname("STRINGS_TEXT")) szHideStatus[] = "HideStatusWindow";
char __based(__segname("STRINGS_TEXT")) szHelpFileName[] = "WIZUNZIP.HLP";
char __based(__segname("STRINGS_TEXT")) szYes[] = "yes";
char __based(__segname("STRINGS_TEXT")) szNo[] = "no";

/* File and Path Name variables */
char __based(__segname("STRINGS_TEXT")) szAppName[] = "WizUnzip";       /* application title        */
char __based(__segname("STRINGS_TEXT")) szStatusClass[] = "MsgWndw";/* status window class  */

                                                
/* Values for listbox selection WIN.INI keyword
 */
char * LBSelectionTable[] = {
    "extract", "display", "test" 
};
#define LBSELECTIONTABLE_ENTRIES (sizeof(LBSelectionTable)/sizeof(char *))

HANDLE hInst;               /* current instance */
HMENU  hMenu;               /* main menu handle */
HANDLE hAccTable;

HANDLE hHourGlass;          /* handle to hourglass cursor        */
HANDLE hSaveCursor;         /* current cursor handle         */
HANDLE hHelpCursor;         /* help cursor                      */
HANDLE hFixedFont;          /* handle to fixed font             */
HANDLE hOldFont;            /* handle to old font               */

int hFile;                /* file handle             */
HWND hWndMain;        /* the main window handle.                */
HWND hWndList;            /* list box handle        */
HWND hWndStatus;        /* status   (a.k.a. Messages) window */
HWND hExtract;          /* extract button               */
HWND hDisplay;          /*display button                */
HWND hTest;             /* test button              */
HWND hShowComment;          /* show comment button          */

UF  uf;

/* Global values defined by WIN.INI settings: */
#if 0
BOOL bHelp = FALSE;     /* Shift-F1 has been struck when TRUE       */
BOOL bRecreateDirs; /* re-create directory structures when TRUE */
BOOL bTranslate = FALSE;    /* translate LF to CR-LF                    */
WORD wFormat = 0;       /* display format: 0 = short, 1 = long */
BOOL bOverwrite = FALSE;    /* overwrite or prompt: IDM_OVERWRITE, IDM_PROMPT */
BOOL bUnzipToZipDir = FALSE; /* unzip only to .ZIP directory        */
BOOL bBeepOnFinish = FALSE;
BOOL bDoAll;
BOOL bIconSwitched = FALSE; /* set true after 1st valid action  */

BOOL bStatusMaxed = FALSE;  /* status box is maximized      */
#endif
WORD wLBSelection = IDM_LB_DISPLAY; /* default listbox selection action */



HBRUSH hBrush ;         /* brush for  standard window backgrounds  */

LPUMB   lpumb;
HANDLE  hStrings;

int ofretval;       /* return value from initial open if filename given */

WORD cZippedFiles;      /* total personal records in file   */
WORD cListBoxLines; /* max list box lines showing on screen */
WORD cLinesMessageWin; /* max visible lines on message window  */
WORD cchComment;            /* length of comment in .ZIP file   */


/* Forward References */
int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
long FAR PASCAL WizUnzipWndProc(HWND, WORD, WORD, LONG);


/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

    COMMENTS:

        This will initialize the window class if it is the first time this
        application is run.  It then creates the window, and processes the
        message loop until a WM_QUIT message is received.  It exits the
        application by returning the value passed by the PostQuitMessage.

****************************************************************************/

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;         /* current instance             */
HANDLE hPrevInstance;     /* previous instance            */
LPSTR lpCmdLine;          /* command line                 */
int nCmdShow;             /* show-window type (open/icon) */
{
    int i;


    if (!hPrevInstance)                 /* Has application been initialized? */
        if (!WizUnzipInit(hInstance))
            return 0;              /* Exits if unable to initialize     */


    hStrings = GlobalAlloc( GPTR, (DWORD)sizeof(UMB));
    if ( !hStrings )
        return 0;

    lpumb = (LPUMB)GlobalLock( hStrings );
    if ( !lpumb )
    {
        GlobalFree( hStrings );
        return 0;
    }
#if 0
    lpszDirName = lpszFileName + 128;
    lpszOrigDirName = lpszDirName + 128;
    lpszTotalsLine = lpszOrigDirName + 128;
    lpszBuffer = lpszTotalsLine + 80;
    lpmsg = (MSG __far *)(lpszBuffer + 256);
    lpOfStruct = (OFSTRUCT __far *)(((char __far *)lpmsg) + sizeof(MSG));
    lpofn = (OPENFILENAME __far *)(((char __far *)lpOfStruct) + sizeof(OFSTRUCT));
#endif

    uf.fCanDragDrop = FALSE;
    if (hHourGlass = GetModuleHandle("SHELL"))
    {
        if (GetProcAddress(hHourGlass, "DragAcceptFiles" ))
            uf.fCanDragDrop = TRUE;
    }
    
    if (_fstrlen(lpCmdLine))            /* if filename passed on start-up   */
    {
        if ((ofretval = OpenFile(lpCmdLine, &lpumb->of, OF_EXIST)) >= 0)
        {
            lstrcpy(lpumb->szFileName, lpumb->of.szPathName); /* save file name */
        }
    }

    /* Get initial Re-create dirs format */
    GetProfileString(szAppName, szRecreateDirsKey, szNo, lpumb->szBuffer, 256);
    uf.fRecreateDirs = (BOOL)(!lstrcmpi(lpumb->szBuffer, szYes));

    /* Get translate flag */
    GetProfileString(szAppName, szTranslateKey, szNo, lpumb->szBuffer, 256);
    uf.fTranslate = (BOOL)(!lstrcmpi(lpumb->szBuffer, szYes));

    /* Get initial display format: short or long */
    GetProfileString(szAppName, szFormatKey, "long", lpumb->szBuffer, 256);
    uf.fFormatLong = (WORD)(!lstrcmpi(lpumb->szBuffer, "long") ? 1 : 0);

    /* Get overwrite option: yes=IDM_OVERWRITE, no=IDM_PROMPT */
    GetProfileString(szAppName, szOverwriteKey, szNo, lpumb->szBuffer, 256);
    uf.fOverwrite = (BOOL)(!lstrcmpi(lpumb->szBuffer, szYes));

    /* Get Unzip to .ZIP dir option: yes or no  */
    GetProfileString(szAppName, szUnzipToZipDirKey, szNo, lpumb->szBuffer, 256);
    uf.fUnzipToZipDir = (BOOL)(!lstrcmpi(lpumb->szBuffer, szYes));

    /* Get Unzip to .ZIP dir option: yes or no  */
    GetProfileString(szAppName, szBeepOnFinish, szNo, lpumb->szBuffer, 256);
    uf.fBeepOnFinish = (BOOL)(!lstrcmpi(lpumb->szBuffer, szYes));

    /* Get Hide Status Window option */
    GetProfileString(szAppName, szHideStatus, szNo, lpumb->szBuffer, 256);
    uf.fStatusHidden = (BOOL)(!lstrcmpi(lpumb->szBuffer, szYes));

    /* Get default listbox selection operation */
    GetProfileString(szAppName, szLBSelectionKey, "display", lpumb->szBuffer, 256);

    for (i = 0; i < LBSELECTIONTABLE_ENTRIES &&
        lstrcmpi(LBSelectionTable[i], lpumb->szBuffer) ; i++)
    {
        ;
    }

    wLBSelection = IDM_LB_DISPLAY;      /* assume default is to display     */
    if (i < LBSELECTIONTABLE_ENTRIES)
        wLBSelection = IDM_LB_EXTRACT + i;

    hWndMain = CreateWindow(szAppName,  /* window class     */
        szAppName,                      /* window name      */
        WS_OVERLAPPEDWINDOW,            /* window style     */
        0,                              /* x position       */
        0,                              /* y position       */
        CW_USEDEFAULT,                  /* width            */
        0,                              /* height           */
        (HWND)0,                        /* parent handle    */
        (HWND)0,                        /* menu or child ID */
        hInstance,                      /* instance         */
        NULL);                          /* additional info  */

    if ( !hWndMain )
        return 0;

    /* On first use, throw up About box, saying what WizUnzip is, etc.
     */
    GetProfileString(szAppName, szFirstUse, szYes, lpumb->szBuffer, 256);
    if (!lstrcmpi(lpumb->szBuffer, szYes))
    {
        WriteProfileString(szAppName, szFirstUse, szNo);
        PostMessage(hWndMain, WM_COMMAND, IDM_ABOUT, 0L);
    }
    hHelpCursor = LoadCursor(hInstance, "HelpCursor");

    ShowWindow(hWndMain, nCmdShow);
    UpdateWindow(hWndMain);

    while ( GetMessage(&lpumb->msg, 0, 0, 0) )
    {
        if ( !TranslateAccelerator(hWndMain, hAccTable, &lpumb->msg) )
        {
            TranslateMessage(&lpumb->msg);
            DispatchMessage(&lpumb->msg);
        }
    }
    /* Don't turn on compiler aliasing or C7 will move */
    /* the following assignment after the GlobalFree() */
    /* which contains the memory for pumb! */
    i = (int)lpumb->msg.wParam;

    GlobalUnlock( hStrings );
    GlobalFree( hStrings );

    return i;
}
