#include <sys/types.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

main(int argc, char *argv[] ) {
  int s; /* socket descriptor */
  struct sockaddr_in sa;
  int l;
  struct hostent *hp;
  char **p;
  
  if( argc < 3 || !sscanf(argv[1],"%d",&s) ) {
    fprintf(stderr,"Usage:\n%s socketN name1 name2 ...\n\n\
Where:\n\tsocketN -\tnumber of answered socket\n\
\tname1.. -\tlist of official host names\n\n\
The programm will exit with errorlevel equil to found name or 200 on error\n\
or errorlevel 0 if no errors occured, but hostname not in list\n\
For example:\n\
%s 787 ftp.my.net ftp-os2.my.net ftp-w95.my.net\n\
will exit with errorlevel 2 if TCP connection is established to\n\
ftp-os2.my.net address\n\n\
Use it from inetd for multi-domain daemons\n", argv[0], argv[0]);
    exit(200);
  }
  
#ifdef DEBUG
  printf("Initing socks\n");
#endif
  if( sock_init() ) {
    fprintf(stderr,"Can't initialize sockets\n");
    exit(200);
  }
  
#ifdef DEBUG
  printf("Getting socket name\n");
#endif
  l = sizeof(sa);
  if( getsockname(s,(struct sockaddr*)&sa,&l) == -1 ) {
    perror("Error");
    exit(200);
  }
  
  hp = gethostbyaddr((char*)&sa.sin_addr.s_addr, 4, AF_INET);
  if( !hp ) {
    fprintf(stderr,"Can't resolve hostname\n");
    exit(200);
  }
  
#ifdef DEBUG
  printf("%s\n", hp->h_name);
#endif
  for(l=2; l < argc; l++)
    if( !stricmp(argv[l],hp->h_name) ) {
#ifdef DEBUG
      printf("Errorlevel %d\n",l-1);
#endif
      exit(l-1);
    }
  
  exit(0);
}