//Filename: MAINWND.C                                       
//"HEAPTEST" Generated by WindowsMAKER Professional         
//Author: Gen Kiyooka                                       

//
// Code in this file is initially generated by WindowsMAKER Professional. 
// This (or other code modules you have established) is where you will want 
// to add your user code.
// A prefix of BLD_ identifies that the function was generated with 
// WindowsMAKER Professional.
// These Suffixes identify the function type:
//	 DlgFunc	Dialog Box startup
//	 DlgProc	Dialog Box procedure
//	 UDCFunc	User Defined Code - place holder for adding your code
//	 ExeFunc	Startup of DOS/Windows executable
//	 MenuFunc	Switch menu set
// For more information see the section "How Code is Generated" in the 
// documentation. 
 
 
#include <WINDOWS.H>
#include "HEAPTEST.H"

#include "HEAP.H"
 
WMPDEBUG
#include "MAINWND.WMC"
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** NAME: WINDOW_CenterOnScreen 
**   This function takes a Window, and without changing the
**   size, repositions it in the center of the physical display.
**
**   PARAMETERS:
**     IN: hWnd - HWND to self
**     
**   ATTRIBUTES: EXPORT QUALIFIED
**
**   RETURNS: TRUE if succesful
*/
BOOL PASCAL WINDOW_CenterOnScreen( HWND hWnd)
{
BOOL bOk = FALSE;
   if (IsWindow(hWnd))
      {
   RECT windowRect;
   int nWidth, nHeight;
   int nScreenWidth, nScreenHeight;
   int nNewX, nNewY;
      GetWindowRect( hWnd, (LPRECT) &windowRect);
      nWidth = windowRect.right - windowRect.left;
      nHeight = windowRect.bottom - windowRect.top;
      nScreenWidth = GetSystemMetrics( SM_CXSCREEN);
      nScreenHeight = GetSystemMetrics( SM_CYSCREEN);
      nNewX = (nScreenWidth/2) - (nWidth/2);
      nNewY = (nScreenHeight/2) - (nHeight/2);
      MoveWindow( hWnd, nNewX, nNewY, nWidth, nHeight, TRUE);
      }
   return bOk;
}

HANDLE hHeap = (HANDLE)NULL;		// This handle identifies the Heap
LPSTR  lpMem = (LPSTR)NULL;		// This pointer identifies a chunk of memory from the heap
 
BOOL BLD_HeapCreateUDCFunc(HWND hWnd, UINT message, UINT wParam, LONG lParam ) 
   {
	if (!hHeap)
		{
		hHeap = HeapCreate( 0, 512, 0 );
		if (hHeap)
			MessageBox( hWnd, "Heap Created.", "Say....", MB_OK );
		}
   return TRUE;
   }

BOOL BLD_HeapDestroyUDCFunc(HWND hWnd, UINT message, UINT wParam, LONG lParam ) 
   {
	if (hHeap)
		{
		HeapDestroy( hHeap );
		hHeap = (HANDLE)NULL;
		MessageBox( hWnd, "Heap Destroyed.", "Say....", MB_OK );
		}
   return TRUE;
   }

 
BOOL BLD_HeapAllocUDCFunc(HWND hWnd, UINT message, UINT wParam, LONG lParam ) 
   {
	if ( hHeap && !lpMem )
		{
	BOOL fTranslated = FALSE;
	UINT cbAlloc = GetDlgItemInt( hWnd, IDEC_SIZE, &fTranslated, FALSE );
		if (fTranslated)
			{
			lpMem = HeapAlloc( hHeap, cbAlloc );
			if (lpMem)
				MessageBox( hWnd, "Heap Alloc succeeded.", "Say....", MB_OK );
			}
		}
   return TRUE;
   }

 
BOOL BLD_HeapSizeUDCFunc(HWND hWnd, UINT message, UINT wParam, LONG lParam ) 
   {
	if ( hHeap && lpMem )
		{
	UINT cbSize = HeapSize( hHeap, lpMem );
		SetDlgItemInt( hWnd, IDEC_SIZE, cbSize , FALSE);
		}
   return TRUE;
   }

 
BOOL BLD_HeapFreeUDCFunc(HWND hWnd, UINT message, UINT wParam, LONG lParam ) 
   {
	if ( hHeap && lpMem )
		{
		if (HeapFree( hHeap, lpMem ))
			MessageBox( hWnd, "Heap Free succeeded.", "Say....", MB_OK );
		lpMem = 0;
		}
   return TRUE;
   }

// Startup procedure for window in client area 
HWND BLD_MainWinControlsClFunc(HWND hWnd, UINT message, UINT wParam, LONG lParam ) 
   {
FARPROC 	lpNew = MakeProcInstance((FARPROC)BLD_MainWinControlsClProc,hInst);
HWND 		hNew = BLDCreateClientControls("MAINWND",lpNew);    
   if (!hNew)
      {
      FreeProcInstance(lpNew);
      BLDDisplayMessage(hWnd,BLD_CannotCreate,"MAINWND", MB_OK | MB_ICONHAND);
      }
   return hNew;
   }
 
BOOL FAR PASCAL BLD_MainWinControlsClProc(HWND hDlg, UINT message, UINT wParam, LONG lParam)
   {
   switch(message)
      {
   case WM_NCDESTROY:
      FreeProcInstance(lpClient);
      hClient = 0;
      break;

   default:
      return BLD_MainWinControlsDlgDefault(hDlg,message,wParam,lParam); 
      break;
      }
   return TRUE;
   }

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** NAME: BLD_AboutDlgFunc 
**	  Create the dialog box.
**
**   ATTRIBUTES: EXPORT QUALIFIED
**
**   RETURNS: TRUE if successful
*/ 
int BLD_AboutDlgFunc(HWND hWnd, UINT message, UINT wParam, LONG lParam ) 
   {
   int ReturnValue;
   FARPROC lpProc;

   lpProc      = MakeProcInstance((FARPROC)BLD_AboutDlgProc,hInst);
   ReturnValue = -1;
   if (lpProc)
      {
      ReturnValue = DialogBox(hInst, (LPSTR)"ABOUT", hWnd, lpProc);
      FreeProcInstance(lpProc);
      }
   if (ReturnValue==-1)
      BLDDisplayMessage(hWnd,BLD_CannotCreate,"ABOUT",MB_OK | MB_ICONHAND);
   return ReturnValue;
   }
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** NAME: BLD_AboutDlgProc 
**	  Do the about DlgProc thang.
**
**   PARAMETERS:
**
**   ATTRIBUTES: EXPORT QUALIFIED
**
**   RETURNS: TRUE if message processed
*/ 
BOOL FAR PASCAL BLD_AboutDlgProc(HWND hDlg, UINT message, UINT wParam, LONG lParam)
   {
   switch(message)
      {
   case WM_INITDIALOG:
		WINDOW_CenterOnScreen( hDlg );
      return BLD_AboutDlgDefault(hDlg,message,wParam,lParam);
      break;

   case WM_COMMAND:
      EndDialog(hDlg,IDOK);
      break;

   default:
      return BLD_AboutDlgDefault(hDlg,message,wParam,lParam); 
      break;
      }
   return TRUE;
   }

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** NAME: BLD_ExitUDCFunc 
**	  Exactly as the name suggests.
**
**   ATTRIBUTES: EXPORT QUALIFIED
**
**   RETURNS: TRUE if successful
*/ 
BOOL BLD_ExitUDCFunc(HWND hWnd, UINT message, UINT wParam, LONG lParam ) 
   {
	PostQuitMessage( 0 );
   return TRUE;
   }

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** NAME: BLD_WM_NCLBUTTONDOWNMsg 
**	  Handle the WM_NCLBUTTON down message with a little magic.
*/ 
LONG BLD_WM_NCLBUTTONDOWNMsg(HWND hWnd, UINT message, UINT wParam, LONG lParam )
   {
	switch (wParam)
		{
		case HTBOTTOM:
		case HTBOTTOMLEFT:
		case HTBOTTOMRIGHT:
		case HTGROWBOX:
		case HTLEFT:
		case HTRIGHT:
		case HTTOP:
		case HTTOPLEFT:
		case HTTOPRIGHT:
			wParam = HTCAPTION;
		default:
		   return DefWindowProc(hWnd, message, wParam, lParam);
		}
	return 0L;
   }
