#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#define BPT_LNODE 1
#define BPT_INODE 2
#define BPT_NOSPECIAL 0
#define BPT_FIRST     1
#define BPT_LAST      2
struct TAGTree;
struct TAGTreeNode;
struct TAGINode;
struct TAGLNode;

#ifdef __WINMEM__
   void FAR * FAR Malloc( DWORD bytes );
   void FAR Free( void FAR *memory );
   #define StrLen lstrlen
   #define StrCpy lstrcpy
   #define StrCmp lstrcmp
   #define LIBFUNC FAR
   typedef void FAR *DATAPTR;
   typedef char FAR *KEYPTR;
#else
   #define Malloc malloc
   #define Free free
   #define StrLen strlen
   #define StrCpy strcpy
   #define StrCmp strcmp
   #define WORD unsigned int
   #define LONG long
   #define LPSTR char *
   #define FAR
   #define LIBFUNC
   typedef void *DATAPTR;
   typedef char *KEYPTR;
#endif

struct TAGLNode {
   KEYPTR  keyValue;
   WORD    specialType;
   DATAPTR data;
   struct TAGTreeNode FAR *next;
   struct TAGTreeNode FAR *prev;
};

struct TAGINode {
   KEYPTR keyValue;
   struct TAGTreeNode FAR *left;
   struct TAGTreeNode FAR *right;
};

typedef struct TAGTreeNode {
   WORD nodeType;
   union {
      struct TAGINode inode;
      struct TAGLNode lnode;
   };
} TREENODE, FAR *TREENODEPTR;
typedef TREENODEPTR FAR *PTR2TREENODEPTR;
typedef struct TAGTree {
   struct TAGTreeNode FAR *curPointer;
   struct TAGTreeNode first;
   struct TAGTreeNode last;   
   struct TAGTreeNode FAR *tree;
} TREE, FAR *TREEPTR;

TREEPTR        LIBFUNC NewTree( void );  
TREENODEPTR    LIBFUNC InsertInTree( TREEPTR tree, KEYPTR key, DATAPTR data );
DATAPTR        LIBFUNC DeleteFromTree( TREEPTR tree, KEYPTR key );
TREENODEPTR    LIBFUNC FindInTree( TREEPTR tree, KEYPTR key );
TREENODEPTR    LIBFUNC FirstInTree( TREEPTR tree );
TREENODEPTR    LIBFUNC LastInTree( TREEPTR tree ); 
TREENODEPTR    LIBFUNC NextInTree( TREEPTR tree );
TREENODEPTR    LIBFUNC PrevInTree( TREEPTR tree );
KEYPTR         LIBFUNC NodeKeyValue( TREENODEPTR tNode );
DATAPTR        LIBFUNC NodeDataValue( TREENODEPTR tNode );
TREENODEPTR    LIBFUNC MakeINode( void );
void           LIBFUNC FreeINode( TREENODEPTR tNode );
TREENODEPTR    LIBFUNC MakeLNode( void );
void           LIBFUNC FreeLNode( TREENODEPTR tNode );
LPSTR          LIBFUNC MakeMemBuf( int size );
void           LIBFUNC FreeMemBuf( KEYPTR szBuf );

