library AMeta;

uses WinProcs, WinTypes, Win31;

Type
	AldusHeader = Record
  	Key:LongInt;
    hMF:Integer;
    BBox:TRECT;
    Inch:Integer;
    Reserved:LongInt;
    CheckSum:Integer;
  end;

function LoadWMF (FName:PChar; var Place:TRect;
var nUnit:Integer):THandle;export;
Var
  hFile:Integer;
  hMem:THandle;
  AHeader:AldusHeader;
  lpMFBits:Pointer;
  MHeader:TMetaHeader;

Begin
	hFile := _lOpen (FName, OF_READ);
  _lRead (hFile, @AHeader, SizeOf (AHeader));
  If AHeader.Key = $9AC6CDD7 then
  	begin
		  CopyRect (Place, AHeader.BBox);
      nUnit := AHeader.Inch;
		  _lRead (hFile, @MHeader, SizeOf (MHeader));
	    _llSeek (hFile, SizeOf (AHeader), 0);
    end
  else
  	begin
      _llSeek (hFile, 0, 0);
		  _lRead (hFile, @MHeader, SizeOf (MHeader));
	    _llSeek (hFile, 0, 0);
    end;
  hMem := GlobalAlloc (GHND, MHeader.mtSize * 2);
  lpMFBits := GlobalLock (hMem);
  {_lRead (hFile, lpMFBits, MHeader.mtSize * 2);}
  _hRead (hFile, lpMFBits, MHeader.mtSize * 2);
  _lClose (hFile);
  PMetaHeader (lpMFBits)^.mtType := 1;
  GlobalUnlock (hMem);
  LoadWMF := SetMetaFileBits (hMem);
end;

procedure Meta2Aldus (SrcMeta:THandle; var Place:TRect;
                    nUnit:Integer; FName:PChar);export;
Var
	Header:AldusHeader;
  hFile:Integer;
  hCopy:THandle;
  MFSize:LongInt;
  lpMFBits:Pointer;

Begin
  Header.Key := $9AC6CDD7;
  Header.CheckSum := $CDD7 Xor $9AC6;
  Header.hMF := 0;
  CopyRect (Header.BBox, Place);
  Header.CheckSum := Header.CheckSum Xor Place.Top;
  Header.CheckSum := Header.CheckSum Xor Place.Left;
  Header.CheckSum := Header.CheckSum Xor Place.Bottom;
  Header.CheckSum := Header.CheckSum Xor Place.Right;
  Header.Inch := nUnit;
  Header.CheckSum := Header.CheckSum Xor Header.Inch;
  Header.Reserved := 0;
  hFile := _lCreat (FName, 0);
  _lwrite (hFile, @Header, SizeOf (Header));
  hCopy := CopyMetaFile (SrcMeta, nil);
  hCopy := GetMetaFileBits(hCopy);
  MFSize := GlobalSize (hCopy);
  lpMFBits := GlobalLock (hCopy);
  {_lWrite (hFile, lpMFBits, MFSize);}
  _hWrite (hFile, lpMFBits, MFSize);
  _lClose (hFile);
  GlobalUnlock (hCopy);
  GlobalFree (hCopy);
end;


Exports
  LoadWMF resident,
	Meta2Aldus resident;

Begin
End.
