/*
 * FAULT.C
 */

#include <windows.h>
#include <toolhelp.h>
#include "fault.h"


HANDLE      hInst;
CATCHBUF    cb;                         //Stores register state.
LPCATCHBUF  pCB=(LPCATCHBUF)&cb;        //Convenient pointer for the handler
BOOL        fTrapGPFault;


/*
 * WinMain the Ubiquitous
 */

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
    {
    WNDCLASS        wc;
    MSG             msg;
    HWND            hWnd;

    hInst=hInstance;

    if (!hPrevInstance)
        {
        wc.style         = CS_HREDRAW | CS_VREDRAW;
        wc.lpfnWndProc   = FaultWndProc;
        wc.cbClsExtra    = 0;
        wc.cbWndExtra    = 0;
        wc.hInstance     = hInstance;
        wc.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(IDR_ICON));
        wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground = COLOR_APPWORKSPACE + 1;
        wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU);
        wc.lpszClassName = "Fault";

        if (!RegisterClass(&wc))
            return FALSE;
        }

    hWnd=CreateWindow("Fault", "GP Fault Handler",
                      WS_MINIMIZEBOX | WS_OVERLAPPEDWINDOW,
                      CW_USEDEFAULT, CW_USEDEFAULT, 400, 120,
                      NULL, NULL, hInstance, NULL);

    if (NULL==hWnd)
        return FALSE;

    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);

    while (GetMessage(&msg, NULL, 0,0 ))
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }

    return msg.wParam;
    }




/*
 * FaultWndProc
 */

long FAR PASCAL FaultWndProc(HWND hWnd, UINT iMsg, UINT wParam, LONG lParam)
    {
    HANDLE              hMem;
    LPSTR               psz;
    UINT                i;
    static FARPROC      pfnInt=NULL;

    switch (iMsg)
        {
        case WM_CREATE:
            pfnInt=MakeProcInstance((FARPROC)FaultHandler, hInst);

            if (NULL!=pfnInt)
                {
                //If we fail to register, fail the create and the application.
                if (!InterruptRegister(NULL, pfnInt))
                    {
                    MessageBox(hWnd, "InterruptRegister Failed.",
                               "Fatal Error", MB_OK);
                    return -1L;
                    }
                }
            break;


        case WM_DESTROY:
            if (NULL!=pfnInt)
                {
                InterruptUnRegister(NULL);
                FreeProcInstance(pfnInt);
                }

            PostQuitMessage(0);
            break;


        case WM_COMMAND:
            switch (wParam)
                {
                case IDM_CAUSEGPFAULT:
                    hMem=GlobalAlloc(GMEM_MOVEABLE, 512);
                    psz=GlobalLock(hMem);

                    for (i=0; i<512; i++)    //Fill the memory with non-zeros
                        psz[i]='X';

                    //Should GP Fault--there's no NULL terminator
                    if (-1==SomeStrLen(psz))
                        {
                        MessageBox(hWnd, "SomeStrLen failed on GP Fault",
                                   "Fault", MB_OK | MB_ICONEXCLAMATION);
                        }
                    else
                        {
                        //This should NOT happen.
                        MessageBox(hWnd, "IMPOSSIBLE: Missed a GP Fault?!?",
                                   "Fault", MB_OK | MB_ICONHAND);
                        }

                    GlobalUnlock(hMem);
                    GlobalFree(hMem);
                    break;
                }
            break;


        default:
            return (DefWindowProc(hWnd, iMsg, wParam, lParam));
        }

    return 0L;
    }



/*
 * SomeStrLen:  A bulletproof strlen.
 */

UINT FAR PASCAL SomeStrLen(LPSTR psz)
    {
    UINT        cch=0;

    fTrapGPFault=TRUE;

    if (!Catch((LPCATCHBUF)&cb))
        return -1;

    while (*psz++!=0)
        cch++;

    fTrapGPFault=FALSE;
    return cch;
    }
