// winapp.h

#if !defined(WINAPP_H)
#define WINAPP_H

#include<dos.h>
#include<windows.h>

extern void *pWindow;

const unsigned WINAPP_RESERVED = sizeof(void *);
inline void *GetPointer(HWND hWnd)
    {
#if defined(__SMALL__) || defined(__MEDIUM__)
    return (void *)GetWindowWord(hWnd,0);
#elif defined(__LARGE__) || defined(__COMPACT__) || defined(__HUGE__)
    return (void *)GetWindowLong(hWnd,0);
#else
    #error Must use Small, Medium, Large, Compact or Huge models!
#endif
    }

inline void SetPointer(HWND hWnd, void *ptr)
    {
#if defined(__SMALL__) || defined(__MEDIUM__)
    SetWindowWord(hWnd,0,(WORD)ptr);
#elif defined(__LARGE__) || defined(__COMPACT__) || defined(__HUGE__)
    SetWindowLong(hWnd,0,(LONG)ptr);
#else
    #error Must use Small, Medium, Large, Compact or Huge models!
#endif
    }

/* WINAPPLICATION:
An object of this class is defined once for every application. It contains the
items passed to WinMain, as well as access functions for returning them. The
constructor initializes them.
*/
extern HINSTANCE _hInstance, _hPrev;
extern int _cmdShow;
extern unsigned int _psp, _pszCmdline;

class WinApplication    // Windows application class
    {
    static HINSTANCE ApphInstance;
    static HINSTANCE hPrevInstance;
    static LPSTR lpszCmdLine;
    static int nCmdShow;
public:
    WinApplication(void)
        {
        ApphInstance = _hInstance;
        hPrevInstance = _hPrev;
        lpszCmdLine = (LPSTR)MK_FP(_psp,_pszCmdline);
        nCmdShow = _cmdShow;
        }
    static HINSTANCE GetInstance(void)     { return ApphInstance;  }
    static HINSTANCE GetPrevInstance(void) { return hPrevInstance; }
    static LPSTR GetCmdLine(void)       { return lpszCmdLine;   }
    static int GetCmdShow(void)         { return nCmdShow;      }
    static int Run(void);    // default message loop processing
   };

   
/* WINCLASS
*/
const NOSTYLE = 0;
const NOEXTRABYTES = 0;

class WinClass : public WNDCLASS
    {
    BOOL    class_registered;
public:
    WinClass(void);
    void ClassRegister(void);
    BOOL ClassRegistered(void);
    };

/* WINHANDLE
An object of this class is created with every instance of Window (below). It
contains data that controls Window creation handling, as well as the window
handle.
 */

class WinHandle
    {
    HWND hWnd;
    LPCSTR classname;
    LPSTR windowname;
    DWORD winstyle;
    int upper_left_x;
    int upper_left_y;
    int winwidth;
    int winheight;
    HWND winParent;
    HMENU menu;
    HINSTANCE hInstance;
    LPSTR lpParam;

public:
    WinHandle(void);
    HWND GetHandle(void) { return hWnd; }
    BOOL Create(void);
    
    friend class Window;    // allow Window to modify members
    };


/* WINDOW

Every window is derived from this abstract class.

Every class derived from this one must have a WinClass object (or a pointer
to one created by a derived class) and pass it back to Window.

And each must supply its own WndProc for the class.
*/
class Window : public WinApplication, public WinClass
    {
public:
//    HWND WHandle;
private:
#if defined(ARCHAIC)
    static long far pascal WndProc(HWND, WORD, WORD, LONG);
#endif
    static LRESULT CALLBACK MDIChildWndProc(HWND, UINT, WPARAM, LPARAM);
 
protected:
    WinHandle WHdl;
private:
    int     current_display;
    int     previously_visible;
//    long (far pascal *UserWndProc)(HWND, WORD, WORD, LONG);

    void    Show(void)
        { previously_visible = ShowWindow(hWnd,current_display); }
    void SetClassWinXbytes(int xtrabytes)    
        { cbWndExtra = xtrabytes; }

protected:
    WORD wParam;
    LONG lParam;
    WORD msg;
    HWND hWnd;
    LONG MsgReturnValue;
    BOOL UserMessageUsed;

public:
    Window(char *winname);
        // displays window and creates if not already created
    BOOL Display(void);
    BOOL Display(int display_style);
    BOOL ClassRegistered(void);
        // should call SetClassInstance and SetClassName if not called
    void RegisterMDIChild(void);
    void Register(void);
    BOOL Create(void);
    HWND GetHandle(void)        { return WHdl.hWnd;                 }

    void Hide(void)             { Display(SW_HIDE);                 }
    void Minimize(void)         { Display(SW_MINIMIZE);             }
    void Maximize(void)         { Display(SW_SHOWMAXIMIZED);        }
        // displays window in original size and position
    void Normalize(void)        { Display(SW_SHOWNORMAL);           }
    void DefaultDisplay(void)   { current_display = GetCmdShow();   }
    void Paint(void);
    void Update(void)           { UpdateWindow(hWnd);            }

            // vocab of functions for modifying the registration info
    void SetClassInstance(void)         { hInstance = GetInstance();    }
    void SetClassName(LPSTR classname)  { lpszClassName = classname;    }
    void SetClassStyle(unsigned newstyle)   { style = newstyle;         }
    void AddClassStyle(unsigned addstyle)   { style |= addstyle;        }
//    void SetClassWinProc(long (FAR PASCAL *lpfnWndProc)(HWND, unsigned, 
//        WORD, LONG))            {   UserWndProc = lpfnWndProc;      }
    void AddClassWinXbytes(int xtrabytes)   { cbWndExtra += xtrabytes;  }
    void SetClassIcon(LPSTR iconname);
    void SetClassBackGround(HBRUSH handle)  {   hbrBackground = handle; }

    LPCSTR GetClassName(void)            { return lpszClassName;         }
    void SetClassMenu(LPSTR menuname)   {   lpszMenuName = menuname;    }

        // vocab of functions for modifying the create info
    void SetWinClassName(LPCSTR classname)   { WHdl.classname = classname;}
    void SetWinName(LPSTR winname)  { WHdl.windowname = winname;        }
    LPSTR GetWinName(void)          { return WHdl.windowname;           }
    void SetWinStyle(DWORD dword)   { WHdl.winstyle = dword;            }
    void AddWinStyle(DWORD dword)   { WHdl.winstyle |= dword;           }
    void SetWinX(int x)             { WHdl.upper_left_x = x;            }
    void SetWinY(int y)             { WHdl.upper_left_y = y;            }
    void SetWinWidth(int width)     { WHdl.winwidth = width;            }
    void SetWinHeight(int height)   { WHdl.winheight = height;          }
    void SetWinParent(HWND hWnd)    { WHdl.winParent = hWnd;            }
    void SetWinMenu(HMENU hmenu)    { WHdl.menu = hmenu;                }
    void SetWinInstance(HINSTANCE hinst){ WHdl.hInstance = hinst;          }
    void SetWinParams(LPSTR param)  { WHdl.lpParam = param;             }

    void pascal DWP(void);
    virtual void UserMessages(void)         {};
    virtual void WMNULL(void)	            {	 DWP();	}
    virtual void WMCREATE(void)	            {	 DWP();	}
    virtual void WMDESTROY(void)	        {	 DWP();	}
    virtual void WMMOVE(void)	            {	 DWP();	}
    virtual void WMSIZE(void)	            {	 DWP();	}
    virtual void WMACTIVATE(void)	        {	 DWP();	}
    virtual void WMSETFOCUS(void)	        {	 DWP();	}
    virtual void WMKILLFOCUS(void)          {	 DWP();	}
    virtual void WMENABLE(void)	            {	 DWP();	}
    virtual void WMSETREDRAW(void)          {	 DWP();	}
    virtual void WMSETTEXT(void)	        {	 DWP();	}
    virtual void WMGETTEXT(void)	        {	 DWP();	}
    virtual void WMGETTEXTLENGTH(void)	    {	 DWP();	}
    virtual void WMPAINT(void)	            {	 DWP();	}
    virtual void WMCLOSE(void)	            {	 DWP();	}
    virtual void WMQUERYENDSESSION(void)	{	 DWP();	}
    virtual void WMQUIT(void)	            {	 DWP();	}
    virtual void WMQUERYOPEN(void)	        {	 DWP();	}
    virtual void WMERASEBKGND(void)	        {	 DWP();	}
    virtual void WMSYSCOLORCHANGE(void)	    {	 DWP();	}
    virtual void WMENDSESSION(void)	        {	 DWP();	}
    virtual void WMSHOWWINDOW(void)	        {	 DWP();	}
    virtual void WMCTLCOLOR(void)	        {	 DWP();	}
    virtual void WMWININICHANGE(void)	    {	 DWP();	}
    virtual void WMDEVMODECHANGE(void)      {	 DWP();	}
    virtual void WMACTIVATEAPP(void)	    {	 DWP();	}
    virtual void WMFONTCHANGE(void)	        {	 DWP();	}
    virtual void WMTIMECHANGE(void)	        {	 DWP();	}
    virtual void WMCANCELMODE(void)	        {	 DWP();	}
    virtual void WMSETCURSOR(void)	        {	 DWP();	}
    virtual void WMMOUSEACTIVATE(void)      {	 DWP();	}
    virtual void WMCHILDACTIVATE(void)      {	 DWP();	}
    virtual void WMQUEUESYNC(void)	        {	 DWP();	}
    virtual void WMGETMINMAXINFO(void)      {	 DWP();	}
//    virtual void WMPAINTICON(void)	        {	 DWP();	}
    virtual void WMICONERASEBKGND(void)	    {	 DWP();	}
    virtual void WMNEXTDLGCTL(void)	        {	 DWP();	}
    virtual void WMSPOOLERSTATUS(void)      {	 DWP();	}
    virtual void WMDRAWITEM(void)	        {	 DWP();	}
    virtual void WMMEASUREITEM(void)	    {	 DWP();	}
    virtual void WMDELETEITEM(void)	        {	 DWP();	}
    virtual void WMVKEYTOITEM(void)	        {	 DWP();	}
    virtual void WMCHARTOITEM(void)	        {	 DWP();	}
    virtual void WMSETFONT(void)	        {	 DWP();	}
    virtual void WMGETFONT(void)	        {	 DWP();	}
    virtual void WMQUERYDRAGICON(void)      {	 DWP();	}
    virtual void WMCOMPAREITEM(void)	    {	 DWP();	}
    virtual void WMCOMPACTING(void)	        {	 DWP();	}
    virtual void WMNCCREATE(void)	        {	 DWP();	}
    virtual void WMNCDESTROY(void)	        {	 DWP();	}
    virtual void WMNCCALCSIZE(void)	        {	 DWP();	}
    virtual void WMNCHITTEST(void)	        {	 DWP();	}
    virtual void WMNCPAINT(void)	        {	 DWP();	}
    virtual void WMNCACTIVATE(void)	        {	 DWP();	}
    virtual void WMGETDLGCODE(void)	        {	 DWP();	}
    virtual void WMNCMOUSEMOVE(void)	    {	 DWP();	}
    virtual void WMNCLBUTTONDOWN(void)      {	 DWP();	}
    virtual void WMNCLBUTTONUP(void)	    {	 DWP();	}
    virtual void WMNCLBUTTONDBLCLK(void)	{	 DWP();	}
    virtual void WMNCRBUTTONDOWN(void)	    {	 DWP();	}
    virtual void WMNCRBUTTONUP(void)	    {	 DWP();	}
    virtual void WMNCRBUTTONDBLCLK(void)	{	 DWP();	}
    virtual void WMNCMBUTTONDOWN(void)	    {	 DWP();	}
    virtual void WMNCMBUTTONUP(void)	    {	 DWP();	}
    virtual void WMNCMBUTTONDBLCLK(void)	{	 DWP();	}
    virtual void WMKEYFIRST(void)	        {	 DWP();	}
    virtual void WMKEYDOWN(void)	        {	 DWP();	}
    virtual void WMKEYUP(void)	            {	 DWP();	}
    virtual void WMCHAR(void)	            {	 DWP();	}
    virtual void WMDEADCHAR(void)	        {	 DWP();	}
    virtual void WMSYSKEYDOWN(void)	        {	 DWP();	}
    virtual void WMSYSKEYUP(void)	        {	 DWP();	}
    virtual void WMSYSCHAR(void)	        {	 DWP();	}
    virtual void WMSYSDEADCHAR(void)	    {	 DWP();	}
    virtual void WMKEYLAST(void)	        {	 DWP();	}
    virtual void WMINITDIALOG(void)	        {	 DWP();	}
    virtual void WMCOMMAND(void)	        {	 DWP();	}
    virtual void WMSYSCOMMAND(void)	        {	 DWP();	}
    virtual void WMTIMER(void)	            {	 DWP();	}
    virtual void WMHSCROLL(void)	        {	 DWP();	}
    virtual void WMVSCROLL(void)	        {	 DWP();	}
    virtual void WMINITMENU(void)	        {	 DWP();	}
    virtual void WMINITMENUPOPUP(void)      {	 DWP();	}
    virtual void WMMENUSELECT(void)	        {	 DWP();	}
    virtual void WMMENUCHAR(void)	        {	 DWP();	}
    virtual void WMENTERIDLE(void)	        {	 DWP();	}
    virtual void WMMOUSEFIRST(void)	        {	 DWP();	}
    virtual void WMMOUSEMOVE(void)	        {	 DWP();	}
    virtual void WMLBUTTONDOWN(void)	    {	 DWP();	}
    virtual void WMLBUTTONUP(void)	        {	 DWP();	}
    virtual void WMLBUTTONDBLCLK(void)      {	 DWP();	}
    virtual void WMRBUTTONDOWN(void)	    {	 DWP();	}
    virtual void WMRBUTTONUP(void)	        {	 DWP();	}
    virtual void WMRBUTTONDBLCLK(void)      {	 DWP();	}
    virtual void WMMBUTTONDOWN(void)	    {	 DWP();	}
    virtual void WMMBUTTONUP(void)	        {	 DWP();	}
    virtual void WMMBUTTONDBLCLK(void)      {	 DWP();	}
    virtual void WMMOUSELAST(void)	        {	 DWP();	}
    virtual void WMPARENTNOTIFY(void)	    {	 DWP();	}
    virtual void WMMDICREATE(void)	        {	 DWP();	}
    virtual void WMMDIDESTROY(void)	        {	 DWP();	}
    virtual void WMMDIACTIVATE(void)	    {	 DWP();	}
    virtual void WMMDIRESTORE(void)	        {	 DWP();	}
    virtual void WMMDINEXT(void)	        {	 DWP();	}
    virtual void WMMDIMAXIMIZE(void)	    {	 DWP();	}
    virtual void WMMDITILE(void)	        {	 DWP();	}
    virtual void WMMDICASCADE(void)	        {	 DWP();	}
    virtual void WMMDIICONARRANGE(void)	    {	 DWP();	}
    virtual void WMMDIGETACTIVE(void)	    {	 DWP();	}
    virtual void WMMDISETMENU(void)	        {	 DWP();	}
    virtual void WMCUT(void)	            {	 DWP();	}
    virtual void WMCOPY(void)	            {	 DWP();	}
    virtual void WMPASTE(void)	            {	 DWP();	}
    virtual void WMCLEAR(void)	            {	 DWP();	}
    virtual void WMUNDO(void)	            {	 DWP();	}
    virtual void WMRENDERFORMAT(void)	    {	 DWP();	}
    virtual void WMRENDERALLFORMATS(void)	{	 DWP();	}
    virtual void WMDESTROYCLIPBOARD(void)	{	 DWP();	}
    virtual void WMDRAWCLIPBOARD(void)	    {	 DWP();	}
    virtual void WMPAINTCLIPBOARD(void)	    {	 DWP();	}
    virtual void WMVSCROLLCLIPBOARD(void)	{	 DWP();	}
    virtual void WMSIZECLIPBOARD(void)	    {	 DWP();	}
    virtual void WMASKCBFORMATNAME(void)	{	 DWP();	}
    virtual void WMCHANGECBCHAIN(void)	    {	 DWP();	}
    virtual void WMHSCROLLCLIPBOARD(void)	{	 DWP();	}
    virtual void WMQUERYNEWPALETTE(void)	{	 DWP();	}
    virtual void WMPALETTEISCHANGING(void)  {	 DWP();	}
    virtual void WMPALETTECHANGED(void)	    {	 DWP();	}

    friend LRESULT CALLBACK DispatchMessage(HWND, UINT, WPARAM, LPARAM);
    };
#endif



