/* This program implements a new objectless object
   derived from TString. While the example is silly,
   it illustrates the technique and issues involved
   well.
*/
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <malloc.h>
#include <string.h>
#include <windows.h>
#include "tstrings.h"


typedef struct TStringNode   FAR &RStringNode;
typedef struct TStringNode   FAR *PStringNode;
typedef struct TStringNode {
  TString snString;
  PStringNode snNext;
} TStringNode;

PStringNode head = NULL;

//destructor for TStringNode
void FAR EXPORT PASCAL TStringNodeDone(RString sSelf)
{
  //do nothing
}

//constructor for TStringNode
int TStringNodeInit(LPSTR AString, RStringNode sSelf)
{
  sSelf.snString.sString = AString;
  sSelf.snString.sGetString = TStringsGetString;
  sSelf.snString.sDone = TStringNodeDone;
  sSelf.snNext = NULL;
  return 1;
}

//return a pointer to the last node in linked list
PStringNode last()
{
  PStringNode node = head;
  while (node->snNext)
    node = node->snNext;
  return node;
}

//add a new TStringNode to the linked list
void add(char *s)
{
  if (head) {
    PStringNode node, lastnode = last();
    node = (PStringNode) farmalloc(sizeof(TStringNode));
    TStringNodeInit(s, *node);
    lastnode->snNext = node;
  }
  else {
    head = (PStringNode) farmalloc(sizeof(TStringNode));
    TStringNodeInit(s, *head);
  }
}

//display an LPSTR
void far_cout(LPSTR s)
{
  while (*s)
    cout << *s++;
  cout << '\n';
}

//display each element in linked list
void dump()
{
  PStringNode node = head;
  while (node) {
    far_cout(node->snString.sGetString(*(PString) node));
    node = node->snNext;
  }
}

//call done destructor for each element in list
void done()
{
  PStringNode node = head;
  while (node) {
    node->snString.sDone(*(PString) node);
    node = node->snNext;
  }
}


#pragma argsused
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpszCmdLine, int cmdShow)
{

  _InitEasyWin();

  char s[255];
  do {
    cout << "Enter a string (or return to quit adding): ";
    gets(s);
    if (*s) {
      //allocate memory for new string
      char *s1 = (char *) malloc(strlen(s) + 1);
      //copy
      strcpy(s1, s);
      //add to linked list
      add(s1);
    }
  } while (*s);
  dump(); //display
  done(); //finish up
  return 0;
}
