/*
 * SURVEYX.C  WM_CTLCOLOR DEMONSTRATION
 *         APPLICATION WITH OWNER DRAW BUTTONS
 *         SIMULATES DATABASE INPUT, ANALYSIS,
 *         AND PRESENTATION
 *
 *         This portion simulates the
 *         data entry from a look alike form
 */

#include "survdemo.h"
#include <stdlib.h>
#include "odbutton.h" /* Our own Owner Draw Button
                         header information */


HANDLE hInst = 0;      /* Handle to current
                       instance of application */
HWND hDlgSurvey = 0;   /* Handle to modeless
                                    dialog box */

       /* Handles to child dialog boxes */
HWND hDlgGraph = 0;
HWND hDlgStatistics = 0;

HANDLE hInst ;
char   szAppName [] = "Survey" ;
char   szCaption [] = "Survey (Dialog Box)" ;

 /* DEFINE OWNER-DRAW BUTTON BORDER THICKNESS */
#define THICKNESS   3

/* Global GDI Objects Used In All Modules */

HICON hIconSurvey;
HICON hIconStats;
HICON hIconGraph;

HBITMAP hBitmapBkGndSurvey;
HBITMAP hBitmapLogo;

HFONT   hFontTimes;
HFONT   hFontTimesSmall;
HFONT   hFontTimesVerySmall;
HFONT   hFontTimesButton;

HPEN    hDarkGrayPen;

HBRUSH hBrushRed;
HBRUSH hBrushLightRed;
HBRUSH hBrushYellow;
HBRUSH hBrushDarkYellow;
HBRUSH hBrushGreen;
HBRUSH hBrushCyan;
HBRUSH hBrushBlue;
HBRUSH hBrushLightBlue;
HBRUSH hBrushMagenta;
HBRUSH hBrushLightMagenta;
HBRUSH hBrushDarkGreen;
HBRUSH hBrushIconSurvey;
HBRUSH hBrushBkGndSurvey;




#define BLACK  RGB(0, 0, 0)
#define RED    RGB(255,0,0)
#define LIGHTRED    RGB(255,130,126)
#define YELLOW RGB(255,255,0)
#define DARKYELLOW RGB(192,192,0)
#define GREEN  RGB(0, 255, 0)
#define CYAN   RGB(0, 255, 255)
#define YELLOWGREEN   RGB(193,255,125)
#define LIGHTGREEN  RGB(130, 255, 130)
#define DARKGREEN  RGB(0, 125, 0)
#define BLUE  RGB(0, 0, 255)
#define BLUEGREEN  RGB(0, 125, 255)
#define LIGHTBLUE  RGB(98, 193, 255)
#define BLACK  RGB(0, 0, 0)
#define MAGENTA  RGB(255, 0, 255)
#define LIGHTMAGENTA RGB(255,90,255)
#define DARKMAGENTA  RGB(223, 0, 172)
#define WHITE  RGB(255, 255, 255)
#define DARKGRAY    RGB(128,128,128)

/* Data to Load Survey - Normally Obtained From
                                      Database */

int fakedataSurvey[] =
  {
  1,0,0,0,0,
  0,1,0,0,0,
  1,0,0,0,0,
  0,0,1,0,0,
  0,1,0,0,0,
  0,1,0,0,0,
  1,0,0,0,0,
  0,1,0,0,0,
  1,0,0,0,0
  };

int NumFakedata = sizeof( fakedataSurvey ) /
                          sizeof( char* );

int idsSurvey[] =
  {
  IDRB_HL1,
  IDRB_HL2,
  IDRB_HL3,
  IDRB_HL4,
  IDRB_HL5,
  IDRB_MWSA6,
  IDRB_MWA7,
  IDRB_MWNA8,
  IDRB_MWD9,
  IDRB_MWSD10,
  IDRB_QCSA11,
  IDRB_QCA12,
  IDRB_QCNA13,
  IDRB_QCD14,
  IDRB_QCSD15,
  IDRB_HISA16,
  IDRB_HIA17,
  IDRB_HINA18,
  IDRB_HID19,
  IDRB_HISD20,
  IDRB_LUSA21,
  IDRB_LUA22,
  IDRB_LUNA23,
  IDRB_LUD24,
  IDRB_LUSD25,
  IDRB_NISA26,
  IDRB_NIA27,
  IDRB_NINA28,
  IDRB_NID29,
  IDRB_NISD30,
  IDRB_HUSA31,
  IDRB_HUA32,
  IDRB_HUNA33,
  IDRB_HUD34,
  IDRB_HUSD35,
  IDRB_HBSA36,
  IDRB_HBA37,
  IDRB_HBNA38,
  IDRB_HBD39,
  IDRB_HBSD40,
  IDRB_OVSA41,
  IDRB_OVA42,
  IDRB_OVNA43,
  IDRB_OVD44,
  IDRB_OVSD45
  };

int NumFakedataSurvey = 45;




/************************************************/
int PASCAL WinMain( HANDLE hInstance,
          HANDLE hPrevInstance, LPSTR lpszCmdLine,
          int nCmdShow )
{
    HMENU hMenu;
    MSG msg;

    if ( hPrevInstance )
    {
    MessageBox( NULL, "Survey is already running.",
              "Windows Survey",
              MB_OK | MB_ICONINFORMATION );
        return 1;
    }

    hInst = hInstance;

    /* Create modeless dialog box. */

    hDlgSurvey = CreateDialog( hInstance,
               szAppName,NULL,
               MakeProcInstance( SurveyDlgProc,
               hInstance) );

    hIconSurvey = LoadIcon (hInstance,"SurveyIcon");
    hIconStats = LoadIcon (hInstance,"StatsIcon");
    hIconGraph = LoadIcon (hInstance,"GraphIcon");


    /* Add item to system menu. */
    hMenu = GetSystemMenu( hDlgSurvey, FALSE );
    AppendMenu( hMenu, MF_SEPARATOR, 0, NULL );
    AppendMenu( hMenu, MF_BYCOMMAND | MF_STRING,
                    IDM_ABOUT, "&About..." );

    while ( GetMessage( &msg, NULL, 0, 0 ) )
    {
        if ( hDlgSurvey == 0 ||
              !IsDialogMessage( hDlgSurvey, &msg))
          {
          if (hDlgStatistics == 0 ||
            !IsDialogMessage(hDlgStatistics,&msg))
            {
            if (hDlgGraph == 0 ||
                 !IsDialogMessage(hDlgGraph,&msg))
            {
              {
              TranslateMessage( &msg );
              DispatchMessage( &msg );
              }
            }
            }
          }
    }
    return ( msg.wParam );
}


/******************************************************************************/
BOOL FAR PASCAL SurveyDlgProc( HWND hDlg,
                   unsigned iMessage, WORD wParam,
                   LONG lParam )
  {
  static FARPROC lpfnAboutDlgProc;
  static FARPROC lpfnStatisticsDlgProc;

/* ID of DlgBox's child control */
  WORD controlID;
  int type;
  int i,id;
  DWORD check;
  RECT rect;
  LPRECT lpRect;

  /* ID of Dialog box'x controls */
  /* which extra work must be done on */

  static HWND hCtrlBitmap;

  PAINTSTRUCT ps;    /* used in painting icon */
  RECT rcWindow;
  HBRUSH hBrush;
  HDC hdc;


  switch ( iMessage )
    {
    case WM_INITDIALOG:

      lpfnStatisticsDlgProc = MakeProcInstance
              (StatisticsDlgProc, hInst );

/*  Get handle to Controls which will be
      processed outside of normal dialog
                                  operations. */
      hCtrlBitmap = GetDlgItem(hDlg,IDSTAT_BITMAP);


          /* Initialize GDI Objects */

      hBitmapBkGndSurvey  = LoadBitmap(hInst,
                             "BkGndYel");
      hBitmapLogo  = LoadBitmap(hInst,
                                "SurveyLogo");
      hBrushBkGndSurvey = CreatePatternBrush
                             (hBitmapBkGndSurvey);

      hFontTimes = CreateFont(16,6,0,0, 800,FALSE,
        FALSE,FALSE,OEM_CHARSET,
        OUT_CHARACTER_PRECIS,CLIP_CHARACTER_PRECIS,
        PROOF_QUALITY,VARIABLE_PITCH|FF_ROMAN,
                      "Roman");
     hFontTimesSmall = CreateFont(12,6,0,0, 400,
        TRUE,FALSE,FALSE,OEM_CHARSET,
        OUT_CHARACTER_PRECIS,CLIP_CHARACTER_PRECIS,
        PROOF_QUALITY,VARIABLE_PITCH|FF_ROMAN,
        "Roman");
     hFontTimesVerySmall = CreateFont(12,6,0,0, 400,
        FALSE,FALSE,FALSE,OEM_CHARSET,
        OUT_CHARACTER_PRECIS,CLIP_CHARACTER_PRECIS,
        PROOF_QUALITY,VARIABLE_PITCH|FF_ROMAN,
        "Roman");
      hFontTimesButton = CreateFont(20,6,0,0, 800,
        FALSE,FALSE,FALSE,OEM_CHARSET,
        OUT_CHARACTER_PRECIS,CLIP_CHARACTER_PRECIS,
        PROOF_QUALITY,VARIABLE_PITCH|FF_ROMAN,
        "Roman");

      hBrushRed = CreateSolidBrush(RED);
      hBrushLightRed = CreateSolidBrush(LIGHTRED);
      hBrushYellow = CreateSolidBrush(YELLOW);
      hBrushDarkYellow = CreateSolidBrush
                                      (DARKYELLOW);
      hBrushGreen = CreateSolidBrush(GREEN);
      hBrushCyan = CreateSolidBrush(CYAN);
      hBrushBlue = CreateSolidBrush(BLUE);
      hBrushLightBlue = CreateSolidBrush(LIGHTBLUE);
      hBrushMagenta = CreateSolidBrush(MAGENTA);
      hBrushLightMagenta = CreateSolidBrush
                                    (LIGHTMAGENTA);
      hBrushDarkGreen = CreateSolidBrush(DARKGREEN);

      hDarkGrayPen = CreatePen(PS_SOLID, 1,DARKGRAY);



      // FILL EXAMPLE SPREADSHEET BOXES

      SetDlgItemText(hDlg,IDSTAT_RECNO403,
                                     (LPSTR)"24");

      for (i=0;i<NumFakedataSurvey;i++)
        CheckDlgButton(hDlg,idsSurvey[i],
                              fakedataSurvey[i]);
        break;

    case WM_PAINT:
      if (IsIconic(hDlg))
        {
        PaintIcon(hDlg,hIconSurvey);
        break;
        }
      else
      /* Logo Bitmap must be painted here  */
        PaintBitmap ( hCtrlBitmap,hBitmapLogo);
        break;

        /* Owner Draw Button Handler */
    case WM_DRAWITEM:
      id = ((LPDRAWITEMSTRUCT)lParam)->CtlID;
      switch (id)
        {
        case IDPB_FIRST501: case IDPB_LAST504:
          SetODButton((LPDRAWITEMSTRUCT)lParam,0,0,
                               DT_CENTER,THICKNESS);
          return TRUE;

        case IDPB_PREV502: case IDPB_NEXT503:
          SetODButton((LPDRAWITEMSTRUCT)lParam,0,0,
                               DT_CENTER,THICKNESS);
          return TRUE;

        case IDPB_STATISTICS:
          SetODButton((LPDRAWITEMSTRUCT)lParam,0,0,
                               DT_CENTER,THICKNESS);
          return TRUE;

        case IDPB_NEW505:
          SetODButton((LPDRAWITEMSTRUCT)lParam,0,0,
                              DT_CENTER,THICKNESS);
          return TRUE;

        case IDPB_SAVE506:
          SetODButton((LPDRAWITEMSTRUCT)lParam,0,0,
                               DT_CENTER,THICKNESS);
          return TRUE;

        case IDPB_QUIT507:
          SetODButton((LPDRAWITEMSTRUCT)lParam,0,0,
                               DT_CENTER,THICKNESS);
          return TRUE;

        default:
          break;
        }
      break;

/* Parse WM_CTLCOLOR Messages and Return  Objects */

    case WM_CTLCOLOR:
      type = HIWORD (lParam);
      controlID = GetWindowWord (LOWORD (lParam),
                                  GWW_ID) ;
      switch (type)
        {
        case CTLCOLOR_DLG:
          return ((DWORD) hBrushBkGndSurvey);

        case CTLCOLOR_BTN:
          SetBkMode(wParam, TRANSPARENT);
          SetBkColor(wParam, GetSysColor
                                 (COLOR_WINDOW));
          switch(controlID)
            {
            case IDPB_STATISTICS:
              SetTextColor(wParam, BLUE);
              SelectObject(wParam,hDarkGrayPen);
              SelectObject(wParam,hFontTimesButton);
              return ((DWORD) hBrushGreen);

            case IDPB_FIRST501: case IDPB_LAST504:
              SetTextColor(wParam, BLUE);
              SelectObject(wParam,hDarkGrayPen);
              SelectObject(wParam,hFontTimesButton);
              return ((DWORD) hBrushMagenta);

            case IDPB_NEXT503: case IDPB_PREV502:
              SetTextColor(wParam, RED);
              SelectObject(wParam,hDarkGrayPen);
              SelectObject(wParam,hFontTimesButton);
              return ((DWORD) hBrushYellow);

            case IDPB_SAVE506:
              SetTextColor(wParam, BLUE);
              SelectObject(wParam,hDarkGrayPen);
              SelectObject(wParam,hFontTimesButton);
              return ((DWORD) hBrushCyan);

            case IDPB_NEW505:
              SetTextColor(wParam, BLUE);
              SelectObject(wParam,hDarkGrayPen);
              SelectObject(wParam,hFontTimesButton);
              return ((DWORD) hBrushYellow);

            case IDPB_QUIT507:
              SetTextColor(wParam, BLUE);
              SelectObject(wParam,hDarkGrayPen);
              SelectObject(wParam,hFontTimesButton);
              return ((DWORD) hBrushRed);

            case IDRB_HL1: case IDRB_HL2:
            case IDRB_HL3: case IDRB_HL4:
            case IDRB_HL5: case IDRB_MWSA6:
            case IDRB_MWA7: case IDRB_MWNA8:
            case IDRB_MWD9: case IDRB_MWSD10:
            case IDRB_QCSA11: case IDRB_QCA12:
            case IDRB_QCNA13: case IDRB_QCD14:
            case IDRB_QCSD15: case IDRB_HISA16:
            case IDRB_HIA17: case IDRB_HINA18:
            case IDRB_HID19: case IDRB_HISD20:
            case IDRB_LUSA21: case IDRB_LUA22:
            case IDRB_LUNA23: case IDRB_LUD24:
            case IDRB_LUSD25: case IDRB_NISA26:
            case IDRB_NIA27: case IDRB_NINA28:
            case IDRB_NID29: case IDRB_NISD30:
            case IDRB_HUSA31: case IDRB_HUA32:
            case IDRB_HUNA33: case IDRB_HUD34:
            case IDRB_HUSD35: case IDRB_HBSA36:
            case IDRB_HBA37: case IDRB_HBNA38:
            case IDRB_HBD39: case IDRB_HBSD40:
            case IDRB_OVSA41: case IDRB_OVA42:
            case IDRB_OVNA43: case IDRB_OVD44:
            case IDRB_OVSD45:

              check = SendDlgItemMessage(hDlg,
                      controlID, BM_GETCHECK, 0, 0);
              if (check)
           /* We can change colors here */
                 SetTextColor(wParam, RED);
              else
                 SetTextColor(wParam, DARKGREEN);
              return ((DWORD) hBrushBkGndSurvey);


            default:
              SetTextColor(wParam, GREEN);
              SelectObject(wParam,hFontTimesButton);
              return ((DWORD) hBrushBkGndSurvey);
            }

        case CTLCOLOR_STATIC:
          SetBkMode(wParam, TRANSPARENT);
          switch(controlID)
            {
            case IDSTAT_401:
              SetTextColor(wParam,RED);
              SelectObject(wParam,hFontTimes);
              return ((DWORD) hBrushBkGndSurvey);

            case IDSTAT_402:
              SetTextColor(wParam,BLUE);
              SelectObject(wParam,hFontTimesSmall);
              return ((DWORD) hBrushBkGndSurvey);

            case IDSTAT_HEADING:
              SetTextColor(wParam,RED);
              SelectObject(wParam,hFontTimes);
              return ((DWORD) hBrushBkGndSurvey);

            case IDSTAT_TEXTBLUE:
              SetTextColor(wParam,BLUE);
              SelectObject(wParam,hFontTimesSmall);
              return ((DWORD) hBrushBkGndSurvey);

            case IDSTAT_TEXTGREEN:
              SetTextColor(wParam,BLACK);
              SelectObject(wParam,hFontTimesSmall);
              return ((DWORD) hBrushBkGndSurvey);

            case IDSTAT_TEXTMAGENTA:
              SetTextColor(wParam,DARKMAGENTA);
              SelectObject(wParam,hFontTimesSmall);
              return ((DWORD) hBrushBkGndSurvey);
          
	    case IDSTAT_TEXTMAGENTASMALL:
              SetTextColor(wParam,DARKMAGENTA);
              SelectObject(wParam,hFontTimesVerySmall);
              return ((DWORD) hBrushBkGndSurvey);

            case IDSTAT_CATAGORY:
              SetTextColor(wParam,DARKMAGENTA);
              SelectObject(wParam,hFontTimes);
              return ((DWORD) hBrushBkGndSurvey);


            default:
              SetTextColor(wParam, CYAN);
              SetBkMode(wParam, TRANSPARENT);
              return ((DWORD) hBrushBkGndSurvey);
            }

        default:

          SetTextColor(wParam, BLUE);
          SetBkMode(wParam, TRANSPARENT);
          return ((DWORD) hBrushBkGndSurvey);
        }


    case WM_COMMAND:
      switch ( wParam )
        {
        case IDPB_NEW505:
          // No routine here - fake button
          break;

        case IDPB_SAVE506:
          // No routine here - fake button
          break;

        case IDPB_FIRST501:
          // No routine here - fake button
          break;


        case IDPB_LAST504:
          // No routine here - fake button
          break;


        case IDPB_NEXT503:
          // No routine here - fake button
          break;

        case IDPB_PREV502:
          // No routine here - fake button
          break;

        case IDPB_STATISTICS:
          if (hDlgStatistics) /* if Statistics
                                 already created */
            break;
          hDlgStatistics = CreateDialog (hInst,
                            "Statistics", NULL,
                            lpfnStatisticsDlgProc);
          MakeStats(hDlgStatistics);
            break;

        case IDPB_QUIT507:
            SendMessage( hDlg, WM_CLOSE, 0, 0L );
            break;

        default:
            return FALSE;
          }
      break;

    case WM_SYSCOMMAND:
      switch ( wParam )
        {
        case IDM_ABOUT:

          lpfnAboutDlgProc = MakeProcInstance
                           ( AboutDlgProc, hInst );
          DialogBox( hInst, "About", hDlg,
                                lpfnAboutDlgProc );
          FreeProcInstance( lpfnAboutDlgProc );
          break;

        default:
          return FALSE;
        }
      break;


/* We have to delete all our GDI objects here  */

    case WM_CLOSE:

      DeleteObject(hDarkGrayPen);
      DeleteObject(hFontTimes);
      DeleteObject(hFontTimesSmall);
      DeleteObject(hFontTimesVerySmall);
      DeleteObject(hFontTimesButton);
      DeleteObject(hBrushRed);
      DeleteObject(hBrushLightRed);
      DeleteObject(hBrushYellow);
      DeleteObject(hBrushDarkYellow);
      DeleteObject(hBrushGreen);
      DeleteObject(hBrushCyan);
      DeleteObject(hBrushDarkGreen);
      DeleteObject(hBrushBlue);
      DeleteObject(hBrushLightBlue);
      DeleteObject(hBrushMagenta);
      DeleteObject(hBrushLightMagenta);
      DeleteObject(hBrushBkGndSurvey);
      DeleteObject(hBitmapBkGndSurvey);
      DeleteObject(hBitmapLogo);

      /* Send a WM_DESTROY message. */
      DestroyWindow( hDlg );
      hDlgSurvey = 0;
      break;

    case WM_DESTROY:

            PostQuitMessage( 0 );
            break;

    default:
      return FALSE;
    }
    return FALSE;
  }


/**************************************************/
BOOL FAR PASCAL AboutDlgProc( HWND hDlg,
                   unsigned iMessage, WORD wParam,
                   LONG lParam )
  {
  switch ( iMessage )
    {
    case WM_INITDIALOG:
      return TRUE;

    case WM_COMMAND:

      if ( wParam == IDOK || wParam == IDCANCEL )
        {
        EndDialog( hDlg, TRUE );
        return TRUE;
        }
      break;
    }
  return FALSE;
  }

BOOL PaintBitmap (HWND hCtrl,HBITMAP hBM)
  {
  HDC     hDCBits, hDC;
  BITMAP  bm;
  BOOL    ok;
  RECT    rect;
  WORD   controlID;

  controlID = GetWindowWord(hCtrl, GWW_ID);
  GetClientRect(hCtrl, &rect);
  UpdateWindow(hCtrl);
  hDC = GetDC(hCtrl);

  GetClientRect(hCtrl,&rect);
  hDCBits = CreateCompatibleDC(hDC);
  GetObject(hBM, sizeof(BITMAP), (LPSTR)&bm);
  SelectObject(hDCBits, hBM);
  ok = StretchBlt(hDC, 0, 0, rect.right,
             rect.bottom, hDCBits, 0, 0, bm.bmWidth,
             bm.bmHeight, SRCCOPY);
  DeleteDC(hDCBits);
  ReleaseDC(hCtrl, hDC);
  return(ok);
  }


void PaintIcon (HWND hDLG, HICON hIcon)
  {
  HDC   hdc;
  RECT rect;
  PAINTSTRUCT ps;
  RECT rcWindow;
  HBRUSH hBrushIcon;

  if (IsIconic(hDLG))
    {
/* get device context and size of display area */
        hdc = BeginPaint(hDLG, &ps);
        GetClientRect(hDLG, &rcWindow);

        /* make background = desktop */
        hBrushIcon = CreateSolidBrush(GetSysColor
                                (COLOR_BACKGROUND));
        FillRect(hdc, &rcWindow, hBrushIcon);
        DeleteObject(hBrushIcon);

/* center icon in client window area. rcWindow.top
   and .left  will always be zero, so we leave them
   out of the calculation. */


        DrawIcon (hdc,
          (rcWindow.right  - GetSystemMetrics
            (SM_CXICON))/2,(rcWindow.bottom -
             GetSystemMetrics(SM_CYICON))/2,
             hIcon);
        EndPaint(hDLG, &ps);
    }
  }

