// odbutton.c  ROUTINES TO DRAW OWNER DRAW BUTTONS
// WITH BUTTON FOCUS AND SENDS WM_CTLCOLOR MESSAGE

/**************************************************

VOID  SetODButton(LPDRAWITEMSTRUCT lpdrawis,
        HBITMAP hbm1,HBITMAP hbm2, WORD aligntext)

INPUT:  (LPDRAWITEMSTRUCT)lParam  LongPointer to
          DRAWITEMSTRUCT passed by the owner-draw
          control with the lParam of the
          WM_DRAWITEM message.
         hbm1  Handle to the primary bitmap to be
           drawn on the button face.If NULL no
           bitmaps are expected and drawn.
         hbm2  Handle to the secondary bitmap to be
           drawn when the button is depressed.
           If NULL hbm1 is used for depressed state.
         DrawText wFormat  Used in alining the
           button text. Expects DT_LEFT, DT_CENTER
           or DT_RIGHT

OUTPUT:  Sends WM_CTLCOLOR message.
         Responds to text and background colors.
         Background Brush. Fonts.
         One Pen for lower-right unpushed
         corner color.

RETURN:  Void

**************************************************/


#include <windows.h>
#include <string.h>
#include "odbutton.h"

#define RGB_LTGRAY      RGB(192,192,192)
#define RGB_DARKGRAY    RGB(128,128,128)
#define RGB_MEDIUMGRAY  RGB(190,190,190)
#define RGB_WHITE       RGB(0xFF,0xFF,0xFF)

#define MAXLENGTH  20 // Max Length of Button Text


#define IsButtonSelected(lpd) (lpd->itemAction == ODA_SELECT && lpd->itemState & ODS_SELECTED)


VOID  SetODButton(LPDRAWITEMSTRUCT lpdrawis,
        HBITMAP hbm1,HBITMAP hbm2, WORD aligntext,
        WORD thickness)
  {
  if (lpdrawis->itemAction & ODA_DRAWENTIRE ||
       lpdrawis->itemAction & ODA_SELECT)
    {
      /* Draw button outline and fill face first */
    DrawODButton((LPDRAWITEMSTRUCT) lpdrawis,
     thickness, OD_BORDER);

      /*  Respond to any bitmaps */
    if (hbm1)
      DrawButtonBitmap ((LPDRAWITEMSTRUCT) lpdrawis,
       thickness, OD_BORDER, hbm1, hbm2);
    }
      /* Place button text and focus */
  DrawButtonText ((LPDRAWITEMSTRUCT) lpdrawis,
     thickness, hbm2, OD_BORDER, aligntext);
  }


VOID DrawODButton(DRAWITEMSTRUCT FAR *lpdrawis,
        WORD wThickness,int border)
  {
  // wThickness  Thickness of the 3D Border.
  //      This is ignored when
  //      the OD_PUSHED style is specified.
  // border == 4  noborder = 0

  HWND    hCtlColorBkgd;
  POINT   apt[3];
  WORD    wIndex;
  HBRUSH  hBrush;
  HPEN    hpenLower;
  DWORD   rgbLowerCorner;
  HPEN    hpenUserPassed; // Assumed passed by caller 
                          // parsing WM_CTLCOLOR
  HPEN    hpenUpper;
  DWORD   rgbUpperCorner;
  HDC     hDC;
  WORD    wStyle;
  int     x,y,cx,cy;
  BOOL    bPushed;


  bPushed = IsButtonSelected(lpdrawis);
  hDC = lpdrawis->hDC;
  x = lpdrawis->rcItem.left;
  y = lpdrawis->rcItem.top;
  cx = lpdrawis->rcItem.right;
  cy = lpdrawis->rcItem.bottom;

/* Send WM_CTLCOLOR message to the Dialog parent */
  hCtlColorBkgd = SendMessage(GetParent
      (lpdrawis->hwndItem),WM_CTLCOLOR,
    hDC,MAKELONG(lpdrawis->hwndItem,CTLCOLOR_BTN));
  hBrush = hCtlColorBkgd ? hCtlColorBkgd :
              GetStockObject(WHITE_BRUSH);
  SelectObject (hDC,hBrush);

  wStyle = ((!bPushed) ? OD_UP : OD_PUSHED);
  wStyle = wStyle | border;

  if(wStyle & OD_BORDER)
    {
    Rectangle(hDC,x,y,cx,cy);
    x ++;
    y ++;
    cx --;
    cy --;
    }

    if(wStyle & OD_DOWN || wStyle & OD_PUSHED)
      {
      rgbUpperCorner = RGB_DARKGRAY;
      rgbLowerCorner = RGB_WHITE;
      }
     else
       {
       rgbUpperCorner = RGB_WHITE;
       rgbLowerCorner = RGB_DARKGRAY;
       }

    hpenLower = CreatePen(PS_SOLID,1,rgbLowerCorner);
    hpenUpper = CreatePen(PS_SOLID,1,rgbUpperCorner);
    hpenUserPassed   = SelectObject(hDC,hpenLower);

    cx --;
    cy --;

    for(wIndex = 0;wIndex < wThickness;wIndex ++)
      {
      if(wStyle & OD_PUSHED)
        SelectObject(hDC,hpenUpper);
      else
        SelectObject(hDC,hpenUpper);
      apt[0].x = x + wIndex;
      apt[0].y = cy - wIndex;
      apt[1].x = apt[0].x;
      apt[1].y = y + wIndex;
      apt[2].x = cx + 1 - wIndex;
      apt[2].y = apt[1].y;
      Polyline(hDC,apt,3);

      if(wStyle & OD_PUSHED)
        SelectObject(hDC,hpenLower);
      else
        SelectObject(hDC,hpenUserPassed);

      apt[0].x ++;
      apt[2].x --;
      apt[1].x = apt[2].x;
      apt[1].y = apt[0].y;
      Polyline(hDC,apt,3);
      }

    SelectObject(hDC,hpenUserPassed);
    DeleteObject(hpenLower);
    DeleteObject(hpenUpper);
  }


BOOL DrawButtonBitmap (DRAWITEMSTRUCT FAR *lpdrawis,
                 WORD wThickness,int border,
                 HBITMAP hbm1, HBITMAP hbm2)
{
  HDC     hDCBits;   /* DC for bitmaps */
  BITMAP  bm;        /* bitmap data struct : width,
                         height, etc. */
  HBITMAP hBM;
  BOOL    ok;        /* ret value from BitBlt()
                          (TRUE if successful) */
  RECT    rect;      /* rect of dialog control
                        for bitmap placement   */
  HDC     hDC;
  WORD    wStyle;
  BOOL    bPushed;
  int     x,y,cx,cy,offset;

  bPushed = IsButtonSelected(lpdrawis);
  offset = bPushed;
  hBM = hbm1;
  if (bPushed && hbm2)
    {
    offset = 0;
    hBM = hbm2;
    }

  hDC = lpdrawis->hDC;
  x = lpdrawis->rcItem.left;
  y = lpdrawis->rcItem.top;
  cx = lpdrawis->rcItem.right;
  cy = lpdrawis->rcItem.bottom;

  if (!hDC || !hBM)  /* if bad hDC or hBM,
                           return FALSE */
    return FALSE;

  hDCBits = CreateCompatibleDC(hDC);
  GetObject(hBM, sizeof(BITMAP), (LPSTR)&bm);
  SelectObject(hDCBits, hBM);

  x = x + wThickness+1+offset;
  y = y + wThickness+1+offset;
  cx = cx - (wThickness+1)*2;
  cy = cy - (wThickness+1)*2;

  ok = StretchBlt(hDC, x, y, cx, cy,
          hDCBits, 0, 0, bm.bmWidth,
          bm.bmHeight,SRCCOPY);
  DeleteDC(hDCBits);

  return(ok);
}


BOOL DrawButtonText (DRAWITEMSTRUCT FAR *lpdrawis,
        WORD wThickness,HBITMAP hbm2,
        int border,WORD aligntext)
  {

  BOOL    ok;        /* ret value from BitBlt()
                            (TRUE if successful) */
  RECT    rect;      /* rect of dialog control
                        for bitmap placement   */
  HDC     hDC;
  WORD    CtrlID;
  BOOL    bPushed;
  char    buf[MAXLENGTH];
  int     cx,cy;
  RECT    rectfocus;
  DWORD   textextent;

  hDC = lpdrawis->hDC;
  if (aligntext == DT_RIGHT)
    lpdrawis->rcItem.right -= (border + wThickness);
  else if (aligntext == DT_LEFT)
    lpdrawis->rcItem.left += (border + wThickness);

  if (lpdrawis->itemAction & ODA_DRAWENTIRE ||
         lpdrawis->itemAction & ODA_SELECT)
    {
    bPushed = IsButtonSelected(lpdrawis);
    if (bPushed && !hbm2)
      {
      lpdrawis->rcItem.top +=2;
      lpdrawis->rcItem.left +=2;
      }
    SendMessage(lpdrawis->hwndItem,WM_GETTEXT,20,
         (LPSTR)buf);
    ok = DrawText(hDC,buf,-1,&lpdrawis->rcItem,
          DT_SINGLELINE | aligntext | DT_VCENTER);
    }
  if (lpdrawis->itemState & ODS_FOCUS)
    {
    SendMessage(lpdrawis->hwndItem,WM_GETTEXT,20,
                  (LPSTR)buf);
    textextent = GetTextExtent(hDC,buf,strlen(buf));

    if (textextent == 0)
      {
      rectfocus.left = lpdrawis->rcItem.left+
          ((lpdrawis->rcItem.right-
               lpdrawis->rcItem.left)/4);
      rectfocus.top = lpdrawis->rcItem.top +
          ((lpdrawis->rcItem.bottom-
                 lpdrawis->rcItem.top)/4);
      rectfocus.right = lpdrawis->rcItem.left+
          ((lpdrawis->rcItem.right-
                 lpdrawis->rcItem.left)*3/4);
      rectfocus.bottom = lpdrawis->rcItem.top +
          ((lpdrawis->rcItem.bottom-
                  lpdrawis->rcItem.top)*3/4);
      }

    else if (aligntext == DT_RIGHT)
      {
      rectfocus.left = lpdrawis->rcItem.right -
                           LOWORD(textextent);
      rectfocus.top = lpdrawis->rcItem.top+
           ((lpdrawis->rcItem.bottom
         -lpdrawis->rcItem.top)/2)-
         (HIWORD(textextent)/2);
      rectfocus.right = lpdrawis->rcItem.right;
      rectfocus.bottom = lpdrawis->rcItem.top+
           ((lpdrawis->rcItem.bottom
           -lpdrawis->rcItem.top)/2)+
           (HIWORD(textextent)/2);
      }
    else if (aligntext == DT_CENTER)
      {
      rectfocus.left = lpdrawis->rcItem.left+
                 ((lpdrawis->rcItem.right
                 -lpdrawis->rcItem.left)/2)-
                 (LOWORD(textextent)/2);
      rectfocus.top = lpdrawis->rcItem.top+
                 ((lpdrawis->rcItem.bottom
                 -lpdrawis->rcItem.top)/2)-
                 (HIWORD(textextent)/2);
      rectfocus.right = lpdrawis->rcItem.left+
                 ((lpdrawis->rcItem.right
                      -lpdrawis->rcItem.left)/2)+
                      (LOWORD(textextent)/2);
      rectfocus.bottom = lpdrawis->rcItem.top+
                 ((lpdrawis->rcItem.bottom
                 -lpdrawis->rcItem.top)/2)+
                 (HIWORD(textextent)/2);
      }
    if (aligntext == DT_LEFT)
      {
      rectfocus.left = lpdrawis->rcItem.left;
      rectfocus.top = lpdrawis->rcItem.top+
                    ((lpdrawis->rcItem.bottom
                    -lpdrawis->rcItem.top)/2)-
                    (HIWORD(textextent)/2);
      rectfocus.right = lpdrawis->rcItem.left +
                     LOWORD(textextent);
      rectfocus.bottom = lpdrawis->rcItem.top+
                     ((lpdrawis->rcItem.bottom
                        -lpdrawis->rcItem.top)/2)+
                        (HIWORD(textextent)/2);
      }

    DrawFocusRect(hDC,&rectfocus);
    }

  return(ok);
}


