// grphdemo.c   GRAPHS dialog box routines

/*   This module will display another Dialog box
     with a grahical display of the analysis.  */

#include "survdemo.h"

 /* DEFINE OWNER-DRAW BUTTON BORDER THICKNESS */
#define THICKNESS   3



  /* GDI Handles Used Only In grphdemo.c */
HBRUSH hBrushBkGndGraph;
HBITMAP hBitmapBkGndGraph;

extern HWND hDlgGraph;

extern HICON hIconGraph;

#define MAXRECS  45
#define nFields  45

// Array of stat data

extern STATDATA statdata[MAXRECS];


#define TOP      1
#define BOTTOM   2




/***************************************************/
BOOL FAR PASCAL GraphDlgProc( HWND hDlg,
                    unsigned iMessage, WORD wParam,
                    LONG lParam )
  {
  static HWND hCtrlGraph11;
  static HWND hCtrlGraph12;
  static HWND hCtrlGraph13;
  static HWND hCtrlGraph14;
  static HWND hCtrlGraph15;
  static HWND hCtrlGraph16;
  static HWND hCtrlGraph17;
  static HWND hCtrlGraph18;
  static HWND hCtrlGraph19;
  static HWND hCtrlQuit;
  static HWND hCtrlUpdate;


  WORD CtrlID;   /* ID of DlgBox's child control */
  int type, id;

    /* Used in Scrollbar and Push Button Movement */

  static short nVscrollPos,nVscrollMax,nVscrollInc;
  int moveButtons;
  RECT rect;
  static RECT rectQuitTop,rectUpdateTop,
                   rectQuitBottom,rectUpdateBottom;
  static RECT rectClientQuit,rectClientUpdate;
  POINT point;
  static int buttonMove;

  switch ( iMessage )
    {
    case WM_INITDIALOG:

      hBitmapBkGndGraph  = LoadBitmap(hInst,
                                       "BkGndCnY");
      hBrushBkGndGraph = CreatePatternBrush
                               (hBitmapBkGndGraph);
            // Handles of Controls to be Painted
      hCtrlGraph11 = GetDlgItem(hDlg, IDG_GRAPH11);
      hCtrlGraph12 = GetDlgItem(hDlg, IDG_GRAPH12);
      hCtrlGraph13 = GetDlgItem(hDlg, IDG_GRAPH13);
      hCtrlGraph14 = GetDlgItem(hDlg, IDG_GRAPH14);
      hCtrlGraph15 = GetDlgItem(hDlg, IDG_GRAPH15);
      hCtrlGraph16 = GetDlgItem(hDlg, IDG_GRAPH16);
      hCtrlGraph17 = GetDlgItem(hDlg, IDG_GRAPH17);
      hCtrlGraph18 = GetDlgItem(hDlg, IDG_GRAPH18);
      hCtrlGraph19 = GetDlgItem(hDlg, IDG_GRAPH19);
      hCtrlQuit    = GetDlgItem(hDlg, IDGPB_QUIT11);
      hCtrlUpdate  = GetDlgItem(hDlg, IDGPB_UPDATE11);

      /* Window Scrollbar Data */
      GetClientRect(hDlg,&rect);
      nVscrollMax= ((rect.bottom - rect.top)*.53/2)*2;

      nVscrollPos = 0;
      SetScrollRange (hDlg,SB_VERT,0,nVscrollMax,
                                              FALSE);
      SetScrollPos   (hDlg,SB_VERT,nVscrollPos,TRUE);

 /* Data used in moving Quit and Update Buttons
                                   with Scrollbar */
      GetClientRect(hCtrlQuit,&rectClientQuit);
      buttonMove = rect.bottom-rectClientQuit.bottom;
      GetWindowRect(hCtrlQuit,&rectQuitTop);
      point.x=rectQuitTop.left;
      point.y=rectQuitTop.top;
      ScreenToClient(hDlg,&point);
      rectQuitTop.left=rectQuitBottom.left=point.x;
      rectQuitTop.top=point.y;
      buttonMove -= (point.y+3);
      rectQuitBottom.top=point.y+buttonMove;

      GetClientRect(hCtrlUpdate,&rectClientUpdate);
      buttonMove = rect.bottom-rectClientUpdate.
                                              bottom;
      GetWindowRect(hCtrlUpdate,&rectUpdateTop);
      point.x=rectUpdateTop.left;
      point.y=rectUpdateTop.top;
      ScreenToClient(hDlg,&point);
      rectUpdateTop.left=rectUpdateBottom.left=
                                            point.x;
      rectUpdateTop.top=point.y;
      buttonMove -= (point.y+3);
      rectUpdateBottom.top=point.y+buttonMove;

      break;

      /* Owner-Draw Buttons */

    case WM_DRAWITEM:
      id = ((LPDRAWITEMSTRUCT)lParam)->CtlID;
      switch (id)
        {
        case IDGPB_UPDATE11:
          SetODButton((LPDRAWITEMSTRUCT)lParam,0,0,
                                DT_CENTER,THICKNESS);
          return TRUE;

        case IDGPB_QUIT11:
          SetODButton((LPDRAWITEMSTRUCT)lParam,0,0,
                                DT_CENTER,THICKNESS);
          return TRUE;

        default:
          break;
        }
      break;


    case WM_PAINT:
      if (IsIconic(hDlg))
        {
        PaintIcon(hDlg,hIconGraph);
        break;
        }
      else
        {
        PaintGraphDlgCtrl(hCtrlGraph11, 0);
        PaintGraphDlgCtrl(hCtrlGraph12, 5);
        PaintGraphDlgCtrl(hCtrlGraph13, 10);
        PaintGraphDlgCtrl(hCtrlGraph14, 15);
        PaintGraphDlgCtrl(hCtrlGraph15, 20);
        PaintGraphDlgCtrl(hCtrlGraph16, 25);
        PaintGraphDlgCtrl(hCtrlGraph17, 30);
        PaintGraphDlgCtrl(hCtrlGraph18, 35);
        PaintGraphDlgCtrl(hCtrlGraph19, 40);
        break;
        }

        /* Parse WM_CTLCOLOR here */

    case WM_CTLCOLOR:
      type = HIWORD (lParam);
      CtrlID = GetWindowWord (LOWORD (lParam),
                                           GWW_ID);

      switch (type)                                       {
        case CTLCOLOR_DLG:
          SetTextColor(wParam,RED);
          return ((DWORD) hBrushBkGndGraph);

        case CTLCOLOR_BTN:
          SetBkMode(wParam, TRANSPARENT);
          SetBkColor(wParam, GetSysColor
                                    (COLOR_WINDOW));
          switch(CtrlID)
            {
            case IDGPB_UPDATE11:
              SelectObject(wParam,hDarkGrayPen);
              SetTextColor(wParam,BLUE);
              return ((DWORD) hBrushYellow);

            case IDGPB_QUIT11:
              SelectObject(wParam,hDarkGrayPen);
              SetTextColor(wParam,BLUE);
              return ((DWORD) hBrushRed);

            default:
              SetTextColor(wParam, DARKGREEN);
              SetBkMode(wParam, TRANSPARENT);
              return ((DWORD) hBrushBkGndGraph);
            }

        case CTLCOLOR_STATIC:
          SetBkMode(wParam, TRANSPARENT);
          switch(CtrlID)
            {
            case IDG_CAPTION11:
              SetTextColor(wParam,RED);
              SelectObject(wParam,hFontTimesSmall);
              return ((DWORD) hBrushBkGndGraph);

            case IDG_GRAPH11:
              SetTextColor(wParam,BLUE);
              return ((DWORD) hBrushCyan);

            case IDG_GRAPH12:
              SetTextColor(wParam,BLUE);
              return ((DWORD) hBrushYellow);

            case IDG_GRAPH13:
              SetTextColor(wParam,BLUE);
              return ((DWORD) hBrushMagenta);

            case IDG_GRAPH14:
              SetTextColor(wParam,BLUE);
              return ((DWORD) hBrushLightBlue);

            case IDG_GRAPH15:
              SetTextColor(wParam,BLUE);
              return ((DWORD) hBrushGreen);

            case IDG_GRAPH16:
              SetTextColor(wParam,BLUE);
              return ((DWORD) hBrushRed);

            case IDG_GRAPH17:
              SetTextColor(wParam,BLUE);
              return ((DWORD) hBrushLightMagenta);

            case IDG_GRAPH18:
              SetTextColor(wParam,BLUE);
              return ((DWORD) hBrushDarkYellow);

            case IDG_GRAPH19:
              SetTextColor(wParam,BLUE);
              return ((DWORD) hBrushLightRed);

            case IDG_SA11: case IDG_SD11:
            case IDG_N11: case IDG_D11:
            case IDG_A11:
              SetTextColor(wParam,BLUE);
              SelectObject(wParam,hFontTimesSmall);
              return ((DWORD) hBrushBkGndGraph);

            default:
              SetTextColor(wParam, DARKGREEN);
              SetBkMode(wParam, TRANSPARENT);
              return ((DWORD) hBrushBkGndGraph);
            }

        default:

          SetTextColor(wParam, BLUE);
          SetBkMode(wParam, TRANSPARENT);
          return ((DWORD) hBrushBkGndGraph);
        }

 /* Yes, we can scroll our dialog box
         and all the controls in it.  */

    case WM_VSCROLL :
      moveButtons = FALSE;
      switch (wParam)
        {
        case SB_PAGEDOWN :
          nVscrollInc += nVscrollMax ;
          moveButtons = BOTTOM;
          break;
        case SB_LINEDOWN :
          nVscrollInc += 16 ;
          break ;
        case SB_PAGEUP :
          nVscrollInc -= nVscrollMax ;
          moveButtons = TOP;
          break;
        case SB_LINEUP :
          nVscrollInc -=16;
          break ;
        case SB_TOP:
          nVscrollInc = 0 ;
          moveButtons = TOP;
          break ;
        case SB_BOTTOM :
          nVscrollInc = nVscrollMax ;
          moveButtons = BOTTOM;
          break ;
        case SB_THUMBPOSITION :
        case SB_THUMBTRACK :
          nVscrollInc= LOWORD (lParam)- nVscrollPos ;
          break ;
        default :
          nVscrollInc = 0 ;
        }
      nVscrollInc = (nVscrollInc/2)*2;
      if (nVscrollInc = max(-nVscrollPos,
                      min(nVscrollInc,nVscrollMax -
                       nVscrollPos)))
        {
        nVscrollPos += nVscrollInc;
        SetScrollPos (hDlg,SB_VERT,nVscrollPos,TRUE);
        ScrollWindow(hDlg,0,-nVscrollInc,NULL,NULL);


 /* All this stuff is to show that we can
        move our buttons, or controls in general,
        around in the dialog box  */

        if (nVscrollPos == 0)
          moveButtons = TOP;
        if (nVscrollPos == nVscrollMax)
          moveButtons = BOTTOM;
        if (moveButtons == TOP)
          {
          MoveWindow(hCtrlQuit,rectQuitTop.left,
            rectQuitTop.top,rectClientQuit.right,
            rectClientQuit.bottom,TRUE);
          MoveWindow(hCtrlUpdate,rectUpdateTop.left,
            rectUpdateTop.top,rectClientUpdate.right,
            rectClientUpdate.bottom,TRUE);
          }
        else if (moveButtons == BOTTOM)
          {
          MoveWindow(hCtrlQuit,rectQuitBottom.left,
            rectQuitBottom.top,rectClientQuit.right,
            rectClientQuit.bottom,TRUE);
          MoveWindow(hCtrlUpdate,
            rectUpdateBottom.left,rectUpdateBottom.
            top,rectClientUpdate.right,
            rectClientUpdate.bottom,TRUE);
          }
        else
          ;
        }
      break;


    case WM_COMMAND:
      switch ( wParam )
        {
        case IDGPB_UPDATE11:
          PaintGraphDlgCtrl(hCtrlGraph11, 0);
          PaintGraphDlgCtrl(hCtrlGraph12, 5);
          PaintGraphDlgCtrl(hCtrlGraph13, 10);
          PaintGraphDlgCtrl(hCtrlGraph14, 15);
          PaintGraphDlgCtrl(hCtrlGraph15, 20);
          PaintGraphDlgCtrl(hCtrlGraph16, 25);
          PaintGraphDlgCtrl(hCtrlGraph17, 30);
          PaintGraphDlgCtrl(hCtrlGraph18, 35);
          PaintGraphDlgCtrl(hCtrlGraph19, 40);
          break;

        case IDGPB_QUIT11:
          SendMessage( hDlg, WMG_CLOSE11, 0, 0L );
          break;

        default:
          return FALSE;
        }
        break;

    case WMG_CLOSE11:
            /* Send a WM_DESTROY message. */
      DeleteObject (hBitmapBkGndGraph);
      DeleteObject(hBrushBkGndGraph);
      DestroyWindow( hDlg );
      hDlgGraph= 0;
      break;

    default:
      return FALSE;
    }
  return FALSE;
}



void PaintGraphDlgCtrl(HWND hCtrl, short dataOffset)
  {
  HDC    hDC;    /* to create child window's DC */
  RECT   rect;   /* to get child window's
                                     client rect */
  WORD   ctrlID; /* child window's ID in RC file */
  TEXTMETRIC tm;
  HFONT hFontHeading;
  static int xmax,ymax,xoffset,yoffset,i,z;
  static int y=0;
  char buf[20] = "xxx";
  int q,r;

/* Find control dimensions */
  ctrlID = GetWindowWord(hCtrl, GWW_ID);
  GetClientRect(hCtrl, &rect);
  InvalidateRect(hCtrl, &rect, TRUE);
  UpdateWindow(hCtrl);
  hDC = GetDC(hCtrl);

  xmax = (rect.right - rect.left)*8/10;
  ymax = (rect.bottom - rect.top)*9/10;
  xoffset = rect.left +(rect.right - rect.left)*1/10;
  yoffset = rect.top + (rect.bottom - rect.top)*1/20;

/* Draw the coordinates */

  MoveTo (hDC,xoffset,yoffset);
  LineTo (hDC,xoffset, yoffset+ymax);
  LineTo (hDC,xoffset+xmax, yoffset+ymax);

  yoffset = yoffset + ymax;
  for (i=1;i<5;i++)
    {
    MoveTo(hDC,xoffset+(i*xmax/4),yoffset);
    LineTo(hDC,xoffset+(i*xmax/4),yoffset+3);
    }
  SetBkMode(hDC,TRANSPARENT);

/* Put in the coordinate values */

  GetTextMetrics(hDC,&tm);

/* If the width of the area between the left border
   and the left edge of the control is very small
   change the font to fit into the area.           */

  if((tm.tmAveCharWidth*3) >(rect.right - rect.left)
                                                 /10)
    {
    r = ((rect.right - rect.left)/30)+2;
    hFontHeading = CreateFont(8, r,0,0, 300,FALSE,
       FALSE,FALSE,OEM_CHARSET,OUT_CHARACTER_PRECIS,
       OUT_DEFAULT_PRECIS,PROOF_QUALITY,
       VARIABLE_PITCH|FF_ROMAN,"Times");
    SelectObject(hDC,hFontHeading);
    SetBkMode(hDC, TRANSPARENT);

    for (i=1;i<5;i++)
      {
      MoveTo(hDC,xoffset-3,yoffset-(i*ymax/5));
      LineTo(hDC,xoffset,yoffset-(i*ymax/5));
      wsprintf((LPSTR)buf,"%1d",20*i);
      TextOut(hDC,rect.left,yoffset-(ymax*i/5),
                                    (LPSTR)buf,2);
      }
    TextOut(hDC,rect.left,yoffset-ymax,(LPSTR)"100",
                                                  3);
    DeleteObject(hFontHeading);
    }
  else
    {
    for (i=1;i<5;i++)
      {
      SelectObject(hDC,hFontTimes);
      MoveTo(hDC,xoffset-3,yoffset-(i*ymax/5));
      LineTo(hDC,xoffset,yoffset-(i*ymax/5));
      wsprintf((LPSTR)buf,"%1d",20*i);
        TextOut(hDC,xoffset-20,yoffset-(ymax*i/5),
                                      (LPSTR)buf,2);
      }
    TextOut(hDC,xoffset-20,yoffset-ymax,
                                    (LPSTR)"100",3);
    }

/* Draw the graph */

  MoveTo(hDC,xoffset,yoffset);
  for (i=0;i<5;i++)
    {
    y =  statdata[i+dataOffset].itemave * ymax / 100;
    z = (int)y;
    LineTo(hDC,xoffset+(i*xmax/4),yoffset-z);
    Rectangle(hDC,(xoffset+(i*xmax/4))-2,
                (yoffset-z)-2,(xoffset+
                (i*xmax/4))+2,(yoffset-z)+2);
    }
  ReleaseDC(hCtrl, hDC);
  }


