Option Explicit
Option Compare Text
DefInt A-Z
Global DownY%
Global MyFile$
Global CommentChanged%
Global CurrentItem$
Global crlf$
'Declares for INI file routines
Declare Function WritePrivateProfileString% Lib "KERNEL" (ByVal lpApplicationName$, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lplFileName$)
Declare Function WriteProfileString% Lib "KERNEL" (ByVal lpApplicationName$, ByVal lpKeyName As Any, ByVal lpString$)
Declare Function GetProfileInt% Lib "KERNEL" (ByVal lpAppName$, ByVal lpKeyName$, ByVal nDefault%)
Declare Function GetPrivateProfileInt% Lib "KERNEL" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal nDefault%, ByVal lpFilename$)
Declare Function GetPrivateProfileString% Lib "KERNEL" (ByVal lpApplicationName As Any, ByVal lpKeyName As Any, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%, ByVal lpFilename$)
Declare Function GetProfileString% Lib "KERNEL" (ByVal lpAppName$, ByVal lpKeyName As Any, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%)

Declare Function GetVersion Lib "kernel" () As Integer

Sub Alert (Mess$)
'  * creates an Alert box with an OK button
MsgBox Mess$, 48, App.Title
End Sub

Sub CenterForm (F As Form)
F.Left = (Screen.Width - F.Width) / 2
F.Top = (Screen.Height - F.Height) / 2
End Sub

   Function CheckForWin95% ()
      Dim i%, lowbyte$, highbyte$
      i% = GetVersion()
      ' Lowbyte is derived by masking off high byte.
      lowbyte$ = Str$(i% And &HFF)
      ' Highbyte is derived by masking off low byte and shifting.
      highbyte$ = LTrim$(Str$((i% And &HFF00) / 256))
      ' Assign Windows version to text property.

      If Val(lowbyte$ + "." + highbyte$) > 3.8 Then
        CheckForWin95% = True
      Else
        CheckForWin95% = False
      End If

   End Function

Function Confirm% (Ask$)
If MsgBox(Ask$, 52, App.Title) = 6 Then Confirm% = True
End Function

Sub DelPrivIniItem (pApp$, pKey$, pFile$)
Dim x%
x% = WritePrivateProfileString%(pApp$, pKey$, 0&, pFile$)
End Sub

Sub DelPrivIniSection (pApp$, pFile$)
Dim x%
x% = WritePrivateProfileString%(pApp$, 0&, 0&, pFile$)
End Sub

Function ExtractFileName$ (ByVal fqPath$)
Dim x%
x% = InStr(fqPath$, "\")
Do While x% > 1
    fqPath$ = Mid$(fqPath$, x% + 1)
    x% = InStr(fqPath$, "\")
Loop
ExtractFileName$ = fqPath$
End Function

Function GetPrivINI$ (pApp$, pKey$, pDefault$, pFile$)
Dim x%
Dim ret As String * 1024
x% = GetPrivateProfileString%(pApp$, pKey$, pDefault$, ret, Len(ret), pFile$)
If x% > 0 Then GetPrivINI$ = Left$(ret, x%)
End Function

Function GetPrivIniInt% (pApp$, pKey$, pDefault%, pFile$)
GetPrivIniInt% = GetPrivateProfileInt%(pApp$, pKey$, pDefault%, pFile$)
End Function

Function GetWinIni$ (pApp$, key$, pDefault$, pFile$)
Dim pKey As Variant
If key$ = "" Then
   pKey = 0&
Else
   pKey = key$
End If
Dim x%
Dim ret As String * 1024
x% = GetPrivateProfileString%(pApp$, pKey, pDefault$, ret, Len(ret), pFile$)
If x% > 0 Then GetWinIni$ = Left$(ret, x%)
End Function

Function GetWinIniInt% (pApp$, pKey$, pDefault%)
GetWinIniInt% = GetProfileInt%(pApp$, pKey$, pDefault%)
End Function

Function ListPrivIniEntries$ (pApp$, pFile$)
Dim x%
Dim ret As String * 4096
'a null for the item parameter returns a list of items
x% = GetPrivateProfileString%(pApp$, 0&, "", ret, Len(ret), pFile$)
If x% > 0 Then ListPrivIniEntries$ = Left$(ret, x%)
End Function

Function ListPrivIniSections$ (pFile$)
Dim x%, tmp$, F%, accum$
'there's no api command for listing sections of an ini file
'so we do it the hard way, with vb's open command
F% = FreeFile
On Error Resume Next
Open pFile$ For Input As F
Do While Not EOF(F)
   Input #F, tmp$
   If Left$(tmp$, 1) = "[" Then accum$ = accum$ + crlf$ + tmp$
Loop
Close F
ListPrivIniSections$ = Mid$(accum$, 3)
End Function

Sub PutPrivIni (pApp$, pKey$, ByVal pString$, pFile$)
Dim x%
x% = WritePrivateProfileString%(pApp$, pKey, pString, pFile$)
End Sub

Sub PutWinIni (pApp$, pKey$, pString$)
Dim x%
x% = WriteProfileString%(pApp$, pKey$, pString$)
End Sub

Function StripPath$ (T$)
Dim x%, ct%
StripPath$ = T$
x% = InStr(T$, "\")
Do While x%
   ct% = x%
   x% = InStr(ct% + 1, T$, "\")
Loop
If ct% > 0 Then StripPath$ = Mid$(T$, ct% + 1)
End Function

