VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "WS/INIedit"
   ClientHeight    =   5595
   ClientLeft      =   855
   ClientTop       =   3285
   ClientWidth     =   6345
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   9.75
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   6285
   Icon            =   INIEDIT.FRX:0000
   Left            =   795
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5595
   ScaleWidth      =   6345
   Top             =   2655
   Width           =   6465
   Begin Ctl3D Ctl3D1 
      CenterDialogs   =   -1  'True
      ClassList       =   INIEDIT.FRX:0302
      IgnoreColors    =   -1  'True
      Left            =   4080
      No3DMenus       =   -1  'True
      Top             =   0
   End
   Begin CommonDialog CMDialog1 
      Left            =   5280
      Top             =   0
   End
   Begin CSFORM CSForm1 
      AcceptFiles     =   -1  'True
      FormHeight      =   419
      FormWidth       =   431
      HLargeChange    =   15
      HSmallChange    =   15
      HValue          =   0
      Left            =   3240
      LockIcon        =   0   'False
      MainForm        =   -1  'True
      ScrollBars      =   0   'False
      SystemModal     =   0   'False
      Top             =   0
      VirtualHeight   =   6870
      VirtualWidth    =   7545
      VLargeChange    =   15
      VSmallChange    =   15
      VValue          =   0
   End
   Begin Frame Frame3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Frame3"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   3615
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   6135
      Begin Outline Outline1 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   3135
         Left            =   120
         PictureClosed   =   INIEDIT.FRX:0310
         PictureLeaf     =   INIEDIT.FRX:046A
         PictureMinus    =   INIEDIT.FRX:05C4
         PictureOpen     =   INIEDIT.FRX:071E
         PicturePlus     =   INIEDIT.FRX:0878
         Style           =   2  'Plus/Minus and Text
         TabIndex        =   6
         Top             =   330
         Width           =   5895
      End
   End
   Begin Frame Frame2 
      BackColor       =   &H00C0C0C0&
      Height          =   615
      Left            =   0
      TabIndex        =   3
      Top             =   5270
      Width           =   5220
      Begin Label Label2 
         AutoSize        =   -1  'True
         BackColor       =   &H8000000F&
         BackStyle       =   0  'Transparent
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   195
         Left            =   240
         TabIndex        =   5
         Top             =   240
         Width           =   45
      End
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Notes:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1335
      Left            =   120
      TabIndex        =   1
      Top             =   3840
      Width           =   6120
      Begin TextBox Text2 
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   855
         Left            =   120
         MultiLine       =   -1  'True
         TabIndex        =   2
         Top             =   330
         Width           =   5895
      End
   End
   Begin Label Label3 
      BackColor       =   &H8000000F&
      BackStyle       =   0  'Transparent
      Caption         =   "Drag the INI file that you want to edit from File Manager onto this window."
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   13.5
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2055
      Left            =   1200
      TabIndex        =   4
      Top             =   1080
      Width           =   5175
   End
   Begin Menu AboutMenu 
      Caption         =   "&File"
      Begin Menu fMenu 
         Caption         =   "&Open"
         Index           =   0
      End
      Begin Menu fMenu 
         Caption         =   "&Close"
         Index           =   1
      End
      Begin Menu fMenu 
         Caption         =   "-"
         Index           =   2
      End
      Begin Menu fMenu 
         Caption         =   "&About WS/INIedit..."
         Index           =   3
      End
      Begin Menu fMenu 
         Caption         =   "-"
         Index           =   4
      End
      Begin Menu fMenu 
         Caption         =   "E&xit"
         Index           =   5
      End
   End
   Begin Menu EditMenu 
      Caption         =   "&Edit"
      Enabled         =   0   'False
      Begin Menu eMenu 
         Caption         =   "Cu&t"
         Index           =   0
         Shortcut        =   ^X
      End
      Begin Menu eMenu 
         Caption         =   "&Copy"
         Index           =   1
         Shortcut        =   ^C
      End
      Begin Menu eMenu 
         Caption         =   "&Paste"
         Index           =   2
         Shortcut        =   ^V
      End
   End
   Begin Menu OutlineMenu 
      Visible         =   0   'False
      Begin Menu oMenu 
         Caption         =   "Edit Current Item"
         Index           =   0
      End
      Begin Menu oMenu 
         Caption         =   "Delete Current Item"
         Index           =   1
      End
      Begin Menu oMenu 
         Caption         =   "Copy Current Item"
         Index           =   2
      End
   End
End


Option Explicit
Option Compare Text
DefInt A-Z
Dim MyIni$

Sub CSForm1_DropFiles (nFiles As Integer, x1 As Single, y1 As Single, Client As Integer)
If nFiles > 1 Then MsgBox "WS/INIedit can only handle one file at a time.": Exit Sub
Dim a$
a$ = CSForm1.DropFile(1)
If Not InStr(a$, ".INI") > 0 Then Exit Sub
Form1.Show
OpenSpecifiedFile a$
EditMenu.Enabled = True
End Sub

Sub CSForm1_MenuBrowse (MenuCaption As String)
Dim x$
x$ = Left$(MenuCaption, 3)
Select Case x$
Case "&Op"
    Label2 = "Select a file to open."
Case "&Cl"
    Label2 = "Close the current file."
Case "Edi"
    Label2 = "Modify the current item."
Case "Del"
    Label2 = "Delete the current item or section."
Case "&Co"
    Label2 = "Copy the current item to the clipboard."
Case "&Pa"
    Label2 = "Paste the contents of the clipboard."
Case "&Ab"
    Label2 = "View copyright information for this utility."
Case "E&x"
    Label2 = "Exit WS/INIedit."
Case Else
    Label2 = ""
End Select

End Sub

Sub CSForm1_MouseEnter (Wnd As Integer, CtlName As String, ctltag As String)
If MyFile$ = "" Then
    Label2 = ""
Else
    Select Case CtlName
        Case Is = "Outline1"
            Label2 = "Select an INI section or item to edit. Right click for menu."
        Case Is = "Text1"
            Label2 = "Enter or edit the value of the selected item."
        Case Is = "Frame1", "Text2"
            Label2 = "Enter a comment or reminder about this item."
        Case Else
            Label2 = ""
    End Select
End If
End Sub

Sub CSForm1_WinIniChange (Section As String)
'notify user of change to WinINI
If StripPath$(MyFile$) = "WIN.INI" Then
    If Confirm%("Another application has modified section " & Section & " of WIN.INI! Do you want to load the modified version?") Then
        OpenSpecifiedFile "WIN.INI"
    End If
End If

End Sub

Sub eMenu_Click (Index As Integer)
Select Case Index
Case 0  'cut
    SendKeys "+{DELETE}"
Case 1  'copy
'copy current item
    If TypeOf Screen.ActiveControl Is Outline Then
        Clipboard.SetText Outline1
    Else
        Clipboard.SetText Text2
    End If
Case 2  'paste
    SendKeys "+{INSERT}"
End Select
End Sub

Sub FixOutlineDisplay ()
'fix for bug in outline control which hides
'first item when you change its LIST property
Dim li%
li% = Outline1.ListIndex
If Outline1.IsItemVisible(li%) = False Then
    Do While Outline1.Indent(Outline1.ListIndex) = 2
        Outline1.ListIndex = Outline1.ListIndex - 1
    Loop
    Outline1.Expand(Outline1.ListIndex) = True
    Outline1.ListIndex = li%
End If
End Sub

Sub fMenu_Click (Index As Integer)
Select Case Index
Case 0  'open
 Const OFN_HIDEREADONLY = &H4&
 Const OFN_OVERWRITEPROMPT = &H2&
 Const OFN_EXTENTIONDIFFERENT = &H400&
 Const OFN_FILEMUSTEXIST = &H1000&
 Const CancelButton = 32755
'  * * * * * * * * * * * * * * * * * * * * * * * * * * * *
'  set up common dialog
'  * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   CMDialog1.Flags = OFN_HIDEREADONLY Or OFN_FILEMUSTEXIST
   CMDialog1.DefaultExt = "INI"
   CMDialog1.CancelError = True
   On Error Resume Next
ExtenErrorLoop:
   CMDialog1.Filter = "INI files|*.INI"
'  * * * * * * * * * * * * * * * * * * * * * * * * * * * *
'  call common dialog
'  exit if user cancels
'  * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   CMDialog1.Action = 1
   If Err = CancelButton Then Exit Sub
'  * * * * * * * * * * * * * * * * * * * * * * * * * * * *
'  don't accept extension other than default (INI)
'  * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   If CMDialog1.Flags And OFN_EXTENTIONDIFFERENT Then
      MsgBox "File must have an INI extension!"
      GoTo ExtenErrorLoop
   End If
   On Error GoTo 0
   Dim a$
   a$ = CMDialog1.Filename
   If a$ = "" Then Exit Sub
   OpenSpecifiedFile a$
   EditMenu.Enabled = True
'  * * * * * * * * * * * * * * * * * * * * * * * * * * * *
'  load file
'  * * * * * * * * * * * * * * * * * * * * * * * * * * * *
Case 1  'close
    Outline1.Clear
    MyFile$ = ""
    EditMenu.Enabled = False
    Outline1.Visible = False
    Frame1.Visible = False
    Frame3.Visible = False
    Label3.Visible = True
    fMenu(1).Enabled = False
Case 3  'about
MsgBox "WS/INIedit copyright  1995 by Paul Bonner." + CRLF$ + "All Rights Reserved."
Case 5  'exit
    If CommentChanged% = True Then UpdateComment: CommentChanged% = False
    Unload Me
    End
Case Else
End Select
End Sub

Sub Form_Load ()
CTL3D1.Disabled = CheckForWin95%()
CRLF$ = Chr$(13) + Chr$(10)
MyIni$ = "WSINIED.INI"
CenterForm Me
fMenu(1).Enabled = False
Label3.Left = (Width - Label3.Width) / 2
'hide ini display controls until we have a file to edit
Outline1.Visible = False
Frame1.Visible = False
Frame3.Visible = False
'process command line arguements
If InStr(Command$, ".ini") > 0 Then OpenSpecifiedFile Command$: EditMenu.Enabled = True
End Sub

Sub Form_Resize ()
Frame2.Width = Width + 60
Frame2.Left = -30
Label2.Top = 110
End Sub

Sub oMenu_Click (Index As Integer)
Select Case Index
Case 0  'edit
    Form2.Show 1
    FixOutlineDisplay
Case 1  'del
    Dim a$, b$, c$, x%
    x% = InStr(CurrentItem$, "\")
    If x% > 0 Then
        a$ = Left$(CurrentItem$, x% - 1)
        b$ = Mid$(CurrentItem$, x% + 1)
       
    End If
    c$ = Form1.Frame3.Caption
    x% = Outline1.ListIndex
    Select Case Outline1.Indent(x%)
    Case 1
        If Confirm%("Do you really want to delete this section?") Then
            a$ = Outline1
            DelPrivIniSection a$, c$
            'after deleting section in file
            'remove section title and all its children from outline
            Form1.Outline1.RemoveItem Form1.Outline1.ListIndex
            Outline1.ListIndex = x%
            Do While Outline1.Indent(x%) = 2
                Form1.Outline1.RemoveItem Form1.Outline1.ListIndex
            Loop
        End If
    Case Else
        If a$ = "" Then Exit Sub
        If Confirm%("Do you really want to delete this item?") Then
            DelPrivIniItem a$, b$, c$
            Form1.Outline1.RemoveItem Form1.Outline1.ListIndex
        End If
    End Select
Case 2  'copy current item
   Clipboard.SetText Outline1
End Select
End Sub

Sub OpenSpecifiedFile (Target$)
'local variables

Dim a$, x%, j%, Y%, b$
'warn & exit if target$=system.ini
a$ = ExtractFileName$(Target$)
If a$ = "system.ini" Then
    If Confirm%("Sorry, the Windows " & a$ & " file is a not" & CRLF$ & "a standard INI file, and cannot be edited" & CRLF$ & "using " & App.Title & "." + CRLF$ + CRLF$ + "Would you like to load " + a$ + " into Notepad?") Then
        x% = Shell("notepad.exe " + a$, 1)
    End If
    Exit Sub
End If
'busy cursor
Screen.MousePointer = 11
'hide initial message and show INI display controls
fMenu(1).Enabled = True  'this is the File Close item
Label3.Visible = False
Outline1.Visible = True
Frame1.Visible = True
Frame3.Visible = True
'clear out old INI file
Outline1.Clear
'identify file to open
MyFile$ = Target$
Frame3.Caption = MyFile$
'get list of sections
a$ = ListPrivIniSections$(MyFile$)
x = 1
j% = InStr(a$, CRLF$)
'add sections to outline
Do While Len(a$) > 2
    If j% = 0 Then
        j% = Len(a$)
        Outline1.AddItem Mid$(a$, x% + 1, j% - 2)
    Else
        Outline1.AddItem Mid$(a$, x% + 1, j% - 3)
    End If
    a$ = Mid$(a$, j% + 2)
    j% = InStr(a$, CRLF$)
Loop


'loop through outline from last section to first to get items for each section
'going backwards ensures that every outline item we encounter is a section
Dim item$, itemName$
For Y% = Outline1.ListCount - 1 To 0 Step -1
    Outline1.ListIndex = Y%
    a$ = Outline1
    b$ = ListPrivIniEntries$(a$, MyFile$)
    'list comes back separated by chr$(0)'s
    'terminates with two in a row
    x = InStr(b$, Chr$(0))
    Do While x > 1
        Outline1.ListIndex = Y%
        'extract item name
        itemName$ = Left$(b$, x - 1)
        'get data for current item
        item$ = GetPrivINI$(a$, itemName$, "", MyFile$)
        Outline1.AddItem itemName$ & "=" & item$
        b$ = Mid$(b$, x + 1)
        x = InStr(b$, Chr$(0))
    Loop
Next
On Error Resume Next
Outline1.SetFocus
'standard cursor
Screen.MousePointer = 0
End Sub

Sub Outline1_Click ()
'busy cursor
Screen.MousePointer = 11
Dim a$, x%, b$
'save comments from last item if necessary
If CommentChanged% = True Then UpdateComment: CommentChanged% = False
'reset pointer to current item used by update value/comment routines
CurrentItem$ = Outline1.FullPath(Outline1.ListIndex)
x% = InStr(CurrentItem$, "=")
If x% > 0 Then CurrentItem$ = Left$(CurrentItem$, x% - 1)
'get comment for this item
Text2 = GetPrivINI$(ExtractFileName$(MyFile$), CurrentItem$, "", MyIni$): CommentChanged% = False
'update popup menu Delete option
If Outline1.Indent(Outline1.ListIndex) = 1 Then
    oMenu(1).Caption = "Delete Current Section"
    oMenu(2).Caption = "Copy Current Section"
Else
    oMenu(1).Caption = "Delete Current Item"
    oMenu(2).Caption = "Copy Current Item"
End If
Screen.MousePointer = 0
End Sub

Sub Outline1_DblClick ()
Dim x%
x% = Outline1.ListIndex
If Outline1.Indent(x%) > 1 Then
    Form2.Show 1
    FixOutlineDisplay
Else
   Outline1.Expand(x%) = Not Outline1.Expand(x%)
End If
End Sub

Sub Outline1_GotFocus ()
If MyFile$ <> "" Then Label2 = "Select an INI section or item to edit. Right click for menu."
eMenu(1).Enabled = True
eMenu(2).Enabled = False
eMenu(0).Enabled = False
End Sub

Sub Outline1_KeyPress (KeyAscii As Integer)
Dim x%
x% = Outline1.ListIndex
If KeyAscii = 13 Then
    If Outline1.Indent(x%) > 1 Then
        Form2.Show 1
        FixOutlineDisplay
    Else
        Outline1.Expand(x%) = Not Outline1.Expand(x%)
    End If
End If
End Sub

Sub Outline1_KeyUp (KeyCode As Integer, Shift As Integer)
If Outline1.ListCount > 0 Then Outline1_Click
End Sub

Sub Outline1_MouseDown (Button As Integer, Shift As Integer, x As Single, Y As Single)
DownY% = Y
If Button = 2 And Outline1.ListCount > 0 Then
    If Outline1.Indent(Outline1.ListIndex) = 1 Then oMenu(0).Visible = False:  Else oMenu(0).Visible = True
    PopupMenu OutlineMenu
End If
End Sub

Sub Text2_Change ()
CommentChanged% = True
End Sub

Sub Text2_GotFocus ()
If MyFile$ <> "" Then Label2 = "Enter a comment or reminder about this item."
eMenu(0).Enabled = True
eMenu(2).Enabled = True
eMenu(1).Enabled = True
End Sub

Sub Text2_MouseDown (Button As Integer, Shift As Integer, x As Single, Y As Single)
    If Button = 2 Then PopupMenu EditMenu
End Sub

Sub UpdateComment ()
Screen.MousePointer = 11
'delete entry if empty
If Text2.Text = "" Then
    DelPrivIniItem ExtractFileName$(MyFile$), CurrentItem$, MyIni$
Else
'otherwise store new value
    PutPrivIni ExtractFileName$(MyFile$), CurrentItem$, Text2.Text, MyIni$
End If
Screen.MousePointer = 0
End Sub

