/***************************************************************************
  Windows Sockets FTP Client Application

  Written by:
      John A. Junod             Internet: <junodj@gordon-emh2.army.mil>
      267 Hillwood Street                 <zj8549@trotter.usma.edu>
      Martinez, GA 30907      Compuserve: 72321,366 

  This program executable and all source code is released into the public
  domain.  It would be nice (but is not required) to give me a little 
  credit for any use of this code.

  The user interface for this FTP client is designed with the novice FTP user
  in mind.  Usage should (??) be obvious with the possible exception of the
  the transfer mode; ascii, binary or l8.  All controls are standard Windows
  controls.

  My development and testing was all completed at home on two 386 PC's using
  the Trumpet Windows Sockets DLL Alpha 15 with NCSA Telnet and WinQVT/Net 2.6
  and 3.9 as the remote host.  Source code may be compiled with Borland C++
  in large mode.

  Some code concepts and names are based on code that is copyright by the
  Regents of the University of California or code published in UNIX Network
  Programming by W. Richard Stevens or code in WATTCP or other public sources.
  The rest is based on my knowledge of Windows programming and my 
  interpretation of RFC 969 and the Windows Sockets API version 1.1.

  THE INFORMATION AND CODE PROVIDED IS PROVIDED AS IS WITHOUT WARRANTY 
  OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
  PURPOSE. IN NO EVENT SHALL JOHN A. JUNOD BE LIABLE FOR ANY DAMAGES 
  WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL, CONSEQUENTIAL, LOSS 
  OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF JOHN A. JUNOD HAS BEEN 
  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

*****************************************************************************/

//----------------------
#include "ws_glob.h"
#include "WS_ftp.H"
#include "version.h"
//----------------------
#include <stdarg.h>
#include <ctype.h>
#include <shellapi.h>

 // lgk new debugging variable
BOOLEAN DEBUGGING_ON = FALSE;

int selects[256];
extern char szInitDir[];
HBRUSH hbrGray1,hbrGray2;
extern HWND hWndDbg;

#ifndef USEASYNC
SubProcessAsync(HWND hWnd,UINT Message,WPARAM wParam,LPARAM lParam)
{
  return(FALSE);
}
#endif

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpszCmdLine, int nCmdShow)
{
  MSG        msg;
  int        nRc;
  long       nWndunits;
  int        nX;
  int        nY;
  int        nWidth;
  int        nHeight;
  int        err;
//  HINSTANCE hWinSock;

  if (strstr(lpszCmdLine,"-d") != NULL)
    {
	  // we want debugging
	  DEBUGGING_ON = TRUE;
	}
   
  if ((err = WSAStartup((WORD)0x0101, &WSAData))!=0)  // register task with
  {                                         // winsock tcp/ip API
    MessageBox(NULL,ReturnWSError(err,NULL),"WS_FTP - WSAStartup",
          MB_OK|MB_ICONEXCLAMATION);
  } else {
    strcpy(szAppName, "WS_FTP");
    hInst = hInstance;

    if(!hPrevInstance)
    {
      // register window classes if first instance of application
      if ((nRc = nCwRegisterClasses()) == -1)
      {
        // registering one of the windows failed
        MessageBox((HWND)NULL, "Window creation failed",
              NULL, MB_ICONEXCLAMATION);
        return nRc;    
      }
    }

    // Create a device independant size and location
    nWndunits = GetDialogBaseUnits();
    nWndx = LOWORD(nWndunits);
    nWndy = HIWORD(nWndunits);
    nX = ((18 * nWndx) / 4);
    nY = ((18 * nWndy) / 8);
    nWidth = ((247 * nWndx) / 4);
    nHeight = ((211 * nWndy) / 8);

    // create application's Main window
    hWndMain = CreateWindow(
      szAppName, "WinSock_FTP",
      WS_CAPTION     | WS_SYSMENU    | WS_MINIMIZEBOX  |
      WS_CLIPCHILDREN | WS_OVERLAPPED,
      nX,nY, nWidth, nHeight,
      (HWND)NULL, (HMENU)NULL, hInst,  NULL);

    if(hWndMain == (HWND)NULL)
    {
      MessageBox((HWND)NULL, "Error registering class",
            NULL, MB_ICONEXCLAMATION);
      return 2;
    }

    ShowWindow(hWndMain, nCmdShow);         // display main window
    GetLocalInfo();
    if(bAutoStart)
      PostMessage(hWndMain,WM_COMMAND,BTN_CONNECT,0L);
    while(GetMessage(&msg, (HWND)NULL, 0, 0))     // Until WM_QUIT message
    {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
    WSACleanup();
    ReleaseDisplayMem();

    // Do clean up before exiting from the application
    CwUnRegisterClasses();
  }
  return msg.wParam;
} //  End of WinMain

int VerifyDelete(LPSTR fname)
{
  wsprintf(szDlgPrompt,"Are you sure you want to delete \"%s\"?",fname);
  return(MessageBox(hWndMain,szDlgPrompt,"Verify Deletion",MB_YESNO)==IDYES);
}

void MakeLower(LPSTR str) {
  while(*str) {
    *str=tolower(*str);
    str++;
  }
}

int StdInput(LPSTR dest,LPSTR fmt,...)
{
  va_list args;
//  FARPROC lpfnMsgProc;
  int  iRetCode;

  va_start(args,fmt);
  vsprintf(szDlgPrompt,fmt,args);
  va_end(args);
  if (dest != NULL) // lgk fix for nt caused access violation
   lstrcpy(szDlgEdit,dest);
  
  else szDlgEdit[0] = 0;

//  lpfnMsgProc=MakeProcInstance((FARPROC)WS_InputMsgProc,hInst);
    iRetCode=DialogBox(hInst,(LPSTR)"DLG_INPUT",hWndMain,WS_InputMsgProc);
//  FreeProcInstance(lpfnMsgProc);
  if(iRetCode && dest) 
  
  // lgk fix here since if dest was null we cannot copy to it
   if (dest != NULL)
    lstrcpy(dest,szDlgEdit);
  
  return(iRetCode);
}

int StdInputPassword(LPSTR dest,LPSTR fmt,...)
{
  va_list args;
  //FARPROC lpfnMsgProc;
  int  iRetCode;

  va_start(args,fmt);
  vsprintf(szDlgPrompt,fmt,args);
  va_end(args);
  lstrcpy(szDlgEdit,dest);
//  lpfnMsgProc=MakeProcInstance((FARPROC)WS_InputMsgProc,hInst);
  iRetCode=DialogBox(hInst,(LPSTR)"DLG_INPUT_PASSWORD",hWndMain,WS_InputMsgProc);
//  FreeProcInstance(lpfnMsgProc);
  if(iRetCode && dest) lstrcpy(dest,szDlgEdit);
  return(iRetCode);
}

/************************************************************************/
/* Main Window Procedure                                                */
/************************************************************************/
LRESULT CALLBACK WndProc(HWND hWnd,UINT Message,WPARAM wParam,LPARAM lParam)
{
  int nIndex,nRC;
  char tempdirectoryname[140];

  switch (Message)
  {
    case WM_COMMAND:
      if(LOWORD(wParam)==BTN_CLOSE || LOWORD(wParam)==BTN_EXIT ||
         LOWORD(wParam)==CMD_CLOSE || LOWORD(wParam)==IDM_EXIT) {
        bAborted=TRUE;
        if(data_socket!=INVALID_SOCKET)
          data_socket=DoClose(data_socket);
        if(listen_socket!=INVALID_SOCKET)
          listen_socket=DoClose(listen_socket);
        if(ctrl_socket!=INVALID_SOCKET) {
          command(ctrl_socket,"QUIT");
          ctrl_socket=DoClose(ctrl_socket);
          bConnected=FALSE;
        }
        SetWindowText(hWnd,"WS_FTP");
        if(LOWORD(wParam)==IDM_EXIT || LOWORD(wParam)==BTN_EXIT)
          SendMessage(hWnd,WM_CLOSE,0,0L);
        else
          GetRemoteDirForWnd(hWnd);
        break;
      } else if(bCmdInProgress) return(FALSE);
      switch (LOWORD(wParam))
      {

// child windows messages ************************************
// local buttons and boxes
        case LST_LDIRS:
          if (HIWORD(wParam) !=LBN_DBLCLK) return(FALSE);
        case BTN_LCHANGE:
            if((nIndex=SendMessage(hLbxLDir,LB_GETCURSEL,
                0,0L))!=LB_ERR)
            {
              SendMessage(hLbxLDir,LB_GETTEXT,nIndex,
                                 (LONG)szMsgBuf);
              if(strncmp(szMsgBuf,"[-",2)==0) {
#ifdef _MSC_
                _chdrive(tolower(szMsgBuf[2])-0x60);
#else
                setdisk(szMsgBuf[2]-'a');
#endif
                GetLocalDirForWnd(hWnd);
              } else if(chdir(szMsgBuf)==0)
                GetLocalDirForWnd(hWnd);
            } else {
              if(StdInput(NULL,"Enter local directory name:")) {
                if(szDlgEdit[1]==':')
#ifdef _MSC_
                  _chdrive(tolower(szDlgEdit[0])-0x60);
#else
                  setdisk(tolower(szDlgEdit[0])-'a');
#endif
                chdir(szDlgEdit);
                GetLocalDirForWnd(hWnd);
              }
            }
          break;
        case LST_LFILES:
          if(HIWORD(wParam) !=LBN_DBLCLK) return(FALSE);
        case BTN_LOCAL_TO_REMOTE:
          {
            u_char tmp[80];
            char localname[220];
            char remotename[80];
            int count;

            count=SendMessage(hLbxLFiles,
                      LB_GETSELITEMS,256,(LPARAM)(int far *)selects);
            if(count>0 && count!=LB_ERR) {
              for(nIndex=0;nIndex<count;nIndex++) {
                SendMessage(hLbxLFiles,LB_GETTEXT,selects[nIndex],
                                 (LONG)localname);
                lstrcpy(remotename,localname);
                if(bInteractive) 
                  StdInput(remotename,"Enter remote file name for %s:",localname);
                wsprintf(tmp,"sending %s as %s (%u of %u)",localname,remotename,nIndex+1,count);
                SendMessage(hTxtStatus,WM_SETTEXT,0,(LPARAM)tmp);
                wsprintf(tmp,"STOR %s",remotename);
                nRC=SendFile(ctrl_socket,tmp,localname,fType);
                if(nRC!=2) break;
              }  
              GetRemoteDirForWnd(hWnd);
            }
          }
          break;
        case BTN_LMKDIR:
          if(StdInput(NULL,"Enter new local directory name:")) {
            mkdir(szDlgEdit);
            GetLocalDirForWnd(hWnd);
          }
          break;
        case BTN_LRMDIR:
            if((nIndex=SendMessage(hLbxLDir,LB_GETCURSEL,
                0,0L))!=LB_ERR)
            {
              SendMessage(hLbxLDir,LB_GETTEXT,nIndex,
                                 (LONG)szMsgBuf);
              if(VerifyDelete(szMsgBuf))
                if(rmdir(szMsgBuf)==0)
                  GetLocalDirForWnd(hWnd);
            }
          break;
        case BTN_LDELETE:
          {
            int count;
            count=SendMessage(hLbxLFiles,
                      LB_GETSELITEMS,256,(LPARAM)(int far *)selects);
            if(count>0 && count!=LB_ERR) {
              for(nIndex=0;nIndex<count;nIndex++) {
                SendMessage(hLbxLFiles,LB_GETTEXT,selects[nIndex],
                                 (LONG)szDlgEdit);
                if(VerifyDelete(szDlgEdit))
                  unlink(szDlgEdit);
              }  
              GetLocalDirForWnd(hWnd);
            }
          }
          break;
        case BTN_LRENAME:
          if((nIndex=SendMessage(hLbxLFiles,LB_GETCURSEL,
                0,0L))!=LB_ERR)
          {
            SendMessage(hLbxLFiles,LB_GETTEXT,nIndex,
                               (LONG)szMsgBuf);
            if(StdInput(NULL,"Enter new name for \"%s\":",szMsgBuf))
              if(rename(szMsgBuf,szDlgEdit)==0)
                GetLocalDirForWnd(hWnd);
          }
          break;
        case BTN_LDISPLAY:
          {
            char remotename[80];
            if((nIndex=SendMessage(hLbxLFiles,LB_GETCURSEL,
                0,0L))!=LB_ERR)
            {
              SendMessage(hLbxLFiles,LB_GETTEXT,nIndex,
                                 (LONG)remotename);
              wsprintf(szMsgBuf,"%s %s",szViewer,remotename);
              if(strchr(remotename,'.')==NULL)
                strcat(szMsgBuf,".");
              WinExec(szMsgBuf,SW_SHOW);
            }
          }
          break;
// remote buttons and boxes
        case BTN_RMKDIR:
          if(StdInput(NULL,"Enter new remote directory name:"))
            if((nRC=DoMKD(ctrl_socket,szDlgEdit))==FTP_COMPLETE)
              GetRemoteDirForWnd(hWnd);
          break;
        case BTN_RRMDIR:
          if((nIndex=SendMessage(hLbxRDir,LB_GETCURSEL,
                0,0L))!=LB_ERR)
          {
            SendMessage(hLbxRDir,LB_GETTEXT,nIndex,
                               (LONG)szMsgBuf);
            if(VerifyDelete(szMsgBuf))
              if((nRC=DoRMD(ctrl_socket,szMsgBuf))==FTP_COMPLETE)
                GetRemoteDirForWnd(hWnd);
          }
          break;
        case BTN_RDELETE:
          {
            int count;
            count=SendMessage(hLbxRFiles,LB_GETSELITEMS,
                                 256,(LPARAM)(int far *)selects);
            if(count>0 && count!=LB_ERR) {
              for(nIndex=0;nIndex<count;nIndex++) {
                SendMessage(hLbxRFiles,LB_GETTEXT,selects[nIndex],
                                 (LONG)szDlgEdit);
                if(VerifyDelete(szDlgEdit))
                  nRC=DoDELE(ctrl_socket,szDlgEdit);
              }
              GetRemoteDirForWnd(hWnd);
            }
          }
          break;
        case BTN_RRENAME:
          if((nIndex=SendMessage(hLbxRFiles,LB_GETCURSEL,
                0,0L))!=LB_ERR)
          {
            SendMessage(hLbxRFiles,LB_GETTEXT,nIndex,
                               (LONG)szMsgBuf);
            if(StdInput(NULL,"Enter new name for \"%s\":",szMsgBuf))
              if((nRC=command(ctrl_socket,"RNFR %s",szMsgBuf))==FTP_CONTINUE)
                if((nRC=command(ctrl_socket,"RNTO %s",szDlgEdit))==FTP_COMPLETE)
                  GetRemoteDirForWnd(hWnd);
          }
          break;
        case LST_RDIRS:
          if(HIWORD(wParam)!=LBN_DBLCLK) return(FALSE);
        case BTN_RCHANGE:
            if((nIndex=SendMessage(hLbxRDir,LB_GETCURSEL,
                0,0L))!=LB_ERR)
            {
              SendMessage(hLbxRDir,LB_GETTEXT,nIndex,
                                 (LONG)szMsgBuf);
              nRC=DoCWD(ctrl_socket,szMsgBuf);
              if(nRC==FTP_COMPLETE)
                GetRemoteDirForWnd(hWnd);
            } else {
              if(StdInput(NULL,"Enter remote directory name:")) 
                if((nRC=DoCWD((SOCKET)ctrl_socket,szDlgEdit))==FTP_COMPLETE)
                  GetRemoteDirForWnd(hWnd);
            }
          break;
        case LST_RFILES:
          if(HIWORD(wParam)!=LBN_DBLCLK) return(FALSE);
        case BTN_REMOTE_TO_LOCAL:
          {
            char tmp[80];
            char remotename[80];
            char localname[220];
			char shortname[80];
            int count;

            count=SendMessage(hLbxRFiles,LB_GETSELITEMS,
                                 256,(LPARAM)(int far *)selects);
            if(count>0 && count!=LB_ERR) {
              for(nIndex=0;nIndex<count;nIndex++) {
                SendMessage(hLbxRFiles,LB_GETTEXT,selects[nIndex],
                                 (LONG)remotename);
                MakeLocalName(localname,shortname,remotename);
                if(bInteractive)
                  StdInput(localname,"Enter local file name for %s:",remotename);
                DoPrintf("receiving %s as %s (%u of %u)",
                     remotename,localname,nIndex+1,count);
                wsprintf(tmp,"RETR %s",remotename);
                nRC=RetrieveFile((SOCKET)ctrl_socket,(LPSTR)tmp,
                     (LPSTR)localname,(LPSTR)shortname,fType);
                if(nRC==2)
                  SendMessage(hLbxLFiles,LB_ADDSTRING,0,(LONG)remotename);
                else
                  break;
              }
              GetLocalDirForWnd(hWnd);
            }
          }
          break;
        case BTN_RDISPLAY:
          {
            char tmp[80];
            char remotename[80];
            if((nIndex=SendMessage(hLbxRFiles,LB_GETCURSEL,
                0,0L))!=LB_ERR)
            {
              SendMessage(hLbxRFiles,LB_GETTEXT,nIndex,
                                 (LONG)remotename);
              wsprintf(tmp,"RETR %s",remotename);
              nRC=RetrieveFile((SOCKET)ctrl_socket,(LPSTR)tmp,
                           (LPSTR)szTmp1File,(LPSTR)szTmp1File,TYPE_A);
              if(nRC==2) {
                wsprintf(szString,"%s %s",szViewer,szTmp1File);
                if(strchr(szTmp1File,'.')==NULL)
                  strcat(szString,".");
                WinExec(szString,SW_SHOW);
              }
              GetLocalDirForWnd(hWnd);
            }
          }
          break;

        case RB_ASCII:
          fType=TYPE_A;
ShowType:
        case RB_SHOWCHECKS:
          SendMessage(hRBascii, BM_SETCHECK,fType==TYPE_A,0L);
          SendMessage(hRBbinary,BM_SETCHECK,fType==TYPE_I,0L);
          SendMessage(hRBl8,    BM_SETCHECK,fType==TYPE_L,0L);
          break;
        case RB_BINARY:
          fType=TYPE_I;
          goto ShowType;
        case RB_L8:
          fType=TYPE_L;
          goto ShowType;

// end of child window message processing *******************

        case BTN_CONNECT:
        case CMD_CONNECT:
          if(ctrl_socket==INVALID_SOCKET) {
            { //FARPROC lpfnMsgProc;
              use_gateway=0;
        //      lpfnMsgProc=MakeProcInstance((FARPROC)WS_HostMsgProc,hInst);
              nRC=DialogBox(hInst,(LPSTR)"DLG_HOST",hWnd,WS_HostMsgProc);
       //       FreeProcInstance(lpfnMsgProc);
            }
            if(nRC) {
              ctrl_socket=(SOCKET)DoConnect(szRemoteHost);
              if(ctrl_socket!=INVALID_SOCKET) {
                if(szInitDir[0]!=0) {
                  DoCWD(ctrl_socket,szInitDir);
                }
                if(LOWORD(wParam)==BTN_CONNECT)
                  GetRemoteDirForWnd(hWnd);
              }
            }
          } else
            SendMessage(hTxtStatus,WM_SETTEXT,0,(LPARAM)"Already connected");
          break;

        case BTN_LONG:
          if(bConnected) {
            wsprintf(szMsgBuf,"%s %s",szViewer,szTmpFile);
            WinExec(szMsgBuf,SW_SHOW);
          }
          break;

        case BTN_OPTION:
          { //FARPROC lpfnMsgProc;
    //        lpfnMsgProc = MakeProcInstance((FARPROC)WS_StatMsgProc, hInst);
            DialogBox(hInst, (LPSTR)"DLG_STATUS", hWnd, WS_StatMsgProc);
       //     FreeProcInstance(lpfnMsgProc);
          }
          SendMessage(hWnd,WM_COMMAND,RB_SHOWCHECKS,0l);
          break;

        case BTN_ABOUT:
        case IDM_ABOUT:
          { //FARPROC lpfnMsgProc;
         //   lpfnMsgProc = MakeProcInstance((FARPROC)WS_AboutMsgProc, hInst); 
            DialogBox(hInst, (LPSTR)"DLG_ABOUT", hWnd, WS_AboutMsgProc);
        //    FreeProcInstance(lpfnMsgProc);
          }
          break;

        default:
          if(!SubProcessAsync(hWnd,Message,wParam,lParam))
            return DefWindowProc(hWnd, Message, wParam, lParam);
      }
      break;

    case WM_VSCROLL:
      switch(LOWORD(wParam)) {
        case SB_LINEUP:
          ScrollStatus(-1);
          break;
        case SB_LINEDOWN:
          ScrollStatus(1);
          break;
      }
      break;

    case WM_CREATE:
      hStdCursor=LoadCursor((HINSTANCE)NULL,IDC_ARROW);
      hWaitCursor=LoadCursor((HINSTANCE)NULL,IDC_WAIT);
      LoadUserInfo();
      hbrGray1= CreateSolidBrush(RGB(192,192,192));
      hbrGray2=CreateSolidBrush(RGB(128,128,128));
      
      if (DEBUGGING_ON)
        CreateDebugWindow(hWnd,hInst);
      
      CreateSubWindows(hWnd,hInst);
      GetLocalDirForWnd(hWnd);
      GetRemoteDirForWnd(hWnd);
      SendMessage(hWnd,WM_COMMAND,RB_SHOWCHECKS,0L);
	  GetCurrentDirectory(140,tempdirectoryname);
      GetTempFileName(tempdirectoryname,"DIR",0,szTmpFile);
      GetTempFileName(tempdirectoryname,"DSP",0,szTmp1File);
      DragAcceptFiles(hWnd,TRUE);
      break;

    case WM_TIMER:
      if(wParam==10){
        KillTimer(hWndMain,10);
        if(WSAIsBlocking()) {
          DoAddLine("Timer cancelled blocking call");    
          bAborted=TRUE;
          WSACancelBlockingCall();
        }
      }
      break;


     case WM_CTLCOLORBTN:
           if(LOWORD(lParam)<10) return((LRESULT)NULL);

     case WM_CTLCOLORSTATIC:
               SelectObject((HDC)wParam, GetStockObject(ANSI_VAR_FONT));
                SetBkColor((HDC) wParam, RGB(192,192,192));
                return(LRESULT)hbrGray1;
				break;
        

    case WM_SETCURSOR:
      if(bCmdInProgress) {
        SetCursor(hWaitCursor);
        return(TRUE);
      } else
        return DefWindowProc(hWnd, Message, wParam, lParam);

    case WM_DROPFILES:
      {
         POINT pt;
         WORD cFiles, a;
         char szFile[150];
         char szRemoteName[80];
         u_char tmp[80];
         LPSTR lpszBaseName;

         DragQueryPoint((HANDLE) wParam, &pt);

         cFiles = DragQueryFile((HANDLE) wParam, 0xFFFF, (LPSTR) NULL, 0);
         if(!bConnected)
           DoPrintf("NOT CONNECTED!! File(s) ignored.");
         else if(bCmdInProgress)
           DoPrintf("We are already busy!! File(s) ignored.");
         else {
           for(a = 0; a < cFiles; pt.y += 20, a++) {
             DragQueryFile((HANDLE) wParam, a, szFile, sizeof(szFile));
             MakeLower(szFile);
             if((lpszBaseName=strrchr(szFile,'\\'))!=NULL) {
               lstrcpy(szRemoteName,++lpszBaseName);
               if(bInteractive) 
                  StdInput(szRemoteName,"Enter remote file name for %s:",lpszBaseName);
               wsprintf(tmp,"sending %s as %s (%u of %u)",szFile,szRemoteName,a,cFiles);
               SendMessage(hTxtStatus,WM_SETTEXT,0,(LPARAM)tmp);
               wsprintf(tmp,"STOR %s",szRemoteName);
               nRC=SendFile(ctrl_socket,tmp,szFile,fType);
               if(nRC!=2) break;
             }  
           }
           GetRemoteDirForWnd(hWnd);
         }
         DragFinish((HANDLE) wParam);
      }
      break;

    case WM_PAINT:  // code for the window's client area
      DoMainPaint(hWnd);
      break;

    case WM_CLOSE:  // close the window 
      // Destroy child windows, modeless dialogs, then, this window
      if (hWnd == hWndMain) {
        if(data_socket!=INVALID_SOCKET)
          data_socket=DoClose(data_socket);
        if(listen_socket!=INVALID_SOCKET)
          listen_socket=DoClose(data_socket);
        if(ctrl_socket!=INVALID_SOCKET)
          ctrl_socket=DoClose(ctrl_socket);
        DestroyWindow(hWnd);
        SaveUserInfo();
        DeleteObject(hbrGray1);
        DeleteObject(hbrGray2);
        _unlink(szTmpFile);
        _unlink(szTmp1File);
        DragAcceptFiles(hWnd,FALSE);
        PostQuitMessage(0);  // Quit the application
      } else
        DestroyWindow(hWnd);
      break;

    default:
      if(!SubProcessAsync(hWnd,Message,wParam,lParam))
        return DefWindowProc(hWnd, Message, wParam, lParam);
  }
  return 0L;
} // End of WndProc

/************************************************************************/
/* Misc Dialog Window Procedures                                        */
/************************************************************************/
BOOL CALLBACK WS_AboutMsgProc(HWND hWndDlg, UINT Message, 
                                WPARAM wParam, LPARAM lParam)
{
 char buf[40];
  
 switch(Message)
 {
   case WM_INITDIALOG:
     cwCenter(hWndDlg, 0);
     wsprintf(buf,"Version %s",VERSION);
     SetDlgItemText(hWndDlg,DLG_EDIT,buf);
     break;
					
      case WM_CTLCOLORBTN:
          if(LOWORD(lParam)<10) return((BOOL)NULL);

     case WM_CTLCOLORDLG:
     case WM_CTLCOLORSTATIC:
          SetBkColor((HDC) wParam, RGB(192,192,192));
        return (BOOL)hbrGray1;
        break;


   case WM_CLOSE:
     PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
     break;

   case WM_COMMAND:
     switch(LOWORD(wParam))
     {
       case IDOK:
         EndDialog(hWndDlg, TRUE);
         break;
       case IDCANCEL:
         EndDialog(hWndDlg, FALSE);
         break;
     }
     break;
    default:
        return FALSE;
  }
  return TRUE;
}

BOOL CALLBACK WS_InputMsgProc(HWND hWndDlg, UINT Message,
                                WPARAM wParam, LPARAM lParam)
{ 
  switch(Message)
  {
    case WM_INITDIALOG:
      SetDlgItemText(hWndDlg,DLG_PROMPT,szDlgPrompt);
      SetDlgItemText(hWndDlg,DLG_EDIT,szDlgEdit);
      cwCenter(hWndDlg, 0);
      break;
 

        case WM_CTLCOLORBTN:
             if(LOWORD(lParam)<10) return((LRESULT)NULL);

        case WM_CTLCOLORDLG:
        case WM_CTLCOLORSTATIC:
        SetBkColor((HDC) wParam, RGB(192,192,192));
         return(LRESULT)hbrGray1;
		  break;

    case WM_CLOSE:
      PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
      break;

    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case IDOK:
          GetDlgItemText(hWndDlg,DLG_EDIT,szDlgEdit,70);
          EndDialog(hWndDlg, TRUE);
          break;
        case IDCANCEL:
          EndDialog(hWndDlg, FALSE);
          break;
      }
      break;
    default:
      return FALSE;
  }
  return TRUE;
}

BOOL CALLBACK WS_StatMsgProc(HWND hWndDlg, UINT Message,
                               WPARAM wParam, LPARAM lParam)
{ 
  switch(Message)
  {
    case WM_INITDIALOG:
      SetDlgItemText(hWndDlg,DLG_EDIT,szViewer);
      SetDlgItemText(hWndDlg,DLG_MAILADDR,szMailAddress);
      if(fType==TYPE_A)
        CheckRadioButton(hWndDlg,RB_ASCII,RB_L8,RB_ASCII);
      else if(fType==TYPE_I)
        CheckRadioButton(hWndDlg,RB_ASCII,RB_L8,RB_BINARY);
      else
        CheckRadioButton(hWndDlg,RB_ASCII,RB_L8,RB_L8);
      CheckDlgButton(hWndDlg,CKB_VERBOSE,bVerbose);
      CheckDlgButton(hWndDlg,CKB_BELL,bBell);
      CheckDlgButton(hWndDlg,CKB_GLOBBING,bDoGlob);
      CheckDlgButton(hWndDlg,CKB_HASH,bHash);
      CheckDlgButton(hWndDlg,CKB_PROMPT,bInteractive);
      CheckDlgButton(hWndDlg,CKB_MCASE,bMCase);
      CheckDlgButton(hWndDlg,CKB_PORT_CMDS,bSendPort);
      CheckDlgButton(hWndDlg,CKB_RECV_UNIQUE,bRecvUniq);
      CheckDlgButton(hWndDlg,CKB_STOR_UNIQUE,bStorUniq);
      CheckDlgButton(hWndDlg,CKB_CRSTRIP,bCRstrip);
      CheckDlgButton(hWndDlg,CKB_AUTOSTART,bAutoStart);
      break;

    case WM_CLOSE:
      PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
      break;

    case WM_SETCURSOR:
      if(bCmdInProgress)
        SetCursor(hWaitCursor);
      else
        return FALSE;
      break;

        case WM_CTLCOLORBTN:
             if(LOWORD(lParam)<10) return((LRESULT)NULL);
       case WM_CTLCOLORDLG:
        case WM_CTLCOLORSTATIC:
         SetBkColor((HDC) wParam, RGB(192,192,192));
          return(LRESULT)hbrGray1;
		  break;

    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case IDOK:
          if(IsDlgButtonChecked(hWndDlg,RB_ASCII)) fType=TYPE_A;
          else if(IsDlgButtonChecked(hWndDlg,RB_BINARY)) fType=TYPE_I;
          else fType=TYPE_L;

          bVerbose=IsDlgButtonChecked(hWndDlg,CKB_VERBOSE);
          bBell=IsDlgButtonChecked(hWndDlg,CKB_BELL);
          bDoGlob=IsDlgButtonChecked(hWndDlg,CKB_GLOBBING);
          bHash=IsDlgButtonChecked(hWndDlg,CKB_HASH);
          bInteractive=IsDlgButtonChecked(hWndDlg,CKB_PROMPT);
          bMCase=IsDlgButtonChecked(hWndDlg,CKB_MCASE);
          bSendPort=IsDlgButtonChecked(hWndDlg,CKB_PORT_CMDS);
          bRecvUniq=IsDlgButtonChecked(hWndDlg,CKB_RECV_UNIQUE);
          bStorUniq=IsDlgButtonChecked(hWndDlg,CKB_STOR_UNIQUE);
          bCRstrip=IsDlgButtonChecked(hWndDlg,CKB_CRSTRIP);
          bAutoStart=IsDlgButtonChecked(hWndDlg,CKB_AUTOSTART);

          GetDlgItemText(hWndDlg,DLG_EDIT,szViewer,70);
          GetDlgItemText(hWndDlg,DLG_MAILADDR,szMailAddress,127);
          EndDialog(hWndDlg, TRUE);
          break;
        case IDCANCEL:
          EndDialog(hWndDlg, FALSE);
          break;
      }
      break;    // End of WM_COMMAND
    default:
      return FALSE;
  }
  return TRUE;
}

/************************************************************************/
/* nCwRegisterClasses Function                                          */
/* The following function registers all the classes of all the windows  */
/* associated with this application. The function returns an error code */
/* if unsuccessful, otherwise it returns 0.                             */
/************************************************************************/
int nCwRegisterClasses(void)
{
  WNDCLASS   wndclass;    // struct to define a window class
  memset(&wndclass, 0x00, sizeof(WNDCLASS));

  // load WNDCLASS with window's characteristics
  wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNWINDOW;
  wndclass.lpfnWndProc = WndProc;
  // Extra storage for Class and Window objects
  wndclass.cbClsExtra = 0;
  wndclass.cbWndExtra = 0;
  wndclass.hInstance = hInst;
  wndclass.hIcon = LoadIcon(hInst, szAppName);
  wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
  // Create brush for erasing background
  wndclass.hbrBackground = (HBRUSH)CreateSolidBrush(RGB(192,192,192));
  wndclass.lpszMenuName = NULL; // szAppName;   /* Menu Name is App Name */
  wndclass.lpszClassName = szAppName; /* Class Name is App Name */
  if(!RegisterClass(&wndclass))
    return -1;
  return(0);
} // End of nCwRegisterClasses

/************************************************************************/
/*  cwCenter Function                                                   */
/*  centers a window based on the client area of its parent             */
/************************************************************************/
void cwCenter(hWnd, top)
HWND hWnd;
int top;
{
  POINT      pt;
  RECT       swp;
  RECT       rParent;
  int        iwidth;
  int        iheight;

  // get the rectangles for the parent and the child
  GetWindowRect(hWnd, &swp);

  // calculate the height and width for MoveWindow
  iwidth = swp.right - swp.left;
  iheight = swp.bottom - swp.top;

  if(IsIconic(hWndMain))
    MoveWindow(hWnd, 0, 0, iwidth, iheight, FALSE);
  else {
    GetClientRect(hWndMain, &rParent);

    // find the center point and convert to screen coordinates
    pt.x = (rParent.right - rParent.left) / 2;
    pt.y = (rParent.bottom - rParent.top) / 2;
    ClientToScreen(hWndMain, &pt);

    // calculate the new x, y starting point
    pt.x = pt.x - (iwidth / 2);
    pt.y = pt.y - (iheight / 2);

    // top will adjust the window position, up or down
    if(top)
      pt.y = pt.y + top;

    // move the window
    MoveWindow(hWnd,max(0,pt.x),max(0,pt.y), iwidth, iheight, FALSE);
  }
} // end of cwCenter

/************************************************************************/
/*  CwUnRegisterClasses Function                                        */
/*  Deletes any refrences to windows resources created for this         */
/*  application, frees memory, deletes instance, handles and does       */
/*  clean up prior to exiting the window                                */
/************************************************************************/
void CwUnRegisterClasses(void)
{
  WNDCLASS   wndclass;    // struct to define a window class
  memset(&wndclass, 0x00, sizeof(WNDCLASS));

  GetClassInfo(hInst, szAppName, &wndclass);
  DeleteObject(wndclass.hbrBackground);
  UnregisterClass(szAppName, hInst);
  UnregisterClass(DBUGWNDCLASS,hInst);
} // End of CwUnRegisterClasses

