unit Self_pgm;

interface

uses
  DisplayUnit,
  SysUtils, WinTypes, WinProcs, Messages,
  Classes, Graphics, Controls,
  Forms, Dialogs, Menus,
  wsc, ExtCtrls, StdCtrls;
type
  TSelf = class(TForm)
    MainMenu: TMainMenu;
    menuPort: TMenuItem;
    Test: TMenuItem;
    menuCOM1: TMenuItem;
    menuCOM2: TMenuItem;
    menuCOM3: TMenuItem;
    menuCOM4: TMenuItem;
    Instructions: TMenuItem;
    menuExit: TMenuItem;
    Memo: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure menuCOM1Click(Sender: TObject);
    procedure menuCOM2Click(Sender: TObject);
    procedure menuCOM3Click(Sender: TObject);
    procedure menuCOM4Click(Sender: TObject);
    procedure KeyPress(Sender: TObject; var Key: Char);
    procedure InstructionsClick(Sender: TObject);
    procedure TestClick(Sender: TObject);
    procedure menuExitClick(Sender: TObject);
  
  private
    { Private declarations }
    Port : Integer;
    Baud : Integer;
    Parity : Integer;
    DataBits : Integer;
    StopBits : Integer;
    TestText : string;
  public
    { Public declarations }
  end ;

var
  Self: TSelf;

implementation

{$R *.DFM}

procedure TSelf.FormCreate(Sender: TObject);
var
  I    : Integer;
  Code : Integer;
begin
  (* initialize parameters *)
  Port := COM1;
  Baud := Baud19200;
  Parity := NoParity;
  DataBits := WordLength8;
  StopBits := OneStopBit;
  Self.Caption := 'Selftest: COM' + Chr($31+Port);
  menuCOM1.Checked := true;
  TestText := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
end;

procedure TSelf.menuCOM1Click(Sender: TObject);
begin
  Self.Caption := 'Selftest: COM' + Chr($31+Port);
  menuCOM1.Checked := true;
  menuCOM2.Checked := false;
  menuCOM3.Checked := false;
  menuCOM4.Checked := false;
  Port := COM1
end;

procedure TSelf.menuCOM2Click(Sender: TObject);
begin
  Self.Caption := 'Selftest: COM' + Chr($32+Port);
  menuCOM1.Checked := false;
  menuCOM2.Checked := true;
  menuCOM3.Checked := false;
  menuCOM4.Checked := false;
  Port := COM2
end;

procedure TSelf.menuCOM3Click(Sender: TObject);
begin
  Self.Caption := 'Selftest: COM' + Chr($33+Port);
  menuCOM1.Checked := false;
  menuCOM2.Checked := false;
  menuCOM3.Checked := true;
  menuCOM4.Checked := false;
  Port := COM3
end;

procedure TSelf.menuCOM4Click(Sender: TObject);
begin
  Self.Caption := 'Selftest: COM' + Chr($34+Port);
  menuCOM1.Checked := false;
  menuCOM2.Checked := false;
  menuCOM3.Checked := false;
  menuCOM4.Checked := true;
  Port := COM4
end;


procedure TSelf.KeyPress(Sender: TObject; var Key: Char);
var
  Code : Integer;
begin
  Code := SioPutc(Port,Key);
end;

procedure TSelf.InstructionsClick(Sender: TObject);
begin
   DisplayLine(Memo,'SELFTEST tests a single port for functionality.');
   DisplayLine(Memo,'The port must terminate with a loopback adapter.');
   DisplayLine(Memo,'See LOOPBACK.DOC for more information.')
end;

procedure TSelf.TestClick(Sender: TObject);
var
  Code : Integer;
  I, N : Integer;
  Loop : Integer;
  Size : Integer;
  Ch   : Char;
  Hr,Mn,ms : Word;
  Sec1,Sec2: Word;
  MaxRxQue : Integer;
  MaxTxQue : Integer;
begin
  (* initialize WSC *)
  Code := SioReset(Port,1024,1024);
  if Code < 0 then begin
    DisplayString(Memo,Format('Error %d: ',[Code]));
    DisplayError(Memo, Code);
    exit
  end;
  (* update settings *)
  Code := SioBaud(Port,Baud);
  Code := SioParms(Port, Parity, StopBits, DataBits);
  Code := SioDTR(Port,'S');
  Code := SioRTS(Port,'S');
  Code := SioFlow(Port,'N');
  (* display the test string *)
  Size := Length(TestText);
  DisplayString(Memo,'Test string "');
  DisplayString(Memo,TestText);
  DisplayLine(Memo,'"');
  (* send TestText 16 times *)
  DisplayString(Memo,'  Sending: ');
  for Loop := 1 to 16 do
    begin
      DisplayString(Memo,Format('%d ',[Loop]));
      (* send test string *)
      for I := 1 to Size do Code := SioPutc(Port,TestText[i]);
    end;
  MaxRxQue := SioRxQue(Port);
  MaxTxQue := SioTxQue(Port);
  DisplayLine(Memo,' ');
  (* receive echo *)
  DisplayString(Memo,'Receiving: ');
  for Loop := 1 to 16 do
    begin
      DisplayString(Memo,Format('%d ',[Loop]));
      (* get response *)
      for N := 1 to Size do
        begin
          (* expect character Ch *)
          Ch := TestText[N];
          DecodeTime(Time,Hr,Mn,Sec1,ms);
          (* get next incoming character *)
          repeat
            (* fetch serial character *)
            Code := SioGetc(Port);
            if Code >= 0 then
              begin
                (* is it the character expected? *)
                if Ch <> char(code) then
                  begin
                    DisplayLine(Memo,Format('Expected %c not %c',[Ch,chr(Code)]));
                    Code := SioDone(Port);
                    exit
                  end
              end
            (* no incoming character *)
            else DecodeTime(Time,Hr,Mn,Sec2,ms);
          until (Code>0) or (Sec2 = (Sec1 + 2) mod 60);
          (* did we time out? *)
          if Code < 0 then
            begin
              DisplayLine(Memo,'Timed out waiting for serial input');
              Code := SioDone(Port);
              exit
            end
        end
    end;
  DisplayLine(Memo,' ');
  DisplayLine(Memo,Format('RX queue size = %d',[MaxRxQue]));
  DisplayLine(Memo,Format('TX queue size = %d',[MaxTxQue]));
  SioRxClear(Port);
  (* close down *)
  DisplayLine(Memo,'Shutting down COM port');
  Code := SioDone(Port)
end;

procedure TSelf.menuExitClick(Sender: TObject);
var
  Code : Integer;
begin
  Code := SioDone(Port);
  Application.Terminate;
end;

end.
