unit Term_pgm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus,
  ExtCtrls, StdCtrls,
  wsc, mio, xydrive;
const
  MaxRow = 15;
  MaxCol = 65;
  NAK = $15;
  CR = 13;
  LF = 10;
  BS = 8;
  DebugLevel = 0; (* XY Driver debug level [0,1,2] *)
  XMODEM = 0;
  YMODEM = 1;
type
  TTerm = class(TForm)
    MainMenu: TMainMenu;
    menuLine: TMenuItem;
    menuOnLine: TMenuItem;
    menuOffline: TMenuItem;
    menuExit: TMenuItem;
    menuChange: TMenuItem;
    menuPort: TMenuItem;
    menuBaud: TMenuItem;
    menuDataBits: TMenuItem;
    menuParity: TMenuItem;
    menuStopBits: TMenuItem;
    menuDial: TMenuItem;
    menuSend: TMenuItem;
    menuCOM1: TMenuItem;
    menuCOM2: TMenuItem;
    menuCOM3: TMenuItem;
    menuCOM4: TMenuItem;
    menu300: TMenuItem;
    menu1200: TMenuItem;
    menu2400: TMenuItem;
    menu4800: TMenuItem;
    menu9600: TMenuItem;
    menu19200: TMenuItem;
    menu38400: TMenuItem;
    menu57600: TMenuItem;
    menuSeven: TMenuItem;
    menuEight: TMenuItem;
    menuNone: TMenuItem;
    menuEven: TMenuItem;
    MenuOdd: TMenuItem;
    menuOne: TMenuItem;
    menuTwo: TMenuItem;
    Timer: TTimer;
    AboutPanel: TPanel;
    AboutOK: TButton;
    AboutMemo: TMemo;
    menuReceive: TMenuItem;
    RXMODEM: TMenuItem;
    RYMODEM: TMenuItem;
    menuBreak: TMenuItem;
    menuAbout: TMenuItem;
    SXMODEM: TMenuItem;
    SYMODEM: TMenuItem;
    AcceptPanel: TPanel;
    AcceptBox: TEdit;
    AcceptMemo: TMemo;
    AcceptOK: TButton;
    menuDebug: TMenuItem;
    procedure IncrCol;
    procedure IncrRow;
    procedure DisplayChar(TheChar : Char);
    procedure DisplayString(Text : String);
    procedure DisplayLine(Text : String);
    procedure ErrorText(Code : Integer);
    procedure FormCreate(Sender: TObject);
    procedure menuOnLineClick(Sender: TObject);
    procedure menuOfflineClick(Sender: TObject);
    procedure menuCOM1Click(Sender: TObject);
    procedure menuCOM2Click(Sender: TObject);
    procedure menuCOM3Click(Sender: TObject);
    procedure menuCOM4Click(Sender: TObject);
    procedure menuExitClick(Sender: TObject);
    procedure menu300Click(Sender: TObject);
    procedure menu1200Click(Sender: TObject);
    procedure menu2400Click(Sender: TObject);
    procedure menu4800Click(Sender: TObject);
    procedure menu9600Click(Sender: TObject);
    procedure menu19200Click(Sender: TObject);
    procedure menu38400Click(Sender: TObject);
    procedure menu57600Click(Sender: TObject);
    procedure menuSevenClick(Sender: TObject);
    procedure menuEightClick(Sender: TObject);
    procedure menuNoneClick(Sender: TObject);
    procedure menuEvenClick(Sender: TObject);
    procedure MenuOddClick(Sender: TObject);
    procedure menuOneClick(Sender: TObject);
    procedure menuTwoClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure KeyPress(Sender: TObject; var Key: Char);
    procedure AboutOKClick(Sender: TObject);
    procedure menuAboutClick(Sender: TObject);
    procedure menuDialClick(Sender: TObject);
    procedure AcceptOKClick(Sender: TObject);
    procedure menuBreakClick(Sender: TObject);
    procedure SXMODEMClick(Sender: TObject);
    procedure SYMODEMClick(Sender: TObject);
    procedure RXMODEMClick(Sender: TObject);
    procedure RYMODEMClick(Sender: TObject);
    procedure XY(Sender: TObject);
  private
    { Private declarations }
    LastPacket : Integer;
    NewState : Integer;
    mioState : Integer;
    xyState  : Integer;
    LastChar : Char;
    Row : Integer;
    Col : Integer;
    RowBase : Integer;
    CharWidth  : Integer;
    CharHeight : Integer;
    Port : Integer;
    Baud : Integer;
    Parity : Integer;
    DataBits : Integer;
    StopBits : Integer;
    ScreenBuffer : array [0..MaxRow] of string;
    BlankLine : string;
  public
    { Public declarations }
  end ;

var
  Term: TTerm;

implementation

{$R *.DFM}

procedure TTerm.IncrRow;
var
  I : Integer;
begin
  Col := 0;
  Inc(Row);
  if Row > MaxRow then
    begin
      (* scroll ScreenBuffer *)
       for I := 0 to MaxRow-1 do
          ScreenBuffer[I] := ScreenBuffer[I+1];
       ScreenBuffer[MaxRow] := '';
       (* re-display *)
       for I := 0 to MaxRow-1 do
         begin
           Canvas.TextOut(0,(I*CharHeight),ScreenBuffer[I]+BlankLine);
         end;
       (* position on last line *)
       Row := MaxRow;
       Canvas.TextOut(0,MaxRow*CharHeight,BlankLine);
       Canvas.MoveTo(0,MaxRow*CharHeight)
    end
end;

procedure TTerm.IncrCol;
begin
  Inc(Col);
  if Col > MaxCol then
    begin
      IncrRow;
    end;
end;

procedure TTerm.DisplayChar(TheChar : Char);
var
   TheString : String;
begin
   if TheChar <> Chr(LF) then
     begin
       if TheChar = Chr(CR) then
         begin
          IncrRow;
         end
       else
         begin
           if Ord(TheChar) = BS Then TheChar := '~';
           (* save char in ScreenBuffer *)
           ScreenBuffer[Row] := ScreenBuffer[Row] + TheChar;
           (* display char on screen *)
           Canvas.TextOut((Col*CharWidth),(Row*CharHeight),''+TheChar);
           IncrCol;
         end;
     end;
end;

procedure TTerm.DisplayString(Text : String);
var
  I   : Integer;
  Len : Integer;
  S   : String;
begin
  Len := Length(Text);
  if Len > 0 then
    begin
      (* save string in ScreenBuffer *)
      ScreenBuffer[Row] := ScreenBuffer[Row] + Text;
      (* display on screen *)
      Canvas.TextOut((Col*CharWidth),(Row*CharHeight),Text);
      IncrCol
    end
end;

procedure TTerm.DisplayLine(Text : String);
begin
  DisplayString(Text);
  DisplayChar(chr(CR))
end;

procedure TTerm.ErrorText(Code : Integer);
var
   Text : String;
begin
  if Code <0 then
    begin
      case Code of
        IE_BADID: Text := 'Bad port ID';
        IE_OPEN:  Text := 'Cannot open port';
        IE_NOPEN: Text := 'Port already open';
        IE_MEMORY:   Text := 'Cannot allocate memory';
        IE_DEFAULT:  Text := 'Error in default parameters';
        IE_HARDWARE: Text := 'Hardware error';
        IE_BYTESIZE: Text := 'Unsupported byte size';
        IE_BAUDRATE: Text := 'Unsupported baud rate';
        WSC_RANGE:   Text := 'Parameter out of range';
        WSC_ABORTED: Text := 'Shareware version corrupted';
{$IFDEF WIN32}
        WSC_WIN32ERR:
            Text := Format('Win32 error %d',[SioWinError]);
{$ENDIF}
        WSC_EXPIRED: Text := 'Shareware version expired';
        else Text := 'Unknown error';
      end;
      DisplayLine(Text);
    end
end;

procedure TTerm.FormCreate(Sender: TObject);
var
  I    : Integer;
  Code : Integer;
begin
  (* initialize canvas *)
  menuBreak.Enabled := False;
  RowBase := 0;
  Row := 0; Col := 0;
  CharWidth := Canvas.TextWidth('A');
  CharHeight := Canvas.TextHeight('A');
  for I := 0 to MaxRow do ScreenBuffer[I] := '';
  BlankLine := '';
  for I := 0 to MaxCol do BlankLine := BlankLine + ' ';
  (* initialize parameters *)
  Port := COM1;
  Baud := Baud19200;
  Parity := NoParity;
  DataBits := WordLength8;
  StopBits := OneStopBit;
  (* initialize menu settings *)
  menuOffLine.Checked := true;
  menuCOM1.Checked := true;
  menu19200.Checked := true;
  menuNone.Checked := true;
  menuEight.Checked := true;
  menuOne.Checked := true;
  (* initialize state variables *)
  mioState := 0;
  xyState := 0;
  xyDebug(DebugLevel);
  DisplayLine('FORM created');
end;

procedure TTerm.menuOnLineClick(Sender: TObject);
var      
  Code : Integer;
begin
  (* initialize WSC *)
  Code := SioReset(Port,2048,2048);
  if Code < 0 then
    begin
      DisplayLine(Format('Error %d: Cannot reset port',[Code]));
      ErrorText(Code);
      exit
    end;
  (* set hardware flow control *)
  Code := SioFlow(Port,'H');
  DisplayLine('Waiting for DSR...');
  (* attach XYDRIVER *)
  Code := xyAcquire(Port);
  (* update menu settings *)
  Term.Caption := 'Term: COM' + Chr($31+Port) + ' Online';
  menuOnLine.Checked := true;
  menuOffLine.Checked := false;
  menuChange.Enabled := false;
  menuSend.Enabled := true;
  menuReceive.Enabled := true;
  menuDial.Enabled := true;
  Code := SioBaud(Port,Baud);
  Code := SioParms(Port, Parity, StopBits);
  Code := SioDTR(Port,'S');
  Code := SioRTS(Port,'S')
end;

procedure TTerm.menuOfflineClick(Sender: TObject);
var
  Code : Integer;
begin
  Term.Caption := 'Term: Offline';
  DisplayString('Shutting down COM port');
  menuOnLine.Checked := false;
  menuOffLine.Checked := true;
  menuChange.Enabled := true;
  menuSend.Enabled := false;
  menuReceive.Enabled := false;
  menuDial.Enabled := false;
  Code := xyRelease(Port);
  Code := SioDone(Port)
end;

procedure TTerm.menuCOM1Click(Sender: TObject);
begin
  menuCOM1.Checked := true;
  menuCOM2.Checked := false;
  menuCOM3.Checked := false;
  menuCOM4.Checked := false;
  Port := COM1
end;

procedure TTerm.menuCOM2Click(Sender: TObject);
begin
  menuCOM1.Checked := false;
  menuCOM2.Checked := true;
  menuCOM3.Checked := false;
  menuCOM4.Checked := false;
  Port := COM2
end;

procedure TTerm.menuCOM3Click(Sender: TObject);
begin
  menuCOM1.Checked := false;
  menuCOM2.Checked := false;
  menuCOM3.Checked := true;
  menuCOM4.Checked := false;
  Port := COM3
end;

procedure TTerm.menuCOM4Click(Sender: TObject);
begin
  menuCOM1.Checked := false;
  menuCOM2.Checked := false;
  menuCOM3.Checked := false;
  menuCOM4.Checked := true;
  Port := COM4
end;

procedure TTerm.menuExitClick(Sender: TObject);
var
  Code : Integer;
begin
  Code := SioDone(Port);
  Application.Terminate;
end;

procedure TTerm.menu300Click(Sender: TObject);
begin
  menu300.Checked := true;
  menu1200.Checked := false;
  menu2400.Checked := false;
  menu4800.Checked := false;
  menu9600.Checked := false;
  menu19200.Checked := false;
  menu38400.Checked := false;
  menu57600.Checked := false;
  Baud := Baud300
end;

procedure TTerm.menu1200Click(Sender: TObject);
begin
  menu300.Checked := false;
  menu1200.Checked := true;
  menu2400.Checked := false;
  menu4800.Checked := false;
  menu9600.Checked := false;
  menu19200.Checked := false;
  menu38400.Checked := false;
  menu57600.Checked := false;
  Baud := Baud1200
end;

procedure TTerm.menu2400Click(Sender: TObject);
begin
  menu300.Checked := false;
  menu1200.Checked := false;
  menu2400.Checked := true;
  menu4800.Checked := false;
  menu9600.Checked := false;
  menu19200.Checked := false;
  menu38400.Checked := false;
  menu57600.Checked := false;
  Baud := Baud2400
end;

procedure TTerm.menu4800Click(Sender: TObject);
begin
  menu300.Checked := false;
  menu1200.Checked := false;
  menu2400.Checked := false;
  menu4800.Checked := true;
  menu9600.Checked := false;
  menu19200.Checked := false;
  menu38400.Checked := false;
  menu57600.Checked := false;
  Baud := Baud4800
end;

procedure TTerm.menu9600Click(Sender: TObject);
begin
  menu300.Checked := false;
  menu1200.Checked := false;
  menu2400.Checked := false;
  menu4800.Checked := false;
  menu9600.Checked := true;
  menu19200.Checked := false;
  menu38400.Checked := false;
  menu57600.Checked := false;
  Baud := Baud9600
end;

procedure TTerm.menu19200Click(Sender: TObject);
begin
  menu300.Checked := false;
  menu1200.Checked := false;
  menu2400.Checked := false;
  menu4800.Checked := false;
  menu9600.Checked := false;
  menu19200.Checked := true;
  menu38400.Checked := false;
  menu57600.Checked := false;
  Baud := Baud19200
end;

procedure TTerm.menu38400Click(Sender: TObject);
begin
  menu300.Checked := false;
  menu1200.Checked := false;
  menu2400.Checked := false;
  menu4800.Checked := false;
  menu9600.Checked := false;
  menu19200.Checked := false;
  menu38400.Checked := true;
  menu57600.Checked := false;
  Baud := Baud38400
end;

procedure TTerm.menu57600Click(Sender: TObject);
begin
  menu300.Checked := false;
  menu1200.Checked := false;
  menu2400.Checked := false;
  menu4800.Checked := false;
  menu9600.Checked := false;
  menu19200.Checked := false;
  menu38400.Checked := false;
  menu57600.Checked := true;
  Baud := Baud57600
end;

procedure TTerm.menuSevenClick(Sender: TObject);
begin
  menuSeven.Checked := true;
  menuEight.Checked := false;
  DataBits := WordLength7
end;

procedure TTerm.menuEightClick(Sender: TObject);
begin
  menuSeven.Checked := false;
  menuEight.Checked := true;
  DataBits := WordLength8
end;

procedure TTerm.menuNoneClick(Sender: TObject);
begin
  menuNone.Checked := true;
  menuEven.Checked := false;
  menuOdd.Checked := false;
  Parity := NoParity
end;

procedure TTerm.menuEvenClick(Sender: TObject);
begin
  menuNone.Checked := false;
  menuEven.Checked := true;
  menuOdd.Checked := false;
  Parity := EvenParity
end;

procedure TTerm.MenuOddClick(Sender: TObject);
begin
  menuNone.Checked := false;
  menuEven.Checked := false;
  menuOdd.Checked := true;
  Parity := OddParity
end;

procedure TTerm.menuOneClick(Sender: TObject);
begin
  menuOne.Checked := true;
  menuTwo.Checked := false;
  StopBits := OneStopBit
end;

procedure TTerm.menuTwoClick(Sender: TObject);
begin
  menuOne.Checked := false;
  menuTwo.Checked := true;
  StopBits := TwoStopBits
end;

procedure TTerm.TimerTimer(Sender: TObject);
var
  I     : Integer;
  Code  : Integer;
  Result: Integer;
  Ptr   : PChar;
  Text  : String;
  Count : Integer;
  C     : Char;
  Packet  : Integer;
  ErrorState : Integer;
begin
  if xyState <> 0 then
    begin
      case xyState of
     10: begin (* XM Send *)
           GetMem(Ptr,32);
           StrPCopy(Ptr,AcceptBox.Text);
           Code := xyStartTx(Port,Ptr,0,XMODEM);
           xyState := 50;
           FreeMem(Ptr,32);
         end;
     20: begin  (* YM Send *)
           GetMem(Ptr,32);
           StrPCopy(Ptr,AcceptBox.Text);
           Code := xyStartTx(Port,Ptr,0,YMODEM);
           xyState := 50;
           FreeMem(Ptr,32)
         end;
     30: begin  (* XM Receive *)
           GetMem(Ptr,32);
           StrPCopy(Ptr,AcceptBox.Text);
           Code := xyStartRx(Port,Ptr,CHR(NAK),XMODEM);
           xyState := 50;
           FreeMem(Ptr,32)
         end;
     40: begin   (* YM Receive *)
           GetMem(Ptr,32);
           StrPCopy(Ptr,'');
           Code := xyStartRx(Port,Ptr,'C',YMODEM);
           xyState := 50;
           LastPacket := -1;
           FreeMem(Ptr,32)
         end;
     50: begin   (* xyDriver *)
           GetMem(Ptr,90);
           while true do
             begin
               if xyGetMessage(Ptr,90) <> 0 then
                 begin
                   Text := StrPas(Ptr);
                   DisplayLine(Text)
                 end
               else break;
             end;
           FreeMem(Ptr,90);
           if xyDriver(Port) = MIO_IDLE then
             begin
               (* xy state driver is idle *)
               xyState := 0;
               menuBreak.Enabled := false;
               menuDial.Enabled := true;
               ErrorState := xyGetParameter(Port,XY_GET_ERROR_CODE);
               if ErrorState <> 0 then
                 begin
                   DisplayLine(Format('File transfer fails (%d)',[ErrorState]));
                 end
               else DisplayLine('File transfer complete');
               (* restore menu buttons *)
               menuSend.Enabled := true;
               menuReceive.Enabled := true;
               menuBreak.Enabled := false
             end
           else
             begin
               (* xy state driver is running *)
               Packet := xyGetParameter(Port,XY_GET_PACKET);
               if (Packet <> LastPacket) and (DebugLevel = 0) then
                 begin
                   (*DisplayChar(Chr(CR));*)
                   DisplayLine( Format('Packet %d',[Packet]) );
                   LastPacket := Packet
                 end
             end;
          end;
      else
        xyState := 0;
      end
    end
  else if mioState <> 0 then
    begin
      case mioState of
      1: begin
           if Length(AcceptBox.Text) = 0 then
             begin
               DisplayLine('Missing phone number');
               mioState := 0;
             end
           else
             begin
               menuBreak.Enabled := true;
               menuDial.Enabled := false;
               Text := '!ATDT' + AcceptBox.Text + '!';
               DisplayLine(Text);
               GetMem(Ptr,32);
               StrPCopy(Ptr,Text);
               mioSendTo(Port,100,Ptr);
               FreeMem(Ptr,32);
               mioState := 2
             end
         end;
      2: begin
           if mioDriver(Port) = MIO_IDLE then
             begin
               Text := 'CONNECT';
               GetMem(Ptr,5);
               StrPCopy(Ptr,Text);
               mioWaitFor(Port,60000,Ptr);
               FreeMem(Ptr,5);
               mioState := 3
             end
         end;
      3: begin
           if mioDriver(Port) = MIO_IDLE then
           begin
             mioState := 0;
             menuBreak.Enabled := false;
             menuDial.Enabled := true;
             if mioResult(Port) <> 0 then DisplayLine('[CONNECT was received]')
             else
               begin
                 DisplayLine('[CONNECT was NOT received]')
               end
           end
         end
      end (* case *)
    end (* else(mioState<>0) *)
  else
    begin
      (* get all serial input *)
      repeat
        Code := SioGetc(Port);
        if Code >= 0 then DisplayChar(Chr(Code))
      until Code < 0;
    end
end;

procedure TTerm.KeyPress(Sender: TObject; var Key: Char);
var
  Code : Integer;
begin
  Code := SioPutc(Port,Key);
  if(Code<WSC_NO_DATA)
  then DisplayLine(Format('SioPutc error %d',[Code]));
end;

procedure TTerm.AboutOKClick(Sender: TObject);
begin
   AboutPanel.Visible := False
end;

procedure TTerm.menuAboutClick(Sender: TObject);
begin
     AboutPanel.Visible := True
end;

procedure TTerm.menuDialClick(Sender: TObject);
begin
   AcceptMemo.Lines.Clear;
   AcceptMemo.Lines.Add('Enter phone number');
   AcceptPanel.Visible := true;
   NewState := 1
end;

procedure TTerm.AcceptOKClick(Sender: TObject);
begin
  AcceptPanel.Visible := false;
  DisplayLine(AcceptBox.Text);
  (* set state variable after get Accept text *)
  if NewState = 1 then mioState := 1
  else xyState := NewState;
  NewState := 0;
end;

procedure TTerm.menuBreakClick(Sender: TObject);
begin
   mioState := 0;
   xyState := 0;
   mioBreak(Port);
   xyAbort(Port);
   menuSend.Enabled := true;
   menuReceive.Enabled := true
end;

procedure TTerm.SXMODEMClick(Sender: TObject);
begin
  AcceptMemo.Lines.Clear;
  AcceptMemo.Lines.Add('XMODEM file name');
  AcceptPanel.Visible := true;
  menuBreak.Enabled := true;
  NewState := 10
end;

procedure TTerm.SYMODEMClick(Sender: TObject);
begin
  AcceptMemo.Lines.Clear;
  AcceptMemo.Lines.Add('YMODEM file name');
  AcceptPanel.Visible := true;
  menuBreak.Enabled := true;
  NewState := 20
end;

procedure TTerm.RXMODEMClick(Sender: TObject);
begin
  AcceptMemo.Lines.Clear;
  AcceptMemo.Lines.Add('XMODEM file name');
  AcceptPanel.Visible := true;
  menuBreak.Enabled := true;
  NewState := 30
end;

procedure TTerm.RYMODEMClick(Sender: TObject);
begin
  (* set xy state variable directly *)
  menuBreak.Enabled := true;
  xyState := 40
end;

procedure TTerm.XY(Sender: TObject);
var
  Ptr : PChar;
  Text : String;
  Parm : LongInt;
begin
  GetMem(Ptr,80);
  while true do
  begin
    if xyGetMessage(Ptr,80) <> 0 then
      begin
        Text := StrPas(Ptr);
        DisplayLine(Text)
      end
    else break;
  end;
  FreeMem(Ptr,80);
  (* display current state *)
  Parm := xyGetParameter(Port,XY_GET_STATE);
  DisplayString('STATE =');
  DisplayLine(Format('%d',[Parm]));
  (* display error code *)
  Parm := xyGetParameter(Port,XY_GET_ERROR_CODE);
  if Parm <> 0 then
    begin
      DisplayLine(Format('ERROR Code = %d',[Parm]));
      DisplayLine(Format('ERROR State = %d',
                    [xyGetParameter(Port,XY_GET_ERROR_STATE)] ));
    end;
  (* display driver count *)
  Parm := xyGetParameter(Port,XY_GET_DRIVER_COUNT);
  DisplayLine( Format('xyDriver Count = %d',[Parm]) );
  (* Display state variables *)
  DisplayLine( Format('xyState = %d',[xyState]) );
end;

end.
