/* wscerror.c */

#include "windows.h"
#include "wsc.h"
#include "paint.h"
#include "wscerror.h"

extern char Temp[256];

void SioError(int Code,LPSTR Text)
{DisplayLine(Text);
 switch(Code)
   {case IE_BADID:
     DisplayLine(" Invalid COM port\n");
     break;
   case IE_OPEN:
     DisplayLine(" COM port already open\n");
     break;
   case IE_NOPEN:
     DisplayLine(" Cannot open COM port\n");
     break;
   case IE_MEMORY:
     DisplayLine(" Cannot allocate memory\n");
     break;
   case IE_DEFAULT:
     DisplayLine(" Error in default parameters\n");
     break;
   case IE_HARDWARE:
     DisplayLine(" COM port hardware not present\n");
     break;
   case IE_BYTESIZE:
     DisplayLine(" Unsupported byte size\n");
     break;
   case IE_BAUDRATE:
     DisplayLine(" Unsupported baud rate\n");
     break;
   default:
     wsprintf((LPSTR)Temp," Windows error code %d\n",Code);
     DisplayLine(Temp);
     break;
   }
}