/*
**                    --- selftest.c ---
*/

#define USECOMM

#include "windows.h"
#include "selftest.h"
#include "message.h"
#include "wsc.h"
#include "ascii.h"
#include "paint.h"
#include "line.h"
#include "menu.h"
#include "about.h"
#include "runtest.h"
#include "wscerror.h"

/* public globals */

HWND hMainWnd;            /* main window handle */
HWND hInfoWnd;            /* popup handle */
HANDLE hInstance;         /* program instance */
int OnLineFlag = FALSE;   /* TRUE: online */
int FatalFlag = FALSE;    /* TRUE: fatal error */
char Temp[1024];

/* private globals */

static int WinWidth = 8 * NCOLS;
static int WinHeight = 12 * NROWS + 48;
static int ThePort = COM1;

/* miscellaneous functions */

void ErrorCheck(int);
void ErrorMessage(char *);
void SetTitle(void);

int PASCAL WinMain(HANDLE hInst,HANDLE hPrevInstance,
                   LPSTR lpCmdLine,int nCmdShow)
{WNDCLASS  wc;
 MSG msg;
 BOOL Result;
 if(!hPrevInstance)
   {/* register main window class */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon(hInst, "SelftestIcon");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "SelftestMenu";
    wc.lpszClassName = "SelftestWClass";
    Result = RegisterClass(&wc);
    if(!Result) return FALSE;
   }

 /* create main window */
 hInstance = hInst;
 hMainWnd = CreateWindow(
        "SelftestWClass", "Selftest",       WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,    CW_USEDEFAULT,
        WinWidth,         WinHeight,
        NULL,             NULL,
        hInstance,        NULL);
 ShowWindow(hMainWnd, nCmdShow);
 UpdateWindow(hMainWnd);

 /* window control loop */

 while(GetMessage(&msg,NULL,NULL,NULL))
   {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
   }
 return (msg.wParam);
} /* end WinMain */

long FAR PASCAL MainWndProc(HWND hWindow,UINT message,WPARAM wParam,LPARAM lParam)
{int  Code;
 HDC  hDC;
 PAINTSTRUCT ps;
 static FARPROC lpProcAbout;

 hMainWnd = hWindow;
 switch (message)
    {case WM_COMMAND:
         switch(wParam)
           {case MSG_ABOUT:
              DialogBox(hInstance,"AboutBox",hMainWnd,lpProcAbout);
              break;

            case MSG_DEBUG:
              break;

            case MSG_INSTRUCT:
              DisplayLine("SELFTEST tests a single port for functionality.\n");
              DisplayLine("The port must terminate with a loopback adapter.");
              DisplayLine("See LOOPBACK.DOC for more info.\n");
              break;

            case MSG_TEST:
              Code = SioReset(ThePort,1024,1024);
              if(Code<0)
                {SioError(Code,"SioReset");
                 break;
                }
              SioBaud(ThePort,19200);
              RunTest(ThePort);
              SioDone(ThePort);
              break;

            case MSG_COM1:
              UncheckTheMenu(MSG_COM1+ThePort);
              ThePort = COM1;
              CheckTheMenu(MSG_COM1);
              SetTitle();
              break;

            case MSG_COM2:
              UncheckTheMenu(MSG_COM1+ThePort);
              ThePort = COM2;
              CheckTheMenu(MSG_COM2);
              SetTitle();
              break;

            case MSG_COM3:
              UncheckTheMenu(MSG_COM1+ThePort);
              ThePort = COM3;
              CheckTheMenu(MSG_COM3);
              SetTitle();
              break;

            case MSG_COM4:
              UncheckTheMenu(MSG_COM1+ThePort);
              ThePort = COM4;
              CheckTheMenu(MSG_COM4);
              SetTitle();
              break;

            case MSG_EXIT:
              PostQuitMessage(0);
              break;

            default:
              return (DefWindowProc(hMainWnd, message, wParam, lParam));
           }
         break;

    case WM_CREATE:

      /* create AboutDlgProc() thunk */
      lpProcAbout = MakeProcInstance(AboutDlgProc, hInstance);
      /* initialize paint module */
      InitPaint();
      /* COM1 is default */
      CheckTheMenu(MSG_COM1);
      SetTitle();
      break;

/*
    case WM_CHAR:
      SioPutc(ThePort, (char)wParam );
      break;
*/

    case WM_SETFOCUS:
      /* create client area caret */
      CreateCaret(hMainWnd,NULL,3,10);
      SetCaretPos(GetXposition(),GetYposition());
      ShowCaret(hMainWnd);
      ShowCaret(hMainWnd);
      break;

    case WM_KILLFOCUS:
      DestroyCaret();
      break;

    case WM_PAINT:
      HideCaret(hMainWnd);
      hDC = BeginPaint(hMainWnd, &ps);
      SetMapMode(hDC,MM_ANISOTROPIC);
      SelectObject(hDC, GetStockObject(OEM_FIXED_FONT) );
      PaintMain(hDC,&ps);
      EndPaint(hMainWnd,&ps);
      SetCaretPos(GetXposition(),GetYposition());
      ShowCaret(hMainWnd);
      break;

    case WM_DESTROY:
      PostQuitMessage(0);
      break;

    default:
      return (DefWindowProc(hMainWnd, message, wParam, lParam));
   }
 return (NULL);
} /* end MainWndProc */

void ErrorMessage(char *MsgPtr)
{
 MessageBox(hMainWnd,MsgPtr,"ERROR",MB_ICONEXCLAMATION | MB_OK);
}

void SetTitle(void)
{wsprintf((LPSTR)Temp,"SELFTEST: COM%d",1+ThePort);
 SetWindowText(hMainWnd,Temp);
 DrawMenuBar(hMainWnd);
}
