/*** line ***/

#include "windows.h"
#include "wsc.h"

#include "line.h"
#include "wscerror.h"

extern HWND hMainWnd;
extern int  FatalFlag;
extern int  OnLineFlag;
extern char Temp[256];

/*** PRIVATE ***/

static int ErrorCheck(int Code,char *Text)
{if(Code<0) SioError(Code,Text);
 return Code;
}

/*** PUBLIC ***/

void GoOnLine(int Port)
{int RetCode;
 /* reset Port */
 RetCode = SioReset(Port,1024,128);
 if(RetCode<0)
   {wsprintf((LPSTR)Temp,"SioReset:COM%d",1+Port);
    /*SioError(RetCode,"SioReset");*/
    SioError(RetCode,Temp);
    return;
   }
 /* clear receive buffer */
 ErrorCheck( SioRxClear(Port), "SioRxClear");
 /* set DTR & RTS */
 ErrorCheck( SioDTR(Port,'S'), "SioDTR");
 ErrorCheck( SioRTS(Port,'S'), "SioRTS");
 /* no flow control */
 ErrorCheck( SioFlow(Port,'N'), "SioFlow");
 /* we're done */
 OnLineFlag = TRUE;
}

void GoOffLine(int Port)
{SioDone(Port);
 /* we're done */
 OnLineFlag = FALSE;
}
