/* This is a REXX program 

A sample REXX file to query settings for objects using the functions
in WPTOOLS.DLL.

*/


arg tCmdLine

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
rc = SysLoadFuncs()

call RxFuncAdd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs' 
rc = WPToolsLoadFuncs()

szObjectName = ""
szParms = ""
do i = 1 to words(tCmdLine)
  tWord = word(tCmdLine, i)
  select
    when tWord = '/S' | tWord = '-S' then do
      szParms = '/S'
      iterate
    end
    otherwise do
      if szObjectName != "" then do
         say 'Invalid argument: ' tWord
         exit
      end
      szObjectName = tWord
      iterate
      end
   end
end

if szObjectName = "" then do
   say 'USAGE: GETSET OBJECTID|PATHNAME [/S]'
   say ''
   say 'Use OBJECTID without < and >'
   say '/S - Also look in subdirs'
   exit
end

call SysFileTree szObjectName, 'rgFiles', 'O'
if rgFiles.0 > 0 then do
  do i = 1 to rgFiles.0
      call GetSettings rgFiles.i, szParms
  end
  if szParms = '/S' Then Do
    szObjectName = szObjectName || '\*.*'
    call SysFileTree szObjectName, 'rgFiles', 'OS'
    if rgFiles.0 > 0 then do
      do i = 1 to rgFiles.0
        call GetSettings rgFiles.i, szParms
      end
    end
  end
  exit
end


szObjectName = '<' || szObjectName || '>'
call GetSettings szObjectName, szParms

Exit

/***********************************************************************
* GetSettings
***********************************************************************/
GetSettings:
iRetco = WPToolsQueryObject(ARG(1), "szClass", "szTitle", "szSetupString", "szLocation") 
if iRetco Then do
     say '"'szClass'", "'szTitle'", "'szSetupString'", "'szLocation'"'
  end 
else
  say 'Unable to return object settings for ' ARG(1)

if ARG(2) = '/S' Then Do

iRetco = WPToolsFolderContent(ARG(1), "list.")
if iRetco = 0 Then Do
   Say 'WPToolsFolderContent for 'ARG(1)' returned 0'
   return
End

do iObject = 1 to list.0
  iRetco=WPToolsQueryObject(list.iObject, "szClass", "szTitle", "szSetupString", "szLocation") 
  if iRetco Then do
     say '"'szClass'", "'szTitle'", "'szSetupString'", "'szLocation'"'
  end 
end
End
return
